/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzn;

public final class zzaj
extends zzf {
    private String zztt;
    private String zzts;
    private int zzalo;
    private String zzage;
    private String zztr;
    private long zzalp;
    private long zzagh;
    private int zzagy;
    private String zzafx;
    private String zzagk;

    zzaj(zzbt zzbt2) {
        super(zzbt2);
    }

    @Override
    protected final boolean zzgt() {
        return true;
    }

    @Override
    protected final void zzgu() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzco)this).getContext().getPackageName();
        PackageManager packageManager = ((zzco)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzco)this).zzgo().zzjd().zzg("PackageManager is null, app identity information might be inaccurate. appId", zzap.zzbv(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzco)this).zzgo().zzjd().zzg("Error retrieving app installer package name. appId", zzap.zzbv(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzco)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzco)this).zzgo().zzjd().zze("Error retrieving package info. appId, appName", zzap.zzbv(string4), string3);
            }
        }
        this.zztt = string4;
        this.zzage = string;
        this.zzts = string2;
        this.zzalo = n;
        this.zztr = string3;
        this.zzalp = 0L;
        zzk zzk2 = ((zzco)this).zzgr();
        packageInfo = GoogleServices.initialize((Context)((zzco)this).getContext());
        boolean bl = (packageInfo != null && packageInfo.isSuccess()) | (!TextUtils.isEmpty((CharSequence)this.zzadj.zzkk()) && "am".equals(this.zzadj.zzkl()));
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzaj zzaj2 = this;
            if (packageInfo2 == null) {
                ((zzco)zzaj2).zzgo().zzjd().zzbx("GoogleService failed to initialize (no status)");
            } else {
                ((zzco)zzaj2).zzgo().zzjd().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzco)this).zzgq().zzhv();
            if (((zzco)this).zzgq().zzhu()) {
                if (this.zzadj.zzkj()) {
                    ((zzco)this).zzgo().zzjj().zzbx("Collection disabled with firebase_analytics_collection_deactivated=1");
                }
            } else if (object != null && !((Boolean)object).booleanValue()) {
                if (this.zzadj.zzkj()) {
                    ((zzco)this).zzgo().zzjj().zzbx("Collection disabled with firebase_analytics_collection_enabled=0");
                }
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzco)this).zzgo().zzjj().zzbx("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzco)this).zzgo().zzjl().zzbx("Collection enabled");
            }
        }
        this.zzafx = "";
        this.zzagk = "";
        this.zzagh = 0L;
        zzk2 = ((zzco)this).zzgr();
        if (!TextUtils.isEmpty((CharSequence)this.zzadj.zzkk()) && "am".equals(this.zzadj.zzkl())) {
            this.zzagk = this.zzadj.zzkk();
        }
        try {
            object = GoogleServices.getGoogleAppId();
            Object object2 = this.zzafx = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (!TextUtils.isEmpty((CharSequence)object)) {
                StringResourceValueReader stringResourceValueReader = new StringResourceValueReader(((zzco)this).getContext());
                this.zzagk = stringResourceValueReader.getString("gma_app_id");
            }
            if (bl2) {
                ((zzco)this).zzgo().zzjl().zze("App package, google app id", this.zztt, this.zzafx);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzco)this).zzgo().zzjd().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzap.zzbv(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzagy = InstantApps.isInstantApp((Context)((zzco)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzagy = 0;
    }

    @WorkerThread
    final zzh zzbr(String string) {
        ((zzco)this).zzaf();
        ((zzco)this).zzgb();
        String string2 = this.zzal();
        String string3 = this.getGmpAppId();
        zzco zzco2 = this;
        ((zzf)zzco2).zzcl();
        String string4 = ((zzaj)zzco2).zzts;
        long l = this.zzja();
        zzco2 = this;
        ((zzf)zzco2).zzcl();
        String string5 = ((zzaj)zzco2).zzage;
        long l2 = ((zzco)this).zzgq().zzhc();
        zzco2 = this;
        ((zzf)zzco2).zzcl();
        zzco2.zzaf();
        if (((zzaj)zzco2).zzalp == 0L) {
            ((zzaj)zzco2).zzalp = ((zzaj)zzco2).zzadj.zzgm().zzd(zzco2.getContext(), zzco2.getContext().getPackageName());
        }
        long l3 = ((zzaj)zzco2).zzalp;
        boolean bl = this.zzadj.isEnabled();
        boolean bl2 = !((zzco)this).zzgp().zzanv;
        zzco2 = this;
        zzco2.zzaf();
        zzco2.zzgb();
        String string6 = zzco2.zzgq().zzbc(((zzaj)zzco2).zztt) && !((zzaj)zzco2).zzadj.isEnabled() ? null : ((zzaj)zzco2).zziz();
        zzco2 = this;
        ((zzf)zzco2).zzcl();
        long l4 = ((zzaj)zzco2).zzagh;
        long l5 = this.zzadj.zzkp();
        int n = this.zzjb();
        zzco2 = ((zzco)this).zzgq();
        zzco2.zzgb();
        Boolean bl3 = ((zzn)zzco2).zzau("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        zzco2 = ((zzco)this).zzgq();
        zzco2.zzgb();
        bl3 = ((zzn)zzco2).zzau("google_analytics_ssaid_collection_enabled");
        return new zzh(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, l4, l5, n, bl4, bl3 == null || bl3 != false, ((zzco)this).zzgp().zzjx(), this.zzgw());
    }

    @WorkerThread
    @VisibleForTesting
    private final String zziz() {
        Object object;
        Class<?> clazz;
        try {
            clazz = ((zzco)this).getContext().getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
            if (clazz == null) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            object = clazz.getDeclaredMethod("getInstance", Context.class).invoke(null, ((zzco)this).getContext());
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            ((zzco)this).zzgo().zzjh().zzbx("Failed to obtain Firebase Analytics instance");
            return null;
        }
        try {
            return (String)clazz.getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            ((zzco)this).zzgo().zzji().zzbx("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzal() {
        this.zzcl();
        return this.zztt;
    }

    final String getGmpAppId() {
        this.zzcl();
        return this.zzafx;
    }

    final String zzgw() {
        this.zzcl();
        return this.zzagk;
    }

    final int zzja() {
        this.zzcl();
        return this.zzalo;
    }

    final int zzjb() {
        this.zzcl();
        return this.zzagy;
    }
}

