/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzco;
import java.util.List;

public final class zzbg {
    final zzbt zzadj;

    zzbg(zzbt zzbt2) {
        this.zzadj = zzbt2;
    }

    @WorkerThread
    protected final void zzcd(String string) {
        if (string == null || string.isEmpty()) {
            this.zzadj.zzgo().zzjj().zzbx("Install Referrer Reporter was called with invalid app package name");
            return;
        }
        ((zzco)this.zzadj.zzgn()).zzaf();
        if (!this.zzka()) {
            this.zzadj.zzgo().zzjj().zzbx("Install Referrer Reporter is not available");
            return;
        }
        this.zzadj.zzgo().zzjj().zzbx("Install Referrer Reporter is initializing");
        zzbh zzbh2 = new zzbh(this, string);
        zzbg zzbg2 = this;
        ((zzco)zzbg2.zzadj.zzgn()).zzaf();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzbg2.zzadj.getContext().getPackageManager();
        if (packageManager == null) {
            zzbg2.zzadj.zzgo().zzjg().zzbx("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string2 = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && "com.android.vending".equals(string2) && zzbg2.zzka()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzbg2.zzadj.getContext(), intent2, (ServiceConnection)zzbh2, 1);
                        zzbg2.zzadj.zzgo().zzjj().zzg("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzbg2.zzadj.zzgo().zzjd().zzg("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzbg2.zzadj.zzgo().zzjj().zzbx("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzbg2.zzadj.zzgo().zzjj().zzbx("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzka() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzadj.getContext());
            if (packageManagerWrapper == null) {
                this.zzadj.zzgo().zzjj().zzbx("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzadj.zzgo().zzjj().zzg("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zza(String string, zzu zzu2) {
        Bundle bundle;
        ((zzco)this.zzadj.zzgn()).zzaf();
        if (zzu2 == null) {
            this.zzadj.zzgo().zzjg().zzbx("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", string);
        try {
            bundle = zzu2.zza(bundle2);
            if (bundle == null) {
                this.zzadj.zzgo().zzjd().zzbx("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzadj.zzgo().zzjd().zzg("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }
}

