/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzbk;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzbm;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzk;

public final class zzbj {
    private final zzbm zzaoi;

    public zzbj(zzbm zzbm2) {
        Preconditions.checkNotNull((Object)zzbm2);
        this.zzaoi = zzbm2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzbt zzbt2 = zzbt.zza(context, null);
        zzap zzap2 = zzbt2.zzgo();
        if (intent == null) {
            zzap2.zzjg().zzbx("Receiver called with null intent");
            return;
        }
        zzk zzk2 = zzbt2.zzgr();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzap2.zzjl().zzg("Device receiver got", string);
        } else {
            zzap2.zzjl().zzg("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzap2.zzjl().zzbx("Starting wakeful intent.");
            this.zzaoi.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzbt2.zzgn().zzc(new zzbk(this, zzbt2, zzap2));
            }
            catch (Exception exception) {
                zzap2.zzjg().zzg("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzaoi.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzap2.zzjl().zzbx("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzap2.zzjj().zzg("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzbt2.zzgm().zza(uri);
            if (bundle == null) {
                zzap2.zzjl().zzbx("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzap2.zzjg().zzbx("Install referrer is missing timestamp");
                }
                zzbt2.zzgn().zzc(new zzbl(this, zzbt2, l, bundle, context, zzap2, pendingResult));
            }
        }
    }
}

