/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzbq;
import com.google.android.gms.measurement.internal.zzbr;
import com.google.android.gms.measurement.internal.zzbs;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzcp;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzbo
extends zzcp {
    private ExecutorService zzaea;
    private zzbs zzaov;
    private zzbs zzaow;
    private final PriorityBlockingQueue<zzbr<?>> zzaox;
    private final BlockingQueue<zzbr<?>> zzaoy;
    private final Thread.UncaughtExceptionHandler zzaoz;
    private final Thread.UncaughtExceptionHandler zzapa;
    private final Object zzapb = new Object();
    private final Semaphore zzapc = new Semaphore(2);
    private volatile boolean zzapd;
    private static final AtomicLong zzape = new AtomicLong(Long.MIN_VALUE);

    zzbo(zzbt zzbt2) {
        super(zzbt2);
        this.zzaox = new PriorityBlockingQueue();
        this.zzaoy = new LinkedBlockingQueue();
        this.zzaoz = new zzbq(this, "Thread death: Uncaught exception on worker thread");
        this.zzapa = new zzbq(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzgt() {
        return false;
    }

    @Override
    public final void zzaf() {
        if (Thread.currentThread() != this.zzaov) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzgc() {
        if (Thread.currentThread() != this.zzaow) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzkb() {
        return Thread.currentThread() == this.zzaov;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbr zzbr2 = new zzbr(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzaov) {
            if (!this.zzaox.isEmpty()) {
                ((zzco)this).zzgo().zzjg().zzbx("Callable skipped the worker queue.");
            }
            zzbr2.run();
        } else {
            this.zza(zzbr2);
        }
        return zzbr2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbr zzbr2 = new zzbr(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzaov) {
            zzbr2.run();
        } else {
            this.zza(zzbr2);
        }
        return zzbr2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzbr(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzco)this).zzgn().zzc(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzco)this).zzgo().zzjg().zzbx(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzco)this).zzgo().zzjg().zzbx(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzbr<?> zzbr2) {
        Object object = this.zzapb;
        synchronized (object) {
            this.zzaox.add(zzbr2);
            if (this.zzaov == null) {
                this.zzaov = new zzbs(this, "Measurement Worker", this.zzaox);
                this.zzaov.setUncaughtExceptionHandler(this.zzaoz);
                this.zzaov.start();
            } else {
                this.zzaov.zzke();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        zzbr zzbr2 = new zzbr(this, runnable, false, "Task exception on network thread");
        zzbo zzbo2 = this;
        Object object = zzbo2.zzapb;
        synchronized (object) {
            zzbo2.zzaoy.add(zzbr2);
            if (zzbo2.zzaow == null) {
                zzbo2.zzaow = new zzbs(zzbo2, "Measurement Network", zzbo2.zzaoy);
                zzbo2.zzaow.setUncaughtExceptionHandler(zzbo2.zzapa);
                zzbo2.zzaow.start();
            } else {
                zzbo2.zzaow.zzke();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutorService zzkc() {
        Object object = this.zzapb;
        synchronized (object) {
            if (this.zzaea == null) {
                this.zzaea = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzaea;
        }
    }

    static /* synthetic */ Semaphore zza(zzbo zzbo2) {
        return zzbo2.zzapc;
    }

    static /* synthetic */ boolean zzb(zzbo zzbo2) {
        return zzbo2.zzapd;
    }

    static /* synthetic */ Object zzc(zzbo zzbo2) {
        return zzbo2.zzapb;
    }

    static /* synthetic */ zzbs zzd(zzbo zzbo2) {
        return zzbo2.zzaov;
    }

    static /* synthetic */ zzbs zza(zzbo zzbo2, zzbs zzbs2) {
        zzbo2.zzaov = null;
        return null;
    }

    static /* synthetic */ zzbs zze(zzbo zzbo2) {
        return zzbo2.zzaow;
    }

    static /* synthetic */ zzbs zzb(zzbo zzbo2, zzbs zzbs2) {
        zzbo2.zzaow = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzkd() {
        return zzape;
    }
}

