/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzsl;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbo;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzdm;
import com.google.android.gms.measurement.internal.zzdo;
import com.google.android.gms.measurement.internal.zzdr;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzx;
import java.util.concurrent.atomic.AtomicReference;

public class zzbt
implements zzcq {
    private static volatile zzbt zzapl;
    private final Context zzri;
    private final String zzadx;
    private final String zzapm;
    private final String zzapn;
    private final boolean zzadv;
    private final zzk zzaiq;
    private final zzn zzapo;
    private final zzba zzapp;
    private final zzap zzapq;
    private final zzbo zzapr;
    private final zzeq zzaps;
    private final AppMeasurement zzapt;
    private final zzfk zzapu;
    private final zzan zzapv;
    private final Clock zzrz;
    private final zzdo zzapw;
    private final zzcs zzapx;
    private final zza zzapy;
    private zzal zzapz;
    private zzdr zzaqa;
    private zzx zzaqb;
    private zzaj zzaqc;
    private zzbg zzaqd;
    private boolean zzvz = false;
    private Boolean zzaqe;
    private long zzaqf;
    private volatile Boolean zzaqg;
    private int zzaqh;
    private int zzaqi;
    private final long zzagx;

    private zzbt(zzcr zzcr2) {
        Preconditions.checkNotNull((Object)zzcr2);
        Object object = zzcr2.zzri;
        this.zzaiq = new zzk((Context)object);
        zzaf.zza(this.zzaiq);
        this.zzri = zzcr2.zzri;
        this.zzadx = zzcr2.zzadx;
        this.zzapm = zzcr2.zzapm;
        this.zzapn = zzcr2.zzapn;
        this.zzadv = zzcr2.zzadv;
        this.zzaqg = zzcr2.zzaqg;
        zzsl.init(this.zzri);
        this.zzrz = DefaultClock.getInstance();
        this.zzagx = this.zzrz.currentTimeMillis();
        object = this;
        this.zzapo = new zzn((zzbt)object);
        object = this;
        zzba zzba2 = new zzba((zzbt)object);
        zzba2.zzq();
        this.zzapp = zzba2;
        object = this;
        zzap zzap2 = new zzap((zzbt)object);
        zzap2.zzq();
        this.zzapq = zzap2;
        object = this;
        zzfk zzfk2 = new zzfk((zzbt)object);
        zzfk2.zzq();
        this.zzapu = zzfk2;
        object = this;
        zzan zzan2 = new zzan((zzbt)object);
        zzan2.zzq();
        this.zzapv = zzan2;
        object = this;
        this.zzapy = new zza((zzbt)object);
        object = this;
        zzdo zzdo2 = new zzdo((zzbt)object);
        zzdo2.zzq();
        this.zzapw = zzdo2;
        object = this;
        zzcs zzcs2 = new zzcs((zzbt)object);
        zzcs2.zzq();
        this.zzapx = zzcs2;
        object = this;
        this.zzapt = new AppMeasurement((zzbt)object);
        object = this;
        zzeq zzeq2 = new zzeq((zzbt)object);
        zzeq2.zzq();
        this.zzaps = zzeq2;
        object = this;
        zzbo zzbo2 = new zzbo((zzbt)object);
        zzbo2.zzq();
        this.zzapr = zzbo2;
        object = this;
        zzk zzk2 = ((zzbt)object).zzaiq;
        if (((zzbt)object).zzri.getApplicationContext() instanceof Application) {
            zzcs zzcs3 = ((zzbt)object).zzge();
            if (((zzco)zzcs3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzco)zzcs3).getContext().getApplicationContext();
                if (zzcs3.zzaqv == null) {
                    zzcs3.zzaqv = new zzdm(zzcs3, null);
                }
                zzdm zzdm2 = zzcs3.zzaqv;
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdm2);
                zzdm2 = zzcs3.zzaqv;
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdm2);
                ((zzco)zzcs3).zzgo().zzjl().zzbx("Registered activity lifecycle callback");
            }
        } else {
            ((zzbt)object).zzgo().zzjg().zzbx("Application context is not an Application");
        }
        this.zzapr.zzc(new zzbu(this, zzcr2));
    }

    @WorkerThread
    private final void zza(zzcr zzcr2) {
        ((zzco)this.zzgn()).zzaf();
        zzn.zzht();
        zzbt zzbt2 = this;
        zzx zzx2 = new zzx(zzbt2);
        zzx2.zzq();
        this.zzaqb = zzx2;
        zzbt2 = this;
        zzaj zzaj2 = new zzaj(zzbt2);
        zzaj2.zzq();
        this.zzaqc = zzaj2;
        zzbt2 = this;
        zzal zzal2 = new zzal(zzbt2);
        zzal2.zzq();
        this.zzapz = zzal2;
        zzbt2 = this;
        zzdr zzdr2 = new zzdr(zzbt2);
        zzdr2.zzq();
        this.zzaqa = zzdr2;
        this.zzapu.zzgs();
        this.zzapp.zzgs();
        zzbt2 = this;
        this.zzaqd = new zzbg(zzbt2);
        this.zzaqc.zzgs();
        this.zzgo().zzjj().zzg("App measurement is starting up, version", this.zzapo.zzhc());
        zzk zzk2 = this.zzaiq;
        this.zzgo().zzjj().zzbx("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzk2 = this.zzaiq;
        String string = zzaj2.zzal();
        if (TextUtils.isEmpty((CharSequence)this.zzadx)) {
            String string2;
            zzar zzar2;
            if (this.zzgm().zzcw(string)) {
                zzar2 = this.zzgo().zzjj();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzar2 = this.zzgo().zzjj();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzar2.zzbx(string2);
        }
        this.zzgo().zzjk().zzbx("Debug-level message logging enabled");
        if (this.zzaqh != this.zzaqi) {
            this.zzgo().zzjd().zze("Not all components initialized", this.zzaqh, this.zzaqi);
        }
        this.zzvz = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzco)this.zzgn()).zzaf();
        if (this.zzgp().zzane.get() == 0L) {
            this.zzgp().zzane.set(this.zzrz.currentTimeMillis());
        }
        if (Long.valueOf(this.zzgp().zzanj.get()) == 0L) {
            this.zzgo().zzjl().zzg("Persisting first open", this.zzagx);
            this.zzgp().zzanj.set(this.zzagx);
        }
        if (!this.zzkr()) {
            if (this.isEnabled()) {
                if (!this.zzgm().zzx("android.permission.INTERNET")) {
                    this.zzgo().zzjd().zzbx("App is missing INTERNET permission");
                }
                if (!this.zzgm().zzx("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzgo().zzjd().zzbx("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzk zzk2 = this.zzaiq;
                if (!Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() && !this.zzapo.zzib()) {
                    if (!zzbj.zza(this.zzri)) {
                        this.zzgo().zzjd().zzbx("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzfk.zza(this.zzri, false)) {
                        this.zzgo().zzjd().zzbx("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzgo().zzjd().zzbx("Uploading is not possible. App measurement disabled");
                return;
            }
        } else {
            zzk zzk3 = this.zzaiq;
            if (!TextUtils.isEmpty((CharSequence)this.zzgf().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgf().zzgw())) {
                this.zzgm();
                if (zzfk.zza(this.zzgf().getGmpAppId(), this.zzgp().zzjs(), this.zzgf().zzgw(), this.zzgp().zzjt())) {
                    this.zzgo().zzjj().zzbx("Rechecking which service to use due to a GMP App Id change");
                    this.zzgp().zzjv();
                    if (this.zzapo.zza(zzaf.zzalc)) {
                        this.zzgi().resetAnalyticsData();
                    }
                    this.zzaqa.disconnect();
                    this.zzaqa.zzdj();
                    this.zzgp().zzanj.set(this.zzagx);
                    this.zzgp().zzanl.zzcc(null);
                }
                this.zzgp().zzca(this.zzgf().getGmpAppId());
                this.zzgp().zzcb(this.zzgf().zzgw());
                if (this.zzapo.zzbj(this.zzgf().zzal())) {
                    this.zzaps.zzam(this.zzagx);
                }
            }
            this.zzge().zzcm(this.zzgp().zzanl.zzjz());
            zzk3 = this.zzaiq;
            if (!TextUtils.isEmpty((CharSequence)this.zzgf().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgf().zzgw())) {
                boolean bl = this.isEnabled();
                if (!this.zzgp().zzjy() && !this.zzapo.zzhu()) {
                    this.zzgp().zzi(!bl);
                }
                if (this.zzapo.zze(this.zzgf().zzal(), zzaf.zzalj)) {
                    this.zzj(false);
                }
                if (!this.zzapo.zzbd(this.zzgf().zzal()) || bl) {
                    this.zzge().zzkz();
                }
                this.zzgg().zza(new AtomicReference<String>());
            }
        }
    }

    final void zzj(boolean bl) {
        ((zzco)this.zzgn()).zzaf();
        String string = this.zzgp().zzans.zzjz();
        boolean bl2 = true;
        if (!bl && string != null) {
            if ("unset".equals(string)) {
                this.zzge().zza("app", "_ap", null, this.zzrz.currentTimeMillis());
            } else {
                this.zzge().zza("app", "_ap", (Object)string, this.zzrz.currentTimeMillis());
                bl2 = false;
            }
        }
        if (bl2) {
            Boolean bl3 = this.zzapo.zzau("google_analytics_default_allow_ad_personalization_signals");
            if (bl3 != null) {
                this.zzge().zza("auto", "_ap", (Object)(bl3 != false ? 1L : 0L), this.zzrz.currentTimeMillis());
                return;
            }
            this.zzge().zza("auto", "_ap", null, this.zzrz.currentTimeMillis());
        }
    }

    @Override
    public final zzk zzgr() {
        return this.zzaiq;
    }

    public final zzn zzgq() {
        return this.zzapo;
    }

    public final zzba zzgp() {
        zzbt.zza((zzco)this.zzapp);
        return this.zzapp;
    }

    @Override
    public final zzap zzgo() {
        zzbt.zza(this.zzapq);
        return this.zzapq;
    }

    public final zzap zzkf() {
        if (this.zzapq != null && this.zzapq.isInitialized()) {
            return this.zzapq;
        }
        return null;
    }

    @Override
    public final zzbo zzgn() {
        zzbt.zza(this.zzapr);
        return this.zzapr;
    }

    public final zzeq zzgj() {
        zzbt.zza(this.zzaps);
        return this.zzaps;
    }

    public final zzbg zzkg() {
        return this.zzaqd;
    }

    final zzbo zzkh() {
        return this.zzapr;
    }

    public final zzcs zzge() {
        zzbt.zza(this.zzapx);
        return this.zzapx;
    }

    public final AppMeasurement zzki() {
        return this.zzapt;
    }

    public final zzfk zzgm() {
        zzbt.zza((zzco)this.zzapu);
        return this.zzapu;
    }

    public final zzan zzgl() {
        zzbt.zza((zzco)this.zzapv);
        return this.zzapv;
    }

    public final zzal zzgi() {
        zzbt.zza(this.zzapz);
        return this.zzapz;
    }

    @Override
    public final Context getContext() {
        return this.zzri;
    }

    public final boolean zzkj() {
        return TextUtils.isEmpty((CharSequence)this.zzadx);
    }

    public final String zzkk() {
        return this.zzadx;
    }

    public final String zzkl() {
        return this.zzapm;
    }

    public final String zzkm() {
        return this.zzapn;
    }

    public final boolean zzkn() {
        return this.zzadv;
    }

    @Override
    public final Clock zzbx() {
        return this.zzrz;
    }

    public final zzdo zzgh() {
        zzbt.zza(this.zzapw);
        return this.zzapw;
    }

    public final zzdr zzgg() {
        zzbt.zza(this.zzaqa);
        return this.zzaqa;
    }

    public final zzx zzgk() {
        zzbt.zza(this.zzaqb);
        return this.zzaqb;
    }

    public final zzaj zzgf() {
        zzbt.zza(this.zzaqc);
        return this.zzaqc;
    }

    public final zza zzgd() {
        if (this.zzapy == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzapy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbt zza(Context context, zzak zzak2) {
        if (zzak2 != null && (zzak2.origin == null || zzak2.zzadx == null)) {
            zzak2 = new zzak(zzak2.zzadt, zzak2.zzadu, zzak2.zzadv, zzak2.zzadw, null, null, zzak2.zzady);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzapl == null) {
            Class<zzbt> clazz = zzbt.class;
            synchronized (zzbt.class) {
                if (zzapl == null) {
                    zzcr zzcr2 = new zzcr(context, zzak2);
                    zzapl = new zzbt(zzcr2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzak2 != null && zzak2.zzady != null && zzak2.zzady.containsKey("dataCollectionDefaultEnabled")) {
            zzapl.zzd(zzak2.zzady.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzapl;
    }

    private final void zzcl() {
        if (!this.zzvz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzcp zzcp2) {
        if (zzcp2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcp2.isInitialized()) {
            String string = String.valueOf(zzcp2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzf zzf2) {
        if (zzf2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzf2.isInitialized()) {
            String string = String.valueOf(zzf2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzco zzco2) {
        if (zzco2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zzd(boolean bl) {
        this.zzaqg = bl;
    }

    @WorkerThread
    public final boolean zzko() {
        return this.zzaqg != null && this.zzaqg != false;
    }

    @WorkerThread
    public final boolean isEnabled() {
        boolean bl;
        ((zzco)this.zzgn()).zzaf();
        this.zzcl();
        if (this.zzapo.zzhu()) {
            return false;
        }
        Boolean bl2 = this.zzapo.zzhv();
        if (bl2 != null) {
            bl = bl2;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzaqg != null && zzaf.zzalh.get().booleanValue()) {
                bl = this.zzaqg;
            }
        }
        return this.zzgp().zzh(bl);
    }

    final long zzkp() {
        Long l = this.zzgp().zzanj.get();
        if (l == 0L) {
            return this.zzagx;
        }
        return Math.min(this.zzagx, l);
    }

    final void zzgb() {
        zzk zzk2 = this.zzaiq;
    }

    final void zzga() {
        zzk zzk2 = this.zzaiq;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzcp zzcp2) {
        ++this.zzaqh;
    }

    final void zzb(zzf zzf2) {
        ++this.zzaqh;
    }

    final void zzkq() {
        ++this.zzaqi;
    }

    @WorkerThread
    protected final boolean zzkr() {
        this.zzcl();
        ((zzco)this.zzgn()).zzaf();
        if (this.zzaqe == null || this.zzaqf == 0L || this.zzaqe != null && !this.zzaqe.booleanValue() && Math.abs(this.zzrz.elapsedRealtime() - this.zzaqf) > 1000L) {
            this.zzaqf = this.zzrz.elapsedRealtime();
            zzk zzk2 = this.zzaiq;
            this.zzaqe = this.zzgm().zzx("android.permission.INTERNET") && this.zzgm().zzx("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() || this.zzapo.zzib() || zzbj.zza(this.zzri) && zzfk.zza(this.zzri, false));
            if (this.zzaqe.booleanValue()) {
                this.zzaqe = this.zzgm().zzt(this.zzgf().getGmpAppId(), this.zzgf().zzgw()) || !TextUtils.isEmpty((CharSequence)this.zzgf().zzgw());
            }
        }
        return this.zzaqe;
    }

    static /* synthetic */ void zza(zzbt zzbt2, zzcr zzcr2) {
        zzbt2.zza(zzcr2);
    }
}

