/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcy;
import com.google.android.gms.measurement.internal.zzcz;
import com.google.android.gms.measurement.internal.zzda;
import com.google.android.gms.measurement.internal.zzdb;
import com.google.android.gms.measurement.internal.zzdc;
import com.google.android.gms.measurement.internal.zzdd;
import com.google.android.gms.measurement.internal.zzde;
import com.google.android.gms.measurement.internal.zzdf;
import com.google.android.gms.measurement.internal.zzdg;
import com.google.android.gms.measurement.internal.zzdh;
import com.google.android.gms.measurement.internal.zzdi;
import com.google.android.gms.measurement.internal.zzdj;
import com.google.android.gms.measurement.internal.zzdk;
import com.google.android.gms.measurement.internal.zzdl;
import com.google.android.gms.measurement.internal.zzdm;
import com.google.android.gms.measurement.internal.zzdn;
import com.google.android.gms.measurement.internal.zzdo;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcs
extends zzf {
    @VisibleForTesting
    protected zzdm zzaqv;
    private AppMeasurement.EventInterceptor zzaqw;
    private final Set<AppMeasurement.OnEventListener> zzaqx = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzaqy;
    private final AtomicReference<String> zzaqz = new AtomicReference();
    @VisibleForTesting
    protected boolean zzara = true;

    protected zzcs(zzbt zzbt2) {
        super(zzbt2);
    }

    @Override
    protected final boolean zzgt() {
        return false;
    }

    public final void zzks() {
        if (((zzco)this).getContext().getApplicationContext() instanceof Application) {
            zzdm zzdm2 = this.zzaqv;
            ((Application)((zzco)this).getContext().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdm2);
        }
    }

    public final Boolean zzkt() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzco)this).zzgn().zza(atomicReference, 15000L, "boolean test flag value", new zzct(this, atomicReference));
    }

    public final String zzku() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzco)this).zzgn().zza(atomicReference, 15000L, "String test flag value", new zzdd(this, atomicReference));
    }

    public final Long zzkv() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzco)this).zzgn().zza(atomicReference, 15000L, "long test flag value", new zzdf(this, atomicReference));
    }

    public final Integer zzkw() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzco)this).zzgn().zza(atomicReference, 15000L, "int test flag value", new zzdg(this, atomicReference));
    }

    public final Double zzkx() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzco)this).zzgn().zza(atomicReference, 15000L, "double test flag value", new zzdh(this, atomicReference));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzcl();
        ((zzco)this).zzgb();
        ((zzco)this).zzgn().zzc(new zzdi(this, bl));
    }

    public final void zzd(boolean bl) {
        this.zzcl();
        ((zzco)this).zzgb();
        ((zzco)this).zzgn().zzc(new zzdj(this, bl));
    }

    @WorkerThread
    private final void zzk(boolean bl) {
        ((zzco)this).zzaf();
        ((zzco)this).zzgb();
        this.zzcl();
        ((zzco)this).zzgo().zzjk().zzg("Setting app measurement enabled (FE)", bl);
        ((zzco)this).zzgp().setMeasurementEnabled(bl);
        this.zzky();
    }

    @WorkerThread
    private final void zzky() {
        if (((zzco)this).zzgq().zze(((zze)this).zzgf().zzal(), zzaf.zzalj)) {
            this.zzadj.zzj(false);
        }
        if (((zzco)this).zzgq().zzbd(((zze)this).zzgf().zzal()) && this.zzadj.isEnabled() && this.zzara) {
            ((zzco)this).zzgo().zzjk().zzbx("Recording app launch after enabling measurement for the first time (FE)");
            this.zzkz();
            return;
        }
        ((zzco)this).zzgo().zzjk().zzbx("Updating Scion state (FE)");
        ((zze)this).zzgg().zzlc();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzco)this).zzgb();
        ((zzco)this).zzgn().zzc(new zzdk(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzco)this).zzgb();
        ((zzco)this).zzgn().zzc(new zzdl(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.logEvent(string, string2, bundle, false, true, ((zzco)this).zzbx().currentTimeMillis());
    }

    public final void logEvent(String string, String string2, Bundle bundle) {
        this.logEvent(string, string2, bundle, true, true, ((zzco)this).zzbx().currentTimeMillis());
    }

    @WorkerThread
    final void zza(String string, String string2, Bundle bundle) {
        ((zzco)this).zzgb();
        ((zzco)this).zzaf();
        this.zza(string, string2, ((zzco)this).zzbx().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzco)this).zzgb();
        ((zzco)this).zzaf();
        boolean bl = this.zzaqw == null || zzfk.zzcv(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    @WorkerThread
    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzdn zzdn2;
        zzdn zzdn3;
        Object object4;
        Object object5;
        zzco zzco2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)bundle);
        ((zzco)this).zzaf();
        this.zzcl();
        if (!this.zzadj.isEnabled()) {
            ((zzco)this).zzgo().zzjk().zzbx("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzaqy) {
            this.zzaqy = true;
            zzco2 = this;
            try {
                object5 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object5;
                object4 = zzco2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzco)object4).getContext());
                }
                catch (Exception exception) {
                    ((zzco)object4).zzgo().zzjg().zzg("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzco2.zzgo().zzjj().zzbx("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3) {
            object4 = ((zzco)this).zzgr();
            if (!"_iap".equals(string2)) {
                int n;
                object5 = string2;
                zzco2 = this.zzadj.zzgm();
                if ((!((zzfk)zzco2).zzr("event", (String)object5) ? 2 : (!((zzfk)zzco2).zza("event", AppMeasurement.Event.zzadk, (String)object5) ? 13 : (n = !((zzfk)zzco2).zza("event", 40, (String)object5) ? 2 : 0))) != 0) {
                    ((zzco)this).zzgo().zzjf().zzg("Invalid public event name. Event will not be logged (FE)", ((zzco)this).zzgl().zzbs(string2));
                    this.zzadj.zzgm();
                    String string4 = zzfk.zza(string2, 40, true);
                    int n2 = string2 != null ? string2.length() : 0;
                    this.zzadj.zzgm().zza(n, "_ev", string4, n2);
                    return;
                }
            }
        }
        object4 = ((zzco)this).zzgr();
        zzdn zzdn4 = ((zze)this).zzgh().zzla();
        if (zzdn4 != null && !bundle.containsKey("_sc")) {
            zzdn4.zzarn = true;
        }
        zzdn zzdn5 = zzdn4;
        zzdo.zza(zzdn5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzfk.zzcv(string2);
        if (bl && this.zzaqw != null && !bl5 && !bl4) {
            ((zzco)this).zzgo().zzjk().zze("Passing event to registered event handler (FE)", ((zzco)this).zzgl().zzbs(string2), ((zzco)this).zzgl().zzd(bundle));
            this.zzaqw.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzadj.zzkr()) {
            return;
        }
        int n = ((zzco)this).zzgm().zzcr(string2);
        if (n != 0) {
            ((zzco)this).zzgo().zzjf().zzg("Invalid event name. Event will not be logged (FE)", ((zzco)this).zzgl().zzbs(string2));
            ((zzco)this).zzgm();
            String string5 = zzfk.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzadj.zzgm().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzco)this).zzgm().zza(string3, string2, bundle, list, bl3, true);
        zzco2 = bundle3;
        if (bundle3 == null || !zzco2.containsKey("_sc") || !zzco2.containsKey("_si")) {
            zzdn3 = null;
        } else {
            object5 = zzco2.getString("_sn");
            String string6 = zzco2.getString("_sc");
            Long l2 = zzco2.getLong("_si");
            zzdn3 = zzdn2 = new zzdn((String)object5, string6, l2);
        }
        if (zzdn3 == null) {
            zzdn2 = zzdn5;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l3 = ((zzco)this).zzgm().zzmd().nextLong();
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzco)this).zzgm();
            object = zzfk.zze(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle object6 = object[j];
                zzdo.zza(zzdn2, object6, true);
                bundle2 = ((zzco)this).zzgm().zza(string3, "_ep", object6, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l3);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l3);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle4 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle4.putString("_o", string);
            object2 = bl2 ? ((zzco)this).zzgm().zze(bundle4) : bundle4;
            ((zzco)this).zzgo().zzjk().zze("Logging event (FE)", ((zzco)this).zzgl().zzbs(string2), ((zzco)this).zzgl().zzd((Bundle)object2));
            object = new zzad((String)object3, new zzaa((Bundle)object2), string, l);
            ((zze)this).zzgg().zzb((zzad)((Object)object), string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzaqx) {
                bundle2 = new Bundle((Bundle)object2);
                onEventListener.onEvent(string, string2, bundle2, l);
            }
        }
        object4 = ((zzco)this).zzgr();
        if (((zze)this).zzgh().zzla() != null && "_ae".equals(string2)) {
            ((zze)this).zzgj().zzn(true);
        }
    }

    public final void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        ((zzco)this).zzgb();
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        boolean bl3 = !bl2 || this.zzaqw == null || zzfk.zzcv(string2);
        this.zzb(string, string2, l, bundle, bl2, bl3, !bl, null);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2 = zzfk.zzf(bundle);
        ((zzco)this).zzgn().zzc(new zzcu(this, string, string2, l, bundle2, bl, bl2, bl3, string3));
    }

    public final void zzb(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, bl, ((zzco)this).zzbx().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl || "_ap".equals(string2)) {
            n2 = ((zzco)this).zzgm().zzcs(string2);
        } else {
            String string3 = string2;
            zzfk zzfk2 = ((zzco)this).zzgm();
            n2 = !zzfk2.zzr("user property", string3) ? 6 : (!zzfk2.zza("user property", AppMeasurement.UserProperty.zzado, string3) ? 15 : (n = !zzfk2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzco)this).zzgm();
            String string4 = zzfk.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzadj.zzgm().zza(n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzco)this).zzgm().zzi(string2, object);
            if (n != 0) {
                ((zzco)this).zzgm();
                String string5 = zzfk.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzadj.zzgm().zza(n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzco)this).zzgm().zzj(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzco)this).zzgn().zzc(new zzcv(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzco)this).zzaf();
        ((zzco)this).zzgb();
        this.zzcl();
        if (((zzco)this).zzgq().zze(((zze)this).zzgf().zzal(), zzaf.zzalj)) {
            if ("_ap".equals(string2) && !"auto".equals(string)) {
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)((String)object))) {
                    object = "true".equals(((String)object).toLowerCase(Locale.ENGLISH)) || "1".equals(object) ? 1L : 0L;
                    ((zzco)this).zzgp().zzans.zzcc((Long)object == 1L ? "true" : "false");
                } else if (object == null) {
                    ((zzco)this).zzgp().zzans.zzcc("unset");
                    ((zzco)this).zzgn().zzc(new zzcw(this));
                }
            }
        } else if ("_ap".equals(string2)) {
            return;
        }
        if (!this.zzadj.isEnabled()) {
            ((zzco)this).zzgo().zzjk().zzbx("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzadj.zzkr()) {
            return;
        }
        ((zzco)this).zzgo().zzjk().zze("Setting user property (FE)", ((zzco)this).zzgl().zzbs(string2), object);
        zzfh zzfh2 = new zzfh(string2, l, object, string);
        ((zze)this).zzgg().zzb(zzfh2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzfh> zzl(boolean bl) {
        ((zzco)this).zzgb();
        this.zzcl();
        ((zzco)this).zzgo().zzjk().zzbx("Fetching user attributes (FE)");
        if (((zzco)this).zzgn().zzkb()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzk.isMainThread()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzadj.zzgn().zzc(new zzcx(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzco)this).zzgo().zzjg().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzco)this).zzgo().zzjg().zzbx("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    @Nullable
    public final String zzfx() {
        ((zzco)this).zzgb();
        return this.zzaqz.get();
    }

    @Nullable
    public final String zzaj(long l) {
        if (((zzco)this).zzgn().zzkb()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        if (zzk.isMainThread()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot retrieve app instance id from main thread");
            return null;
        }
        long l2 = ((zzco)this).zzbx().elapsedRealtime();
        String string = this.zzak(120000L);
        long l3 = ((zzco)this).zzbx().elapsedRealtime() - l2;
        if (string == null && l3 < 120000L) {
            string = this.zzak(120000L - l3);
        }
        return string;
    }

    final void zzcm(@Nullable String string) {
        this.zzaqz.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final String zzak(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzco)this).zzgn().zzc(new zzcy(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzco)this).zzgo().zzjg().zzbx("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData(long l) {
        if (((zzco)this).zzgq().zza(zzaf.zzalk)) {
            this.zzcm(null);
        }
        ((zzco)this).zzgn().zzc(new zzcz(this, l));
    }

    @WorkerThread
    public final void zzkz() {
        ((zzco)this).zzaf();
        ((zzco)this).zzgb();
        this.zzcl();
        if (!this.zzadj.zzkr()) {
            return;
        }
        ((zze)this).zzgg().zzkz();
        this.zzara = false;
        String string = ((zzco)this).zzgp().zzjw();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzco)this).zzgk().zzcl();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.logEvent("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzco)this).zzaf();
        ((zzco)this).zzgb();
        this.zzcl();
        if (eventInterceptor != null && eventInterceptor != this.zzaqw) {
            Preconditions.checkState((this.zzaqw == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzaqw = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzco)this).zzgb();
        this.zzcl();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzaqx.add(onEventListener)) {
            ((zzco)this).zzgo().zzjg().zzbx("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzco)this).zzgb();
        this.zzcl();
        Preconditions.checkNotNull((Object)onEventListener);
        if (!this.zzaqx.remove(onEventListener)) {
            ((zzco)this).zzgo().zzjg().zzbx("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        ((zzco)this).zzgb();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzco)this).zzgo().zzjg().zzbx("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mAppId);
        ((zzco)this).zzga();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzco)this).zzbx().currentTimeMillis();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzco)this).zzgm().zzcs(string) != 0) {
            ((zzco)this).zzgo().zzjd().zzg("Invalid conditional user property name", ((zzco)this).zzgl().zzbu(string));
            return;
        }
        if (((zzco)this).zzgm().zzi(string, object) != 0) {
            ((zzco)this).zzgo().zzjd().zze("Invalid conditional user property value", ((zzco)this).zzgl().zzbu(string), object);
            return;
        }
        Object object2 = ((zzco)this).zzgm().zzj(string, object);
        if (object2 == null) {
            ((zzco)this).zzgo().zzjd().zze("Unable to normalize conditional user property value", ((zzco)this).zzgl().zzbu(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzco)this).zzgo().zzjd().zze("Invalid conditional user property timeout", ((zzco)this).zzgl().zzbu(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzco)this).zzgo().zzjd().zze("Invalid conditional user property time to live", ((zzco)this).zzgl().zzbu(string), l3);
            return;
        }
        ((zzco)this).zzgn().zzc(new zzda(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzco)this).zzgb();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzco)this).zzga();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzco)this).zzbx().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzco)this).zzgn().zzc(new zzdb(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzad zzad2;
        zzad zzad3;
        zzad zzad4;
        ((zzco)this).zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzadj.isEnabled()) {
            ((zzco)this).zzgo().zzjk().zzbx("Conditional property not sent since collection is disabled");
            return;
        }
        zzfh zzfh2 = new zzfh(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzad4 = ((zzco)this).zzgm().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzad3 = ((zzco)this).zzgm().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzad2 = ((zzco)this).zzgm().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzl zzl2 = new zzl(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzfh2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzad3, conditionalUserProperty.mTriggerTimeout, zzad4, conditionalUserProperty.mTimeToLive, zzad2);
        ((zze)this).zzgg().zzd(zzl2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzad zzad2;
        ((zzco)this).zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        if (!this.zzadj.isEnabled()) {
            ((zzco)this).zzgo().zzjk().zzbx("Conditional property not cleared since collection is disabled");
            return;
        }
        zzfh zzfh2 = new zzfh(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzad2 = ((zzco)this).zzgm().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzl zzl2 = new zzl(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzfh2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzad2);
        ((zze)this).zzgg().zzd(zzl2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzco)this).zzgb();
        return this.zzf(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzco)this).zzga();
        return this.zzf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final List<AppMeasurement.ConditionalUserProperty> zzf(String string, String string2, String string3) {
        if (((zzco)this).zzgn().zzkb()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzk.isMainThread()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzadj.zzgn().zzc(new zzdc(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzco)this).zzgo().zzjg().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzco)this).zzgo().zzjg().zzg("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzl zzl2 = (zzl)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = zzl2.packageName;
                conditionalUserProperty.mOrigin = zzl2.origin;
                conditionalUserProperty.mCreationTimestamp = zzl2.creationTimestamp;
                conditionalUserProperty.mName = zzl2.zzahb.name;
                conditionalUserProperty.mValue = zzl2.zzahb.getValue();
                conditionalUserProperty.mActive = zzl2.active;
                conditionalUserProperty.mTriggerEventName = zzl2.triggerEventName;
                if (zzl2.zzahc != null) {
                    conditionalUserProperty.mTimedOutEventName = zzl2.zzahc.name;
                    if (zzl2.zzahc.zzaid != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzl2.zzahc.zzaid.zziv();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzl2.triggerTimeout;
                if (zzl2.zzahd != null) {
                    conditionalUserProperty.mTriggeredEventName = zzl2.zzahd.name;
                    if (zzl2.zzahd.zzaid != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzl2.zzahd.zzaid.zziv();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzl2.zzahb.zzaue;
                conditionalUserProperty.mTimeToLive = zzl2.timeToLive;
                if (zzl2.zzahe != null) {
                    conditionalUserProperty.mExpiredEventName = zzl2.zzahe.name;
                    if (zzl2.zzahe.zzaid != null) {
                        conditionalUserProperty.mExpiredEventParams = zzl2.zzahe.zzaid.zziv();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzco)this).zzgb();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzco)this).zzga();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzco)this).zzgn().zzkb()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzk.isMainThread()) {
            ((zzco)this).zzgo().zzjd().zzbx("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzadj.zzgn().zzc(new zzde(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzco)this).zzgo().zzjg().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzco)this).zzgo().zzjg().zzbx("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzfh zzfh2 = (zzfh)((Object)iterator.next());
                arrayMap.put(zzfh2.name, zzfh2.getValue());
            }
            return arrayMap;
        }
    }

    @Nullable
    public final String getCurrentScreenName() {
        zzdn zzdn2 = this.zzadj.zzgh().zzlb();
        if (zzdn2 != null) {
            return zzdn2.zzuw;
        }
        return null;
    }

    @Nullable
    public final String getCurrentScreenClass() {
        zzdn zzdn2 = this.zzadj.zzgh().zzlb();
        if (zzdn2 != null) {
            return zzdn2.zzarl;
        }
        return null;
    }

    @Nullable
    public final String getGmpAppId() {
        if (this.zzadj.zzkk() != null) {
            return this.zzadj.zzkk();
        }
        try {
            return GoogleServices.getGoogleAppId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzadj.zzgo().zzjd().zzg("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    static /* synthetic */ void zza(zzcs zzcs2, boolean bl) {
        zzcs2.zzk(bl);
    }

    static /* synthetic */ void zza(zzcs zzcs2) {
        zzcs2.zzky();
    }

    static /* synthetic */ void zza(zzcs zzcs2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcs2.zza(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcs zzcs2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcs2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcs zzcs2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcs2.zzc(conditionalUserProperty);
    }
}

