/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzdr;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzn;

@VisibleForTesting
public final class zzef
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzasm;
    private volatile zzao zzasn;
    final /* synthetic */ zzdr zzasg;

    protected zzef(zzdr zzdr2) {
        this.zzasg = zzdr2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzc(Intent intent) {
        ((zzco)this.zzasg).zzaf();
        Context context = ((zzco)this.zzasg).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzef zzef2 = this;
        synchronized (zzef2) {
            if (this.zzasm) {
                ((zzco)this.zzasg).zzgo().zzjl().zzbx("Connection attempt already in progress");
                return;
            }
            ((zzco)this.zzasg).zzgo().zzjl().zzbx("Using local app measurement service");
            this.zzasm = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzdr.zza(this.zzasg), 129);
            return;
        }
    }

    @WorkerThread
    public final void zzlg() {
        if (this.zzasn != null && (this.zzasn.isConnected() || this.zzasn.isConnecting())) {
            this.zzasn.disconnect();
        }
        this.zzasn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzef zzef2 = this;
        synchronized (zzef2) {
            String string;
            if (iBinder == null) {
                this.zzasm = false;
                ((zzco)this.zzasg).zzgo().zzjd().zzbx("Service connected with null binder");
                return;
            }
            zzag zzag2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzag2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzag ? (zzag)iInterface : new zzai(iBinder2));
                    ((zzco)this.zzasg).zzgo().zzjl().zzbx("Bound to IMeasurementService interface");
                } else {
                    ((zzco)this.zzasg).zzgo().zzjd().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzco)this.zzasg).zzgo().zzjd().zzbx("Service connect failed to get IMeasurementService");
            }
            if (zzag2 == null) {
                this.zzasm = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzco)this.zzasg).getContext(), (ServiceConnection)zzdr.zza(this.zzasg));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzag2;
                ((zzco)this.zzasg).zzgn().zzc(new zzeg(this, (zzag)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzco)this.zzasg).zzgo().zzjk().zzbx("Service disconnected");
        ((zzco)this.zzasg).zzgn().zzc(new zzeh(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzlh() {
        ((zzco)this.zzasg).zzaf();
        Context context = ((zzco)this.zzasg).getContext();
        zzef zzef2 = this;
        synchronized (zzef2) {
            if (this.zzasm) {
                ((zzco)this.zzasg).zzgo().zzjl().zzbx("Connection attempt already in progress");
                return;
            }
            if (this.zzasn != null && (!zzn.zzia() || this.zzasn.isConnecting() || this.zzasn.isConnected())) {
                ((zzco)this.zzasg).zzgo().zzjl().zzbx("Already awaiting connection attempt");
                return;
            }
            this.zzasn = new zzao(context, Looper.getMainLooper(), this, this);
            ((zzco)this.zzasg).zzgo().zzjl().zzbx("Connecting to remote service");
            this.zzasm = true;
            this.zzasn.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzef zzef2 = this;
        synchronized (zzef2) {
            try {
                zzag zzag2 = (zzag)this.zzasn.getService();
                if (!zzn.zzia()) {
                    this.zzasn = null;
                }
                ((zzco)this.zzasg).zzgn().zzc(new zzei(this, zzag2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzasn = null;
                this.zzasm = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzco)this.zzasg).zzgo().zzjk().zzbx("Service connection suspended");
        ((zzco)this.zzasg).zzgn().zzc(new zzej(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzap zzap2 = this.zzasg.zzadj.zzkf();
        if (zzap2 != null) {
            zzap2.zzjg().zzg("Service connection failed", connectionResult);
        }
        zzef zzef2 = this;
        synchronized (zzef2) {
            this.zzasm = false;
            this.zzasn = null;
        }
        ((zzco)this.zzasg).zzgn().zzc(new zzek(this));
    }

    static /* synthetic */ boolean zza(zzef zzef2, boolean bl) {
        zzef2.zzasm = false;
        return false;
    }
}

