/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import java.lang.reflect.InvocationTargetException;

public final class zzn
extends zzco {
    private Boolean zzahf;
    @NonNull
    private zzp zzahg = zzo.zzahh;
    private Boolean zzyk;

    zzn(zzbt zzbt2) {
        super(zzbt2);
        zzaf.zza(zzbt2);
    }

    final void zza(@NonNull zzp zzp2) {
        this.zzahg = zzp2;
    }

    static String zzht() {
        return zzaf.zzajd.get();
    }

    @WorkerThread
    public final int zzat(@Size(min=1L) String string) {
        return this.zzb(string, zzaf.zzajr);
    }

    public final long zzhc() {
        zzk zzk2 = ((zzco)this).zzgr();
        return 13001L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzdw() {
        if (this.zzyk == null) {
            zzn zzn2 = this;
            synchronized (zzn2) {
                if (this.zzyk == null) {
                    ApplicationInfo applicationInfo = ((zzco)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzyk = string2 != null && string2.equals(string);
                    }
                    if (this.zzyk == null) {
                        this.zzyk = Boolean.TRUE;
                        ((zzco)this).zzgo().zzjd().zzbx("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzyk;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzaf.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahg.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.parseLong(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzaf.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahg.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.parseInt(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzaf.zza<Double> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahg.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            double d = Double.parseDouble(string2);
            return zza2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzaf.zza<Boolean> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahg.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zza2.get(bl);
    }

    public final boolean zze(String string, zzaf.zza<Boolean> zza2) {
        return this.zzd(string, zza2);
    }

    public final boolean zza(zzaf.zza<Boolean> zza2) {
        zzaf.zza<Boolean> zza3 = zza2;
        return this.zzd(null, zza3);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzau(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzco)this).getContext().getPackageManager() == null) {
                ((zzco)this).zzgo().zzjd().zzbx("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzco)this).getContext()).getApplicationInfo(((zzco)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzco)this).zzgo().zzjd().zzbx("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzco)this).zzgo().zzjd().zzbx("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzco)this).zzgo().zzjd().zzg("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzhu() {
        zzk zzk2 = ((zzco)this).zzgr();
        Boolean bl = this.zzau("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzhv() {
        zzk zzk2 = ((zzco)this).zzgr();
        return this.zzau("firebase_analytics_collection_enabled");
    }

    public static long zzhw() {
        return zzaf.zzakg.get();
    }

    public static long zzhx() {
        return zzaf.zzajg.get();
    }

    public final String zzhy() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzco)this).zzgo().zzjd().zzg("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzco)this).zzgo().zzjd().zzg("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzco)this).zzgo().zzjd().zzg("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzco)this).zzgo().zzjd().zzg("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzhz() {
        return zzaf.zzajc.get();
    }

    public final boolean zzav(String string) {
        return "1".equals(this.zzahg.zzf(string, "gaia_collection_enabled"));
    }

    public final boolean zzaw(String string) {
        return "1".equals(this.zzahg.zzf(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzax(String string) {
        return this.zzd(string, zzaf.zzakp);
    }

    @WorkerThread
    final boolean zzay(String string) {
        return this.zzd(string, zzaf.zzakr);
    }

    @WorkerThread
    final boolean zzaz(String string) {
        return this.zzd(string, zzaf.zzaks);
    }

    @WorkerThread
    final boolean zzba(String string) {
        return this.zzd(string, zzaf.zzakk);
    }

    @WorkerThread
    final String zzbb(String string) {
        zzaf.zza<String> zza2 = zzaf.zzakl;
        String string2 = string;
        zzn zzn2 = this;
        if (string2 == null) {
            return zza2.get();
        }
        return zza2.get(zzn2.zzahg.zzf(string2, zza2.getKey()));
    }

    final boolean zzbc(String string) {
        return this.zzd(string, zzaf.zzakt);
    }

    @WorkerThread
    final boolean zzbd(String string) {
        return this.zzd(string, zzaf.zzaku);
    }

    @WorkerThread
    final boolean zzbe(String string) {
        return this.zzd(string, zzaf.zzakx);
    }

    @WorkerThread
    final boolean zzbf(String string) {
        return this.zzd(string, zzaf.zzaky);
    }

    @WorkerThread
    final boolean zzbg(String string) {
        return this.zzd(string, zzaf.zzala);
    }

    static boolean zzia() {
        return zzaf.zzalb.get();
    }

    @WorkerThread
    final boolean zzib() {
        if (this.zzahf == null) {
            this.zzahf = this.zzau("app_measurement_lite");
            if (this.zzahf == null) {
                this.zzahf = false;
            }
        }
        return this.zzahf != false || !this.zzadj.zzkn();
    }

    @WorkerThread
    final boolean zzbh(String string) {
        return this.zzd(string, zzaf.zzakz);
    }

    @WorkerThread
    static boolean zzic() {
        return zzaf.zzald.get();
    }

    @WorkerThread
    final boolean zzbi(String string) {
        return this.zzd(string, zzaf.zzale);
    }

    @WorkerThread
    final boolean zzbj(String string) {
        return this.zzd(string, zzaf.zzalf);
    }
}

