/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzet;

@VisibleForTesting
public final class zzeo
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzatb;
    private volatile zzap zzatc;
    final /* synthetic */ zzdz zzasv;

    protected zzeo(zzdz zzdz2) {
        this.zzasv = zzdz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzc(Intent intent) {
        ((zzcp)this.zzasv).zzaf();
        Context context = ((zzcp)this.zzasv).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzeo zzeo2 = this;
        synchronized (zzeo2) {
            if (this.zzatb) {
                ((zzcp)this.zzasv).zzgt().zzjo().zzca("Connection attempt already in progress");
                return;
            }
            ((zzcp)this.zzasv).zzgt().zzjo().zzca("Using local app measurement service");
            this.zzatb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzdz.zza(this.zzasv), 129);
            return;
        }
    }

    @WorkerThread
    public final void zzlk() {
        if (this.zzatc != null && (this.zzatc.isConnected() || this.zzatc.isConnecting())) {
            this.zzatc.disconnect();
        }
        this.zzatc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzeo zzeo2 = this;
        synchronized (zzeo2) {
            String string;
            if (iBinder == null) {
                this.zzatb = false;
                ((zzcp)this.zzasv).zzgt().zzjg().zzca("Service connected with null binder");
                return;
            }
            zzah zzah2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzah2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzah ? (zzah)iInterface : new zzaj(iBinder2));
                    ((zzcp)this.zzasv).zzgt().zzjo().zzca("Bound to IMeasurementService interface");
                } else {
                    ((zzcp)this.zzasv).zzgt().zzjg().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcp)this.zzasv).zzgt().zzjg().zzca("Service connect failed to get IMeasurementService");
            }
            if (zzah2 == null) {
                this.zzatb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzcp)this.zzasv).getContext(), (ServiceConnection)zzdz.zza(this.zzasv));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzah2;
                ((zzcp)this.zzasv).zzgs().zzc(new zzep(this, (zzah)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcp)this.zzasv).zzgt().zzjn().zzca("Service disconnected");
        ((zzcp)this.zzasv).zzgs().zzc(new zzeq(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzll() {
        ((zzcp)this.zzasv).zzaf();
        Context context = ((zzcp)this.zzasv).getContext();
        zzeo zzeo2 = this;
        synchronized (zzeo2) {
            if (this.zzatb) {
                ((zzcp)this.zzasv).zzgt().zzjo().zzca("Connection attempt already in progress");
                return;
            }
            if (this.zzatc != null && (this.zzatc.isConnecting() || this.zzatc.isConnected())) {
                ((zzcp)this.zzasv).zzgt().zzjo().zzca("Already awaiting connection attempt");
                return;
            }
            this.zzatc = new zzap(context, Looper.getMainLooper(), this, this);
            ((zzcp)this.zzasv).zzgt().zzjo().zzca("Connecting to remote service");
            this.zzatb = true;
            this.zzatc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzeo zzeo2 = this;
        synchronized (zzeo2) {
            try {
                zzah zzah2 = (zzah)this.zzatc.getService();
                ((zzcp)this.zzasv).zzgs().zzc(new zzer(this, zzah2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzatc = null;
                this.zzatb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcp)this.zzasv).zzgt().zzjn().zzca("Service connection suspended");
        ((zzcp)this.zzasv).zzgs().zzc(new zzes(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzaq zzaq2 = this.zzasv.zzadp.zzkj();
        if (zzaq2 != null) {
            zzaq2.zzjj().zzg("Service connection failed", connectionResult);
        }
        zzeo zzeo2 = this;
        synchronized (zzeo2) {
            this.zzatb = false;
            this.zzatc = null;
        }
        ((zzcp)this.zzasv).zzgs().zzc(new zzet(this));
    }

    static /* synthetic */ boolean zza(zzeo zzeo2, boolean bl) {
        zzeo2.zzatb = false;
        return false;
    }
}

