/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzl;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;

public final class zzfu
extends zzcq {
    private static final String[] zzavb = new String[]{"firebase_", "google_", "ga_"};
    private SecureRandom zzavc;
    private final AtomicLong zzavd = new AtomicLong(0L);
    private int zzaed;
    private Integer zzave = null;

    zzfu(zzbu zzbu2) {
        super(zzbu2);
    }

    @Override
    protected final boolean zzgy() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzgz() {
        ((zzcp)this).zzaf();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzcp)this).zzgt().zzjj().zzca("Utils falling back to Random for random id");
        }
        this.zzavd.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzmj() {
        if (this.zzavd.get() == 0L) {
            AtomicLong atomicLong = this.zzavd;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzcp)this).zzbx().currentTimeMillis()).nextLong() + (long)(++this.zzaed);
            }
        }
        AtomicLong atomicLong = this.zzavd;
        synchronized (atomicLong) {
            this.zzavd.compareAndSet(-1L, 1L);
            return this.zzavd.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzmk() {
        ((zzcp)this).zzaf();
        if (this.zzavc == null) {
            this.zzavc = new SecureRandom();
        }
        return this.zzavc;
    }

    static boolean zzcv(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    final Bundle zza(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzcp)this).zzgt().zzjj().zzg("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    static boolean zzd(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    final boolean zzs(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzcp)this).zzgt().zzjg().zzg("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzcp)this).zzgt().zzjg().zzg("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzcp)this).zzgt().zzjg().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzcp)this).zzgt().zzjg().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    private final boolean zzt(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzcp)this).zzgt().zzjg().zzg("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzcp)this).zzgt().zzjg().zzg("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzcp)this).zzgt().zzjg().zze("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzcp)this).zzgt().zzjg().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String string2) {
        boolean bl;
        int n;
        String[] stringArray2;
        String string3;
        block6: {
            if (string2 == null) {
                ((zzcp)this).zzgt().zzjg().zzg("Name is required and can't be null. Type", string);
                return false;
            }
            string3 = string2;
            Preconditions.checkNotNull((Object)string3);
            stringArray2 = zzavb;
            int n2 = zzavb.length;
            for (n = 0; n < n2; ++n) {
                String string4 = stringArray2[n];
                if (!string3.startsWith(string4)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            ((zzcp)this).zzgt().zzjg().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null) {
            boolean bl2;
            block7: {
                stringArray2 = stringArray;
                string3 = string2;
                Preconditions.checkNotNull((Object)stringArray2);
                String[] stringArray3 = stringArray2;
                n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string5 = stringArray3[i];
                    if (!zzfu.zzv(string3, string5)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                ((zzcp)this).zzgt().zzjg().zze("Name is reserved. Type, name", string, string2);
                return false;
            }
        }
        return true;
    }

    final boolean zza(String string, int n, String string2) {
        if (string2 == null) {
            ((zzcp)this).zzgt().zzjg().zzg("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzcp)this).zzgt().zzjg().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final int zzcw(String string) {
        if (!this.zzt("event", string)) {
            return 2;
        }
        if (!this.zza("event", zzcs.zzard, string)) {
            return 13;
        }
        if (!this.zza("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzcx(String string) {
        if (!this.zzt("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", zzcu.zzarh, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    private final boolean zza(String string, String string2, int n, Object object, boolean bl) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzcp)this).zzgt().zzjj().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        if (object instanceof Bundle && bl) {
            return true;
        }
        if (object instanceof Parcelable[] && bl) {
            for (Parcelable parcelable : (Parcelable[])object) {
                if (parcelable instanceof Bundle) continue;
                ((zzcp)this).zzgt().zzjj().zze("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                return false;
            }
            return true;
        }
        if (object instanceof ArrayList && bl) {
            ArrayList arrayList = (ArrayList)object;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList.get(i);
                Object e2 = e;
                if (e instanceof Bundle) continue;
                ((zzcp)this).zzgt().zzjj().zze("All ArrayList elements must be of type Bundle. Value type, name", e2.getClass(), string2);
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzu(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!zzfu.zzcy(string)) {
                if (this.zzadp.zzkn()) {
                    ((zzcp)this).zzgt().zzjg().zzg("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzaq.zzby(string));
                }
                return false;
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (!zzfu.zzcy(string2)) {
                ((zzcp)this).zzgt().zzjg().zzg("Invalid admob_app_id. Analytics disabled.", zzaq.zzby(string2));
                return false;
            }
        } else {
            if (this.zzadp.zzkn()) {
                ((zzcp)this).zzgt().zzjg().zzca("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            }
            return false;
        }
        return true;
    }

    static boolean zza(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl && bl2) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    @VisibleForTesting
    private static boolean zzcy(String string) {
        Preconditions.checkNotNull((Object)string);
        String string2 = "^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$";
        return string.matches(string2);
    }

    private static Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzfu.zza(String.valueOf(object), n, bl);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    final Object zzh(String string, Object object) {
        if ("_ev".equals(string)) {
            return zzfu.zza(256, object, true);
        }
        return zzfu.zza(zzfu.zzda(string) ? 256 : 100, object, false);
    }

    static Bundle[] zzf(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    final Bundle zza(String var1_1, String var2_2, Bundle var3_3, @Nullable List<String> var4_4, boolean var5_5, boolean var6_6) {
        block15: {
            var7_7 = null;
            if (var3_3 == null) break block15;
            var7_7 = new Bundle(var3_3);
            var8_8 = 0;
            for (String var10_10 : var3_3.keySet()) {
                block16: {
                    var11_11 = 0;
                    if (var4_4 == null || !var4_4.contains(var10_10)) {
                        if (var5_5) {
                            var13_13 = this;
                            var14_14 = var10_10;
                            v0 = var13_13.zzs("event param", var14_14) == false ? 3 : (var13_13.zza("event param", null, var14_14) == false ? 14 : (var11_11 = var13_13.zza("event param", 40, var14_14) == false ? 3 : 0));
                        }
                        if (var11_11 == 0) {
                            var13_13 = this;
                            var14_14 = var10_10;
                            v1 = var13_13.zzt("event param", var14_14) == false ? 3 : (var13_13.zza("event param", null, var14_14) == false ? 14 : (var11_11 = var13_13.zza("event param", 40, var14_14) == false ? 3 : 0));
                        }
                    }
                    if (var11_11 != 0) {
                        if (zzfu.zza(var7_7, var11_11)) {
                            var12_12 = zzfu.zza(var10_10, 40, true);
                            var7_7.putString("_ev", var12_12);
                            if (var11_11 == 3) {
                                zzfu.zza(var7_7, var10_10);
                            }
                        }
                        var7_7.remove(var10_10);
                        continue;
                    }
                    var18_18 = var6_6;
                    var17_17 = var3_3.get(var10_10);
                    var16_16 = var10_10;
                    var15_15 = var2_2;
                    var14_14 = var1_1;
                    var13_13 = this;
                    var13_13.zzaf();
                    if (!var18_18) ** GOTO lbl-1000
                    var23_23 = var17_17;
                    var22_22 = var16_16;
                    var21_21 = "param";
                    var20_20 = var13_13;
                    if (!(var23_23 instanceof Parcelable[])) break block16;
                    var24_24 = ((Parcelable[])var23_23).length;
                    ** GOTO lbl44
                }
                if (!(var23_23 instanceof ArrayList)) {
                    v2 = true;
                } else {
                    var24_24 = ((ArrayList)var23_23).size();
lbl44:
                    // 2 sources

                    if (var24_24 > 1000) {
                        var20_20.zzgt().zzjj().zzd("Parameter array is too long; discarded. Value kind, name, array length", var21_21, var22_22, var24_24);
                        v2 = false;
                    } else {
                        v2 = true;
                    }
                }
                if (!v2) {
                    v3 = 17;
                } else lbl-1000:
                // 2 sources

                {
                    var19_19 = var13_13.zzgv().zzax(var14_14) != false && zzfu.zzda(var15_15) != false || zzfu.zzda(var16_16) != false ? var13_13.zza("param", var16_16, 256, var17_17, var18_18) : var13_13.zza("param", var16_16, 100, var17_17, var18_18);
                    v3 = var11_11 = var19_19 != false ? 0 : 4;
                }
                if (v3 != 0 && !"_ev".equals(var10_10)) {
                    if (zzfu.zza(var7_7, var11_11)) {
                        var12_12 = zzfu.zza(var10_10, 40, true);
                        var7_7.putString("_ev", var12_12);
                        zzfu.zza(var7_7, var3_3.get(var10_10));
                    }
                    var7_7.remove(var10_10);
                    continue;
                }
                if (!zzfu.zzcv(var10_10) || ++var8_8 <= 25) continue;
                var12_12 = new StringBuilder(48).append("Event can't contain more than 25 params").toString();
                this.zzgt().zzjg().zze(var12_12, this.zzgq().zzbv(var2_2), this.zzgq().zzd(var3_3));
                zzfu.zza(var7_7, 5);
                var7_7.remove(var10_10);
            }
        }
        return var7_7;
    }

    private static boolean zza(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private static void zza(Bundle bundle, Object object) {
        Preconditions.checkNotNull((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private static int zzcz(String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        return 36;
    }

    final int zzi(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, zzfu.zzcz(string), object, false) : this.zza("user property", string, zzfu.zzcz(string), object, false);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzj(String string, Object object) {
        if ("_ldl".equals(string)) {
            return zzfu.zza(zzfu.zzcz(string), object, true);
        }
        return zzfu.zza(zzfu.zzcz(string), object, false);
    }

    final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzcp)this).zzgt().zzjl().zze("Not putting event parameter. Invalid value type. name, type", ((zzcp)this).zzgq().zzbw(string), string3);
        }
    }

    public final void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    final void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzfu.zza(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zzl zzl2 = this.zzadp.zzgw();
        this.zzadp.zzgj().logEvent("auto", "_err", bundle);
    }

    static MessageDigest getMessageDigest() {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    @VisibleForTesting
    static long zzc(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    static boolean zza(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzfu.zzc(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzfu.zzc(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    private static boolean zzc(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    final boolean zzx(String string) {
        ((zzcp)this).zzaf();
        if (Wrappers.packageManager((Context)((zzcp)this).getContext()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzcp)this).zzgt().zzjn().zzg("Permission not granted", string);
        return false;
    }

    static boolean zzda(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzv(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    final boolean zzdb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = ((zzcp)this).zzgv().zzid();
        zzl zzl2 = ((zzcp)this).zzgw();
        return string2.equals(string);
    }

    final Bundle zze(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzh(string, bundle.get(string));
                if (object == null) {
                    ((zzcp)this).zzgt().zzjj().zzg("Param value can't be null", ((zzcp)this).zzgq().zzbw(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    final zzae zza(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (this.zzcw(string2) != 0) {
            ((zzcp)this).zzgt().zzjg().zzg("Invalid conditional property event name", ((zzcp)this).zzgq().zzbx(string2));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        List list = CollectionUtils.listOf((Object)"_o");
        Bundle bundle2 = this.zza(string, string2, bundle, list, false, false);
        Bundle bundle3 = this.zze(bundle2);
        return new zzae(string2, new zzab(bundle3), string3, l);
    }

    @WorkerThread
    final long zzd(Context context, String string) {
        ((zzcp)this).zzaf();
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzfu.getMessageDigest();
        if (messageDigest == null) {
            ((zzcp)this).zzgt().zzjg().zzca("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zze(context, string)) {
                    PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(((zzcp)this).getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzfu.zzc(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzcp)this).zzgt().zzjj().zzca("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcp)this).zzgt().zzjg().zzg("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    @VisibleForTesting
    private final boolean zze(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzcp)this).zzgt().zzjg().zzg("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzcp)this).zzgt().zzjg().zzg("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Bundle zzf(Bundle bundle) {
        if (bundle == null) {
            return new Bundle();
        }
        Bundle bundle2 = new Bundle(bundle);
        for (String string : bundle2.keySet()) {
            int n;
            Object object;
            Object object2 = bundle2.get(string);
            if (object2 instanceof Bundle) {
                bundle2.putBundle(string, new Bundle((Bundle)object2));
                continue;
            }
            if (object2 instanceof Parcelable[]) {
                object = (Parcelable[])object2;
                for (n = 0; n < ((Parcelable[])object).length; ++n) {
                    if (!(object[n] instanceof Bundle)) continue;
                    object[n] = new Bundle((Bundle)object[n]);
                }
                continue;
            }
            if (!(object2 instanceof List)) continue;
            object = (List)object2;
            for (n = 0; n < object.size(); ++n) {
                Object e = object.get(n);
                if (!(e instanceof Bundle)) continue;
                object.set(n, new Bundle((Bundle)e));
            }
        }
        return bundle2;
    }

    public final int zzml() {
        if (this.zzave == null) {
            this.zzave = GoogleApiAvailabilityLight.getInstance().getApkVersion(((zzcp)this).getContext()) / 1000;
        }
        return this.zzave;
    }

    public static long zzc(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    @WorkerThread
    final String zzmm() {
        byte[] byArray = new byte[16];
        this.zzmk().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    final void zza(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            ((zzcp)this).zzgt().zzjj().zzg("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    public final void zzb(zzef zzef2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzef2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzadp.zzgt().zzjj().zzg("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }
}

