/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.measurement.internal.zzbk;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import java.util.List;

public final class zzbj {
    final zzbw zzada;

    zzbj(zzbw zzbw2) {
        this.zzada = zzbw2;
    }

    @WorkerThread
    protected final void zzce(String string) {
        if (string == null || string.isEmpty()) {
            this.zzada.zzgt().zzjm().zzby("Install Referrer Reporter was called with invalid app package name");
            return;
        }
        ((zzcr)this.zzada.zzgs()).zzaf();
        if (!this.zzke()) {
            this.zzada.zzgt().zzjm().zzby("Install Referrer Reporter is not available");
            return;
        }
        this.zzada.zzgt().zzjm().zzby("Install Referrer Reporter is initializing");
        zzbk zzbk2 = new zzbk(this, string);
        zzbj zzbj2 = this;
        ((zzcr)zzbj2.zzada.zzgs()).zzaf();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzbj2.zzada.getContext().getPackageManager();
        if (packageManager == null) {
            zzbj2.zzada.zzgt().zzjj().zzby("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string2 = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && "com.android.vending".equals(string2) && zzbj2.zzke()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzbj2.zzada.getContext(), intent2, (ServiceConnection)zzbk2, 1);
                        zzbj2.zzada.zzgt().zzjm().zzg("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzbj2.zzada.zzgt().zzjg().zzg("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzbj2.zzada.zzgt().zzjm().zzby("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzbj2.zzada.zzgt().zzjm().zzby("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzke() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzada.getContext());
            if (packageManagerWrapper == null) {
                this.zzada.zzgt().zzjm().zzby("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzada.zzgt().zzjm().zzg("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zza(String string, zzu zzu2) {
        Bundle bundle;
        ((zzcr)this.zzada.zzgs()).zzaf();
        if (zzu2 == null) {
            this.zzada.zzgt().zzjj().zzby("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", string);
        try {
            bundle = zzu2.zza(bundle2);
            if (bundle == null) {
                this.zzada.zzgt().zzjg().zzby("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzada.zzgt().zzjg().zzg("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }
}

