/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzfx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzbd
extends zzcs {
    @VisibleForTesting
    static final Pair<String, Long> zzana = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzabr;
    public zzbh zzanb;
    public final zzbg zzanc = new zzbg(this, "last_upload", 0L);
    public final zzbg zzand = new zzbg(this, "last_upload_attempt", 0L);
    public final zzbg zzane = new zzbg(this, "backoff", 0L);
    public final zzbg zzanf = new zzbg(this, "last_delete_stale", 0L);
    public final zzbg zzang;
    public final zzbg zzanh;
    public final zzbg zzani;
    public final zzbi zzanj;
    private String zzank;
    private boolean zzanl;
    private long zzanm;
    public final zzbg zzann = new zzbg(this, "time_before_start", 10000L);
    public final zzbg zzano = new zzbg(this, "session_timeout", 1800000L);
    public final zzbf zzanp = new zzbf(this, "start_new_session", true);
    public final zzbg zzanq = new zzbg(this, "last_pause_time", 0L);
    public final zzbg zzanr = new zzbg(this, "time_active", 0L);
    public boolean zzans;
    public zzbf zzant;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzbz(String string) {
        this.zzaf();
        long l = this.zzbx().elapsedRealtime();
        if (this.zzank != null && l < this.zzanm) {
            return new Pair((Object)this.zzank, (Object)this.zzanl);
        }
        String string2 = string;
        this.zzanm = l + this.zzgv().zza(string2, zzai.zzaiv);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzank = info.getId();
                this.zzanl = info.isLimitAdTrackingEnabled();
            }
            if (this.zzank == null) {
                this.zzank = "";
            }
        }
        catch (Exception exception) {
            this.zzgt().zzjn().zzg("Unable to get advertising id", exception);
            this.zzank = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzank, (Object)this.zzanl);
    }

    @WorkerThread
    final String zzca(String string) {
        this.zzaf();
        String string2 = (String)this.zzbz((String)string).first;
        MessageDigest messageDigest = zzfx.getMessageDigest();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzbd(zzbw zzbw2) {
        super(zzbw2);
        this.zzang = new zzbg(this, "midnight_offset", 0L);
        this.zzanh = new zzbg(this, "first_open_time", 0L);
        this.zzani = new zzbg(this, "app_install_time", 0L);
        this.zzanj = new zzbi(this, "app_instance_id", null);
        this.zzant = new zzbf(this, "app_backgrounded", false);
    }

    @Override
    protected final boolean zzgy() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzgz() {
        this.zzabr = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzans = this.zzabr.getBoolean("has_been_opened", false);
        if (!this.zzans) {
            SharedPreferences.Editor editor = this.zzabr.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzanb = new zzbh(this, "health_monitor", Math.max(0L, zzai.zzaiw.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zzju() {
        this.zzaf();
        this.zzcl();
        return this.zzabr;
    }

    @WorkerThread
    final void zzcb(String string) {
        this.zzaf();
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjv() {
        this.zzaf();
        return this.zzju().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzcc(String string) {
        this.zzaf();
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjw() {
        this.zzaf();
        return this.zzju().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzjx() {
        this.zzaf();
        if (!this.zzju().contains("use_service")) {
            return null;
        }
        return this.zzju().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzg(boolean bl) {
        this.zzaf();
        this.zzgt().zzjo().zzg("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzjy() {
        this.zzaf();
        this.zzgt().zzjo().zzby("Clearing collection preferences.");
        if (this.zzgv().zza(zzai.zzale)) {
            Boolean bl = this.zzjz();
            SharedPreferences.Editor editor = this.zzju().edit();
            editor.clear();
            editor.apply();
            if (bl != null) {
                this.setMeasurementEnabled(bl);
            }
            return;
        }
        boolean bl = this.zzju().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzh(true);
        }
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzaf();
        this.zzgt().zzjo().zzg("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzh(boolean bl) {
        this.zzaf();
        return this.zzju().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    final Boolean zzjz() {
        this.zzaf();
        if (this.zzju().contains("measurement_enabled")) {
            return this.zzju().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzka() {
        this.zzaf();
        String string = this.zzju().getString("previous_os_version", null);
        this.zzgp().zzcl();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzju().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzi(boolean bl) {
        this.zzaf();
        this.zzgt().zzjo().zzg("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzkb() {
        this.zzaf();
        return this.zzju().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzkc() {
        return this.zzabr.contains("deferred_analytics_collection");
    }

    final boolean zzaf(long l) {
        return l - this.zzano.get() > this.zzanq.get();
    }

    static /* synthetic */ SharedPreferences zza(zzbd zzbd2) {
        return zzbd2.zzju();
    }
}

