/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzeb
extends zzf {
    private final zzes zzase;
    private zzaj zzasf;
    private volatile Boolean zzasg;
    private final zzy zzash;
    private final zzfi zzasi;
    private final List<Runnable> zzasj = new ArrayList<Runnable>();
    private final zzy zzask;

    protected zzeb(zzbw zzbw2) {
        super(zzbw2);
        this.zzasi = new zzfi(zzbw2.zzbx());
        this.zzase = new zzes(this);
        this.zzash = new zzec(this, zzbw2);
        this.zzask = new zzek(this, zzbw2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcr)this).zzaf();
        this.zzcl();
        return this.zzasf != null;
    }

    @WorkerThread
    protected final void zzlg() {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(true);
        this.zzf(new zzel(this, zzk2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzaj zzaj2, AbstractSafeParcelable abstractSafeParcelable, zzk zzk2) {
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgg();
        this.zzcl();
        boolean bl = this.zzlh();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zze)this).zzgn().zzr(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzag) {
                    try {
                        zzaj2.zza((zzag)abstractSafeParcelable2, zzk2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcr)this).zzgt().zzjg().zzg("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzfu) {
                    try {
                        zzaj2.zza((zzfu)abstractSafeParcelable2, zzk2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcr)this).zzgt().zzjg().zzg("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzo) {
                    try {
                        zzaj2.zza((zzo)abstractSafeParcelable2, zzk2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcr)this).zzgt().zzjg().zzg("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcr)this).zzgt().zzjg().zzby("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzag zzag2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzag2));
        ((zzcr)this).zzaf();
        this.zzcl();
        boolean bl = this.zzlh();
        boolean bl2 = bl && ((zze)this).zzgn().zza(zzag2);
        zzk zzk2 = this.zzl(true);
        this.zzf(new zzem(this, bl, bl2, zzag2, zzk2, string));
    }

    @WorkerThread
    protected final void zzd(zzo zzo2) {
        Preconditions.checkNotNull((Object)((Object)zzo2));
        ((zzcr)this).zzaf();
        this.zzcl();
        zzn zzn2 = ((zzcr)this).zzgw();
        boolean bl = true;
        boolean bl2 = true && ((zze)this).zzgn().zzc(zzo2);
        zzo zzo3 = new zzo(zzo2);
        zzk zzk2 = this.zzl(true);
        this.zzf(new zzen(this, bl, bl2, zzo3, zzk2, zzo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzo>> atomicReference, String string, String string2, String string3) {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(false);
        this.zzf(new zzeo(this, atomicReference, string, string2, string3, zzk2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzfu>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(false);
        this.zzf(new zzep(this, atomicReference, string, string2, string3, bl, zzk2));
    }

    @WorkerThread
    protected final void zza(zzdq zzdq2, String string, String string2, boolean bl) {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(false);
        this.zzf(new zzeq(this, string, string2, bl, zzk2, zzdq2));
    }

    @WorkerThread
    protected final void zzb(zzfu zzfu2) {
        ((zzcr)this).zzaf();
        this.zzcl();
        boolean bl = this.zzlh() && ((zze)this).zzgn().zza(zzfu2);
        zzk zzk2 = this.zzl(true);
        this.zzf(new zzer(this, bl, zzfu2, zzk2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzfu>> atomicReference, boolean bl) {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(false);
        this.zzf(new zzed(this, atomicReference, zzk2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgg();
        this.zzcl();
        zzk zzk2 = this.zzl(false);
        if (this.zzlh()) {
            ((zze)this).zzgn().resetAnalyticsData();
        }
        this.zzf(new zzee(this, zzk2));
    }

    private final boolean zzlh() {
        zzn zzn2 = ((zzcr)this).zzgw();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(false);
        this.zzf(new zzef(this, atomicReference, zzk2));
    }

    @WorkerThread
    public final void getAppInstanceId(zzdq zzdq2) {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(false);
        this.zzf(new zzeg(this, zzk2, zzdq2));
    }

    @WorkerThread
    protected final void zzld() {
        ((zzcr)this).zzaf();
        this.zzcl();
        zzk zzk2 = this.zzl(true);
        this.zzf(new zzeh(this, zzk2));
    }

    @WorkerThread
    protected final void zza(zzdx zzdx2) {
        ((zzcr)this).zzaf();
        this.zzcl();
        this.zzf(new zzei(this, zzdx2));
    }

    @WorkerThread
    private final void zzcy() {
        ((zzcr)this).zzaf();
        this.zzasi.start();
        this.zzash.zzh(zzai.zzaka.get());
    }

    @WorkerThread
    final void zzdj() {
        zzn zzn2;
        Boolean bl;
        zzeb zzeb2;
        ((zzcr)this).zzaf();
        this.zzcl();
        if (this.isConnected()) {
            return;
        }
        if (this.zzasg == null) {
            boolean bl2;
            zzeb2 = this;
            ((zzcr)zzeb2).zzaf();
            zzeb2.zzcl();
            bl = ((zzcr)zzeb2).zzgu().zzjx();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzn2 = ((zzcr)zzeb2).zzgw();
                if (((zze)zzeb2).zzgk().zzje() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzcr)zzeb2).zzgt().zzjo().zzby("Checking service availability");
                    int n = ((zzcr)zzeb2).zzgr().zzs(12451000);
                    switch (n) {
                        case 0: {
                            ((zzcr)zzeb2).zzgt().zzjo().zzby("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzcr)zzeb2).zzgt().zzjo().zzby("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzcr)zzeb2).zzgt().zzjj().zzby("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzcr)zzeb2).zzgt().zzjn().zzby("Service container out of date");
                            if (((zzcr)zzeb2).zzgr().zzml() < 14500) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzcr)zzeb2).zzgu().zzjx();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzcr)zzeb2).zzgt().zzjj().zzby("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzcr)zzeb2).zzgt().zzjj().zzby("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzcr)zzeb2).zzgt().zzjj().zzg("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzcr)zzeb2).zzgv().zzif()) {
                    ((zzcr)zzeb2).zzgt().zzjg().zzby("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzcr)zzeb2).zzgu().zzg(bl4);
                }
                bl2 = bl4;
            }
            this.zzasg = bl2;
        }
        if (this.zzasg.booleanValue()) {
            this.zzase.zzll();
            return;
        }
        if (!((zzcr)this).zzgv().zzif()) {
            Intent intent;
            zzeb2 = this;
            zzn2 = ((zzcr)zzeb2).zzgw();
            bl = ((zzcr)zzeb2).getContext().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzcr)zzeb2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzn2 = ((zzcr)this).zzgw();
                intent2.setComponent(new ComponentName(((zzcr)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzase.zzb(intent2);
                return;
            }
            ((zzcr)this).zzgt().zzjg().zzby("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzli() {
        return this.zzasg;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzaj zzaj2) {
        ((zzcr)this).zzaf();
        Preconditions.checkNotNull((Object)zzaj2);
        this.zzasf = zzaj2;
        this.zzcy();
        this.zzlj();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcr)this).zzaf();
        this.zzcl();
        this.zzase.zzlk();
        try {
            ConnectionTracker.getInstance().unbindService(((zzcr)this).getContext(), (ServiceConnection)this.zzase);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzasf = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcr)this).zzaf();
        if (this.zzasf != null) {
            this.zzasf = null;
            ((zzcr)this).zzgt().zzjo().zzg("Disconnected from device MeasurementService", componentName);
            zzeb zzeb2 = this;
            ((zzcr)zzeb2).zzaf();
            zzeb2.zzdj();
        }
    }

    @WorkerThread
    private final void zzcz() {
        ((zzcr)this).zzaf();
        if (!this.isConnected()) {
            return;
        }
        ((zzcr)this).zzgt().zzjo().zzby("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzf(Runnable runnable) throws IllegalStateException {
        ((zzcr)this).zzaf();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzasj.size() >= 1000L) {
            ((zzcr)this).zzgt().zzjg().zzby("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzasj.add(runnable);
        this.zzask.zzh(60000L);
        this.zzdj();
    }

    @WorkerThread
    private final void zzlj() {
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgt().zzjo().zzg("Processing queued up service tasks", this.zzasj.size());
        for (Runnable runnable : this.zzasj) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzcr)this).zzgt().zzjg().zzg("Task exception while flushing queue", exception);
            }
        }
        this.zzasj.clear();
        this.zzask.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzk zzl(boolean bl) {
        zzn zzn2 = ((zzcr)this).zzgw();
        return ((zze)this).zzgk().zzbs(bl ? ((zzcr)this).zzgt().zzjq() : null);
    }

    @WorkerThread
    public final void zza(zzdq zzdq2, zzag zzag2, String string) {
        ((zzcr)this).zzaf();
        this.zzcl();
        int n = ((zzcr)this).zzgr().zzs(12451000);
        if (n != 0) {
            ((zzcr)this).zzgt().zzjj().zzby("Not bundling data. Service unavailable or out of date");
            ((zzcr)this).zzgr().zza(zzdq2, new byte[0]);
            return;
        }
        this.zzf(new zzej(this, zzag2, string, zzdq2));
    }

    static /* synthetic */ zzes zza(zzeb zzeb2) {
        return zzeb2.zzase;
    }

    static /* synthetic */ void zza(zzeb zzeb2, ComponentName componentName) {
        zzeb2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzaj zza(zzeb zzeb2, zzaj zzaj2) {
        zzeb2.zzasf = null;
        return null;
    }

    static /* synthetic */ void zzb(zzeb zzeb2) {
        zzeb2.zzlj();
    }

    static /* synthetic */ void zzc(zzeb zzeb2) {
        zzeb2.zzcz();
    }

    static /* synthetic */ zzaj zzd(zzeb zzeb2) {
        return zzeb2.zzasf;
    }

    static /* synthetic */ void zze(zzeb zzeb2) {
        zzeb2.zzcy();
    }
}

