/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;

public class zzd
extends zzz {
    static final String zzbbT = String.valueOf(zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE / 1000).replaceAll("(\\d+)(\\d)(\\d\\d)", "$1.$2.$3");
    private Boolean zzXt;

    zzd(zzx zzx2) {
        super(zzx2);
    }

    String zzEu() {
        return zzl.zzbcv.get();
    }

    public int zzEv() {
        return 25;
    }

    public int zzEw() {
        return 32;
    }

    public int zzEx() {
        return 24;
    }

    int zzEy() {
        return 24;
    }

    int zzEz() {
        return 36;
    }

    int zzEA() {
        return 256;
    }

    public int zzEB() {
        return 36;
    }

    public int zzEC() {
        return 2048;
    }

    int zzED() {
        return 500;
    }

    public long zzEE() {
        return zzl.zzbcF.get().intValue();
    }

    public long zzEF() {
        return zzl.zzbcG.get().intValue();
    }

    public long zzEG() {
        return 1000L;
    }

    public int zzfc(@Size(min=1L) String string) {
        return this.zzb(string, zzl.zzbcH);
    }

    int zzEH() {
        return 25;
    }

    int zzEI() {
        return 50;
    }

    long zzEJ() {
        return 3600000L;
    }

    long zzEK() {
        return 60000L;
    }

    long zzEL() {
        return 61000L;
    }

    long zzfd(String string) {
        return this.zza(string, zzl.zzbcw);
    }

    int zzfe(String string) {
        return this.zzb(string, zzl.zzbcS);
    }

    long zznr() {
        return zzl.zzbcT.get();
    }

    public String zznw() {
        return "google_app_measurement.db";
    }

    public String zznx() {
        return "google_app_measurement2.db";
    }

    public long zzEi() {
        return 9080L;
    }

    public boolean zzmW() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzmX() {
        if (this.zzXt == null) {
            zzd zzd2 = this;
            synchronized (zzd2) {
                if (this.zzXt == null) {
                    ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
                    String string = zzt.zzvj();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzXt = string2 != null && string2.equals(string);
                    }
                    if (this.zzXt == null) {
                        this.zzXt = Boolean.TRUE;
                        this.zzFm().zzFE().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzXt;
    }

    public long zza(String string, zzl.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzFj().zzU(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    public int zzb(String string, zzl.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzFj().zzU(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @Nullable
    private Boolean zzff(@Size(min=1L) String string) {
        zzaa.zzdl((String)string);
        try {
            PackageManager packageManager = this.getContext().getPackageManager();
            if (packageManager == null) {
                this.zzFm().zzFE().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(this.getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                this.zzFm().zzFE().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                this.zzFm().zzFE().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzFm().zzFE().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public boolean zzEM() {
        if (this.zzmW()) {
            return false;
        }
        Boolean bl = this.zzff("firebase_analytics_collection_deactivated");
        return bl != null && bl == false;
    }

    public Boolean zzEN() {
        if (this.zzmW()) {
            return null;
        }
        return this.zzff("firebase_analytics_collection_enabled");
    }

    public boolean zzsB() {
        return zzom.zzsB();
    }

    public long zzEO() {
        return zzl.zzbcR.get();
    }

    public long zzEP() {
        return zzl.zzbcN.get();
    }

    public long zzEQ() {
        return 1000L;
    }

    public long zznC() {
        return Math.max(0L, zzl.zzbcx.get());
    }

    public int zzfg(String string) {
        return this.zzb(string, zzl.zzbcB);
    }

    public int zzfh(String string) {
        return Math.max(0, this.zzb(string, zzl.zzbcC));
    }

    public int zzfi(String string) {
        int n = this.zzb(string, zzl.zzbcI);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzER() {
        return Math.max(0, zzl.zzbcD.get());
    }

    public int zzES() {
        return Math.max(1, zzl.zzbcE.get());
    }

    public String zzET() {
        return zzl.zzbcJ.get();
    }

    public String zzN(String string, String string2) {
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string);
        builder.scheme(zzl.zzbcz.get()).encodedAuthority(zzl.zzbcA.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string2).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(this.zzEi()));
        return builder.build().toString();
    }

    public long zzEU() {
        return zzl.zzbcy.get();
    }

    public long zzEV() {
        return Math.max(0L, zzl.zzbcK.get());
    }

    public long zzEW() {
        return Math.max(0L, zzl.zzbcM.get());
    }

    public long zzEX() {
        return zzl.zzbcL.get();
    }

    public long zzEY() {
        return Math.max(0L, zzl.zzbcO.get());
    }

    public long zzEZ() {
        return Math.max(0L, zzl.zzbcP.get());
    }

    public int zzFa() {
        return Math.min(20, Math.max(0, zzl.zzbcQ.get()));
    }
}

