/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzt
extends zzaa {
    static final Pair<String, Long> zzbdE = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzYX;
    public final zzc zzbdF = new zzc("health_monitor", this.zzFo().zznC());
    public final zzb zzbdG = new zzb("last_upload", 0L);
    public final zzb zzbdH = new zzb("last_upload_attempt", 0L);
    public final zzb zzbdI = new zzb("backoff", 0L);
    public final zzb zzbdJ = new zzb("last_delete_stale", 0L);
    public final zzb zzbdK;
    private String zzbdL;
    private boolean zzbdM;
    private long zzbdN;
    private SecureRandom zzbdO;
    public final zzb zzbdP = new zzb("time_before_start", 10000L);
    public final zzb zzbdQ = new zzb("session_timeout", 1800000L);
    public final zza zzbdR = new zza("start_new_session", true);
    public final zzb zzbdS = new zzb("last_pause_time", 0L);
    public final zzb zzbdT = new zzb("time_active", 0L);
    public boolean zzbdU;

    @WorkerThread
    private SecureRandom zzFN() {
        this.zzkN();
        if (this.zzbdO == null) {
            this.zzbdO = new SecureRandom();
        }
        return this.zzbdO;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzfu(String string) {
        this.zzkN();
        long l = this.zzlQ().elapsedRealtime();
        if (this.zzbdL != null && l < this.zzbdN) {
            return new Pair((Object)this.zzbdL, (Object)this.zzbdM);
        }
        this.zzbdN = l + this.zzFo().zzfd(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzbdL = info.getId();
            if (this.zzbdL == null) {
                this.zzbdL = "";
            }
            this.zzbdM = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzFm().zzFK().zzj("Unable to get advertising id", throwable);
            this.zzbdL = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzbdL, (Object)this.zzbdM);
    }

    String zzfv(String string) {
        String string2 = (String)this.zzfu((String)string).first;
        MessageDigest messageDigest = zzal.zzbZ("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzFO() {
        byte[] byArray = new byte[16];
        this.zzFN().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzEd() {
        this.zzkN();
        return com.google.firebase.iid.zzc.zzUl().getId();
    }

    @WorkerThread
    long zzFP() {
        this.zzma();
        this.zzkN();
        long l = this.zzbdK.get();
        if (l == 0L) {
            l = 1 + this.zzFN().nextInt(86400000);
            this.zzbdK.set(l);
        }
        return l;
    }

    zzt(zzx zzx2) {
        super(zzx2);
        this.zzbdK = new zzb("midnight_offset", 0L);
    }

    @Override
    protected void zzkO() {
        this.zzYX = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzbdU = this.zzYX.getBoolean("has_been_opened", false);
        if (!this.zzbdU) {
            SharedPreferences.Editor editor = this.zzYX.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzFQ() {
        this.zzkN();
        this.zzma();
        return this.zzYX;
    }

    @WorkerThread
    void zzfw(String string) {
        this.zzkN();
        SharedPreferences.Editor editor = this.zzFQ().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzFR() {
        this.zzkN();
        return this.zzFQ().getString("gmp_app_id", null);
    }

    @WorkerThread
    Boolean zzFS() {
        this.zzkN();
        if (!this.zzFQ().contains("use_service")) {
            return null;
        }
        return this.zzFQ().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzaw(boolean bl) {
        this.zzkN();
        this.zzFm().zzFL().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzFQ().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzFT() {
        this.zzkN();
        this.zzFm().zzFL().log("Clearing collection preferences.");
        boolean bl = this.zzFQ().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzax(true);
        }
        SharedPreferences.Editor editor = this.zzFQ().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzkN();
        this.zzFm().zzFL().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzFQ().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzax(boolean bl) {
        this.zzkN();
        return this.zzFQ().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzFU() {
        this.zzkN();
        String string = this.zzFQ().getString("previous_os_version", null);
        String string2 = this.zzFf().zzFx();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzFQ().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzwQ;
        private final boolean zzbdV;
        private boolean zzbdW;
        private boolean zzakR;

        public zza(String string, boolean bl) {
            com.google.android.gms.common.internal.zzaa.zzdl((String)string);
            this.zzwQ = string;
            this.zzbdV = bl;
        }

        @WorkerThread
        private void zzFV() {
            if (this.zzbdW) {
                return;
            }
            this.zzbdW = true;
            this.zzakR = zzt.this.zzYX.getBoolean(this.zzwQ, this.zzbdV);
        }

        @WorkerThread
        public boolean get() {
            this.zzFV();
            return this.zzakR;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzt.this.zzYX.edit();
            editor.putBoolean(this.zzwQ, bl);
            editor.apply();
            this.zzakR = bl;
        }
    }

    public final class zzb {
        private final String zzwQ;
        private final long zzbdY;
        private boolean zzbdW;
        private long zzVv;

        public zzb(String string, long l) {
            com.google.android.gms.common.internal.zzaa.zzdl((String)string);
            this.zzwQ = string;
            this.zzbdY = l;
        }

        @WorkerThread
        private void zzFV() {
            if (this.zzbdW) {
                return;
            }
            this.zzbdW = true;
            this.zzVv = zzt.this.zzYX.getLong(this.zzwQ, this.zzbdY);
        }

        @WorkerThread
        public long get() {
            this.zzFV();
            return this.zzVv;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzt.this.zzYX.edit();
            editor.putLong(this.zzwQ, l);
            editor.apply();
            this.zzVv = l;
        }
    }

    public final class zzc {
        final String zzbdZ;
        private final String zzbea;
        private final String zzbeb;
        private final long zzZb;

        private zzc(String string, long l) {
            com.google.android.gms.common.internal.zzaa.zzdl((String)string);
            com.google.android.gms.common.internal.zzaa.zzaj((l > 0L ? 1 : 0) != 0);
            this.zzbdZ = String.valueOf(string).concat(":start");
            this.zzbea = String.valueOf(string).concat(":count");
            this.zzbeb = String.valueOf(string).concat(":value");
            this.zzZb = l;
        }

        @WorkerThread
        private void zzon() {
            zzt.this.zzkN();
            long l = zzt.this.zzlQ().currentTimeMillis();
            SharedPreferences.Editor editor = zzt.this.zzYX.edit();
            editor.remove(this.zzbea);
            editor.remove(this.zzbeb);
            editor.putLong(this.zzbdZ, l);
            editor.apply();
        }

        @WorkerThread
        private long zzoo() {
            zzt.this.zzkN();
            long l = this.zzoq();
            if (l == 0L) {
                this.zzon();
                return 0L;
            }
            return Math.abs(l - zzt.this.zzlQ().currentTimeMillis());
        }

        @WorkerThread
        public void zzbU(String string) {
            this.zzf(string, 1L);
        }

        @WorkerThread
        public void zzf(String string, long l) {
            long l2;
            zzt.this.zzkN();
            long l3 = this.zzoq();
            if (l3 == 0L) {
                this.zzon();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzt.this.zzYX.getLong(this.zzbea, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzt.this.zzYX.edit();
                editor.putString(this.zzbeb, string);
                editor.putLong(this.zzbea, l);
                editor.apply();
                return;
            }
            long l4 = zzt.this.zzFN().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzt.this.zzYX.edit();
            if (bl) {
                editor.putString(this.zzbeb, string);
            }
            editor.putLong(this.zzbea, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzop() {
            zzt.this.zzkN();
            long l = this.zzoo();
            if (l < this.zzZb) {
                return null;
            }
            if (l > this.zzZb * 2L) {
                this.zzon();
                return null;
            }
            String string = zzt.this.zzFQ().getString(this.zzbeb, null);
            long l2 = zzt.this.zzFQ().getLong(this.zzbea, 0L);
            this.zzon();
            if (string == null || l2 <= 0L) {
                return zzbdE;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzoq() {
            return zzt.this.zzFQ().getLong(this.zzbdZ, 0L);
        }
    }
}

