/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzx;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

public class zzw
extends zzaa {
    private zzd zzbeh;
    private zzd zzbei;
    private final PriorityBlockingQueue<FutureTask<?>> zzbej;
    private final BlockingQueue<FutureTask<?>> zzbek;
    private final Thread.UncaughtExceptionHandler zzbel;
    private final Thread.UncaughtExceptionHandler zzbem;
    private final Object zzben = new Object();
    private final Semaphore zzbeo = new Semaphore(2);
    private volatile boolean zzbep;
    private static final AtomicLong zzbeq = new AtomicLong(Long.MIN_VALUE);

    zzw(zzx zzx2) {
        super(zzx2);
        this.zzbej = new PriorityBlockingQueue();
        this.zzbek = new LinkedBlockingQueue();
        this.zzbel = new zzb("Thread death: Uncaught exception on worker thread");
        this.zzbem = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzkO() {
    }

    @Override
    public void zzkN() {
        if (Thread.currentThread() != this.zzbeh) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzFb() {
        if (Thread.currentThread() != this.zzbei) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbeh) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbeh) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzg(Runnable runnable) throws IllegalStateException {
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.zzben;
        synchronized (object) {
            this.zzbej.add(zzc2);
            if (this.zzbeh == null) {
                this.zzbeh = new zzd("Measurement Worker", this.zzbej);
                this.zzbeh.setUncaughtExceptionHandler(this.zzbel);
                this.zzbeh.start();
            } else {
                this.zzbeh.zzge();
            }
        }
    }

    public void zzh(Runnable runnable) throws IllegalStateException {
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.zzben;
        synchronized (object) {
            this.zzbek.add(futureTask);
            if (this.zzbei == null) {
                this.zzbei = new zzd("Measurement Network", this.zzbek);
                this.zzbei.setUncaughtExceptionHandler(this.zzbem);
                this.zzbei.start();
            } else {
                this.zzbei.zzge();
            }
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzber;

        public zzb(String string) {
            com.google.android.gms.common.internal.zzaa.zzz((Object)string);
            this.zzber = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzw.this.zzFm().zzFE().zzj(this.zzber, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long zzbet;
        private final boolean zzbeu;
        private final String zzber;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            com.google.android.gms.common.internal.zzaa.zzz((Object)string);
            this.zzbet = zzbeq.getAndIncrement();
            this.zzber = string;
            this.zzbeu = bl;
            if (this.zzbet == Long.MAX_VALUE) {
                zzw.this.zzFm().zzFE().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            com.google.android.gms.common.internal.zzaa.zzz((Object)string);
            this.zzbet = zzbeq.getAndIncrement();
            this.zzber = string;
            this.zzbeu = bl;
            if (this.zzbet == Long.MAX_VALUE) {
                zzw.this.zzFm().zzFE().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzw.this.zzFm().zzFE().zzj(this.zzber, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(zzc zzc2) {
            if (this.zzbeu != zzc2.zzbeu) {
                return this.zzbeu ? -1 : 1;
            }
            if (this.zzbet < zzc2.zzbet) {
                return -1;
            }
            if (this.zzbet > zzc2.zzbet) {
                return 1;
            }
            zzw.this.zzFm().zzFF().zzj("Two tasks share the same index. index", this.zzbet);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object zzbev;
        private final BlockingQueue<FutureTask<?>> zzbew;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            com.google.android.gms.common.internal.zzaa.zzz((Object)string);
            com.google.android.gms.common.internal.zzaa.zzz(blockingQueue);
            this.zzbev = new Object();
            this.zzbew = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzw.this.zzbeo.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.zzbew.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.zzbev;
                    synchronized (object) {
                        if (this.zzbew.peek() == null && !zzw.this.zzbep) {
                            try {
                                this.zzbev.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzw.this.zzben;
                    synchronized (object) {
                        if (this.zzbew.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzw.this.zzben;
                synchronized (object) {
                    zzw.this.zzbeo.release();
                    zzw.this.zzben.notifyAll();
                    if (this == zzw.this.zzbeh) {
                        zzw.this.zzbeh = null;
                    } else if (this == zzw.this.zzbei) {
                        zzw.this.zzbei = null;
                    } else {
                        zzw.this.zzFm().zzFE().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzge() {
            Object object = this.zzbev;
            synchronized (object) {
                this.zzbev.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzw.this.zzFm().zzFG().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

