/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class zzac
extends zzaa {
    private zza amW;
    private AppMeasurement.zzb amX;
    private final Set<AppMeasurement.zzc> amY = new HashSet<AppMeasurement.zzc>();
    private boolean amZ;

    protected zzac(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzwv() {
    }

    @TargetApi(value=14)
    public void zzbvj() {
        if (this.getContext().getApplicationContext() instanceof Application) {
            Application application = (Application)this.getContext().getApplicationContext();
            if (this.amW == null) {
                this.amW = new zza();
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.amW);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.amW);
            this.zzbsz().zzbty().log("Registered activity lifecycle callback");
        }
    }

    public void setMeasurementEnabled(final boolean bl) {
        this.zzzg();
        this.zzyv();
        this.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzcc(bl);
            }
        });
    }

    @WorkerThread
    private void zzcc(boolean bl) {
        this.zzwu();
        this.zzyv();
        this.zzzg();
        this.zzbsz().zzbtx().zzj("Setting app measurement enabled (FE)", bl);
        this.zzbta().setMeasurementEnabled(bl);
        this.zzbst().zzbvn();
    }

    public void setMinimumSessionDuration(final long l) {
        this.zzyv();
        this.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzbta().alE.set(l);
                zzac.this.zzbsz().zzbtx().zzj("Minimum session duration set", l);
            }
        });
    }

    public void setSessionTimeoutDuration(final long l) {
        this.zzyv();
        this.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzbta().alF.set(l);
                zzac.this.zzbsz().zzbtx().zzj("Session timeout duration set", l);
            }
        });
    }

    public void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.zzyv();
        boolean bl2 = this.amX == null || zzal.zzmu(string2);
        this.zza(string, string2, bundle, true, bl2, bl, null);
    }

    public void zze(String string, String string2, Bundle bundle) {
        this.zzyv();
        boolean bl = this.amX == null || zzal.zzmu(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public void zzd(String string, String string2, Bundle bundle, long l) {
        this.zzyv();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, this.zzyw().currentTimeMillis(), bundle, bl, bl2, bl3, string3);
    }

    Bundle zzal(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                String string2;
                Object object = this.zzbsv().zzl(string, bundle.get(string));
                if (object == null) {
                    this.zzbsz().zzbtt().zzj("Param value can't be null", string);
                    continue;
                }
                if ((object instanceof String || object instanceof Character || object instanceof CharSequence) && TextUtils.isEmpty((CharSequence)(string2 = String.valueOf(object)))) continue;
                this.zzbsv().zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    protected void zza(final String string, final String string2, final long l, Bundle bundle, final boolean bl, final boolean bl2, final boolean bl3, final String string3) {
        final Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
        this.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzb(string, string2, l, bundle2, bl, bl2, bl3, string3);
            }
        });
    }

    @WorkerThread
    private void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzab.zzhs((String)string);
        zzab.zzhs((String)string2);
        zzab.zzaa((Object)bundle);
        this.zzwu();
        this.zzzg();
        if (!this.aja.isEnabled()) {
            this.zzbsz().zzbtx().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.amZ) {
            this.amZ = true;
            this.zzbvl();
        }
        boolean bl4 = zzal.zzmu(string2);
        if (bl && this.amX != null && !bl4) {
            this.zzbsz().zzbtx().zze("Passing event to registered event handler (FE)", string2, bundle);
            this.amX.zzb(string, string2, bundle, l);
        } else {
            if (!this.aja.zzbuk()) {
                return;
            }
            int n = this.zzbsv().zzmm(string2);
            if (n != 0) {
                String string4 = this.zzbsv().zza(string2, this.zzbtb().zzbrj(), true);
                this.aja.zzbsv().zze(n, "_ev", string4);
                return;
            }
            bundle.putString("_o", string);
            List list = zzf.zzab((Object)"_o");
            Bundle bundle2 = this.zzbsv().zza(string2, bundle, list, bl3);
            Bundle bundle3 = bl2 ? this.zzal(bundle2) : bundle2;
            this.zzbsz().zzbtx().zze("Logging event (FE)", string2, bundle3);
            EventParcel eventParcel = new EventParcel(string2, new EventParams(bundle3), string, l);
            this.zzbst().zzc(eventParcel, string3);
            for (AppMeasurement.zzc zzc2 : this.amY) {
                zzc2.zzc(string, string2, bundle3, l);
            }
        }
    }

    public void zzd(String string, String string2, Object object) {
        zzab.zzhs((String)string);
        long l = this.zzyw().currentTimeMillis();
        int n = this.zzbsv().zzmo(string2);
        if (n != 0) {
            String string3 = this.zzbsv().zza(string2, this.zzbtb().zzbrk(), true);
            this.aja.zzbsv().zze(n, "_ev", string3);
            return;
        }
        if (object != null) {
            n = this.zzbsv().zzm(string2, object);
            if (n != 0) {
                String string4 = this.zzbsv().zza(string2, this.zzbtb().zzbrk(), true);
                this.aja.zzbsv().zze(n, "_ev", string4);
                return;
            }
            Object object2 = this.zzbsv().zzn(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
        } else {
            this.zza(string, string2, l, null);
        }
    }

    void zza(final String string, final String string2, final long l, final Object object) {
        this.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzac.this.zza(string, string2, object, l);
            }
        });
    }

    @WorkerThread
    private void zza(String string, String string2, Object object, long l) {
        zzab.zzhs((String)string);
        zzab.zzhs((String)string2);
        this.zzwu();
        this.zzyv();
        this.zzzg();
        if (!this.aja.isEnabled()) {
            this.zzbsz().zzbtx().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.aja.zzbuk()) {
            return;
        }
        this.zzbsz().zzbtx().zze("Setting user property (FE)", string2, object);
        UserAttributeParcel userAttributeParcel = new UserAttributeParcel(string2, l, object, string);
        this.zzbst().zza(userAttributeParcel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Nullable
    public List<UserAttributeParcel> zzcd(final boolean bl) {
        this.zzyv();
        this.zzzg();
        this.zzbsz().zzbtx().log("Fetching user attributes (FE)");
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.zzbsz().zzbtt().log("getUserProperties called from main thread.");
            return null;
        }
        final AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (object) {
            this.aja.zzbsy().zzl(new Runnable(){

                @Override
                public void run() {
                    zzac.this.zzbst().zza(atomicReference, bl);
                }
            });
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzbsz().zzbtt().zzj("Interrupted waiting for get user properties", interruptedException);
            }
        }
        object = (List)atomicReference.get();
        if (object == null) {
            this.zzbsz().zzbtt().log("Timed out waiting for get user properties");
            return null;
        }
        return object;
    }

    @WorkerThread
    public void zzbvk() {
        this.zzwu();
        this.zzyv();
        this.zzzg();
        if (!this.aja.zzbuk()) {
            return;
        }
        this.zzbst().zzbvk();
        String string = this.zzbta().zzbuh();
        if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzbss().zzbtk())) {
            Bundle bundle = new Bundle();
            bundle.putString("_po", string);
            this.zze("auto", "_ou", bundle);
        }
    }

    @WorkerThread
    public void zza(AppMeasurement.zzb zzb2) {
        this.zzwu();
        this.zzyv();
        this.zzzg();
        if (zzb2 != null && zzb2 != this.amX) {
            zzab.zza((this.amX == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.amX = zzb2;
    }

    @WorkerThread
    public void zza(AppMeasurement.zzc zzc2) {
        this.zzwu();
        this.zzyv();
        this.zzzg();
        zzab.zzaa((Object)zzc2);
        if (this.amY.contains(zzc2)) {
            throw new IllegalStateException("OnEventListener already registered.");
        }
        this.amY.add(zzc2);
    }

    @WorkerThread
    private void zzbvl() {
        try {
            Class<?> clazz = Class.forName(this.zzbvm());
            this.zzg(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzbsz().zzbtw().log("Tag Manager is not found and thus will not be used");
        }
    }

    private String zzbvm() {
        return "com.google.android.gms.tagmanager.TagManagerService";
    }

    @WorkerThread
    public void zzg(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("initialize", Context.class);
            method.invoke(null, this.getContext());
        }
        catch (Exception exception) {
            this.zzbsz().zzbtt().zzj("Failed to invoke Tag Manager's initialize() method", exception);
        }
    }

    @MainThread
    @TargetApi(value=14)
    private class zza
    implements Application.ActivityLifecycleCallbacks {
        private zza() {
        }

        private boolean zzmi(String string) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzac.this.zzd("auto", "_ldl", string);
                return true;
            }
            return false;
        }

        private boolean zzs(Uri uri) {
            String string = uri.getQueryParameter("utm_campaign");
            String string2 = uri.getQueryParameter("utm_source");
            String string3 = uri.getQueryParameter("utm_medium");
            String string4 = uri.getQueryParameter("gclid");
            if (!(TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string4))) {
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                Bundle bundle = new Bundle();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bundle.putString("campaign", string);
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    bundle.putString("source", string2);
                }
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    bundle.putString("medium", string3);
                }
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    bundle.putString("gclid", string4);
                }
                if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                    bundle.putString("term", string9);
                }
                if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                    bundle.putString("content", string8);
                }
                if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                    bundle.putString("aclid", string7);
                }
                if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                    bundle.putString("cp1", string6);
                }
                if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                    bundle.putString("anid", string5);
                }
                zzac.this.zze("auto", "_cmp", bundle);
                return true;
            }
            return false;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            try {
                Uri uri;
                zzac.this.zzbsz().zzbty().log("onActivityCreated");
                Intent intent = activity.getIntent();
                if (intent != null && (uri = intent.getData()) != null && uri.isHierarchical()) {
                    String string;
                    if (bundle == null) {
                        this.zzs(uri);
                    }
                    if (TextUtils.isEmpty((CharSequence)(string = uri.getQueryParameter("referrer")))) {
                        return;
                    }
                    if (!string.contains("gclid")) {
                        zzac.this.zzbsz().zzbtx().log("Activity created with data 'referrer' param without gclid");
                        return;
                    }
                    zzac.this.zzbsz().zzbtx().zzj("Activity created with referrer", string);
                    this.zzmi(string);
                }
            }
            catch (Throwable throwable) {
                zzac.this.zzbsz().zzbtr().zzj("Throwable caught in onActivityCreated", throwable);
            }
        }

        public void onActivityDestroyed(Activity activity) {
        }

        @MainThread
        public void onActivityPaused(Activity activity) {
            zzac.this.zzbsx().zzbvv();
        }

        @MainThread
        public void onActivityResumed(Activity activity) {
            zzac.this.zzbsx().zzbvt();
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }
}

