/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class zzn
extends zzaa {
    private static final X500Principal akJ = new X500Principal("CN=Android Debug,O=Android,C=US");
    private String zzcjj;
    private String zzcuq;
    private int akK;
    private String ajn;
    private String zzcup;
    private long akL;
    private String ajg;

    zzn(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzwv() {
        Object object;
        boolean bl;
        CharSequence charSequence;
        Object object2;
        String string;
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        PackageManager packageManager = this.getContext().getPackageManager();
        String string4 = packageManager.getInstallerPackageName(string = this.getContext().getPackageName());
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            object2 = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
            if (object2 != null) {
                charSequence = packageManager.getApplicationLabel(((PackageInfo)object2).applicationInfo);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string3 = charSequence.toString();
                }
                string2 = ((PackageInfo)object2).versionName;
                n = ((PackageInfo)object2).versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbsz().zzbtr().zzj("Error retrieving package info: appName", string3);
        }
        this.zzcjj = string;
        this.ajn = string4;
        this.zzcuq = string2;
        this.akK = n;
        this.zzcup = string3;
        object2 = zzal.zzfb("MD5");
        if (object2 == null) {
            this.zzbsz().zzbtr().log("Could not get MD5 instance");
            this.akL = -1L;
        } else {
            this.akL = 0L;
            try {
                if (!this.zzbtq()) {
                    charSequence = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                    if (((PackageInfo)charSequence).signatures != null && ((PackageInfo)charSequence).signatures.length > 0) {
                        byte[] byArray = ((MessageDigest)object2).digest(((PackageInfo)charSequence).signatures[0].toByteArray());
                        this.akL = zzal.zzac(byArray);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbsz().zzbtr().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        charSequence = this.zzbtb().zzabc() ? zzqk.zzc((Context)this.getContext(), (String)"-", (boolean)true) : zzqk.zzcb((Context)this.getContext());
        boolean bl2 = bl = charSequence != null && charSequence.isSuccess();
        if (!bl) {
            this.zzdq((Status)charSequence);
        }
        boolean bl3 = false;
        if (bl) {
            object = this.zzbtb().zzbsa();
            if (this.zzbtb().zzbrz()) {
                this.zzbsz().zzbtw().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                this.zzbsz().zzbtw().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && this.zzbtb().zzaql()) {
                this.zzbsz().zzbtw().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl3 = true;
                this.zzbsz().zzbty().log("Collection enabled");
            }
        }
        this.ajg = "";
        if (!this.zzbtb().zzabc()) {
            try {
                object = zzqk.zzaqk();
                Object object3 = this.ajg = TextUtils.isEmpty((CharSequence)object) ? "" : object;
                if (bl3) {
                    this.zzbsz().zzbty().zze("App package, google app id", this.zzcjj, this.ajg);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbsz().zzbtr().zzj("getGoogleAppId or isMeasurementEnabled failed with exception", illegalStateException);
            }
        }
    }

    protected void zzdq(Status status) {
        if (status == null) {
            this.zzbsz().zzbtr().log("GoogleService failed to initialize (no status)");
        } else {
            this.zzbsz().zzbtr().zze("GoogleService failed to initialize, status", status.getStatusCode(), status.getStatusMessage());
        }
    }

    AppMetadata zzlw(String string) {
        return new AppMetadata(this.zzsi(), this.zzbqo(), this.zzxc(), this.zzbtp(), this.zzbqu(), this.zzbqv(), this.zzbqw(), string, this.aja.isEnabled(), !this.zzbta().alJ, this.zzbta().zzbqq());
    }

    String zzsi() {
        this.zzzg();
        return this.zzcjj;
    }

    String zzbqo() {
        this.zzzg();
        return this.ajg;
    }

    String zzxc() {
        this.zzzg();
        return this.zzcuq;
    }

    int zzbtp() {
        this.zzzg();
        return this.akK;
    }

    String zzbqu() {
        this.zzzg();
        return this.ajn;
    }

    long zzbqv() {
        return this.zzbtb().zzbqv();
    }

    long zzbqw() {
        this.zzzg();
        return this.akL;
    }

    boolean zzbtq() {
        try {
            PackageInfo packageInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(akJ);
            }
        }
        catch (CertificateException certificateException) {
            this.zzbsz().zzbtr().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbsz().zzbtr().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }
}

