/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzt
extends zzaa {
    static final Pair<String, Long> alt = new Pair((Object)"", (Object)0L);
    private SharedPreferences al;
    public final zzc alu = new zzc("health_monitor", this.zzbtb().zzaci());
    public final zzb alv = new zzb("last_upload", 0L);
    public final zzb alw = new zzb("last_upload_attempt", 0L);
    public final zzb alx = new zzb("backoff", 0L);
    public final zzb aly = new zzb("last_delete_stale", 0L);
    public final zzb alz;
    private String alA;
    private boolean alB;
    private long alC;
    private SecureRandom alD;
    public final zzb alE = new zzb("time_before_start", 10000L);
    public final zzb alF = new zzb("session_timeout", 1800000L);
    public final zza alG = new zza("start_new_session", true);
    public final zzb alH = new zzb("last_pause_time", 0L);
    public final zzb alI = new zzb("time_active", 0L);
    public boolean alJ;

    @WorkerThread
    private SecureRandom zzbua() {
        this.zzwu();
        if (this.alD == null) {
            this.alD = new SecureRandom();
        }
        return this.alD;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzly(String string) {
        this.zzwu();
        long l = this.zzyw().elapsedRealtime();
        if (this.alA != null && l < this.alC) {
            return new Pair((Object)this.alA, (Object)this.alB);
        }
        this.alC = l + this.zzbtb().zzlh(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.alA = info.getId();
            if (this.alA == null) {
                this.alA = "";
            }
            this.alB = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzbsz().zzbtx().zzj("Unable to get advertising id", throwable);
            this.alA = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.alA, (Object)this.alB);
    }

    String zzlz(String string) {
        String string2 = (String)this.zzly((String)string).first;
        MessageDigest messageDigest = zzal.zzfb("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzbub() {
        byte[] byArray = new byte[16];
        this.zzbua().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzbqq() {
        this.zzwu();
        return com.google.firebase.iid.zzc.zzcwt().getId();
    }

    @WorkerThread
    long zzbuc() {
        this.zzzg();
        this.zzwu();
        long l = this.alz.get();
        if (l == 0L) {
            l = 1 + this.zzbua().nextInt(86400000);
            this.alz.set(l);
        }
        return l;
    }

    zzt(zzx zzx2) {
        super(zzx2);
        this.alz = new zzb("midnight_offset", 0L);
    }

    @Override
    protected void zzwv() {
        this.al = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.alJ = this.al.getBoolean("has_been_opened", false);
        if (!this.alJ) {
            SharedPreferences.Editor editor = this.al.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzbud() {
        this.zzwu();
        this.zzzg();
        return this.al;
    }

    @WorkerThread
    void zzma(String string) {
        this.zzwu();
        SharedPreferences.Editor editor = this.zzbud().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzbue() {
        this.zzwu();
        return this.zzbud().getString("gmp_app_id", null);
    }

    @WorkerThread
    Boolean zzbuf() {
        this.zzwu();
        if (!this.zzbud().contains("use_service")) {
            return null;
        }
        return this.zzbud().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzca(boolean bl) {
        this.zzwu();
        this.zzbsz().zzbty().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzbud().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzbug() {
        this.zzwu();
        this.zzbsz().zzbty().log("Clearing collection preferences.");
        boolean bl = this.zzbud().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzcb(true);
        }
        SharedPreferences.Editor editor = this.zzbud().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzwu();
        this.zzbsz().zzbty().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzbud().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzcb(boolean bl) {
        this.zzwu();
        return this.zzbud().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzbuh() {
        this.zzwu();
        String string = this.zzbud().getString("previous_os_version", null);
        String string2 = this.zzbss().zzbtk();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzbud().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzaxn;
        private final boolean alK;
        private boolean alL;
        private boolean rD;

        public zza(String string, boolean bl) {
            zzab.zzhs((String)string);
            this.zzaxn = string;
            this.alK = bl;
        }

        @WorkerThread
        private void zzbui() {
            if (this.alL) {
                return;
            }
            this.alL = true;
            this.rD = zzt.this.al.getBoolean(this.zzaxn, this.alK);
        }

        @WorkerThread
        public boolean get() {
            this.zzbui();
            return this.rD;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzt.this.al.edit();
            editor.putBoolean(this.zzaxn, bl);
            editor.apply();
            this.rD = bl;
        }
    }

    public final class zzb {
        private final String zzaxn;
        private final long alN;
        private boolean alL;
        private long zzcvh;

        public zzb(String string, long l) {
            zzab.zzhs((String)string);
            this.zzaxn = string;
            this.alN = l;
        }

        @WorkerThread
        private void zzbui() {
            if (this.alL) {
                return;
            }
            this.alL = true;
            this.zzcvh = zzt.this.al.getLong(this.zzaxn, this.alN);
        }

        @WorkerThread
        public long get() {
            this.zzbui();
            return this.zzcvh;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzt.this.al.edit();
            editor.putLong(this.zzaxn, l);
            editor.apply();
            this.zzcvh = l;
        }
    }

    public final class zzc {
        final String alO;
        private final String alP;
        private final String alQ;
        private final long ap;

        private zzc(String string, long l) {
            zzab.zzhs((String)string);
            zzab.zzbn((l > 0L ? 1 : 0) != 0);
            this.alO = String.valueOf(string).concat(":start");
            this.alP = String.valueOf(string).concat(":count");
            this.alQ = String.valueOf(string).concat(":value");
            this.ap = l;
        }

        @WorkerThread
        private void zzadt() {
            zzt.this.zzwu();
            long l = zzt.this.zzyw().currentTimeMillis();
            SharedPreferences.Editor editor = zzt.this.al.edit();
            editor.remove(this.alP);
            editor.remove(this.alQ);
            editor.putLong(this.alO, l);
            editor.apply();
        }

        @WorkerThread
        private long zzadu() {
            zzt.this.zzwu();
            long l = this.zzadw();
            if (l == 0L) {
                this.zzadt();
                return 0L;
            }
            return Math.abs(l - zzt.this.zzyw().currentTimeMillis());
        }

        @WorkerThread
        public void zzew(String string) {
            this.zzg(string, 1L);
        }

        @WorkerThread
        public void zzg(String string, long l) {
            long l2;
            zzt.this.zzwu();
            long l3 = this.zzadw();
            if (l3 == 0L) {
                this.zzadt();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzt.this.al.getLong(this.alP, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzt.this.al.edit();
                editor.putString(this.alQ, string);
                editor.putLong(this.alP, l);
                editor.apply();
                return;
            }
            long l4 = zzt.this.zzbua().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzt.this.al.edit();
            if (bl) {
                editor.putString(this.alQ, string);
            }
            editor.putLong(this.alP, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzadv() {
            zzt.this.zzwu();
            long l = this.zzadu();
            if (l < this.ap) {
                return null;
            }
            if (l > this.ap * 2L) {
                this.zzadt();
                return null;
            }
            String string = zzt.this.zzbud().getString(this.alQ, null);
            long l2 = zzt.this.zzbud().getLong(this.alP, 0L);
            this.zzadt();
            if (string == null || l2 <= 0L) {
                return alt;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzadw() {
            return zzt.this.zzbud().getLong(this.alO, 0L);
        }
    }
}

