/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.support.annotation.BinderThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzy
extends zzm.zza {
    private final zzx aja;
    private final boolean amQ;

    public zzy(zzx zzx2) {
        zzab.zzaa((Object)zzx2);
        this.aja = zzx2;
        this.amQ = false;
    }

    public zzy(zzx zzx2, boolean bl) {
        zzab.zzaa((Object)zzx2);
        this.aja = zzx2;
        this.amQ = bl;
    }

    @WorkerThread
    void zzmf(String string) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)string) && (stringArray = string.split(":", 2)).length == 2) {
            long l;
            try {
                l = Long.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                this.aja.zzbsz().zzbtt().zzj("Combining sample with a non-number weight", stringArray[0]);
                return;
            }
            if (l > 0L) {
                this.aja.zzbta().alu.zzg(stringArray[1], l);
            } else {
                this.aja.zzbsz().zzbtt().zzj("Combining sample with a non-positive weight", l);
            }
        }
    }

    @Override
    @BinderThread
    public void zzb(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.aja.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzy.this.aja.zzbvd();
                zzy.this.zzmf(appMetadata.ajD);
                zzy.this.aja.zzc(appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        zzab.zzaa((Object)((Object)eventParcel));
        this.zzf(appMetadata);
        this.aja.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzy.this.aja.zzbvd();
                zzy.this.zzmf(appMetadata.ajD);
                zzy.this.aja.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final String string, final String string2) {
        zzab.zzaa((Object)((Object)eventParcel));
        zzab.zzhs((String)string);
        this.zzmg(string);
        this.aja.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzy.this.aja.zzbvd();
                zzy.this.zzmf(string2);
                zzy.this.aja.zzb(eventParcel, string);
            }
        });
    }

    @Override
    @BinderThread
    public byte[] zza(final EventParcel eventParcel, final String string) {
        zzab.zzhs((String)string);
        zzab.zzaa((Object)((Object)eventParcel));
        this.zzmg(string);
        this.aja.zzbsz().zzbtx().zzj("Log and bundle. event", eventParcel.name);
        long l = this.aja.zzyw().nanoTime() / 1000000L;
        Future<byte[]> future = this.aja.zzbsy().zze(new Callable<byte[]>(){

            public byte[] zzbvf() throws Exception {
                zzy.this.aja.zzbvd();
                return zzy.this.aja.zza(eventParcel, string);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbvf();
            }
        });
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.aja.zzbsz().zzbtr().log("Log and bundle returned null");
                byArray = new byte[]{};
            }
            long l2 = this.aja.zzyw().nanoTime() / 1000000L;
            this.aja.zzbsz().zzbtx().zzd("Log and bundle processed. event, size, time_ms", eventParcel.name, byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.aja.zzbsz().zzbtr().zze("Failed to log and bundle. event, error", eventParcel.name, exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        zzab.zzaa((Object)((Object)userAttributeParcel));
        this.zzf(appMetadata);
        if (userAttributeParcel.getValue() == null) {
            this.aja.zzbsy().zzl(new Runnable(){

                @Override
                public void run() {
                    zzy.this.aja.zzbvd();
                    zzy.this.zzmf(appMetadata.ajD);
                    zzy.this.aja.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.aja.zzbsy().zzl(new Runnable(){

                @Override
                public void run() {
                    zzy.this.aja.zzbvd();
                    zzy.this.zzmf(appMetadata.ajD);
                    zzy.this.aja.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    @BinderThread
    public List<UserAttributeParcel> zza(final AppMetadata appMetadata, boolean bl) {
        this.zzf(appMetadata);
        Future<List<zzak>> future = this.aja.zzbsy().zzd(new Callable<List<zzak>>(){

            public List<zzak> zzbvg() throws Exception {
                zzy.this.aja.zzbvd();
                return zzy.this.aja.zzbsu().zzln(appMetadata.packageName);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbvg();
            }
        });
        try {
            List<zzak> list = future.get();
            ArrayList<UserAttributeParcel> arrayList = new ArrayList<UserAttributeParcel>(list.size());
            for (zzak zzak2 : list) {
                if (!bl && zzal.zzmu(zzak2.mName)) continue;
                arrayList.add(new UserAttributeParcel(zzak2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.aja.zzbsz().zzbtr().zzj("Failed to get user attributes", exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.aja.zzbsy().zzl(new Runnable(){

            @Override
            public void run() {
                zzy.this.aja.zzbvd();
                zzy.this.zzmf(appMetadata.ajD);
                zzy.this.aja.zzd(appMetadata);
            }
        });
    }

    @BinderThread
    private void zzf(AppMetadata appMetadata) {
        zzab.zzaa((Object)((Object)appMetadata));
        this.zzmg(appMetadata.packageName);
        this.aja.zzbsv().zzmr(appMetadata.ajz);
    }

    @BinderThread
    private void zzmg(String string) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.aja.zzbsz().zzbtr().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzmh(string);
        }
        catch (SecurityException securityException) {
            this.aja.zzbsz().zzbtr().zzj("Measurement Service called with invalid calling package", string);
            throw securityException;
        }
    }

    protected void zzmh(String string) throws SecurityException {
        int n = this.amQ ? Process.myUid() : Binder.getCallingUid();
        if (com.google.android.gms.common.util.zzy.zzb((Context)this.aja.getContext(), (int)n, (String)string)) {
            return;
        }
        if (com.google.android.gms.common.util.zzy.zze((Context)this.aja.getContext(), (int)n) && !this.aja.zzbuu()) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string));
    }
}

