/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzvw;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;

public final class zzae {
    private final Handler mHandler;
    private final Context mContext;
    private final zza amc;
    private static Boolean zzcry;

    public zzae(zza zza2) {
        this.mContext = zza2.getContext();
        zzab.zzy((Object)this.mContext);
        this.amc = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzaw(Context context) {
        zzab.zzy((Object)context);
        if (zzcry != null) {
            return zzcry;
        }
        boolean bl = zzal.zzj(context, "com.google.android.gms.measurement.AppMeasurementService");
        zzcry = bl;
        return bl;
    }

    @MainThread
    public void onCreate() {
        zzx zzx2 = zzx.zzdo(this.mContext);
        zzp zzp2 = zzx2.zzbsd();
        if (zzx2.zzbsf().zzabc()) {
            zzp2.zzbtc().log("Device AppMeasurementService is starting up");
        } else {
            zzp2.zzbtc().log("Local AppMeasurementService is starting up");
        }
    }

    @MainThread
    public void onDestroy() {
        zzx zzx2 = zzx.zzdo(this.mContext);
        zzp zzp2 = zzx2.zzbsd();
        if (zzx2.zzbsf().zzabc()) {
            zzp2.zzbtc().log("Device AppMeasurementService is shutting down");
        } else {
            zzp2.zzbtc().log("Local AppMeasurementService is shutting down");
        }
    }

    @MainThread
    public int onStartCommand(Intent intent, int n, final int n2) {
        this.zzvw();
        final zzx zzx2 = zzx.zzdo(this.mContext);
        final zzp zzp2 = zzx2.zzbsd();
        if (intent == null) {
            zzp2.zzbsx().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        if (zzx2.zzbsf().zzabc()) {
            zzp2.zzbtc().zze("Device AppMeasurementService called. startId, action", n2, string);
        } else {
            zzp2.zzbtc().zze("Local AppMeasurementService called. startId, action", n2, string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzx2.zzbsc().zzm(new Runnable(){

                @Override
                public void run() {
                    zzx2.zzbuh();
                    zzx2.zzbuc();
                    zzae.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzae.this.amc.callServiceStopSelfResult(n2);
                            if (bl) {
                                if (zzx2.zzbsf().zzabc()) {
                                    zzp2.zzbtc().log("Device AppMeasurementService processed last upload request");
                                } else {
                                    zzp2.zzbtc().log("Local AppMeasurementService processed last upload request");
                                }
                            }
                        }
                    });
                }
            });
            return 2;
        }
        return 2;
    }

    @MainThread
    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzbsd().zzbsv().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzy(zzx.zzdo(this.mContext));
        }
        this.zzbsd().zzbsx().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzbsd().zzbsv().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzbsd().zzbtc().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzbsd().zzbsv().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzbsd().zzbtc().zzj("onRebind called. action", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvw() {
        try {
            Object object = zzu.zzamr;
            synchronized (object) {
                zzvw zzvw2 = zzu.zzcrw;
                if (zzvw2 != null && zzvw2.isHeld()) {
                    zzvw2.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private zzp zzbsd() {
        return zzx.zzdo(this.mContext).zzbsd();
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

