/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class zzn
extends zzaa {
    private static final X500Principal ajm = new X500Principal("CN=Android Debug,O=Android,C=US");
    private String zzcjf;
    private String zzcun;
    private int ajn;
    private String ahQ;
    private String zzcum;
    private long ajo;
    private String ahJ;

    zzn(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzwv() {
        Object object;
        boolean bl;
        CharSequence charSequence;
        Object object2;
        String string;
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        PackageManager packageManager = this.getContext().getPackageManager();
        String string4 = packageManager.getInstallerPackageName(string = this.getContext().getPackageName());
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            object2 = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
            if (object2 != null) {
                charSequence = packageManager.getApplicationLabel(((PackageInfo)object2).applicationInfo);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string3 = charSequence.toString();
                }
                string2 = ((PackageInfo)object2).versionName;
                n = ((PackageInfo)object2).versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbsd().zzbsv().zzj("Error retrieving package info: appName", string3);
        }
        this.zzcjf = string;
        this.ahQ = string4;
        this.zzcun = string2;
        this.ajn = n;
        this.zzcum = string3;
        object2 = zzal.zzfa("MD5");
        if (object2 == null) {
            this.zzbsd().zzbsv().log("Could not get MD5 instance");
            this.ajo = -1L;
        } else {
            this.ajo = 0L;
            try {
                if (!this.zzbsu()) {
                    charSequence = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                    if (((PackageInfo)charSequence).signatures != null && ((PackageInfo)charSequence).signatures.length > 0) {
                        byte[] byArray = ((MessageDigest)object2).digest(((PackageInfo)charSequence).signatures[0].toByteArray());
                        this.ajo = zzal.zzx(byArray);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbsd().zzbsv().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        charSequence = this.zzbsf().zzabc() ? zzqf.zzc((Context)this.getContext(), (String)"-", (boolean)true) : zzqf.zzcb((Context)this.getContext());
        boolean bl2 = bl = charSequence != null && charSequence.isSuccess();
        if (!bl) {
            this.zzdq((Status)charSequence);
        }
        boolean bl3 = false;
        if (bl) {
            object = this.zzbsf().zzbre();
            if (this.zzbsf().zzbrd()) {
                this.zzbsd().zzbta().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                this.zzbsd().zzbta().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && this.zzbsf().zzaqp()) {
                this.zzbsd().zzbta().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl3 = true;
                this.zzbsd().zzbtc().log("Collection enabled");
            }
        }
        this.ahJ = "";
        if (!this.zzbsf().zzabc()) {
            try {
                object = zzqf.zzaqo();
                Object object3 = this.ahJ = TextUtils.isEmpty((CharSequence)object) ? "" : object;
                if (bl3) {
                    this.zzbsd().zzbtc().zze("App package, google app id", this.zzcjf, this.ahJ);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbsd().zzbsv().zzj("getGoogleAppId or isMeasurementEnabled failed with exception", illegalStateException);
            }
        }
    }

    protected void zzdq(Status status) {
        if (status == null) {
            this.zzbsd().zzbsv().log("GoogleService failed to initialize (no status)");
        } else {
            this.zzbsd().zzbsv().zze("GoogleService failed to initialize, status", status.getStatusCode(), status.getStatusMessage());
        }
    }

    AppMetadata zzlv(String string) {
        return new AppMetadata(this.zzsh(), this.zzbps(), this.zzxc(), this.zzbst(), this.zzbpy(), this.zzbpz(), this.zzbqa(), string, this.ahD.isEnabled(), !this.zzbse().akm, this.zzbse().zzbpu());
    }

    String zzsh() {
        this.zzzg();
        return this.zzcjf;
    }

    String zzbps() {
        this.zzzg();
        return this.ahJ;
    }

    String zzxc() {
        this.zzzg();
        return this.zzcun;
    }

    int zzbst() {
        this.zzzg();
        return this.ajn;
    }

    String zzbpy() {
        this.zzzg();
        return this.ahQ;
    }

    long zzbpz() {
        return this.zzbsf().zzbpz();
    }

    long zzbqa() {
        this.zzzg();
        return this.ajo;
    }

    boolean zzbsu() {
        try {
            PackageInfo packageInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(ajm);
            }
        }
        catch (CertificateException certificateException) {
            this.zzbsd().zzbsv().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbsd().zzbsv().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }
}

