/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzapo;
import com.google.android.gms.internal.zzug;
import com.google.android.gms.internal.zzuh;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class zzx {
    private static volatile zzx akP;
    private final Context mContext;
    private final zzd akQ;
    private final zzt akR;
    private final zzp akS;
    private final zzw akT;
    private final zzaf akU;
    private final zzv akV;
    private final AppMeasurement akW;
    private final zzal akX;
    private final zze akY;
    private final zzq akZ;
    private final com.google.android.gms.common.util.zze zzaoc;
    private final zzad ala;
    private final zzg alb;
    private final zzac alc;
    private final zzn ald;
    private final zzr ale;
    private final zzai alf;
    private final zzc alg;
    public final FirebaseAnalytics alh;
    private final boolean zzcwq;
    private boolean ali;
    private Boolean alj;
    private FileLock alk;
    private FileChannel all;
    private List<Long> alm;
    private int aln;
    private int alo;

    zzx(zzab zzab2) {
        com.google.android.gms.common.internal.zzab.zzy((Object)zzab2);
        this.mContext = zzab2.mContext;
        this.zzaoc = zzab2.zzl(this);
        this.akQ = zzab2.zza(this);
        zzt zzt2 = zzab2.zzb(this);
        zzt2.initialize();
        this.akR = zzt2;
        zzp zzp2 = zzab2.zzc(this);
        zzp2.initialize();
        this.akS = zzp2;
        this.zzbsd().zzbta().zzj("App measurement is starting up, version", this.zzbsf().zzbpz());
        this.zzbsd().zzbta().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        this.zzbsd().zzbtb().log("Debug logging enabled");
        this.zzbsd().zzbtb().zzj("AppMeasurement singleton hash", System.identityHashCode(this));
        this.akX = zzab2.zzi(this);
        zzg zzg2 = zzab2.zzn(this);
        zzg2.initialize();
        this.alb = zzg2;
        zzn zzn2 = zzab2.zzo(this);
        zzn2.initialize();
        this.ald = zzn2;
        zze zze2 = zzab2.zzj(this);
        zze2.initialize();
        this.akY = zze2;
        zzc zzc2 = zzab2.zzr(this);
        zzc2.initialize();
        this.alg = zzc2;
        zzq zzq2 = zzab2.zzk(this);
        zzq2.initialize();
        this.akZ = zzq2;
        zzad zzad2 = zzab2.zzm(this);
        zzad2.initialize();
        this.ala = zzad2;
        zzac zzac2 = zzab2.zzh(this);
        zzac2.initialize();
        this.alc = zzac2;
        zzai zzai2 = zzab2.zzq(this);
        zzai2.initialize();
        this.alf = zzai2;
        this.ale = zzab2.zzp(this);
        this.akW = zzab2.zzg(this);
        this.alh = new FirebaseAnalytics(this);
        zzaf zzaf2 = zzab2.zze(this);
        zzaf2.initialize();
        this.akU = zzaf2;
        zzv zzv2 = zzab2.zzf(this);
        zzv2.initialize();
        this.akV = zzv2;
        zzw zzw2 = zzab2.zzd(this);
        zzw2.initialize();
        this.akT = zzw2;
        if (this.aln != this.alo) {
            this.zzbsd().zzbsv().zze("Not all components initialized", this.aln, this.alo);
        }
        this.zzcwq = true;
        if (!this.akQ.zzabc() && !this.zzbty()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                if (Build.VERSION.SDK_INT >= 14) {
                    this.zzbru().zzbun();
                } else {
                    this.zzbsd().zzbtb().log("Not tracking deep linking pre-ICS");
                }
            } else {
                this.zzbsd().zzbsx().log("Application context is not an Application");
            }
        }
        this.akT.zzm(new Runnable(){

            @Override
            public void run() {
                zzx.this.start();
            }
        });
    }

    void zzzg() {
        if (!this.zzcwq) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzbto() {
        this.zzzg();
        this.zzwu();
        if (this.alj == null) {
            this.alj = this.zzbrz().zzeo("android.permission.INTERNET") && this.zzbrz().zzeo("android.permission.ACCESS_NETWORK_STATE") && zzu.zzav(this.getContext()) && zzae.zzaw(this.getContext());
            if (this.alj.booleanValue() && !this.zzbsf().zzabc()) {
                this.alj = this.zzbrz().zzmq(this.zzbrv().zzbps());
            }
        }
        return this.alj;
    }

    @WorkerThread
    protected void start() {
        this.zzwu();
        if (this.zzbty() && (!this.akT.isInitialized() || this.akT.zzbul())) {
            this.zzbsd().zzbsv().log("Scheduler shutting down before Scion.start() called");
            return;
        }
        this.zzbry().zzbsh();
        if (!this.zzbto()) {
            if (this.isEnabled()) {
                if (!this.zzbrz().zzeo("android.permission.INTERNET")) {
                    this.zzbsd().zzbsv().log("App is missing INTERNET permission");
                }
                if (!this.zzbrz().zzeo("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzbsd().zzbsv().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzu.zzav(this.getContext())) {
                    this.zzbsd().zzbsv().log("AppMeasurementReceiver not registered/enabled");
                }
                if (!zzae.zzaw(this.getContext())) {
                    this.zzbsd().zzbsv().log("AppMeasurementService not registered/enabled");
                }
                this.zzbsd().zzbsv().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!this.zzbsf().zzabc() && !TextUtils.isEmpty((CharSequence)this.zzbrv().zzbps())) {
                String string = this.zzbse().zzbti();
                if (string == null) {
                    this.zzbse().zzlz(this.zzbrv().zzbps());
                } else if (!string.equals(this.zzbrv().zzbps())) {
                    this.zzbsd().zzbta().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzbse().zzbtk();
                    this.ala.disconnect();
                    this.ala.zzaai();
                    this.zzbse().zzlz(this.zzbrv().zzbps());
                }
            }
            if (!(this.zzbsf().zzabc() || this.zzbty() || TextUtils.isEmpty((CharSequence)this.zzbrv().zzbps()))) {
                this.zzbru().zzbuo();
            }
        }
        this.zzbue();
    }

    public zzd zzbsf() {
        return this.akQ;
    }

    public zzt zzbse() {
        this.zza((zzz)this.akR);
        return this.akR;
    }

    public zzp zzbsd() {
        this.zza(this.akS);
        return this.akS;
    }

    public zzp zzbtp() {
        return this.akS != null && this.akS.isInitialized() ? this.akS : null;
    }

    public zzw zzbsc() {
        this.zza(this.akT);
        return this.akT;
    }

    public zzaf zzbsb() {
        this.zza(this.akU);
        return this.akU;
    }

    public zzv zzbsa() {
        this.zza(this.akV);
        return this.akV;
    }

    zzw zzbtq() {
        return this.akT;
    }

    public zzac zzbru() {
        this.zza(this.alc);
        return this.alc;
    }

    public AppMeasurement zzbtr() {
        return this.akW;
    }

    public zzal zzbrz() {
        this.zza(this.akX);
        return this.akX;
    }

    public zze zzbry() {
        this.zza(this.akY);
        return this.akY;
    }

    public zzq zzbts() {
        this.zza(this.akZ);
        return this.akZ;
    }

    public Context getContext() {
        return this.mContext;
    }

    public com.google.android.gms.common.util.zze zzyw() {
        return this.zzaoc;
    }

    public zzad zzbrx() {
        this.zza(this.ala);
        return this.ala;
    }

    public zzg zzbrw() {
        this.zza(this.alb);
        return this.alb;
    }

    public zzn zzbrv() {
        this.zza(this.ald);
        return this.ald;
    }

    public zzr zzbtt() {
        if (this.ale == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.ale;
    }

    public zzai zzbtu() {
        this.zza(this.alf);
        return this.alf;
    }

    public zzc zzbrt() {
        this.zza(this.alg);
        return this.alg;
    }

    @WorkerThread
    public void zzwu() {
        this.zzbsc().zzwu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzx zzdo(Context context) {
        com.google.android.gms.common.internal.zzab.zzy((Object)context);
        com.google.android.gms.common.internal.zzab.zzy((Object)context.getApplicationContext());
        if (akP != null) return akP;
        Class<zzx> clazz = zzx.class;
        synchronized (zzx.class) {
            if (akP != null) return akP;
            zzab zzab2 = null;
            boolean bl = false;
            zzab2 = new zzab(context);
            akP = zzab2.zzbum();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return akP;
        }
    }

    FileChannel zzbtv() {
        return this.all;
    }

    private void zza(zzaa zzaa2) {
        if (zzaa2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzaa2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzz zzz2) {
        if (zzz2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzbtw() {
        this.zzwu();
        this.zzzg();
        if (this.zzbui() && this.zzbtx()) {
            int n = this.zza(this.zzbtv());
            int n2 = this.zzbrv().zzbst();
            this.zzu(n, n2);
        }
    }

    @WorkerThread
    boolean zzbtx() {
        this.zzwu();
        String string = this.akY.zzaab();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.all = new RandomAccessFile(file2, "rw").getChannel();
            this.alk = this.all.tryLock();
            if (this.alk != null) {
                this.zzbsd().zzbtc().log("Storage concurrent access okay");
                return true;
            }
            this.zzbsd().zzbsv().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzbsd().zzbsv().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzu(int n, int n2) {
        this.zzwu();
        if (n > n2) {
            this.zzbsd().zzbsv().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzbtv())) {
                this.zzbsd().zzbtc().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzbsd().zzbsv().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzwu();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbsd().zzbsv().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n3 = fileChannel.read(byteBuffer);
            if (n3 != 4) {
                this.zzbsd().zzbsx().zzj("Unexpected data length or empty data in channel. Bytes read", n3);
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzwu();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbsd().zzbsv().log("Bad chanel to read from");
            return false;
        }
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzbsd().zzbsv().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    protected boolean zzbty() {
        return false;
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzwu();
        this.zzzg();
        if (this.zzbsf().zzbrd()) {
            return false;
        }
        Boolean bl = this.zzbsf().zzbre();
        boolean bl2 = bl != null ? bl : !this.zzbsf().zzaqp();
        return this.zzbse().zzcc(bl2);
    }

    void zzc(AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzhr((String)appMetadata.packageName);
        this.zze(appMetadata);
    }

    @WorkerThread
    void zzb(EventParcel eventParcel, String string) {
        Object object;
        com.google.android.gms.measurement.internal.zza zza2;
        block4: {
            zza2 = this.zzbry().zzln(string);
            if (zza2 == null || TextUtils.isEmpty((CharSequence)zza2.zzxc())) {
                this.zzbsd().zzbtb().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = this.getContext().getPackageManager().getPackageInfo((String)string, (int)0).versionName;
                if (zza2.zzxc() != null && !zza2.zzxc().equals(object)) {
                    this.zzbsd().zzbsx().zzj("App version does not match; dropping event", string);
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(eventParcel.name)) break block4;
                this.zzbsd().zzbsx().zzj("Could not find package", string);
            }
        }
        object = new AppMetadata(string, zza2.zzbps(), zza2.zzxc(), zza2.zzbpx(), zza2.zzbpy(), zza2.zzbpz(), zza2.zzbqa(), null, zza2.zzbqb(), false, zza2.zzbpu());
        this.zzb(eventParcel, (AppMetadata)((Object)object));
    }

    long zzbtz() {
        long l = this.zzyw().currentTimeMillis() + this.zzbse().zzbtg();
        return l / 1000L / 60L / 60L / 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        long l = System.nanoTime();
        this.zzwu();
        this.zzzg();
        String string = appMetadata.packageName;
        com.google.android.gms.common.internal.zzab.zzhr((String)string);
        if (TextUtils.isEmpty((CharSequence)appMetadata.aic)) {
            return;
        }
        if (!appMetadata.aih) {
            this.zze(appMetadata);
            return;
        }
        if (this.zzbsa().zzax(string, eventParcel.name)) {
            this.zzbsd().zzbsx().zzj("Dropping blacklisted event", eventParcel.name);
            this.zzbrz().zze(11, "_ev", eventParcel.name);
            return;
        }
        if (this.zzbsd().zzaz(2)) {
            this.zzbsd().zzbtc().zzj("Logging event", (Object)eventParcel);
        }
        this.zzbry().beginTransaction();
        try {
            zzi zzi2;
            Bundle bundle = eventParcel.aiI.zzbss();
            this.zze(appMetadata);
            if ("_iap".equals(eventParcel.name) || "ecommerce_purchase".equals(eventParcel.name)) {
                String string2 = bundle.getString("currency");
                long l2 = 0L;
                if ("ecommerce_purchase".equals(eventParcel.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzbsd().zzbsx().zzj("Data lost. Currency value is too big", d);
                        this.zzbry().setTransactionSuccessful();
                        return;
                    }
                    l2 = Math.round(d);
                } else {
                    l2 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzak zzak2 = this.zzbry().zzas(string, string5);
                    if (zzak2 == null || !(zzak2.zzcnn instanceof Long)) {
                        this.zzbry().zzy(string, this.zzbsf().zzlh(string) - 1);
                        zzak2 = new zzak(string, string5, this.zzyw().currentTimeMillis(), l2);
                    } else {
                        long l3 = (Long)zzak2.zzcnn;
                        zzak2 = new zzak(string, string5, this.zzyw().currentTimeMillis(), l3 + l2);
                    }
                    if (!this.zzbry().zza(zzak2)) {
                        this.zzbsd().zzbsv().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzcnn);
                        this.zzbrz().zze(9, null, null);
                    }
                }
            }
            boolean bl = zzal.zzmj(eventParcel.name);
            boolean bl2 = zzal.zzam(bundle);
            boolean bl3 = "_err".equals(eventParcel.name);
            zze.zza zza2 = this.zzbry().zza(this.zzbtz(), string, bl, false, bl3);
            long l4 = zza2.aiq - this.zzbsf().zzbqv();
            if (l4 > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzbsd().zzbsv().zzj("Data loss. Too many events logged. count", zza2.aiq);
                }
                this.zzbrz().zze(16, "_ev", eventParcel.name);
                this.zzbry().setTransactionSuccessful();
                return;
            }
            if (bl && (l4 = zza2.aip - this.zzbsf().zzbqw()) > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzbsd().zzbsv().zzj("Data loss. Too many public events logged. count", zza2.aip);
                }
                this.zzbrz().zze(16, "_ev", eventParcel.name);
                this.zzbry().setTransactionSuccessful();
                return;
            }
            if (bl3 && (l4 = zza2.ais - this.zzbsf().zzbqx()) > 0L) {
                if (l4 == 1L) {
                    this.zzbsd().zzbsv().zzj("Too many error events logged. count", zza2.ais);
                }
                this.zzbry().setTransactionSuccessful();
                return;
            }
            this.zzbrz().zza(bundle, "_o", eventParcel.aiJ);
            long l5 = this.zzbry().zzlo(string);
            if (l5 > 0L) {
                this.zzbsd().zzbsx().zzj("Data lost. Too many events stored on disk, deleted", l5);
            }
            zzh zzh2 = new zzh(this, eventParcel.aiJ, string, eventParcel.name, eventParcel.aiK, 0L, bundle);
            zzi zzi3 = this.zzbry().zzaq(string, zzh2.mName);
            if (zzi3 == null) {
                long l6 = this.zzbry().zzlu(string);
                if (l6 >= (long)this.zzbsf().zzbqu()) {
                    this.zzbsd().zzbsv().zze("Too many event names used, ignoring event. name, supported count", zzh2.mName, this.zzbsf().zzbqu());
                    this.zzbrz().zze(8, null, null);
                    return;
                }
                zzi2 = new zzi(string, zzh2.mName, 0L, 0L, zzh2.pJ);
            } else {
                zzh2 = zzh2.zza(this, zzi3.aiE);
                zzi2 = zzi3.zzbj(zzh2.pJ);
            }
            this.zzbry().zza(zzi2);
            this.zza(zzh2, appMetadata);
            this.zzbry().setTransactionSuccessful();
            if (this.zzbsd().zzaz(2)) {
                this.zzbsd().zzbtc().zzj("Event recorded", zzh2);
            }
        }
        finally {
            this.zzbry().endTransaction();
        }
        this.zzbue();
        this.zzbsd().zzbtc().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull EventParcel eventParcel, @Size(min=1L) String string) {
        Object object;
        zzapo zzapo2;
        Object object2;
        this.zzzg();
        this.zzwu();
        this.zzbua();
        com.google.android.gms.common.internal.zzab.zzy((Object)((Object)eventParcel));
        com.google.android.gms.common.internal.zzab.zzhr((String)string);
        zzuh.zzd zzd2 = new zzuh.zzd();
        this.zzbry().beginTransaction();
        try {
            zzi zzi2;
            long l;
            Object object3;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbry().zzln(string);
            if (zza2 == null) {
                this.zzbsd().zzbtb().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zza2.zzbqb()) {
                this.zzbsd().zzbtb().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzuh.zze();
            zzd2.ans = new zzuh.zze[]{object2};
            object2.anu = 1;
            object2.anC = "android";
            object2.zzck = zza2.zzsh();
            object2.aid = zza2.zzbpy();
            object2.aav = zza2.zzxc();
            object2.anP = (int)zza2.zzbpx();
            object2.anG = zza2.zzbpz();
            object2.aic = zza2.zzbps();
            object2.anL = zza2.zzbqa();
            zzapo2 = this.zzbse().zzlx(zza2.zzsh());
            if (zzapo2 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)zzapo2.first))) {
                object2.anI = (String)zzapo2.first;
                object2.anJ = (Boolean)zzapo2.second;
            }
            object2.anD = this.zzbrw().zztg();
            object2.zzct = this.zzbrw().zzbso();
            object2.anF = (int)this.zzbrw().zzbsp();
            object2.anE = this.zzbrw().zzbsq();
            object2.anK = zza2.zzawo();
            object2.aik = zza2.zzbpu();
            object = this.zzbry().zzlm(zza2.zzsh());
            object2.anw = new zzuh.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzuh.zzg();
                object2.anw[i] = object3;
                ((zzuh.zzg)object3).name = object.get((int)i).mName;
                ((zzuh.zzg)object3).anW = object.get((int)i).amx;
                this.zzbrz().zza((zzuh.zzg)object3, object.get((int)i).zzcnn);
            }
            Bundle bundle = eventParcel.aiI.zzbss();
            if ("_iap".equals(eventParcel.name)) {
                bundle.putLong("_c", 1L);
            }
            bundle.putString("_o", eventParcel.aiJ);
            object3 = this.zzbry().zzaq(string, eventParcel.name);
            if (object3 == null) {
                l = 0L;
                zzi2 = new zzi(string, eventParcel.name, 1L, 0L, eventParcel.aiK);
                this.zzbry().zza(zzi2);
            } else {
                l = ((zzi)object3).aiE;
                zzi2 = ((zzi)object3).zzbj(eventParcel.aiK);
                zzi2 = zzi2.zzbsr();
                this.zzbry().zza(zzi2);
            }
            zzh zzh2 = new zzh(this, eventParcel.aiJ, string, eventParcel.name, eventParcel.aiK, l, bundle);
            zzuh.zzb zzb2 = new zzuh.zzb();
            object2.anv = new zzuh.zzb[]{zzb2};
            zzb2.ano = zzh2.pJ;
            zzb2.name = zzh2.mName;
            zzb2.anp = zzh2.aiA;
            zzb2.ann = new zzuh.zzc[zzh2.aiB.size()];
            int n = 0;
            for (String string2 : zzh2.aiB) {
                zzuh.zzc zzc2 = new zzuh.zzc();
                zzb2.ann[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzh2.aiB.get(string2);
                this.zzbrz().zza(zzc2, object4);
            }
            object2.anO = this.zza(zza2.zzsh(), object2.anw, object2.anv);
            object2.any = zzb2.ano;
            object2.anz = zzb2.ano;
            long l2 = zza2.zzbpw();
            object2.anB = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zza2.zzbpv();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.anA = l3 != 0L ? Long.valueOf(l3) : null;
            zza2.zzbqf();
            object2.anM = (int)zza2.zzbqc();
            object2.anH = this.zzbsf().zzbpz();
            object2.anx = this.zzyw().currentTimeMillis();
            object2.anN = Boolean.TRUE;
            zza2.zzau(object2.any);
            zza2.zzav(object2.anz);
            this.zzbry().zza(zza2);
            this.zzbry().setTransactionSuccessful();
        }
        finally {
            this.zzbry().endTransaction();
        }
        try {
            int n = zzd2.aM();
            object2 = new byte[n];
            zzapo2 = zzapo.zzbe((byte[])object2);
            zzd2.zza(zzapo2);
            zzapo2.az();
            object = this.zzbrz().zzj((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Data loss. Failed to bundle and serialize", iOException);
            return null;
        }
    }

    void zza(zzh zzh2, AppMetadata appMetadata) {
        Object object;
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzy((Object)zzh2);
        com.google.android.gms.common.internal.zzab.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzab.zzhr((String)zzh2.zzcjf);
        com.google.android.gms.common.internal.zzab.zzbo((boolean)zzh2.zzcjf.equals(appMetadata.packageName));
        zzuh.zze zze2 = new zzuh.zze();
        zze2.anu = 1;
        zze2.anC = "android";
        zze2.zzck = appMetadata.packageName;
        zze2.aid = appMetadata.aid;
        zze2.aav = appMetadata.aav;
        zze2.anP = (int)appMetadata.aij;
        zze2.anG = appMetadata.aie;
        zze2.aic = appMetadata.aic;
        zze2.anL = appMetadata.aif == 0L ? null : Long.valueOf(appMetadata.aif);
        Pair<String, Boolean> pair = this.zzbse().zzlx(appMetadata.packageName);
        if (pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.anI = (String)pair.first;
            zze2.anJ = (Boolean)pair.second;
        } else if (!this.zzbrw().zzdn(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzbsd().zzbsx().log("null secure ID");
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzbsd().zzbsx().log("empty secure ID");
            }
            zze2.anS = object;
        }
        zze2.anD = this.zzbrw().zztg();
        zze2.zzct = this.zzbrw().zzbso();
        zze2.anF = (int)this.zzbrw().zzbsp();
        zze2.anE = this.zzbrw().zzbsq();
        zze2.anH = null;
        zze2.anx = null;
        zze2.any = null;
        zze2.anz = null;
        object = this.zzbry().zzln(appMetadata.packageName);
        if (object == null) {
            object = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            ((com.google.android.gms.measurement.internal.zza)object).zzky(this.zzbse().zzbtf());
            ((com.google.android.gms.measurement.internal.zza)object).zzlb(appMetadata.aik);
            ((com.google.android.gms.measurement.internal.zza)object).zzkz(appMetadata.aic);
            ((com.google.android.gms.measurement.internal.zza)object).zzla(this.zzbse().zzly(appMetadata.packageName));
            ((com.google.android.gms.measurement.internal.zza)object).zzaz(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzau(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzav(0L);
            ((com.google.android.gms.measurement.internal.zza)object).setAppVersion(appMetadata.aav);
            ((com.google.android.gms.measurement.internal.zza)object).zzaw(appMetadata.aij);
            ((com.google.android.gms.measurement.internal.zza)object).zzlc(appMetadata.aid);
            ((com.google.android.gms.measurement.internal.zza)object).zzax(appMetadata.aie);
            ((com.google.android.gms.measurement.internal.zza)object).zzay(appMetadata.aif);
            ((com.google.android.gms.measurement.internal.zza)object).setMeasurementEnabled(appMetadata.aih);
            this.zzbry().zza((com.google.android.gms.measurement.internal.zza)object);
        }
        zze2.anK = ((com.google.android.gms.measurement.internal.zza)object).zzawo();
        zze2.aik = ((com.google.android.gms.measurement.internal.zza)object).zzbpu();
        List<zzak> list = this.zzbry().zzlm(appMetadata.packageName);
        zze2.anw = new zzuh.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzuh.zzg zzg2;
            zze2.anw[i] = zzg2 = new zzuh.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.anW = list.get((int)i).amx;
            this.zzbrz().zza(zzg2, list.get((int)i).zzcnn);
        }
        long l = 0L;
        try {
            l = this.zzbry().zzb(zze2);
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Data loss. Failed to insert raw event metadata", iOException);
            return;
        }
        this.zzbry().zza(zzh2, l);
    }

    void zzyv() {
        if (this.zzbsf().zzabc()) {
            throw new IllegalStateException("Unexpected call on package side");
        }
    }

    void zzbua() {
        if (!this.zzbsf().zzabc()) {
            throw new IllegalStateException("Unexpected call on client side");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        if (TextUtils.isEmpty((CharSequence)appMetadata.aic)) {
            return;
        }
        if (!appMetadata.aih) {
            this.zze(appMetadata);
            return;
        }
        int n = this.zzbrz().zzmn(userAttributeParcel.name);
        if (n != 0) {
            String string = this.zzbrz().zza(userAttributeParcel.name, this.zzbsf().zzbqo(), true);
            this.zzbrz().zze(n, "_ev", string);
            return;
        }
        n = this.zzbrz().zzm(userAttributeParcel.name, userAttributeParcel.getValue());
        if (n != 0) {
            String string = this.zzbrz().zza(userAttributeParcel.name, this.zzbsf().zzbqo(), true);
            this.zzbrz().zze(n, "_ev", string);
            return;
        }
        Object object = this.zzbrz().zzn(userAttributeParcel.name, userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzak zzak2 = new zzak(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.amt, object);
        this.zzbsd().zzbtb().zze("Setting user property", zzak2.mName, object);
        this.zzbry().beginTransaction();
        try {
            this.zze(appMetadata);
            boolean bl = this.zzbry().zza(zzak2);
            this.zzbry().setTransactionSuccessful();
            if (bl) {
                this.zzbsd().zzbtb().zze("User property set", zzak2.mName, zzak2.zzcnn);
            } else {
                this.zzbsd().zzbsv().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzcnn);
                this.zzbrz().zze(9, null, null);
            }
        }
        finally {
            this.zzbry().endTransaction();
        }
    }

    @WorkerThread
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        if (TextUtils.isEmpty((CharSequence)appMetadata.aic)) {
            return;
        }
        if (!appMetadata.aih) {
            this.zze(appMetadata);
            return;
        }
        this.zzbsd().zzbtb().zzj("Removing user property", userAttributeParcel.name);
        this.zzbry().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzbry().zzar(appMetadata.packageName, userAttributeParcel.name);
            this.zzbry().setTransactionSuccessful();
            this.zzbsd().zzbtb().zzj("User property removed", userAttributeParcel.name);
        }
        finally {
            this.zzbry().endTransaction();
        }
    }

    @WorkerThread
    private boolean zzbub() {
        this.zzwu();
        return this.alm != null;
    }

    private void zzad(List<Long> list) {
        com.google.android.gms.common.internal.zzab.zzbo((!list.isEmpty() ? 1 : 0) != 0);
        if (this.alm != null) {
            this.zzbsd().zzbsv().log("Set uploading progress before finishing the previous upload");
        } else {
            this.alm = new ArrayList<Long>(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void zzbuc() {
        String string;
        this.zzwu();
        this.zzzg();
        if (!this.zzbsf().zzabc()) {
            Boolean bl = this.zzbse().zzbtj();
            if (bl == null) {
                this.zzbsd().zzbsx().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzbsd().zzbsv().log("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzbub()) {
            this.zzbsd().zzbsx().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzbts().zzadj()) {
            this.zzbsd().zzbsx().log("Network not connected, ignoring upload request");
            this.zzbue();
            return;
        }
        long l = this.zzyw().currentTimeMillis();
        this.zzbl(l - this.zzbsf().zzbrl());
        long l2 = this.zzbse().ajY.get();
        if (l2 != 0L) {
            this.zzbsd().zzbtb().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzbry().zzbsg()))) {
            int n = this.zzbsf().zzlj(string);
            int n2 = this.zzbsf().zzlk(string);
            List<Pair<zzuh.zze, Long>> list = this.zzbry().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzuh.zze, Long> object2 : list) {
                    zzuh.zze zze2 = (zzuh.zze)object2.first;
                    if (TextUtils.isEmpty((CharSequence)zze2.anI)) continue;
                    string2 = zze2.anI;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzuh.zze zze3 = (zzuh.zze)list.get((int)i).first;
                        if (TextUtils.isEmpty((CharSequence)zze3.anI) || zze3.anI.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                zzuh.zzd zzd2 = new zzuh.zzd();
                zzd2.ans = new zzuh.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < zzd2.ans.length; ++i) {
                    zzd2.ans[i] = (zzuh.zze)list.get((int)i).first;
                    arrayList.add((Long)list.get((int)i).second);
                    zzd2.ans[i].anH = this.zzbsf().zzbpz();
                    zzd2.ans[i].anx = l;
                    zzd2.ans[i].anN = this.zzbsf().zzabc();
                }
                String string3 = null;
                if (this.zzbsd().zzaz(2)) {
                    string3 = zzal.zzb(zzd2);
                }
                byte[] byArray = this.zzbrz().zza(zzd2);
                String string4 = this.zzbsf().zzbrk();
                try {
                    URL uRL = new URL(string4);
                    this.zzad(arrayList);
                    this.zzbse().ajZ.set(l);
                    String string5 = "?";
                    if (zzd2.ans.length > 0) {
                        string5 = zzd2.ans[0].zzck;
                    }
                    this.zzbsd().zzbtc().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzbts().zza(string, uRL, byArray, null, new zzq.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzx.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzbsd().zzbsv().zzj("Failed to parse upload URL. Not uploading", string4);
                }
            }
        } else {
            String string6 = this.zzbry().zzbi(l - this.zzbsf().zzbrl());
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                com.google.android.gms.measurement.internal.zza zza2 = this.zzbry().zzln(string6);
                if (zza2 != null) {
                    String string7 = this.zzbsf().zzap(zza2.zzbps(), zza2.zzawo());
                    try {
                        void var11_23;
                        URL uRL = new URL(string7);
                        this.zzbsd().zzbtc().zzj("Fetching remote configuration", zza2.zzsh());
                        zzug.zzb zzb2 = this.zzbsa().zzmb(zza2.zzsh());
                        Object var11_21 = null;
                        String string8 = this.zzbsa().zzmc(zza2.zzsh());
                        if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string8)) {
                            ArrayMap arrayMap = new ArrayMap();
                            arrayMap.put("If-Modified-Since", string8);
                        }
                        this.zzbts().zza(string6, uRL, (Map<String, String>)var11_23, new zzq.zza(){

                            @Override
                            public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                                zzx.this.zzb(string, n, throwable, byArray, map);
                            }
                        });
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzbsd().zzbsv().zzj("Failed to parse config URL. Not fetching", string7);
                    }
                }
                return;
            }
        }
    }

    boolean zzbl(long l) {
        return this.zzi(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzi(String string, long l) {
        this.zzbry().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzbry().zza(string, l, zza2);
            if (!zza2.isEmpty()) {
                int n;
                zzuh.zze zze2 = zza2.alq;
                zze2.anv = new zzuh.zzb[zza2.zzalc.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzalc.size(); ++n) {
                    if (this.zzbsa().zzax(zza2.alq.zzck, zza2.zzalc.get((int)n).name)) {
                        this.zzbsd().zzbsx().zzj("Dropping blacklisted raw event", zza2.zzalc.get((int)n).name);
                        this.zzbrz().zze(11, "_ev", zza2.zzalc.get((int)n).name);
                        continue;
                    }
                    if (this.zzbsa().zzay(zza2.alq.zzck, zza2.zzalc.get((int)n).name)) {
                        boolean bl;
                        boolean bl2 = false;
                        if (zza2.zzalc.get((int)n).ann == null) {
                            zza2.zzalc.get((int)n).ann = new zzuh.zzc[0];
                        }
                        for (zzuh.zzc zzc2 : zza2.zzalc.get((int)n).ann) {
                            if (!"_c".equals(zzc2.name)) continue;
                            zzc2.anr = 1L;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            this.zzbsd().zzbtc().zzj("Marking event as conversion", zza2.zzalc.get((int)n).name);
                            zzuh.zzc[] zzcArray = Arrays.copyOf(zza2.zzalc.get((int)n).ann, zza2.zzalc.get((int)n).ann.length + 1);
                            zzuh.zzc zzc3 = new zzuh.zzc();
                            zzc3.name = "_c";
                            zzc3.anr = 1L;
                            zzcArray[zzcArray.length - 1] = zzc3;
                            zza2.zzalc.get((int)n).ann = zzcArray;
                        }
                        if (bl = zzal.zzmj(zza2.zzalc.get((int)n).name)) {
                            zze.zza zza3 = this.zzbry().zza(this.zzbtz(), zza2.alq.zzck, false, bl, false);
                            long l2 = zza3.air - (long)this.zzbsf().zzlf(zza2.alq.zzck);
                            if (l2 > 0L) {
                                this.zzbsd().zzbsx().log("Too many conversions. Not logging as conversion.");
                                zzuh.zzb zzb2 = zza2.zzalc.get(n);
                                boolean bl3 = false;
                                zzuh.zzc zzc4 = null;
                                for (zzuh.zzc zzc5 : zza2.zzalc.get((int)n).ann) {
                                    if ("_c".equals(zzc5.name)) {
                                        zzc4 = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl3 = true;
                                }
                                if (bl3 && zzc4 != null) {
                                    zzuh.zzc[] zzcArray = new zzuh.zzc[zzb2.ann.length - 1];
                                    int n3 = 0;
                                    for (zzuh.zzc zzc6 : zzb2.ann) {
                                        if (zzc6 == zzc4) continue;
                                        zzcArray[n3++] = zzc6;
                                    }
                                    zza2.zzalc.get((int)n).ann = zzcArray;
                                } else if (zzc4 != null) {
                                    zzc4.name = "_err";
                                    zzc4.anr = 10L;
                                } else {
                                    this.zzbsd().zzbsv().log("Did not find conversion parameter. Error not tracked");
                                }
                            }
                        }
                    }
                    zze2.anv[n2++] = zza2.zzalc.get(n);
                }
                if (n2 < zza2.zzalc.size()) {
                    zze2.anv = Arrays.copyOf(zze2.anv, n2);
                }
                zze2.anO = this.zza(zza2.alq.zzck, zza2.alq.anw, zze2.anv);
                zze2.any = zze2.anv[0].ano;
                zze2.anz = zze2.anv[0].ano;
                for (n = 1; n < zze2.anv.length; ++n) {
                    zzuh.zzb zzb3 = zze2.anv[n];
                    if (zzb3.ano < zze2.any) {
                        zze2.any = zzb3.ano;
                    }
                    if (zzb3.ano <= zze2.anz) continue;
                    zze2.anz = zzb3.ano;
                }
                String string2 = zza2.alq.zzck;
                com.google.android.gms.measurement.internal.zza zza4 = this.zzbry().zzln(string2);
                if (zza4 == null) {
                    this.zzbsd().zzbsv().log("Bundling raw events w/o app info");
                } else {
                    long l3 = zza4.zzbpw();
                    zze2.anB = l3 != 0L ? Long.valueOf(l3) : null;
                    long l4 = zza4.zzbpv();
                    if (l4 == 0L) {
                        l4 = l3;
                    }
                    zze2.anA = l4 != 0L ? Long.valueOf(l4) : null;
                    zza4.zzbqf();
                    zze2.anM = (int)zza4.zzbqc();
                    zza4.zzau(zze2.any);
                    zza4.zzav(zze2.anz);
                    this.zzbry().zza(zza4);
                }
                zze2.aig = this.zzbsd().zzbtd();
                this.zzbry().zza(zze2);
                this.zzbry().zzac(zza2.alr);
                this.zzbry().zzlt(string2);
                this.zzbry().setTransactionSuccessful();
                boolean bl = true;
                return true;
            }
            this.zzbry().setTransactionSuccessful();
            boolean bl = false;
            return false;
        }
        finally {
            this.zzbry().endTransaction();
        }
    }

    private zzuh.zza[] zza(String string, zzuh.zzg[] zzgArray, zzuh.zzb[] zzbArray) {
        com.google.android.gms.common.internal.zzab.zzhr((String)string);
        return this.zzbrt().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzhr((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzbry().beginTransaction();
        try {
            boolean bl;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbry().zzln(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zza2 == null) {
                this.zzbsd().zzbsx().zzj("App does not exist in onConfigFetched", string);
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzbsa().zzmb(string) == null && !this.zzbsa().zzb(string, null, null) : !this.zzbsa().zzb(string, byArray, string2)) {
                    return;
                }
                zza2.zzba(this.zzyw().currentTimeMillis());
                this.zzbry().zza(zza2);
                if (n == 404) {
                    this.zzbsd().zzbsx().log("Config not found. Using empty config");
                } else {
                    this.zzbsd().zzbtc().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzbts().zzadj() && this.zzbud()) {
                    this.zzbuc();
                } else {
                    this.zzbue();
                }
            } else {
                boolean bl3;
                zza2.zzbb(this.zzyw().currentTimeMillis());
                this.zzbry().zza(zza2);
                this.zzbsd().zzbtc().zze("Fetching config failed. code, error", n, throwable);
                this.zzbsa().zzmd(string);
                this.zzbse().ajZ.set(this.zzyw().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzbse().aka.set(this.zzyw().currentTimeMillis());
                }
                this.zzbue();
            }
            this.zzbry().setTransactionSuccessful();
        }
        finally {
            this.zzbry().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzwu();
        this.zzzg();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.alm;
        this.alm = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzbse().ajY.set(this.zzyw().currentTimeMillis());
            this.zzbse().ajZ.set(0L);
            this.zzbue();
            this.zzbsd().zzbtc().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzbry().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzbry().zzbh(l);
                }
                this.zzbry().setTransactionSuccessful();
            }
            finally {
                this.zzbry().endTransaction();
            }
            if (this.zzbts().zzadj() && this.zzbud()) {
                this.zzbuc();
            } else {
                this.zzbue();
            }
        } else {
            boolean bl;
            this.zzbsd().zzbtc().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzbse().ajZ.set(this.zzyw().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzbse().aka.set(this.zzyw().currentTimeMillis());
            }
            this.zzbue();
        }
    }

    private boolean zzbud() {
        this.zzwu();
        this.zzzg();
        boolean bl = this.zzbry().zzbsl();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzbry().zzbsg());
    }

    @WorkerThread
    private void zzbue() {
        this.zzwu();
        this.zzzg();
        if (!this.zzbui()) {
            return;
        }
        if (!this.zzbto() || !this.zzbud()) {
            this.zzbtt().unregister();
            this.zzbtu().cancel();
            return;
        }
        long l = this.zzbuf();
        if (l == 0L) {
            this.zzbtt().unregister();
            this.zzbtu().cancel();
            return;
        }
        if (!this.zzbts().zzadj()) {
            this.zzbtt().zzadg();
            this.zzbtu().cancel();
            return;
        }
        long l2 = this.zzbse().aka.get();
        long l3 = this.zzbsf().zzbrm();
        if (!this.zzbrz().zzg(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzbtt().unregister();
        long l4 = l - this.zzyw().currentTimeMillis();
        if (l4 <= 0L) {
            this.zzbtu().zzv(1L);
        } else {
            this.zzbsd().zzbtc().zzj("Upload scheduled in approximately ms", l4);
            this.zzbtu().zzv(l4);
        }
    }

    private long zzbuf() {
        long l;
        long l2 = this.zzyw().currentTimeMillis();
        long l3 = this.zzbsf().zzbrp();
        long l4 = this.zzbsf().zzbrn();
        long l5 = this.zzbse().ajY.get();
        long l6 = this.zzbse().ajZ.get();
        long l7 = this.zzbry().zzbsj();
        long l8 = Math.max(l7, l = this.zzbry().zzbsk());
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l2 - Math.abs(l8 - l2);
        l5 = l2 - Math.abs(l5 - l2);
        l6 = l2 - Math.abs(l6 - l2);
        long l9 = Math.max(l5, l6);
        long l10 = l8 + l3;
        if (!this.zzbrz().zzg(l9, l4)) {
            l10 = l9 + l4;
        }
        if (l6 != 0L && l6 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzbsf().zzbrr(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzbsf().zzbrq() * l12) <= l6) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzas(boolean bl) {
        this.zzbue();
    }

    void zzb(zzaa zzaa2) {
        ++this.aln;
    }

    void zzbug() {
        ++this.alo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zzd(AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzab.zzhr((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.aic)) {
            return;
        }
        if (!appMetadata.aih) {
            this.zze(appMetadata);
            return;
        }
        long l = this.zzyw().currentTimeMillis();
        this.zzbry().beginTransaction();
        try {
            this.zza(appMetadata, l);
            this.zze(appMetadata);
            zzi zzi2 = this.zzbry().zzaq(appMetadata.packageName, "_f");
            if (zzi2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l, l2, "auto");
                this.zzb(userAttributeParcel, appMetadata);
                this.zzb(appMetadata, l);
                this.zzc(appMetadata, l);
            } else if (appMetadata.aii) {
                this.zzd(appMetadata, l);
            }
            this.zzbry().setTransactionSuccessful();
        }
        finally {
            this.zzbry().endTransaction();
        }
    }

    @WorkerThread
    void zza(AppMetadata appMetadata, long l) {
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbry().zzln(appMetadata.packageName);
        if (zza2 != null && zza2.zzbps() != null && !zza2.zzbps().equals(appMetadata.aic)) {
            this.zzbsd().zzbsx().log("New GMP App Id passed in. Removing cached database data.");
            this.zzbry().zzls(zza2.zzsh());
            zza2 = null;
        }
        if (zza2 != null && zza2.zzxc() != null && !zza2.zzxc().equals(appMetadata.aav)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zza2.zzxc());
            EventParcel eventParcel = new EventParcel("_au", new EventParams(bundle), "auto", l);
            this.zzb(eventParcel, appMetadata);
        }
    }

    @WorkerThread
    void zzb(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        EventParcel eventParcel = new EventParcel("_f", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzc(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        EventParcel eventParcel = new EventParcel("_e", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzd(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        EventParcel eventParcel = new EventParcel("_cd", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    private void zze(AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzab.zzhr((String)appMetadata.packageName);
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbry().zzln(appMetadata.packageName);
        String string = this.zzbse().zzly(appMetadata.packageName);
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            zza2.zzky(this.zzbse().zzbtf());
            zza2.zzla(string);
            bl = true;
        } else if (!string.equals(zza2.zzbpt())) {
            zza2.zzla(string);
            zza2.zzky(this.zzbse().zzbtf());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.aic) && !appMetadata.aic.equals(zza2.zzbps())) {
            zza2.zzkz(appMetadata.aic);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.aik) && !appMetadata.aik.equals(zza2.zzbpu())) {
            zza2.zzlb(appMetadata.aik);
            bl = true;
        }
        if (appMetadata.aie != 0L && appMetadata.aie != zza2.zzbpz()) {
            zza2.zzax(appMetadata.aie);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.aav) && !appMetadata.aav.equals(zza2.zzxc())) {
            zza2.setAppVersion(appMetadata.aav);
            bl = true;
        }
        if (appMetadata.aij != zza2.zzbpx()) {
            zza2.zzaw(appMetadata.aij);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.aid) && !appMetadata.aid.equals(zza2.zzbpy())) {
            zza2.zzlc(appMetadata.aid);
            bl = true;
        }
        if (appMetadata.aif != zza2.zzbqa()) {
            zza2.zzay(appMetadata.aif);
            bl = true;
        }
        if (appMetadata.aih != zza2.zzbqb()) {
            zza2.setMeasurementEnabled(appMetadata.aih);
            bl = true;
        }
        if (bl) {
            this.zzbry().zza(zza2);
        }
    }

    @WorkerThread
    void zzbuh() {
        this.zzwu();
        this.zzzg();
        if (!this.ali) {
            this.zzbsd().zzbta().log("This instance being marked as an uploader");
            this.zzbtw();
        }
        this.ali = true;
    }

    @WorkerThread
    boolean zzbui() {
        this.zzwu();
        this.zzzg();
        return this.ali || this.zzbty();
    }

    private class zza
    implements zze.zzb {
        zzuh.zze alq;
        List<Long> alr;
        List<zzuh.zzb> zzalc;
        long als;

        private zza() {
        }

        @Override
        public void zzc(zzuh.zze zze2) {
            com.google.android.gms.common.internal.zzab.zzy((Object)zze2);
            this.alq = zze2;
        }

        @Override
        public boolean zza(long l, zzuh.zzb zzb2) {
            com.google.android.gms.common.internal.zzab.zzy((Object)zzb2);
            if (this.zzalc == null) {
                this.zzalc = new ArrayList<zzuh.zzb>();
            }
            if (this.alr == null) {
                this.alr = new ArrayList<Long>();
            }
            if (this.zzalc.size() > 0 && this.zza(this.zzalc.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.als + (long)zzb2.aM();
            if (l2 >= (long)zzx.this.zzbsf().zzbri()) {
                return false;
            }
            this.als = l2;
            this.zzalc.add(zzb2);
            this.alr.add(l);
            return this.zzalc.size() < zzx.this.zzbsf().zzbrj();
        }

        private long zza(zzuh.zzb zzb2) {
            return zzb2.ano / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzalc == null || this.zzalc.isEmpty();
        }
    }
}

