/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.support.annotation.BinderThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzy
extends zzm.zza {
    private final zzx ahD;
    private final boolean alt;

    public zzy(zzx zzx2) {
        zzab.zzy((Object)zzx2);
        this.ahD = zzx2;
        this.alt = false;
    }

    public zzy(zzx zzx2, boolean bl) {
        zzab.zzy((Object)zzx2);
        this.ahD = zzx2;
        this.alt = bl;
    }

    @WorkerThread
    void zzme(String string) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)string) && (stringArray = string.split(":", 2)).length == 2) {
            long l;
            try {
                l = Long.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                this.ahD.zzbsd().zzbsx().zzj("Combining sample with a non-number weight", stringArray[0]);
                return;
            }
            if (l > 0L) {
                this.ahD.zzbse().ajX.zzh(stringArray[1], l);
            } else {
                this.ahD.zzbsd().zzbsx().zzj("Combining sample with a non-positive weight", l);
            }
        }
    }

    @Override
    @BinderThread
    public void zzb(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.ahD.zzbsc().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.ahD.zzbuh();
                zzy.this.zzme(appMetadata.aig);
                zzy.this.ahD.zzc(appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        zzab.zzy((Object)((Object)eventParcel));
        this.zzf(appMetadata);
        this.ahD.zzbsc().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.ahD.zzbuh();
                zzy.this.zzme(appMetadata.aig);
                zzy.this.ahD.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final String string, final String string2) {
        zzab.zzy((Object)((Object)eventParcel));
        zzab.zzhr((String)string);
        this.zzmf(string);
        this.ahD.zzbsc().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.ahD.zzbuh();
                zzy.this.zzme(string2);
                zzy.this.ahD.zzb(eventParcel, string);
            }
        });
    }

    @Override
    @BinderThread
    public byte[] zza(final EventParcel eventParcel, final String string) {
        zzab.zzhr((String)string);
        zzab.zzy((Object)((Object)eventParcel));
        this.zzmf(string);
        this.ahD.zzbsd().zzbtb().zzj("Log and bundle. event", eventParcel.name);
        long l = this.ahD.zzyw().nanoTime() / 1000000L;
        Future<byte[]> future = this.ahD.zzbsc().zze(new Callable<byte[]>(){

            public byte[] zzbuj() throws Exception {
                zzy.this.ahD.zzbuh();
                return zzy.this.ahD.zza(eventParcel, string);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbuj();
            }
        });
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.ahD.zzbsd().zzbsv().log("Log and bundle returned null");
                byArray = new byte[]{};
            }
            long l2 = this.ahD.zzyw().nanoTime() / 1000000L;
            this.ahD.zzbsd().zzbtb().zzd("Log and bundle processed. event, size, time_ms", eventParcel.name, byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.ahD.zzbsd().zzbsv().zze("Failed to log and bundle. event, error", eventParcel.name, exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        zzab.zzy((Object)((Object)userAttributeParcel));
        this.zzf(appMetadata);
        if (userAttributeParcel.getValue() == null) {
            this.ahD.zzbsc().zzm(new Runnable(){

                @Override
                public void run() {
                    zzy.this.ahD.zzbuh();
                    zzy.this.zzme(appMetadata.aig);
                    zzy.this.ahD.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.ahD.zzbsc().zzm(new Runnable(){

                @Override
                public void run() {
                    zzy.this.ahD.zzbuh();
                    zzy.this.zzme(appMetadata.aig);
                    zzy.this.ahD.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    @BinderThread
    public List<UserAttributeParcel> zza(final AppMetadata appMetadata, boolean bl) {
        this.zzf(appMetadata);
        Future<List<zzak>> future = this.ahD.zzbsc().zzd(new Callable<List<zzak>>(){

            public List<zzak> zzbuk() throws Exception {
                zzy.this.ahD.zzbuh();
                return zzy.this.ahD.zzbry().zzlm(appMetadata.packageName);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbuk();
            }
        });
        try {
            List<zzak> list = future.get();
            ArrayList<UserAttributeParcel> arrayList = new ArrayList<UserAttributeParcel>(list.size());
            for (zzak zzak2 : list) {
                if (!bl && zzal.zzmt(zzak2.mName)) continue;
                arrayList.add(new UserAttributeParcel(zzak2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.ahD.zzbsd().zzbsv().zzj("Failed to get user attributes", exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.ahD.zzbsc().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.ahD.zzbuh();
                zzy.this.zzme(appMetadata.aig);
                zzy.this.ahD.zzd(appMetadata);
            }
        });
    }

    @BinderThread
    private void zzf(AppMetadata appMetadata) {
        zzab.zzy((Object)((Object)appMetadata));
        this.zzmf(appMetadata.packageName);
        this.ahD.zzbrz().zzmq(appMetadata.aic);
    }

    @BinderThread
    private void zzmf(String string) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.ahD.zzbsd().zzbsv().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzmg(string);
        }
        catch (SecurityException securityException) {
            this.ahD.zzbsd().zzbsv().zzj("Measurement Service called with invalid calling package", string);
            throw securityException;
        }
    }

    protected void zzmg(String string) throws SecurityException {
        int n = this.alt ? Process.myUid() : Binder.getCallingUid();
        if (com.google.android.gms.common.util.zzy.zzb((Context)this.ahD.getContext(), (int)n, (String)string)) {
            return;
        }
        if (com.google.android.gms.common.util.zzy.zze((Context)this.ahD.getContext(), (int)n) && !this.ahD.zzbty()) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string));
    }
}

