/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzard;
import com.google.android.gms.internal.zzvl;
import com.google.android.gms.internal.zzvm;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class zzx {
    private static volatile zzx aqP;
    private final Context mContext;
    private final zzd aqQ;
    private final zzt aqR;
    private final zzp aqS;
    private final zzw aqT;
    private final zzaf aqU;
    private final zzv aqV;
    private final AppMeasurement aqW;
    private final FirebaseAnalytics aqX;
    private final zzal aqY;
    private final zze aqZ;
    private final zzq ara;
    private final com.google.android.gms.common.util.zze zzapy;
    private final zzad arb;
    private final zzg arc;
    private final zzac ard;
    private final zzn are;
    private final zzr arf;
    private final zzai arg;
    private final zzc arh;
    private final boolean aJ;
    private boolean ari;
    private Boolean arj;
    private FileLock ark;
    private FileChannel arl;
    private List<Long> arm;
    private int arn;
    private int aro;

    zzx(zzab zzab2) {
        com.google.android.gms.common.internal.zzac.zzy((Object)zzab2);
        this.mContext = zzab2.mContext;
        this.zzapy = zzab2.zzm(this);
        this.aqQ = zzab2.zza(this);
        zzt zzt2 = zzab2.zzb(this);
        zzt2.initialize();
        this.aqR = zzt2;
        zzp zzp2 = zzab2.zzc(this);
        zzp2.initialize();
        this.aqS = zzp2;
        this.zzbvg().zzbwh().zzj("App measurement is starting up, version", this.zzbvi().zzbsy());
        this.zzbvg().zzbwh().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        this.zzbvg().zzbwi().log("Debug-level message logging enabled");
        this.zzbvg().zzbwi().zzj("AppMeasurement singleton hash", System.identityHashCode(this));
        this.aqY = zzab2.zzj(this);
        zzg zzg2 = zzab2.zzo(this);
        zzg2.initialize();
        this.arc = zzg2;
        zzn zzn2 = zzab2.zzp(this);
        zzn2.initialize();
        this.are = zzn2;
        String string = zzn2.zzti();
        if (this.zzbvc().zzni(string)) {
            this.zzbvg().zzbwh().log("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop firebase.analytics.debug-mode .none.");
        } else {
            String string2 = String.valueOf(string);
            this.zzbvg().zzbwh().log(string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop firebase.analytics.debug-mode ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop firebase.analytics.debug-mode "));
        }
        zze zze2 = zzab2.zzk(this);
        zze2.initialize();
        this.aqZ = zze2;
        zzc zzc2 = zzab2.zzs(this);
        zzc2.initialize();
        this.arh = zzc2;
        zzq zzq2 = zzab2.zzl(this);
        zzq2.initialize();
        this.ara = zzq2;
        zzad zzad2 = zzab2.zzn(this);
        zzad2.initialize();
        this.arb = zzad2;
        zzac zzac2 = zzab2.zzi(this);
        zzac2.initialize();
        this.ard = zzac2;
        zzai zzai2 = zzab2.zzr(this);
        zzai2.initialize();
        this.arg = zzai2;
        this.arf = zzab2.zzq(this);
        this.aqW = zzab2.zzh(this);
        this.aqX = zzab2.zzg(this);
        zzaf zzaf2 = zzab2.zze(this);
        zzaf2.initialize();
        this.aqU = zzaf2;
        zzv zzv2 = zzab2.zzf(this);
        zzv2.initialize();
        this.aqV = zzv2;
        zzw zzw2 = zzab2.zzd(this);
        zzw2.initialize();
        this.aqT = zzw2;
        if (this.arn != this.aro) {
            this.zzbvg().zzbwc().zze("Not all components initialized", this.arn, this.aro);
        }
        this.aJ = true;
        if (!this.aqQ.zzact() && !this.zzbxg()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                if (Build.VERSION.SDK_INT >= 14) {
                    this.zzbux().zzbxv();
                } else {
                    this.zzbvg().zzbwi().log("Not tracking deep linking pre-ICS");
                }
            } else {
                this.zzbvg().zzbwe().log("Application context is not an Application");
            }
        }
        this.aqT.zzm(new Runnable(){

            @Override
            public void run() {
                zzx.this.start();
            }
        });
    }

    void zzaax() {
        if (!this.aJ) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzbwv() {
        this.zzaax();
        this.zzyl();
        if (this.arj == null) {
            if (this.zzbvi().zzact()) {
                this.arj = true;
                return true;
            }
            this.arj = this.zzbvc().zzew("android.permission.INTERNET") && this.zzbvc().zzew("android.permission.ACCESS_NETWORK_STATE") && zzu.zzh(this.getContext(), false) && zzae.zzi(this.getContext(), false);
            if (this.arj.booleanValue()) {
                this.arj = this.zzbvc().zzne(this.zzbuy().zzbsr());
            }
        }
        return this.arj;
    }

    @WorkerThread
    protected void start() {
        this.zzyl();
        if (this.zzbxg() && (!this.aqT.isInitialized() || this.aqT.zzbxt())) {
            this.zzbvg().zzbwc().log("Scheduler shutting down before Scion.start() called");
            return;
        }
        this.zzbvb().zzbvl();
        if (this.zzbvh().apQ.get() == 0L) {
            this.zzbvh().apQ.set(this.zzaan().currentTimeMillis());
        }
        if (!this.zzbwv()) {
            if (this.isEnabled()) {
                if (!this.zzbvc().zzew("android.permission.INTERNET")) {
                    this.zzbvg().zzbwc().log("App is missing INTERNET permission");
                }
                if (!this.zzbvc().zzew("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzbvg().zzbwc().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!this.zzbvi().zzact()) {
                    if (!zzu.zzh(this.getContext(), false)) {
                        this.zzbvg().zzbwc().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzae.zzi(this.getContext(), false)) {
                        this.zzbvg().zzbwc().log("AppMeasurementService not registered/enabled");
                    }
                }
                if (!this.zzbxg()) {
                    this.zzbvg().zzbwc().log("Uploading is not possible. App measurement disabled");
                }
            }
        } else {
            if (!this.zzbvi().zzact() && !TextUtils.isEmpty((CharSequence)this.zzbuy().zzbsr())) {
                String string = this.zzbvh().zzbwp();
                if (string == null) {
                    this.zzbvh().zzmn(this.zzbuy().zzbsr());
                } else if (!string.equals(this.zzbuy().zzbsr())) {
                    this.zzbvg().zzbwh().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzbvh().zzbwr();
                    this.arb.disconnect();
                    this.arb.zzabz();
                    this.zzbvh().zzmn(this.zzbuy().zzbsr());
                }
            }
            if (!(this.zzbvi().zzact() || this.zzbxg() || TextUtils.isEmpty((CharSequence)this.zzbuy().zzbsr()))) {
                this.zzbux().zzbxw();
            }
        }
        this.zzbxm();
    }

    public zzd zzbvi() {
        return this.aqQ;
    }

    public zzt zzbvh() {
        this.zza((zzz)this.aqR);
        return this.aqR;
    }

    public zzp zzbvg() {
        this.zza(this.aqS);
        return this.aqS;
    }

    public zzp zzbww() {
        return this.aqS != null && this.aqS.isInitialized() ? this.aqS : null;
    }

    public zzw zzbvf() {
        this.zza(this.aqT);
        return this.aqT;
    }

    public zzaf zzbve() {
        this.zza(this.aqU);
        return this.aqU;
    }

    public zzv zzbvd() {
        this.zza(this.aqV);
        return this.aqV;
    }

    zzw zzbwx() {
        return this.aqT;
    }

    public zzac zzbux() {
        this.zza(this.ard);
        return this.ard;
    }

    public AppMeasurement zzbwy() {
        return this.aqW;
    }

    public FirebaseAnalytics zzbwz() {
        return this.aqX;
    }

    public zzal zzbvc() {
        this.zza(this.aqY);
        return this.aqY;
    }

    public zze zzbvb() {
        this.zza(this.aqZ);
        return this.aqZ;
    }

    public zzq zzbxa() {
        this.zza(this.ara);
        return this.ara;
    }

    public Context getContext() {
        return this.mContext;
    }

    public com.google.android.gms.common.util.zze zzaan() {
        return this.zzapy;
    }

    public zzad zzbva() {
        this.zza(this.arb);
        return this.arb;
    }

    public zzg zzbuz() {
        this.zza(this.arc);
        return this.arc;
    }

    public zzn zzbuy() {
        this.zza(this.are);
        return this.are;
    }

    public zzr zzbxb() {
        if (this.arf == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.arf;
    }

    public zzai zzbxc() {
        this.zza(this.arg);
        return this.arg;
    }

    public zzc zzbuw() {
        this.zza(this.arh);
        return this.arh;
    }

    @WorkerThread
    public void zzyl() {
        this.zzbvf().zzyl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzx zzdt(Context context) {
        com.google.android.gms.common.internal.zzac.zzy((Object)context);
        com.google.android.gms.common.internal.zzac.zzy((Object)context.getApplicationContext());
        if (aqP != null) return aqP;
        Class<zzx> clazz = zzx.class;
        synchronized (zzx.class) {
            if (aqP != null) return aqP;
            zzab zzab2 = null;
            boolean bl = false;
            zzab2 = new zzab(context);
            aqP = zzab2.zzbxu();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return aqP;
        }
    }

    FileChannel zzbxd() {
        return this.arl;
    }

    private void zza(zzaa zzaa2) {
        if (zzaa2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzaa2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzz zzz2) {
        if (zzz2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzbxe() {
        this.zzyl();
        this.zzaax();
        if (this.zzbxq() && this.zzbxf()) {
            int n = this.zza(this.zzbxd());
            int n2 = this.zzbuy().zzbwa();
            this.zzu(n, n2);
        }
    }

    @WorkerThread
    boolean zzbxf() {
        this.zzyl();
        String string = this.aqZ.zzabs();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.arl = new RandomAccessFile(file2, "rw").getChannel();
            this.ark = this.arl.tryLock();
            if (this.ark != null) {
                this.zzbvg().zzbwj().log("Storage concurrent access okay");
                return true;
            }
            this.zzbvg().zzbwc().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzbvg().zzbwc().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzu(int n, int n2) {
        this.zzyl();
        if (n > n2) {
            this.zzbvg().zzbwc().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzbxd())) {
                this.zzbvg().zzbwj().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzbvg().zzbwc().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzyl();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbvg().zzbwc().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n3 = fileChannel.read(byteBuffer);
            if (n3 != 4) {
                if (n3 != -1) {
                    this.zzbvg().zzbwe().zzj("Unexpected data length. Bytes read", n3);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzyl();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbvg().zzbwc().log("Bad chanel to read from");
            return false;
        }
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzbvg().zzbwc().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    public boolean zzbxg() {
        return false;
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzyl();
        this.zzaax();
        if (this.zzbvi().zzbuc()) {
            return false;
        }
        Boolean bl = this.zzbvi().zzbud();
        boolean bl2 = bl != null ? bl : !this.zzbvi().zzasm();
        return this.zzbvh().zzcg(bl2);
    }

    void zzc(AppMetadata appMetadata) {
        this.zzyl();
        this.zzaax();
        com.google.android.gms.common.internal.zzac.zzhz((String)appMetadata.packageName);
        this.zze(appMetadata);
    }

    @WorkerThread
    void zzb(EventParcel eventParcel, String string) {
        Object object;
        com.google.android.gms.measurement.internal.zza zza2;
        block4: {
            zza2 = this.zzbvb().zzlz(string);
            if (zza2 == null || TextUtils.isEmpty((CharSequence)zza2.zzyt())) {
                this.zzbvg().zzbwi().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = this.getContext().getPackageManager().getPackageInfo((String)string, (int)0).versionName;
                if (zza2.zzyt() != null && !zza2.zzyt().equals(object)) {
                    this.zzbvg().zzbwe().zzj("App version does not match; dropping event", string);
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(eventParcel.name)) break block4;
                this.zzbvg().zzbwe().zzj("Could not find package", string);
            }
        }
        object = new AppMetadata(string, zza2.zzbsr(), zza2.zzyt(), zza2.zzbsw(), zza2.zzbsx(), zza2.zzbsy(), zza2.zzbsz(), null, zza2.zzbta(), false, zza2.zzbst());
        this.zzb(eventParcel, (AppMetadata)((Object)object));
    }

    long zzbxh() {
        long l = this.zzaan().currentTimeMillis() + this.zzbvh().zzbwn();
        return l / 1000L / 60L / 60L / 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        long l = System.nanoTime();
        this.zzyl();
        this.zzaax();
        String string = appMetadata.packageName;
        com.google.android.gms.common.internal.zzac.zzhz((String)string);
        if (TextUtils.isEmpty((CharSequence)appMetadata.anQ)) {
            return;
        }
        if (!appMetadata.anV) {
            this.zze(appMetadata);
            return;
        }
        if (this.zzbvd().zzax(string, eventParcel.name)) {
            this.zzbvg().zzbwe().zzj("Dropping blacklisted event", eventParcel.name);
            this.zzbvc().zza(11, "_ev", eventParcel.name, 0);
            return;
        }
        if (this.zzbvg().zzbf(2)) {
            this.zzbvg().zzbwj().zzj("Logging event", (Object)eventParcel);
        }
        this.zzbvb().beginTransaction();
        try {
            zzi zzi2;
            long l2;
            Bundle bundle = eventParcel.aoz.zzbvz();
            this.zze(appMetadata);
            if ("_iap".equals(eventParcel.name) || "ecommerce_purchase".equals(eventParcel.name)) {
                String string2 = bundle.getString("currency");
                long l3 = 0L;
                if ("ecommerce_purchase".equals(eventParcel.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzbvg().zzbwe().zzj("Data lost. Currency value is too big", d);
                        this.zzbvb().setTransactionSuccessful();
                        return;
                    }
                    l3 = Math.round(d);
                } else {
                    l3 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzak zzak2 = this.zzbvb().zzas(string, string5);
                    if (zzak2 == null || !(zzak2.zzctv instanceof Long)) {
                        this.zzbvb().zzz(string, this.zzbvi().zzls(string) - 1);
                        zzak2 = new zzak(string, string5, this.zzaan().currentTimeMillis(), l3);
                    } else {
                        l2 = (Long)zzak2.zzctv;
                        zzak2 = new zzak(string, string5, this.zzaan().currentTimeMillis(), l2 + l3);
                    }
                    if (!this.zzbvb().zza(zzak2)) {
                        this.zzbvg().zzbwc().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzctv);
                        this.zzbvc().zza(9, null, null, 0);
                    }
                }
            }
            boolean bl = zzal.zzmx(eventParcel.name);
            boolean bl2 = "_err".equals(eventParcel.name);
            zze.zza zza2 = this.zzbvb().zza(this.zzbxh(), string, true, bl, false, bl2, false);
            long l4 = zza2.aog - this.zzbvi().zzbtv();
            if (l4 > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzbvg().zzbwc().zzj("Data loss. Too many events logged. count", zza2.aog);
                }
                this.zzbvc().zza(16, "_ev", eventParcel.name, 0);
                this.zzbvb().setTransactionSuccessful();
                return;
            }
            if (bl && (l4 = zza2.aof - this.zzbvi().zzbtw()) > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzbvg().zzbwc().zzj("Data loss. Too many public events logged. count", zza2.aof);
                }
                this.zzbvc().zza(16, "_ev", eventParcel.name, 0);
                this.zzbvb().setTransactionSuccessful();
                return;
            }
            if (bl2 && (l4 = zza2.aoi - (long)this.zzbvi().zzlo(appMetadata.packageName)) > 0L) {
                if (l4 == 1L) {
                    this.zzbvg().zzbwc().zzj("Too many error events logged. count", zza2.aoi);
                }
                this.zzbvb().setTransactionSuccessful();
                return;
            }
            this.zzbvc().zza(bundle, "_o", eventParcel.aoA);
            if (this.zzbvc().zzni(string)) {
                this.zzbvc().zza(bundle, "_dbg", 1L);
                this.zzbvc().zza(bundle, "_r", 1L);
            }
            if ((l2 = this.zzbvb().zzma(string)) > 0L) {
                this.zzbvg().zzbwe().zzj("Data lost. Too many events stored on disk, deleted", l2);
            }
            zzh zzh2 = new zzh(this, eventParcel.aoA, string, eventParcel.name, eventParcel.aoB, 0L, bundle);
            zzi zzi3 = this.zzbvb().zzaq(string, zzh2.mName);
            if (zzi3 == null) {
                long l5 = this.zzbvb().zzmh(string);
                if (l5 >= (long)this.zzbvi().zzbtu()) {
                    this.zzbvg().zzbwc().zze("Too many event names used, ignoring event. name, supported count", zzh2.mName, this.zzbvi().zzbtu());
                    this.zzbvc().zza(8, null, null, 0);
                    return;
                }
                zzi2 = new zzi(string, zzh2.mName, 0L, 0L, zzh2.tr);
            } else {
                zzh2 = zzh2.zza(this, zzi3.aov);
                zzi2 = zzi3.zzbm(zzh2.tr);
            }
            this.zzbvb().zza(zzi2);
            this.zza(zzh2, appMetadata);
            this.zzbvb().setTransactionSuccessful();
            if (this.zzbvg().zzbf(2)) {
                this.zzbvg().zzbwj().zzj("Event recorded", zzh2);
            }
        }
        finally {
            this.zzbvb().endTransaction();
        }
        this.zzbxm();
        this.zzbvg().zzbwj().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull EventParcel eventParcel, @Size(min=1L) String string) {
        Object object;
        zzard zzard2;
        Object object2;
        this.zzaax();
        this.zzyl();
        this.zzbxi();
        com.google.android.gms.common.internal.zzac.zzy((Object)((Object)eventParcel));
        com.google.android.gms.common.internal.zzac.zzhz((String)string);
        zzvm.zzd zzd2 = new zzvm.zzd();
        this.zzbvb().beginTransaction();
        try {
            zzi zzi2;
            long l;
            Object object3;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbvb().zzlz(string);
            if (zza2 == null) {
                this.zzbvg().zzbwi().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zza2.zzbta()) {
                this.zzbvg().zzbwi().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzvm.zze();
            zzd2.att = new zzvm.zze[]{object2};
            object2.atv = 1;
            object2.atD = "android";
            object2.zzck = zza2.zzti();
            object2.anR = zza2.zzbsx();
            object2.afY = zza2.zzyt();
            object2.atQ = (int)zza2.zzbsw();
            object2.atH = zza2.zzbsy();
            object2.anQ = zza2.zzbsr();
            object2.atM = zza2.zzbsz();
            zzard2 = this.zzbvh().zzml(zza2.zzti());
            if (zzard2 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)zzard2.first))) {
                object2.atJ = (String)zzard2.first;
                object2.atK = (Boolean)zzard2.second;
            }
            object2.atE = this.zzbuz().zzuj();
            object2.zzct = this.zzbuz().zzbvv();
            object2.atG = (int)this.zzbuz().zzbvw();
            object2.atF = this.zzbuz().zzbvx();
            object2.atL = zza2.zzayn();
            object2.anY = zza2.zzbst();
            object = this.zzbvb().zzly(zza2.zzti());
            object2.atx = new zzvm.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzvm.zzg();
                object2.atx[i] = object3;
                ((zzvm.zzg)((Object)object3)).name = object.get((int)i).mName;
                ((zzvm.zzg)((Object)object3)).atX = object.get((int)i).asy;
                this.zzbvc().zza((zzvm.zzg)((Object)object3), object.get((int)i).zzctv);
            }
            Bundle bundle = eventParcel.aoz.zzbvz();
            if ("_iap".equals(eventParcel.name)) {
                bundle.putLong("_c", 1L);
                this.zzbvg().zzbwi().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", eventParcel.aoA);
            if (this.zzbvc().zzni(object2.zzck)) {
                this.zzbvc().zza(bundle, "_dbg", 1L);
                this.zzbvc().zza(bundle, "_r", 1L);
            }
            if ((object3 = this.zzbvb().zzaq(string, eventParcel.name)) == null) {
                l = 0L;
                zzi2 = new zzi(string, eventParcel.name, 1L, 0L, eventParcel.aoB);
                this.zzbvb().zza(zzi2);
            } else {
                l = ((zzi)object3).aov;
                zzi2 = ((zzi)object3).zzbm(eventParcel.aoB);
                zzi2 = zzi2.zzbvy();
                this.zzbvb().zza(zzi2);
            }
            zzh zzh2 = new zzh(this, eventParcel.aoA, string, eventParcel.name, eventParcel.aoB, l, bundle);
            zzvm.zzb zzb2 = new zzvm.zzb();
            object2.atw = new zzvm.zzb[]{zzb2};
            zzb2.atp = zzh2.tr;
            zzb2.name = zzh2.mName;
            zzb2.atq = zzh2.aor;
            zzb2.ato = new zzvm.zzc[zzh2.aos.size()];
            int n = 0;
            for (String string2 : zzh2.aos) {
                zzvm.zzc zzc2 = new zzvm.zzc();
                zzb2.ato[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzh2.aos.get(string2);
                this.zzbvc().zza(zzc2, object4);
            }
            object2.atP = this.zza(zza2.zzti(), object2.atx, object2.atw);
            object2.atz = zzb2.atp;
            object2.atA = zzb2.atp;
            long l2 = zza2.zzbsv();
            object2.atC = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zza2.zzbsu();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.atB = l3 != 0L ? Long.valueOf(l3) : null;
            zza2.zzbte();
            object2.atN = (int)zza2.zzbtb();
            object2.atI = this.zzbvi().zzbsy();
            object2.aty = this.zzaan().currentTimeMillis();
            object2.atO = Boolean.TRUE;
            zza2.zzaw(object2.atz);
            zza2.zzax(object2.atA);
            this.zzbvb().zza(zza2);
            this.zzbvb().setTransactionSuccessful();
        }
        finally {
            this.zzbvb().endTransaction();
        }
        try {
            int n = zzd2.db();
            object2 = new byte[n];
            zzard2 = zzard.zzbe((byte[])object2);
            zzd2.zza(zzard2);
            zzard2.cO();
            object = this.zzbvc().zzj((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Data loss. Failed to bundle and serialize", iOException);
            return null;
        }
    }

    void zza(zzh zzh2, AppMetadata appMetadata) {
        Object object;
        this.zzyl();
        this.zzaax();
        com.google.android.gms.common.internal.zzac.zzy((Object)zzh2);
        com.google.android.gms.common.internal.zzac.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzac.zzhz((String)zzh2.zzcpe);
        com.google.android.gms.common.internal.zzac.zzbs((boolean)zzh2.zzcpe.equals(appMetadata.packageName));
        zzvm.zze zze2 = new zzvm.zze();
        zze2.atv = 1;
        zze2.atD = "android";
        zze2.zzck = appMetadata.packageName;
        zze2.anR = appMetadata.anR;
        zze2.afY = appMetadata.afY;
        zze2.atQ = (int)appMetadata.anX;
        zze2.atH = appMetadata.anS;
        zze2.anQ = appMetadata.anQ;
        zze2.atM = appMetadata.anT == 0L ? null : Long.valueOf(appMetadata.anT);
        Pair<String, Boolean> pair = this.zzbvh().zzml(appMetadata.packageName);
        if (pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.atJ = (String)pair.first;
            zze2.atK = (Boolean)pair.second;
        } else if (!this.zzbuz().zzds(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzbvg().zzbwe().log("null secure ID");
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzbvg().zzbwe().log("empty secure ID");
            }
            zze2.atT = object;
        }
        zze2.atE = this.zzbuz().zzuj();
        zze2.zzct = this.zzbuz().zzbvv();
        zze2.atG = (int)this.zzbuz().zzbvw();
        zze2.atF = this.zzbuz().zzbvx();
        zze2.atI = null;
        zze2.aty = null;
        zze2.atz = null;
        zze2.atA = null;
        object = this.zzbvb().zzlz(appMetadata.packageName);
        if (object == null) {
            object = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            ((com.google.android.gms.measurement.internal.zza)object).zzlj(this.zzbvh().zzbwm());
            ((com.google.android.gms.measurement.internal.zza)object).zzlm(appMetadata.anY);
            ((com.google.android.gms.measurement.internal.zza)object).zzlk(appMetadata.anQ);
            ((com.google.android.gms.measurement.internal.zza)object).zzll(this.zzbvh().zzmm(appMetadata.packageName));
            ((com.google.android.gms.measurement.internal.zza)object).zzbb(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzaw(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzax(0L);
            ((com.google.android.gms.measurement.internal.zza)object).setAppVersion(appMetadata.afY);
            ((com.google.android.gms.measurement.internal.zza)object).zzay(appMetadata.anX);
            ((com.google.android.gms.measurement.internal.zza)object).zzln(appMetadata.anR);
            ((com.google.android.gms.measurement.internal.zza)object).zzaz(appMetadata.anS);
            ((com.google.android.gms.measurement.internal.zza)object).zzba(appMetadata.anT);
            ((com.google.android.gms.measurement.internal.zza)object).setMeasurementEnabled(appMetadata.anV);
            this.zzbvb().zza((com.google.android.gms.measurement.internal.zza)object);
        }
        zze2.atL = ((com.google.android.gms.measurement.internal.zza)object).zzayn();
        zze2.anY = ((com.google.android.gms.measurement.internal.zza)object).zzbst();
        List<zzak> list = this.zzbvb().zzly(appMetadata.packageName);
        zze2.atx = new zzvm.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzvm.zzg zzg2;
            zze2.atx[i] = zzg2 = new zzvm.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.atX = list.get((int)i).asy;
            this.zzbvc().zza(zzg2, list.get((int)i).zzctv);
        }
        long l = 0L;
        try {
            l = this.zzbvb().zza(zze2);
        }
        catch (IOException iOException) {
            this.zzbvg().zzbwc().zzj("Data loss. Failed to insert raw event metadata", iOException);
            return;
        }
        this.zzbvb().zza(zzh2, l, this.zza(zzh2));
    }

    private boolean zza(zzh zzh2) {
        Object object2;
        if (zzh2.aos == null) {
            return false;
        }
        for (Object object2 : zzh2.aos) {
            if (!"_r".equals(object2)) continue;
            return true;
        }
        boolean bl = this.zzbvd().zzay(zzh2.zzcpe, zzh2.mName);
        object2 = this.zzbvb().zza(this.zzbxh(), zzh2.zzcpe, false, false, false, false, false);
        return bl && ((zze.zza)object2).aoj < (long)this.zzbvi().zzlq(zzh2.zzcpe);
    }

    void zzaam() {
        if (this.zzbvi().zzact()) {
            throw new IllegalStateException("Unexpected call on package side");
        }
    }

    void zzbxi() {
        if (!this.zzbvi().zzact()) {
            throw new IllegalStateException("Unexpected call on client side");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzyl();
        this.zzaax();
        if (TextUtils.isEmpty((CharSequence)appMetadata.anQ)) {
            return;
        }
        if (!appMetadata.anV) {
            this.zze(appMetadata);
            return;
        }
        int n = this.zzbvc().zznb(userAttributeParcel.name);
        if (n != 0) {
            String string = this.zzbvc().zza(userAttributeParcel.name, this.zzbvi().zzbto(), true);
            int n2 = userAttributeParcel.name != null ? userAttributeParcel.name.length() : 0;
            this.zzbvc().zza(n, "_ev", string, n2);
            return;
        }
        n = this.zzbvc().zzm(userAttributeParcel.name, userAttributeParcel.getValue());
        if (n != 0) {
            String string = this.zzbvc().zza(userAttributeParcel.name, this.zzbvi().zzbto(), true);
            Object object = userAttributeParcel.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                String string2 = String.valueOf(object);
                n3 = string2.length();
            }
            this.zzbvc().zza(n, "_ev", string, n3);
            return;
        }
        Object object = this.zzbvc().zzn(userAttributeParcel.name, userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzak zzak2 = new zzak(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.asu, object);
        this.zzbvg().zzbwi().zze("Setting user property", zzak2.mName, object);
        this.zzbvb().beginTransaction();
        try {
            this.zze(appMetadata);
            boolean bl = this.zzbvb().zza(zzak2);
            this.zzbvb().setTransactionSuccessful();
            if (bl) {
                this.zzbvg().zzbwi().zze("User property set", zzak2.mName, zzak2.zzctv);
            } else {
                this.zzbvg().zzbwc().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzctv);
                this.zzbvc().zza(9, null, null, 0);
            }
        }
        finally {
            this.zzbvb().endTransaction();
        }
    }

    @WorkerThread
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzyl();
        this.zzaax();
        if (TextUtils.isEmpty((CharSequence)appMetadata.anQ)) {
            return;
        }
        if (!appMetadata.anV) {
            this.zze(appMetadata);
            return;
        }
        this.zzbvg().zzbwi().zzj("Removing user property", userAttributeParcel.name);
        this.zzbvb().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzbvb().zzar(appMetadata.packageName, userAttributeParcel.name);
            this.zzbvb().setTransactionSuccessful();
            this.zzbvg().zzbwi().zzj("User property removed", userAttributeParcel.name);
        }
        finally {
            this.zzbvb().endTransaction();
        }
    }

    @WorkerThread
    private boolean zzbxj() {
        this.zzyl();
        return this.arm != null;
    }

    private void zzag(List<Long> list) {
        com.google.android.gms.common.internal.zzac.zzbs((!list.isEmpty() ? 1 : 0) != 0);
        if (this.arm != null) {
            this.zzbvg().zzbwc().log("Set uploading progress before finishing the previous upload");
        } else {
            this.arm = new ArrayList<Long>(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void zzbxk() {
        String string;
        this.zzyl();
        this.zzaax();
        if (!this.zzbvi().zzact()) {
            Boolean bl = this.zzbvh().zzbwq();
            if (bl == null) {
                this.zzbvg().zzbwe().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzbvg().zzbwc().log("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzbxj()) {
            this.zzbvg().zzbwe().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzbxa().zzafa()) {
            this.zzbvg().zzbwe().log("Network not connected, ignoring upload request");
            this.zzbxm();
            return;
        }
        long l = this.zzaan().currentTimeMillis();
        this.zzbo(l - this.zzbvi().zzbuk());
        long l2 = this.zzbvh().apQ.get();
        if (l2 != 0L) {
            this.zzbvg().zzbwi().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzbvb().zzbvj()))) {
            int n = this.zzbvi().zzlv(string);
            int n2 = this.zzbvi().zzlw(string);
            List<Pair<zzvm.zze, Long>> list = this.zzbvb().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzvm.zze, Long> object2 : list) {
                    zzvm.zze zze2 = (zzvm.zze)((Object)object2.first);
                    if (TextUtils.isEmpty((CharSequence)zze2.atJ)) continue;
                    string2 = zze2.atJ;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzvm.zze zze3 = (zzvm.zze)((Object)list.get((int)i).first);
                        if (TextUtils.isEmpty((CharSequence)zze3.atJ) || zze3.atJ.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                Object object3 = new zzvm.zzd();
                ((zzvm.zzd)((Object)object3)).att = new zzvm.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < ((zzvm.zzd)((Object)object3)).att.length; ++i) {
                    ((zzvm.zzd)((Object)object3)).att[i] = (zzvm.zze)((Object)list.get((int)i).first);
                    arrayList.add((Long)list.get((int)i).second);
                    ((zzvm.zzd)((Object)object3)).att[i].atI = this.zzbvi().zzbsy();
                    ((zzvm.zzd)((Object)object3)).att[i].aty = l;
                    ((zzvm.zzd)((Object)object3)).att[i].atO = this.zzbvi().zzact();
                }
                String string3 = null;
                if (this.zzbvg().zzbf(2)) {
                    string3 = zzal.zzb(object3);
                }
                byte[] byArray = this.zzbvc().zza((zzvm.zzd)((Object)object3));
                String string4 = this.zzbvi().zzbuj();
                try {
                    URL uRL = new URL(string4);
                    this.zzag(arrayList);
                    this.zzbvh().apR.set(l);
                    String string5 = "?";
                    if (((zzvm.zzd)((Object)object3)).att.length > 0) {
                        string5 = ((zzvm.zzd)((Object)object3)).att[0].zzck;
                    }
                    this.zzbvg().zzbwj().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzbxa().zza(string, uRL, byArray, null, new zzq.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzx.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzbvg().zzbwc().zzj("Failed to parse upload URL. Not uploading", string4);
                }
            }
        } else {
            com.google.android.gms.measurement.internal.zza zza2;
            String string6 = this.zzbvb().zzbl(l - this.zzbvi().zzbuk());
            if (!TextUtils.isEmpty((CharSequence)string6) && (zza2 = this.zzbvb().zzlz(string6)) != null) {
                String string7 = this.zzbvi().zzap(zza2.zzbsr(), zza2.zzayn());
                try {
                    void var11_23;
                    URL uRL = new URL(string7);
                    this.zzbvg().zzbwj().zzj("Fetching remote configuration", zza2.zzti());
                    zzvl.zzb zzb2 = this.zzbvd().zzmp(zza2.zzti());
                    Object var11_21 = null;
                    String string8 = this.zzbvd().zzmq(zza2.zzti());
                    if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string8)) {
                        ArrayMap arrayMap = new ArrayMap();
                        arrayMap.put("If-Modified-Since", string8);
                    }
                    this.zzbxa().zza(string6, uRL, (Map<String, String>)var11_23, new zzq.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzx.this.zzb(string, n, throwable, byArray, map);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzbvg().zzbwc().zzj("Failed to parse config URL. Not fetching", string7);
                }
            }
        }
    }

    boolean zzbo(long l) {
        return this.zzj(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzj(String string, long l) {
        this.zzbvb().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzbvb().zza(string, l, zza2);
            if (!zza2.isEmpty()) {
                int n;
                boolean bl = false;
                zzvm.zze zze2 = zza2.arq;
                zze2.atw = new zzvm.zzb[zza2.zzamv.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzamv.size(); ++n) {
                    boolean bl2 = bl;
                    if (this.zzbvd().zzax(zza2.arq.zzck, zza2.zzamv.get((int)n).name)) {
                        this.zzbvg().zzbwe().zzj("Dropping blacklisted raw event", zza2.zzamv.get((int)n).name);
                        this.zzbvc().zza(11, "_ev", zza2.zzamv.get((int)n).name, 0);
                        continue;
                    }
                    if (this.zzbvd().zzay(zza2.arq.zzck, zza2.zzamv.get((int)n).name)) {
                        Object object;
                        zzvm.zzc[] zzcArray;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (zza2.zzamv.get((int)n).ato == null) {
                            zza2.zzamv.get((int)n).ato = new zzvm.zzc[0];
                        }
                        for (zzvm.zzc zzc2 : zza2.zzamv.get((int)n).ato) {
                            if ("_c".equals(zzc2.name)) {
                                zzc2.ats = 1L;
                                bl3 = true;
                                continue;
                            }
                            if (!"_r".equals(zzc2.name)) continue;
                            zzc2.ats = 1L;
                            bl4 = true;
                        }
                        if (!bl3) {
                            this.zzbvg().zzbwj().zzj("Marking event as conversion", zza2.zzamv.get((int)n).name);
                            zzcArray = Arrays.copyOf(zza2.zzamv.get((int)n).ato, zza2.zzamv.get((int)n).ato.length + 1);
                            zzvm.zzc zzc3 = new zzvm.zzc();
                            zzc3.name = "_c";
                            zzc3.ats = 1L;
                            zzcArray[zzcArray.length - 1] = zzc3;
                            zza2.zzamv.get((int)n).ato = zzcArray;
                        }
                        if (!bl4) {
                            this.zzbvg().zzbwj().zzj("Marking event as real-time", zza2.zzamv.get((int)n).name);
                            zzcArray = Arrays.copyOf(zza2.zzamv.get((int)n).ato, zza2.zzamv.get((int)n).ato.length + 1);
                            zzvm.zzc zzc4 = new zzvm.zzc();
                            zzc4.name = "_r";
                            zzc4.ats = 1L;
                            zzcArray[zzcArray.length - 1] = zzc4;
                            zza2.zzamv.get((int)n).ato = zzcArray;
                        }
                        bl = true;
                        boolean bl5 = zzal.zzmx(zza2.zzamv.get((int)n).name);
                        zze.zza zza3 = this.zzbvb().zza(this.zzbxh(), zza2.arq.zzck, false, false, false, false, true);
                        if (zza3.aoj > (long)this.zzbvi().zzlq(zza2.arq.zzck)) {
                            zzvm.zzb zzb2 = zza2.zzamv.get(n);
                            for (int i = 0; i < zzb2.ato.length; ++i) {
                                if (!"_r".equals(zzb2.ato[i].name)) continue;
                                object = new zzvm.zzc[zzb2.ato.length - 1];
                                if (i > 0) {
                                    System.arraycopy(zzb2.ato, 0, object, 0, i);
                                }
                                if (i < ((zzvm.zzc[])object).length) {
                                    System.arraycopy(zzb2.ato, i + 1, object, i, ((zzvm.zzc[])object).length - i);
                                }
                                zzb2.ato = object;
                                break;
                            }
                            bl = bl2;
                        }
                        if (bl5) {
                            zza3 = this.zzbvb().zza(this.zzbxh(), zza2.arq.zzck, false, false, true, false, false);
                            if (zza3.aoh > (long)this.zzbvi().zzlp(zza2.arq.zzck)) {
                                this.zzbvg().zzbwe().log("Too many conversions. Not logging as conversion.");
                                zzvm.zzb zzb3 = zza2.zzamv.get(n);
                                boolean bl6 = false;
                                object = null;
                                for (zzvm.zzc zzc5 : zzb3.ato) {
                                    if ("_c".equals(zzc5.name)) {
                                        object = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl6 = true;
                                }
                                if (bl6 && object != null) {
                                    zzvm.zzc[] zzcArray2 = new zzvm.zzc[zzb3.ato.length - 1];
                                    int n3 = 0;
                                    for (zzvm.zzc zzc6 : zzb3.ato) {
                                        if (zzc6 == object) continue;
                                        zzcArray2[n3++] = zzc6;
                                    }
                                    zzb3.ato = zzcArray2;
                                } else if (object != null) {
                                    object.name = "_err";
                                    object.ats = 10L;
                                } else {
                                    this.zzbvg().zzbwc().log("Did not find conversion parameter. Error not tracked");
                                }
                            }
                        }
                    }
                    zze2.atw[n2++] = zza2.zzamv.get(n);
                }
                if (n2 < zza2.zzamv.size()) {
                    zze2.atw = Arrays.copyOf(zze2.atw, n2);
                }
                zze2.atP = this.zza(zza2.arq.zzck, zza2.arq.atx, zze2.atw);
                zze2.atz = zze2.atw[0].atp;
                zze2.atA = zze2.atw[0].atp;
                for (n = 1; n < zze2.atw.length; ++n) {
                    zzvm.zzb zzb4 = zze2.atw[n];
                    if (zzb4.atp < zze2.atz) {
                        zze2.atz = zzb4.atp;
                    }
                    if (zzb4.atp <= zze2.atA) continue;
                    zze2.atA = zzb4.atp;
                }
                String string2 = zza2.arq.zzck;
                com.google.android.gms.measurement.internal.zza zza4 = this.zzbvb().zzlz(string2);
                if (zza4 == null) {
                    this.zzbvg().zzbwc().log("Bundling raw events w/o app info");
                } else {
                    long l2 = zza4.zzbsv();
                    zze2.atC = l2 != 0L ? Long.valueOf(l2) : null;
                    long l3 = zza4.zzbsu();
                    if (l3 == 0L) {
                        l3 = l2;
                    }
                    zze2.atB = l3 != 0L ? Long.valueOf(l3) : null;
                    zza4.zzbte();
                    zze2.atN = (int)zza4.zzbtb();
                    zza4.zzaw(zze2.atz);
                    zza4.zzax(zze2.atA);
                    this.zzbvb().zza(zza4);
                }
                zze2.anU = this.zzbvg().zzbwk();
                this.zzbvb().zza(zze2, bl);
                this.zzbvb().zzaf(zza2.arr);
                this.zzbvb().zzmg(string2);
                this.zzbvb().setTransactionSuccessful();
                boolean bl7 = true;
                return true;
            }
            this.zzbvb().setTransactionSuccessful();
            boolean bl = false;
            return false;
        }
        finally {
            this.zzbvb().endTransaction();
        }
    }

    private zzvm.zza[] zza(String string, zzvm.zzg[] zzgArray, zzvm.zzb[] zzbArray) {
        com.google.android.gms.common.internal.zzac.zzhz((String)string);
        return this.zzbuw().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzyl();
        this.zzaax();
        com.google.android.gms.common.internal.zzac.zzhz((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzbvb().beginTransaction();
        try {
            boolean bl;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbvb().zzlz(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zza2 == null) {
                this.zzbvg().zzbwe().zzj("App does not exist in onConfigFetched", string);
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzbvd().zzmp(string) == null && !this.zzbvd().zzb(string, null, null) : !this.zzbvd().zzb(string, byArray, string2)) {
                    return;
                }
                zza2.zzbc(this.zzaan().currentTimeMillis());
                this.zzbvb().zza(zza2);
                if (n == 404) {
                    this.zzbvg().zzbwe().log("Config not found. Using empty config");
                } else {
                    this.zzbvg().zzbwj().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzbxa().zzafa() && this.zzbxl()) {
                    this.zzbxk();
                } else {
                    this.zzbxm();
                }
            } else {
                boolean bl3;
                zza2.zzbd(this.zzaan().currentTimeMillis());
                this.zzbvb().zza(zza2);
                this.zzbvg().zzbwj().zze("Fetching config failed. code, error", n, throwable);
                this.zzbvd().zzmr(string);
                this.zzbvh().apR.set(this.zzaan().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzbvh().apS.set(this.zzaan().currentTimeMillis());
                }
                this.zzbxm();
            }
            this.zzbvb().setTransactionSuccessful();
        }
        finally {
            this.zzbvb().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzyl();
        this.zzaax();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.arm;
        this.arm = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzbvh().apQ.set(this.zzaan().currentTimeMillis());
            this.zzbvh().apR.set(0L);
            this.zzbxm();
            this.zzbvg().zzbwj().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzbvb().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzbvb().zzbk(l);
                }
                this.zzbvb().setTransactionSuccessful();
            }
            finally {
                this.zzbvb().endTransaction();
            }
            if (this.zzbxa().zzafa() && this.zzbxl()) {
                this.zzbxk();
            } else {
                this.zzbxm();
            }
        } else {
            boolean bl;
            this.zzbvg().zzbwj().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzbvh().apR.set(this.zzaan().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzbvh().apS.set(this.zzaan().currentTimeMillis());
            }
            this.zzbxm();
        }
    }

    private boolean zzbxl() {
        this.zzyl();
        this.zzaax();
        boolean bl = this.zzbvb().zzbvp();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzbvb().zzbvj());
    }

    @WorkerThread
    private void zzbxm() {
        this.zzyl();
        this.zzaax();
        if (!this.zzbxq()) {
            return;
        }
        if (!this.zzbwv() || !this.zzbxl()) {
            this.zzbxb().unregister();
            this.zzbxc().cancel();
            return;
        }
        long l = this.zzbxn();
        if (l == 0L) {
            this.zzbxb().unregister();
            this.zzbxc().cancel();
            return;
        }
        if (!this.zzbxa().zzafa()) {
            this.zzbxb().zzaex();
            this.zzbxc().cancel();
            return;
        }
        long l2 = this.zzbvh().apS.get();
        long l3 = this.zzbvi().zzbul();
        if (!this.zzbvc().zzg(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzbxb().unregister();
        long l4 = l - this.zzaan().currentTimeMillis();
        if (l4 <= 0L) {
            l4 = this.zzbvi().zzbuo();
        }
        this.zzbvg().zzbwj().zzj("Upload scheduled in approximately ms", l4);
        this.zzbxc().zzx(l4);
    }

    private long zzbxn() {
        long l;
        long l2 = this.zzaan().currentTimeMillis();
        long l3 = this.zzbvi().zzbur();
        boolean bl = this.zzbvb().zzbvq() || this.zzbvb().zzbvk();
        long l4 = bl ? this.zzbvi().zzbun() : this.zzbvi().zzbum();
        long l5 = this.zzbvh().apQ.get();
        long l6 = this.zzbvh().apR.get();
        long l7 = this.zzbvb().zzbvn();
        long l8 = Math.max(l7, l = this.zzbvb().zzbvo());
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l2 - Math.abs(l8 - l2);
        l5 = l2 - Math.abs(l5 - l2);
        l6 = l2 - Math.abs(l6 - l2);
        long l9 = Math.max(l5, l6);
        long l10 = l8 + l3;
        if (bl && l9 > 0L) {
            l10 = Math.min(l8, l9) + l4;
        }
        if (!this.zzbvc().zzg(l9, l4)) {
            l10 = l9 + l4;
        }
        if (l6 != 0L && l6 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzbvi().zzbut(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzbvi().zzbus() * l12) <= l6) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzav(boolean bl) {
        this.zzbxm();
    }

    void zzb(zzaa zzaa2) {
        ++this.arn;
    }

    void zzbxo() {
        ++this.aro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zzd(AppMetadata appMetadata) {
        this.zzyl();
        this.zzaax();
        com.google.android.gms.common.internal.zzac.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzac.zzhz((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.anQ)) {
            return;
        }
        if (!appMetadata.anV) {
            this.zze(appMetadata);
            return;
        }
        long l = this.zzaan().currentTimeMillis();
        this.zzbvb().beginTransaction();
        try {
            this.zza(appMetadata, l);
            this.zze(appMetadata);
            zzi zzi2 = this.zzbvb().zzaq(appMetadata.packageName, "_f");
            if (zzi2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l, l2, "auto");
                this.zzb(userAttributeParcel, appMetadata);
                this.zzb(appMetadata, l);
                this.zzc(appMetadata, l);
            } else if (appMetadata.anW) {
                this.zzd(appMetadata, l);
            }
            this.zzbvb().setTransactionSuccessful();
        }
        finally {
            this.zzbvb().endTransaction();
        }
    }

    @WorkerThread
    void zza(AppMetadata appMetadata, long l) {
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbvb().zzlz(appMetadata.packageName);
        if (zza2 != null && zza2.zzbsr() != null && !zza2.zzbsr().equals(appMetadata.anQ)) {
            this.zzbvg().zzbwe().log("New GMP App Id passed in. Removing cached database data.");
            this.zzbvb().zzme(zza2.zzti());
            zza2 = null;
        }
        if (zza2 != null && zza2.zzyt() != null && !zza2.zzyt().equals(appMetadata.afY)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zza2.zzyt());
            EventParcel eventParcel = new EventParcel("_au", new EventParams(bundle), "auto", l);
            this.zzb(eventParcel, appMetadata);
        }
    }

    @WorkerThread
    void zzb(AppMetadata appMetadata, long l) {
        this.zzyl();
        this.zzaax();
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        bundle.putLong("_r", 1L);
        bundle.putLong("_uwa", 0L);
        bundle.putLong("_pfo", 0L);
        bundle.putLong("_sys", 0L);
        bundle.putLong("_sysu", 0L);
        PackageManager packageManager = this.getContext().getPackageManager();
        if (packageManager == null) {
            this.zzbvg().zzbwc().log("PackageManager is null, first open report might be inaccurate");
        } else {
            PackageInfo packageInfo = null;
            try {
                packageInfo = packageManager.getPackageInfo(appMetadata.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbvg().zzbwc().zzj("Package info is null, first open report might be inaccurate", (Object)nameNotFoundException);
            }
            if (packageInfo != null && packageInfo.firstInstallTime != 0L && packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                bundle.putLong("_uwa", 1L);
            }
            ApplicationInfo applicationInfo = null;
            try {
                applicationInfo = packageManager.getApplicationInfo(appMetadata.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbvg().zzbwc().zzj("Application info is null, first open report might be inaccurate", (Object)nameNotFoundException);
            }
            if (applicationInfo != null) {
                if ((applicationInfo.flags & 1) != 0) {
                    bundle.putLong("_sys", 1L);
                }
                if ((applicationInfo.flags & 0x80) != 0) {
                    bundle.putLong("_sysu", 1L);
                }
            }
        }
        long l2 = this.zzbvb().zzmf(appMetadata.packageName);
        if (l2 != 0L) {
            bundle.putLong("_pfo", l2);
        }
        EventParcel eventParcel = new EventParcel("_f", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzc(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        EventParcel eventParcel = new EventParcel("_e", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzd(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        EventParcel eventParcel = new EventParcel("_cd", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    private void zze(AppMetadata appMetadata) {
        this.zzyl();
        this.zzaax();
        com.google.android.gms.common.internal.zzac.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzac.zzhz((String)appMetadata.packageName);
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbvb().zzlz(appMetadata.packageName);
        String string = this.zzbvh().zzmm(appMetadata.packageName);
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            zza2.zzlj(this.zzbvh().zzbwm());
            zza2.zzll(string);
            bl = true;
        } else if (!string.equals(zza2.zzbss())) {
            zza2.zzll(string);
            zza2.zzlj(this.zzbvh().zzbwm());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.anQ) && !appMetadata.anQ.equals(zza2.zzbsr())) {
            zza2.zzlk(appMetadata.anQ);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.anY) && !appMetadata.anY.equals(zza2.zzbst())) {
            zza2.zzlm(appMetadata.anY);
            bl = true;
        }
        if (appMetadata.anS != 0L && appMetadata.anS != zza2.zzbsy()) {
            zza2.zzaz(appMetadata.anS);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.afY) && !appMetadata.afY.equals(zza2.zzyt())) {
            zza2.setAppVersion(appMetadata.afY);
            bl = true;
        }
        if (appMetadata.anX != zza2.zzbsw()) {
            zza2.zzay(appMetadata.anX);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.anR) && !appMetadata.anR.equals(zza2.zzbsx())) {
            zza2.zzln(appMetadata.anR);
            bl = true;
        }
        if (appMetadata.anT != zza2.zzbsz()) {
            zza2.zzba(appMetadata.anT);
            bl = true;
        }
        if (appMetadata.anV != zza2.zzbta()) {
            zza2.setMeasurementEnabled(appMetadata.anV);
            bl = true;
        }
        if (bl) {
            this.zzbvb().zza(zza2);
        }
    }

    @WorkerThread
    void zzbxp() {
        this.zzyl();
        this.zzaax();
        if (!this.ari) {
            this.zzbvg().zzbwh().log("This instance being marked as an uploader");
            this.zzbxe();
        }
        this.ari = true;
    }

    @WorkerThread
    boolean zzbxq() {
        this.zzyl();
        this.zzaax();
        return this.ari || this.zzbxg();
    }

    private class zza
    implements zze.zzb {
        zzvm.zze arq;
        List<Long> arr;
        List<zzvm.zzb> zzamv;
        long ars;

        private zza() {
        }

        @Override
        public void zzb(zzvm.zze zze2) {
            com.google.android.gms.common.internal.zzac.zzy((Object)((Object)zze2));
            this.arq = zze2;
        }

        @Override
        public boolean zza(long l, zzvm.zzb zzb2) {
            com.google.android.gms.common.internal.zzac.zzy((Object)((Object)zzb2));
            if (this.zzamv == null) {
                this.zzamv = new ArrayList<zzvm.zzb>();
            }
            if (this.arr == null) {
                this.arr = new ArrayList<Long>();
            }
            if (this.zzamv.size() > 0 && this.zza(this.zzamv.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.ars + (long)zzb2.db();
            if (l2 >= (long)zzx.this.zzbvi().zzbuh()) {
                return false;
            }
            this.ars = l2;
            this.zzamv.add(zzb2);
            this.arr.add(l);
            return this.zzamv.size() < zzx.this.zzbvi().zzbui();
        }

        private long zza(zzvm.zzb zzb2) {
            return zzb2.atp / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzamv == null || this.zzamv.isEmpty();
        }
    }
}

