/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzx;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

public class zzw
extends zzaa {
    private zzd aqz;
    private zzd aqA;
    private final PriorityBlockingQueue<FutureTask<?>> aqB;
    private final BlockingQueue<FutureTask<?>> aqC;
    private final Thread.UncaughtExceptionHandler aqD;
    private final Thread.UncaughtExceptionHandler aqE;
    private final Object aqF = new Object();
    private final Semaphore aqG = new Semaphore(2);
    private volatile boolean aqH;
    private static final AtomicLong aqI = new AtomicLong(Long.MIN_VALUE);

    zzw(zzx zzx2) {
        super(zzx2);
        this.aqB = new PriorityBlockingQueue();
        this.aqC = new LinkedBlockingQueue();
        this.aqD = new zzb("Thread death: Uncaught exception on worker thread");
        this.aqE = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzym() {
    }

    @Override
    public void zzyl() {
        if (Thread.currentThread() != this.aqz) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzbuv() {
        if (Thread.currentThread() != this.aqA) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzaax();
        zzac.zzy(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.aqz) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzaax();
        zzac.zzy(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.aqz) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zzaax();
        zzac.zzy((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.aqF;
        synchronized (object) {
            this.aqB.add(zzc2);
            if (this.aqz == null) {
                this.aqz = new zzd("Measurement Worker", this.aqB);
                this.aqz.setUncaughtExceptionHandler(this.aqD);
                this.aqz.start();
            } else {
                this.aqz.zzoi();
            }
        }
    }

    public void zzn(Runnable runnable) throws IllegalStateException {
        this.zzaax();
        zzac.zzy((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.aqF;
        synchronized (object) {
            this.aqC.add(futureTask);
            if (this.aqA == null) {
                this.aqA = new zzd("Measurement Network", this.aqC);
                this.aqA.setUncaughtExceptionHandler(this.aqE);
                this.aqA.start();
            } else {
                this.aqA.zzoi();
            }
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String aqJ;

        public zzb(String string) {
            zzac.zzy((Object)string);
            this.aqJ = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzw.this.zzbvg().zzbwc().zzj(this.aqJ, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long aqL;
        private final boolean aqM;
        private final String aqJ;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            zzac.zzy((Object)string);
            this.aqL = aqI.getAndIncrement();
            this.aqJ = string;
            this.aqM = bl;
            if (this.aqL == Long.MAX_VALUE) {
                zzw.this.zzbvg().zzbwc().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            zzac.zzy((Object)string);
            this.aqL = aqI.getAndIncrement();
            this.aqJ = string;
            this.aqM = bl;
            if (this.aqL == Long.MAX_VALUE) {
                zzw.this.zzbvg().zzbwc().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzw.this.zzbvg().zzbwc().zzj(this.aqJ, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(@NonNull zzc zzc2) {
            if (this.aqM != zzc2.aqM) {
                return this.aqM ? -1 : 1;
            }
            if (this.aqL < zzc2.aqL) {
                return -1;
            }
            if (this.aqL > zzc2.aqL) {
                return 1;
            }
            zzw.this.zzbvg().zzbwd().zzj("Two tasks share the same index. index", this.aqL);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(@NonNull Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object aqN;
        private final BlockingQueue<FutureTask<?>> aqO;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzac.zzy((Object)string);
            zzac.zzy(blockingQueue);
            this.aqN = new Object();
            this.aqO = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzw.this.aqG.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.aqO.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.aqN;
                    synchronized (object) {
                        if (this.aqO.peek() == null && !zzw.this.aqH) {
                            try {
                                this.aqN.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzw.this.aqF;
                    synchronized (object) {
                        if (this.aqO.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzw.this.aqF;
                synchronized (object) {
                    zzw.this.aqG.release();
                    zzw.this.aqF.notifyAll();
                    if (this == zzw.this.aqz) {
                        zzw.this.aqz = null;
                    } else if (this == zzw.this.aqA) {
                        zzw.this.aqA = null;
                    } else {
                        zzw.this.zzbvg().zzbwc().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzoi() {
            Object object = this.aqN;
            synchronized (object) {
                this.aqN.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzw.this.zzbvg().zzbwe().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

