/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public class zzac
extends zzaa {
    protected zza auO;
    private AppMeasurement.zzb auP;
    private final Set<AppMeasurement.zzc> auQ = new CopyOnWriteArraySet<AppMeasurement.zzc>();
    private boolean auR;

    protected zzac(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzzy() {
    }

    @TargetApi(value=14)
    public void zzbyp() {
        if (this.getContext().getApplicationContext() instanceof Application) {
            Application application = (Application)this.getContext().getApplicationContext();
            if (this.auO == null) {
                this.auO = new zza();
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.auO);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.auO);
            this.zzbwb().zzbxe().log("Registered activity lifecycle callback");
        }
    }

    public void setMeasurementEnabled(final boolean bl) {
        this.zzacj();
        this.zzaby();
        this.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzci(bl);
            }
        });
    }

    @WorkerThread
    private void zzci(boolean bl) {
        this.zzzx();
        this.zzaby();
        this.zzacj();
        this.zzbwb().zzbxd().zzj("Setting app measurement enabled (FE)", bl);
        this.zzbwc().setMeasurementEnabled(bl);
        this.zzbvt().zzbyv();
    }

    public void setMinimumSessionDuration(final long l) {
        this.zzaby();
        this.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzbwc().ati.set(l);
                zzac.this.zzbwb().zzbxd().zzj("Minimum session duration set", l);
            }
        });
    }

    public void setSessionTimeoutDuration(final long l) {
        this.zzaby();
        this.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzbwc().atj.set(l);
                zzac.this.zzbwb().zzbxd().zzj("Session timeout duration set", l);
            }
        });
    }

    public void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.zzaby();
        boolean bl2 = this.auP == null || zzal.zzne(string2);
        this.zza(string, string2, bundle, true, bl2, bl, null);
    }

    public void zzf(String string, String string2, Bundle bundle) {
        this.zzaby();
        boolean bl = this.auP == null || zzal.zzne(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public void zzd(String string, String string2, Bundle bundle, long l) {
        this.zzaby();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, this.zzabz().currentTimeMillis(), bundle, bl, bl2, bl3, string3);
    }

    Bundle zzam(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzbvx().zzl(string, bundle.get(string));
                if (object == null) {
                    this.zzbwb().zzbxa().zzj("Param value can't be null", string);
                    continue;
                }
                this.zzbvx().zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    protected void zza(final String string, final String string2, final long l, Bundle bundle, final boolean bl, final boolean bl2, final boolean bl3, final String string3) {
        final Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
        this.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzb(string, string2, l, bundle2, bl, bl2, bl3, string3);
            }
        });
    }

    @WorkerThread
    private void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        com.google.android.gms.common.internal.zzaa.zzy((Object)bundle);
        this.zzzx();
        this.zzacj();
        if (!this.aqw.isEnabled()) {
            this.zzbwb().zzbxd().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.auR) {
            this.auR = true;
            this.zzbyr();
        }
        boolean bl4 = zzal.zzne(string2);
        if (bl && this.auP != null && !bl4) {
            this.zzbwb().zzbxd().zze("Passing event to registered event handler (FE)", string2, bundle);
            this.auP.zzb(string, string2, bundle, l);
        } else {
            Object object;
            Object object2;
            if (!this.aqw.zzbxq()) {
                return;
            }
            int n = this.zzbvx().zzmw(string2);
            if (n != 0) {
                String string4 = this.zzbvx().zza(string2, this.zzbwd().zzbud(), true);
                int n2 = string2 != null ? string2.length() : 0;
                this.aqw.zzbvx().zza(n, "_ev", string4, n2);
                return;
            }
            bundle.putString("_o", string);
            List list = zzf.zzz((Object)"_o");
            Bundle bundle2 = this.zzbvx().zza(string2, bundle, list, bl3);
            if (!bundle.containsKey("_sc")) {
                object2 = null;
                this.zzbwd().zzayi();
                object = this.zzbvu().zzbyt();
                if (object != null) {
                    object.avr = true;
                }
                object2 = object;
                zzad.zza((AppMeasurement.zzf)object2, bundle2);
            }
            object2 = bl2 ? this.zzam(bundle2) : bundle2;
            this.zzbwb().zzbxd().zze("Logging event (FE)", string2, object2);
            object = new EventParcel(string2, new EventParams((Bundle)object2), string, l);
            this.zzbvt().zzc((EventParcel)((Object)object), string3);
            for (AppMeasurement.zzc zzc2 : this.auQ) {
                Bundle bundle3 = new Bundle(object2);
                zzc2.zzc(string, string2, bundle3, l);
            }
        }
    }

    public void zzd(String string, String string2, Object object) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        long l = this.zzabz().currentTimeMillis();
        int n = this.zzbvx().zzmy(string2);
        if (n != 0) {
            String string3 = this.zzbvx().zza(string2, this.zzbwd().zzbue(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.aqw.zzbvx().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = this.zzbvx().zzm(string2, object);
            if (n != 0) {
                String string4 = this.zzbvx().zza(string2, this.zzbwd().zzbue(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    String string5 = String.valueOf(object);
                    n3 = string5.length();
                }
                this.aqw.zzbvx().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = this.zzbvx().zzn(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
        } else {
            this.zza(string, string2, l, null);
        }
    }

    void zza(final String string, final String string2, final long l, final Object object) {
        this.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zza(string, string2, object, l);
            }
        });
    }

    @WorkerThread
    private void zza(String string, String string2, Object object, long l) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        this.zzzx();
        this.zzaby();
        this.zzacj();
        if (!this.aqw.isEnabled()) {
            this.zzbwb().zzbxd().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.aqw.zzbxq()) {
            return;
        }
        this.zzbwb().zzbxd().zze("Setting user property (FE)", string2, object);
        UserAttributeParcel userAttributeParcel = new UserAttributeParcel(string2, l, object, string);
        this.zzbvt().zzb(userAttributeParcel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserAttributeParcel> zzcj(final boolean bl) {
        this.zzaby();
        this.zzacj();
        this.zzbwb().zzbxd().log("Fetching user attributes (FE)");
        final AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (object) {
            this.aqw.zzbwa().zzm(new Runnable(){

                @Override
                public void run() {
                    zzac.this.zzbvt().zza(atomicReference, bl);
                }
            });
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzbwb().zzbxa().zzj("Interrupted waiting for get user properties", interruptedException);
            }
        }
        object = (List)atomicReference.get();
        if (object == null) {
            this.zzbwb().zzbxa().log("Timed out waiting for get user properties");
            return Collections.emptyList();
        }
        return object;
    }

    @WorkerThread
    public void zzbyq() {
        this.zzzx();
        this.zzaby();
        this.zzacj();
        if (!this.aqw.zzbxq()) {
            return;
        }
        this.zzbvt().zzbyq();
        String string = this.zzbwc().zzbxn();
        if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzbvs().zzbws())) {
            Bundle bundle = new Bundle();
            bundle.putString("_po", string);
            this.zzf("auto", "_ou", bundle);
        }
    }

    @WorkerThread
    public void zza(AppMeasurement.zzb zzb2) {
        this.zzzx();
        this.zzaby();
        this.zzacj();
        if (zzb2 != null && zzb2 != this.auP) {
            com.google.android.gms.common.internal.zzaa.zza((this.auP == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.auP = zzb2;
    }

    public void zza(AppMeasurement.zzc zzc2) {
        this.zzaby();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzc2);
        if (!this.auQ.add(zzc2)) {
            this.zzbwb().zzbxa().log("OnEventListener already registered");
        }
    }

    @WorkerThread
    private void zzbyr() {
        try {
            Class<?> clazz = Class.forName(this.zzbys());
            this.zzg(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzbwb().zzbxc().log("Tag Manager is not found and thus will not be used");
        }
    }

    private String zzbys() {
        return "com.google.android.gms.tagmanager.TagManagerService";
    }

    @WorkerThread
    public void zzg(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("initialize", Context.class);
            method.invoke(null, this.getContext());
        }
        catch (Exception exception) {
            this.zzbwb().zzbxa().zzj("Failed to invoke Tag Manager's initialize() method", exception);
        }
    }

    @MainThread
    @TargetApi(value=14)
    private class zza
    implements Application.ActivityLifecycleCallbacks {
        private zza() {
        }

        private boolean zzms(String string) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzac.this.zzd("auto", "_ldl", string);
                return true;
            }
            return false;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            try {
                Uri uri;
                zzac.this.zzbwb().zzbxe().log("onActivityCreated");
                Intent intent = activity.getIntent();
                if (intent != null && (uri = intent.getData()) != null && uri.isHierarchical()) {
                    boolean bl;
                    String string;
                    if (bundle == null && (string = zzac.this.zzbvx().zzu(uri)) != null) {
                        zzac.this.zzf("auto", "_cmp", (Bundle)string);
                    }
                    if (TextUtils.isEmpty((CharSequence)(string = uri.getQueryParameter("referrer")))) {
                        return;
                    }
                    boolean bl2 = bl = string.contains("gclid") && (string.contains("utm_campaign") || string.contains("utm_source") || string.contains("utm_medium") || string.contains("utm_term") || string.contains("utm_content"));
                    if (!bl) {
                        zzac.this.zzbwb().zzbxd().log("Activity created with data 'referrer' param without gclid and at least one utm field");
                        return;
                    }
                    zzac.this.zzbwb().zzbxd().zzj("Activity created with referrer", string);
                    this.zzms(string);
                }
            }
            catch (Throwable throwable) {
                zzac.this.zzbwb().zzbwy().zzj("Throwable caught in onActivityCreated", throwable);
            }
            zzac.this.zzbvu().onActivityCreated(activity, bundle);
        }

        public void onActivityDestroyed(Activity activity) {
            zzac.this.zzbvu().onActivityDestroyed(activity);
        }

        @MainThread
        public void onActivityPaused(Activity activity) {
            zzac.this.zzbvu().onActivityPaused(activity);
            zzac.this.zzbvz().zzbzd();
        }

        @MainThread
        public void onActivityResumed(Activity activity) {
            zzac.this.zzbvu().onActivityResumed(activity);
            zzac.this.zzbvz().zzbzb();
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzac.this.zzbvu().onActivitySaveInstanceState(activity, bundle);
        }
    }
}

