/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzart;
import com.google.android.gms.internal.zzwa;
import com.google.android.gms.internal.zzwc;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.x500.X500Principal;

public class zzal
extends zzz {
    zzal(zzx zzx2) {
        super(zzx2);
    }

    static boolean zzmu(String string) {
        zzaa.zzib((String)string);
        return string.charAt(0) != '_';
    }

    public Bundle zzu(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.zzbwb().zzbxa().zzj("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    boolean zzaz(String string, String string2) {
        if (string2 == null) {
            this.zzbwb().zzbwy().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzbwb().zzbwy().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        char c = string2.charAt(0);
        if (!Character.isLetter(c)) {
            this.zzbwb().zzbwy().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        for (int i = 1; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (c2 == '_' || Character.isLetterOrDigit(c2)) continue;
            this.zzbwb().zzbwy().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzba(String string, String string2) {
        if (string2 == null) {
            this.zzbwb().zzbwy().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzbwb().zzbwy().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            this.zzbwb().zzbwy().zze("Name must start with a letter or _ (underscores). Type, name", string, string2);
            return false;
        }
        for (int i = 1; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (c2 == '_' || Character.isLetterOrDigit(c2)) continue;
            this.zzbwb().zzbwy().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzc(String string, Map<String, String> map, String string2) {
        if (string2 == null) {
            this.zzbwb().zzbwy().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.startsWith("firebase_")) {
            this.zzbwb().zzbwy().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (map != null && map.containsKey(string2)) {
            this.zzbwb().zzbwy().zze("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzc(String string, int n, String string2) {
        if (string2 == null) {
            this.zzbwb().zzbwy().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() > n) {
            this.zzbwb().zzbwy().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    public int zzmv(String string) {
        if (!this.zzaz("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.aqx, string)) {
            return 13;
        }
        if (!this.zzc("event", this.zzbwd().zzbud(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzmw(String string) {
        if (!this.zzba("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.aqx, string)) {
            return 13;
        }
        if (!this.zzc("event", this.zzbwd().zzbud(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzmx(String string) {
        if (!this.zzaz("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zzg.aqC, string)) {
            return 15;
        }
        if (!this.zzc("user property", this.zzbwd().zzbue(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzmy(String string) {
        if (!this.zzba("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zzg.aqC, string)) {
            return 15;
        }
        if (!this.zzc("user property", this.zzbwd().zzbue(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzmz(String string) {
        if (!this.zzaz("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzc("event param", this.zzbwd().zzbuf(), string)) {
            return 3;
        }
        return 0;
    }

    public int zzna(String string) {
        if (!this.zzba("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzc("event param", this.zzbwd().zzbuf(), string)) {
            return 3;
        }
        return 0;
    }

    boolean zza(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.length() > n) {
                this.zzbwb().zzbxa().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean zznb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzbwb().zzbwy().log("Measurement Service called without google_app_id");
            return false;
        }
        if (!string.matches("^\\d+:.*")) {
            this.zzbwb().zzbxa().zzj("Measurement Service called with invalid id version", string);
            return false;
        }
        if (!string.startsWith("1:")) {
            this.zzbwb().zzbxa().zzj("Measurement Service called with unknown id version", string);
            return true;
        }
        if (!this.zznc(string)) {
            this.zzbwb().zzbwy().zzj("Invalid google_app_id. Firebase Analytics disabled. See", "https://goo.gl/FZRIUV");
            return false;
        }
        return true;
    }

    boolean zznc(String string) {
        zzaa.zzy((Object)string);
        String string2 = "^1:\\d+:android:[a-f0-9]+$";
        return string.matches(string2);
    }

    private Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string = String.valueOf(object);
            return this.zza(string, n, bl);
        }
        return null;
    }

    public String zza(String string, int n, boolean bl) {
        if (string.length() > n) {
            if (bl) {
                return String.valueOf(string.substring(0, n)).concat("...");
            }
            return null;
        }
        return string;
    }

    public boolean zzk(String string, Object object) {
        return zzal.zzne(string) ? this.zza("param", string, this.zzbwd().zzbuh(), object) : this.zza("param", string, this.zzbwd().zzbug(), object);
    }

    public Object zzl(String string, Object object) {
        if ("_ev".equals(string)) {
            Object object2 = this.zza(this.zzbwd().zzbuh(), object, true);
            return object2;
        }
        Object object3 = this.zza(zzal.zzne(string) ? this.zzbwd().zzbuh() : this.zzbwd().zzbug(), object, false);
        return object3;
    }

    public Bundle zza(String string, Bundle bundle, @Nullable List<String> list, boolean bl) {
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            int n2 = this.zzbwd().zzbuc();
            for (String string2 : bundle.keySet()) {
                String string3;
                int n3 = 0;
                if (list == null || !list.contains(string2)) {
                    if (bl) {
                        n3 = this.zzmz(string2);
                    }
                    if (n3 == 0) {
                        n3 = this.zzna(string2);
                    }
                }
                if (n3 != 0) {
                    if (this.zzd(bundle2, n3)) {
                        string3 = this.zza(string2, this.zzbwd().zzbuf(), true);
                        bundle2.putString("_ev", string3);
                        if (n3 == 3) {
                            this.zzb(bundle2, string2);
                        }
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!this.zzk(string2, bundle.get(string2)) && !"_ev".equals(string2)) {
                    if (this.zzd(bundle2, 4)) {
                        string3 = this.zza(string2, this.zzbwd().zzbuf(), true);
                        bundle2.putString("_ev", string3);
                        this.zzb(bundle2, bundle.get(string2));
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!zzal.zzmu(string2) || ++n <= 25) continue;
                string3 = new StringBuilder(48).append("Event can't contain more then ").append(25).append(" params").toString();
                this.zzbwb().zzbwy().zze(string3, string, bundle);
                this.zzd(bundle2, 5);
                bundle2.remove(string2);
            }
        }
        return bundle2;
    }

    public boolean zzd(Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        long l = bundle.getLong("_err");
        if (l == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    public void zzb(Bundle bundle, Object object) {
        zzaa.zzy((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private int zznd(String string) {
        if ("_ldl".equals(string)) {
            return this.zzbwd().zzbuj();
        }
        return this.zzbwd().zzbui();
    }

    public int zzm(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, this.zznd(string), object) : this.zza("user property", string, this.zznd(string), object);
        return bl ? 0 : 7;
    }

    public Object zzn(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zza(this.zznd(string), object, true);
        }
        return this.zza(this.zznd(string), object, false);
    }

    public void zza(zzwc.zzg zzg2, Object object) {
        zzaa.zzy((Object)object);
        zzg2.Fe = null;
        zzg2.awR = null;
        zzg2.avW = null;
        if (object instanceof String) {
            zzg2.Fe = (String)object;
        } else if (object instanceof Long) {
            zzg2.awR = (Long)object;
        } else if (object instanceof Double) {
            zzg2.avW = (Double)object;
        } else {
            this.zzbwb().zzbwy().zzj("Ignoring invalid (type) user attribute value", object);
        }
    }

    public void zza(zzwc.zzc zzc2, Object object) {
        zzaa.zzy((Object)object);
        zzc2.Fe = null;
        zzc2.awR = null;
        zzc2.avW = null;
        if (object instanceof String) {
            zzc2.Fe = (String)object;
        } else if (object instanceof Long) {
            zzc2.awR = (Long)object;
        } else if (object instanceof Double) {
            zzc2.avW = (Double)object;
        } else {
            this.zzbwb().zzbwy().zzj("Ignoring invalid (type) event param value", object);
        }
    }

    public void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            this.zzbwb().zzbxb().zze("Not putting event parameter. Invalid value type. name, type", string, string3);
        }
    }

    public void zza(int n, String string, String string2, int n2) {
        Bundle bundle = new Bundle();
        this.zzd(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString(string, string2);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        this.aqw.zzbvq().zzf("auto", "_err", bundle);
    }

    public byte[] zzk(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zzx(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest zzfl(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    static long zzy(byte[] byArray) {
        zzaa.zzy((Object)byArray);
        zzaa.zzbs((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    @WorkerThread
    public long zzz(byte[] byArray) {
        zzaa.zzy((Object)byArray);
        this.zzzx();
        MessageDigest messageDigest = zzal.zzfl("MD5");
        if (messageDigest == null) {
            this.zzbwb().zzbwy().log("Failed to get MD5");
            return 0L;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return zzal.zzy(byArray2);
    }

    public byte[] zza(zzwc.zzd zzd2) {
        try {
            int n = zzd2.cz();
            byte[] byArray = new byte[n];
            zzart zzart2 = zzart.zzbe((byte[])byArray);
            zzd2.zza(zzart2);
            zzart2.cm();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public boolean zzf(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzabz().currentTimeMillis() - l) > l2;
    }

    public static boolean zza(Context context, String string, boolean bl) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, string), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean zzr(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @WorkerThread
    public boolean zzez(String string) {
        this.zzzx();
        int n = this.getContext().checkCallingOrSelfPermission(string);
        if (n == 0) {
            return true;
        }
        this.zzbwb().zzbxd().zzj("Permission not granted", string);
        return false;
    }

    public static boolean zzne(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    public static boolean zzbb(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && 64 * i + j < bitSet.length(); ++j) {
                if (!bitSet.get(64 * i + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length * 64) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzal.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    private static void zza(StringBuilder stringBuilder, int n, zzwc.zze zze2) {
        if (zze2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("bundle {\n");
        zzal.zza(stringBuilder, n, "protocol_version", zze2.awU);
        zzal.zza(stringBuilder, n, "platform", zze2.axc);
        zzal.zza(stringBuilder, n, "gmp_version", zze2.axg);
        zzal.zza(stringBuilder, n, "uploading_gmp_version", zze2.axh);
        zzal.zza(stringBuilder, n, "config_version", zze2.axt);
        zzal.zza(stringBuilder, n, "gmp_app_id", zze2.aqZ);
        zzal.zza(stringBuilder, n, "app_id", zze2.zzcs);
        zzal.zza(stringBuilder, n, "app_version", zze2.aii);
        zzal.zza(stringBuilder, n, "app_version_major", zze2.axp);
        zzal.zza(stringBuilder, n, "firebase_instance_id", zze2.arh);
        zzal.zza(stringBuilder, n, "dev_cert_hash", zze2.axl);
        zzal.zza(stringBuilder, n, "app_store", zze2.ara);
        zzal.zza(stringBuilder, n, "upload_timestamp_millis", zze2.awX);
        zzal.zza(stringBuilder, n, "start_timestamp_millis", zze2.awY);
        zzal.zza(stringBuilder, n, "end_timestamp_millis", zze2.awZ);
        zzal.zza(stringBuilder, n, "previous_bundle_start_timestamp_millis", zze2.axa);
        zzal.zza(stringBuilder, n, "previous_bundle_end_timestamp_millis", zze2.axb);
        zzal.zza(stringBuilder, n, "app_instance_id", zze2.axk);
        zzal.zza(stringBuilder, n, "resettable_device_id", zze2.axi);
        zzal.zza(stringBuilder, n, "device_id", zze2.axs);
        zzal.zza(stringBuilder, n, "limited_ad_tracking", zze2.axj);
        zzal.zza(stringBuilder, n, "os_version", zze2.zzdb);
        zzal.zza(stringBuilder, n, "device_model", zze2.axd);
        zzal.zza(stringBuilder, n, "user_default_language", zze2.axe);
        zzal.zza(stringBuilder, n, "time_zone_offset_minutes", zze2.axf);
        zzal.zza(stringBuilder, n, "bundle_sequential_index", zze2.axm);
        zzal.zza(stringBuilder, n, "service_upload", zze2.axn);
        zzal.zza(stringBuilder, n, "health_monitor", zze2.ard);
        zzal.zza(stringBuilder, n, zze2.awW);
        zzal.zza(stringBuilder, n, zze2.axo);
        zzal.zza(stringBuilder, n, zze2.awV);
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzwc.zzg[] zzgArray) {
        if (zzgArray == null) {
            return;
        }
        ++n;
        for (zzwc.zzg zzg2 : zzgArray) {
            if (zzg2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("user_property {\n");
            zzal.zza(stringBuilder, n, "set_timestamp_millis", zzg2.axx);
            zzal.zza(stringBuilder, n, "name", zzg2.name);
            zzal.zza(stringBuilder, n, "string_value", zzg2.Fe);
            zzal.zza(stringBuilder, n, "int_value", zzg2.awR);
            zzal.zza(stringBuilder, n, "double_value", zzg2.avW);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzwc.zzc[] zzcArray) {
        if (zzcArray == null) {
            return;
        }
        ++n;
        for (zzwc.zzc zzc2 : zzcArray) {
            if (zzc2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzal.zza(stringBuilder, n, "name", zzc2.name);
            zzal.zza(stringBuilder, n, "string_value", zzc2.Fe);
            zzal.zza(stringBuilder, n, "int_value", zzc2.awR);
            zzal.zza(stringBuilder, n, "double_value", zzc2.avW);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzwc.zzb[] zzbArray) {
        if (zzbArray == null) {
            return;
        }
        ++n;
        for (zzwc.zzb zzb2 : zzbArray) {
            if (zzb2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("event {\n");
            zzal.zza(stringBuilder, n, "name", zzb2.name);
            zzal.zza(stringBuilder, n, "timestamp_millis", zzb2.awO);
            zzal.zza(stringBuilder, n, "previous_timestamp_millis", zzb2.awP);
            zzal.zza(stringBuilder, n, "count", zzb2.count);
            zzal.zza(stringBuilder, n, zzb2.awN);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzwc.zza[] zzaArray) {
        if (zzaArray == null) {
            return;
        }
        ++n;
        for (zzwc.zza zza2 : zzaArray) {
            if (zza2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("audience_membership {\n");
            zzal.zza(stringBuilder, n, "audience_id", zza2.avZ);
            zzal.zza(stringBuilder, n, "new_audience", zza2.awL);
            zzal.zza(stringBuilder, n, "current_data", zza2.awJ);
            zzal.zza(stringBuilder, n, "previous_data", zza2.awK);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzwc.zzf zzf2) {
        Long l;
        int n2;
        int n3;
        long[] lArray;
        int n4;
        if (zzf2 == null) {
            return;
        }
        zzal.zza(stringBuilder, ++n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.axv != null) {
            zzal.zza(stringBuilder, n + 1);
            stringBuilder.append("results: ");
            n4 = 0;
            lArray = zzf2.axv;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzf2.axu != null) {
            zzal.zza(stringBuilder, n + 1);
            stringBuilder.append("status: ");
            n4 = 0;
            lArray = zzf2.axu;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzwa.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.awn != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzd2.awn) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzal.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzal.zza(stringBuilder, n, "match_as_float", zzd2.awo);
        zzal.zza(stringBuilder, n, "comparison_value", zzd2.awp);
        zzal.zza(stringBuilder, n, "min_comparison_value", zzd2.awq);
        zzal.zza(stringBuilder, n, "max_comparison_value", zzd2.awr);
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzwa.zzf zzf2) {
        if (zzf2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.awv != null) {
            String[] stringArray = "UNKNOWN_MATCH_TYPE";
            switch (zzf2.awv) {
                case 1: {
                    stringArray = "REGEXP";
                    break;
                }
                case 2: {
                    stringArray = "BEGINS_WITH";
                    break;
                }
                case 3: {
                    stringArray = "ENDS_WITH";
                    break;
                }
                case 4: {
                    stringArray = "PARTIAL";
                    break;
                }
                case 5: {
                    stringArray = "EXACT";
                    break;
                }
                case 6: {
                    stringArray = "IN_LIST";
                }
            }
            zzal.zza(stringBuilder, n, "match_type", stringArray);
        }
        zzal.zza(stringBuilder, n, "expression", zzf2.aww);
        zzal.zza(stringBuilder, n, "case_sensitive", zzf2.awx);
        if (zzf2.awy.length > 0) {
            zzal.zza(stringBuilder, n + 1);
            stringBuilder.append("expression_list {\n");
            for (String string2 : zzf2.awy) {
                zzal.zza(stringBuilder, n + 2);
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            stringBuilder.append("}\n");
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzwa.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzal.zza(stringBuilder, n, "complement", zzc2.awl);
        zzal.zza(stringBuilder, n, "param_name", zzc2.awm);
        zzal.zza(stringBuilder, n + 1, "string_filter", zzc2.awj);
        zzal.zza(stringBuilder, n + 1, "number_filter", zzc2.awk);
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    public static String zzb(zzwc.zzd zzd2) {
        if (zzd2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzd2.awS != null) {
            for (zzwc.zze zze2 : zzd2.awS) {
                if (zze2 == null) continue;
                zzal.zza(stringBuilder, 1, zze2);
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzwa.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzal.zza(stringBuilder, 0, "filter_id", zzb2.awd);
        zzal.zza(stringBuilder, 0, "event_name", zzb2.awe);
        zzal.zza(stringBuilder, 1, "event_count_filter", zzb2.awh);
        stringBuilder.append("  filters {\n");
        for (zzwa.zzc zzc2 : zzb2.awf) {
            zzal.zza(stringBuilder, 2, zzc2);
        }
        zzal.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzwa.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzal.zza(stringBuilder, 0, "filter_id", zze2.awd);
        zzal.zza(stringBuilder, 0, "property_name", zze2.awt);
        zzal.zza(stringBuilder, 1, zze2.awu);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public boolean zznf(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = this.zzbwd().zzbvn();
        this.zzbwd().zzayi();
        return string2.equals(string);
    }

    static boolean zzng(String string) {
        return string != null && string.matches("(\\+|-)?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    boolean zznh(String string) {
        return "1".equals(this.zzbvy().zzaw(string, "measurement.upload.blacklist_internal"));
    }

    boolean zzni(String string) {
        return "1".equals(this.zzbvy().zzaw(string, "measurement.upload.blacklist_public"));
    }

    @WorkerThread
    long zzad(Context context, String string) {
        this.zzzx();
        zzaa.zzy((Object)context);
        zzaa.zzib((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzal.zzfl("MD5");
        if (messageDigest == null) {
            this.zzbwb().zzbwy().log("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzae(context, string)) {
                    PackageInfo packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        byte[] byArray = messageDigest.digest(packageInfo.signatures[0].toByteArray());
                        l = zzal.zzy(byArray);
                    } else {
                        this.zzbwb().zzbxa().log("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbwb().zzbwy().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    boolean zzae(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            this.zzbwb().zzbwy().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbwb().zzbwy().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    @WorkerThread
    static boolean zzc(EventParcel eventParcel, AppMetadata appMetadata) {
        zzaa.zzy((Object)((Object)eventParcel));
        zzaa.zzy((Object)((Object)appMetadata));
        return !TextUtils.isEmpty((CharSequence)appMetadata.aqZ) || "_in".equals(eventParcel.name);
    }
}

