/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class zzd
extends zzz {
    static final String ari = String.valueOf(zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE / 1000).replaceAll("(\\d+)(\\d)(\\d\\d)", "$1.$2.$3");
    private Boolean eb;

    zzd(zzx zzx2) {
        super(zzx2);
    }

    String zzbub() {
        return zzl.arP.get();
    }

    public int zzbuc() {
        return 25;
    }

    public int zzbud() {
        return 32;
    }

    public int zzbue() {
        return 24;
    }

    int zzbuf() {
        return 24;
    }

    int zzbug() {
        return 36;
    }

    int zzbuh() {
        return 256;
    }

    public int zzbui() {
        return 36;
    }

    public int zzbuj() {
        return 2048;
    }

    int zzbuk() {
        return 500;
    }

    public long zzbul() {
        return zzl.arZ.get().intValue();
    }

    public long zzbum() {
        return zzl.asb.get().intValue();
    }

    public int zzlo(@Size(min=1L) String string) {
        int n = this.zzb(string, zzl.asa);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzlp(@Size(min=1L) String string) {
        return this.zzb(string, zzl.asc);
    }

    public int zzlq(@Size(min=1L) String string) {
        return this.zzb(string, zzl.asd);
    }

    int zzbun() {
        return 25;
    }

    int zzbuo() {
        return 50;
    }

    long zzbup() {
        return 3600000L;
    }

    long zzbuq() {
        return 60000L;
    }

    long zzbur() {
        return 61000L;
    }

    long zzlr(String string) {
        return this.zza(string, zzl.arQ);
    }

    int zzls(String string) {
        return this.zzb(string, zzl.ass);
    }

    int zzlt(String string) {
        int n = this.zzb(string, zzl.ast);
        n = Math.min(2000, n);
        n = Math.max(0, n);
        return n;
    }

    long zzaez() {
        return zzl.asu.get();
    }

    public String zzafe() {
        return "google_app_measurement.db";
    }

    String zzbus() {
        return "google_app_measurement_local.db";
    }

    public long zzbto() {
        return 9877L;
    }

    public boolean zzayi() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzaef() {
        if (this.eb == null) {
            zzd zzd2 = this;
            synchronized (zzd2) {
                if (this.eb == null) {
                    ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
                    String string = zzt.zzayz();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.eb = string2 != null && string2.equals(string);
                    }
                    if (this.eb == null) {
                        this.eb = Boolean.TRUE;
                        this.zzbwb().zzbwy().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.eb;
    }

    public long zza(String string, zzl.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzbvy().zzaw(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    public int zzb(String string, zzl.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzbvy().zzaw(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @Nullable
    Boolean zzlu(@Size(min=1L) String string) {
        zzaa.zzib((String)string);
        try {
            PackageManager packageManager = this.getContext().getPackageManager();
            if (packageManager == null) {
                this.zzbwb().zzbwy().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(this.getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                this.zzbwb().zzbwy().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                this.zzbwb().zzbwy().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbwb().zzbwy().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public boolean zzbut() {
        Boolean bl = this.zzlu("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public Boolean zzbuu() {
        return this.zzlu("firebase_analytics_collection_enabled");
    }

    public boolean zzatu() {
        return zzrk.zzatu();
    }

    public long zzbuv() {
        return zzl.asr.get();
    }

    public long zzbuw() {
        return zzl.asm.get();
    }

    public long zzbux() {
        return zzl.asn.get();
    }

    public long zzbuy() {
        return 1000L;
    }

    public long zzafj() {
        return Math.max(0L, zzl.arR.get());
    }

    public int zzlv(String string) {
        return this.zzb(string, zzl.arV);
    }

    public int zzlw(String string) {
        return Math.max(0, this.zzb(string, zzl.arW));
    }

    public int zzlx(String string) {
        int n = this.zzb(string, zzl.ase);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzbuz() {
        return Math.max(0, zzl.arX.get());
    }

    public int zzbva() {
        return Math.max(1, zzl.arY.get());
    }

    public int zzbvb() {
        return 100000;
    }

    public String zzbvc() {
        return zzl.asf.get();
    }

    public String zzao(String string, String string2) {
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string);
        builder.scheme(zzl.arT.get()).encodedAuthority(zzl.arU.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string2).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(9877L));
        return builder.build().toString();
    }

    public long zzbvd() {
        return zzl.arS.get();
    }

    public long zzbve() {
        return Math.max(0L, zzl.asg.get());
    }

    public long zzbvf() {
        return Math.max(0L, zzl.asi.get());
    }

    public long zzbvg() {
        return Math.max(0L, zzl.asj.get());
    }

    public long zzbvh() {
        return Math.max(0L, zzl.ask.get());
    }

    public long zzbvi() {
        return Math.max(0L, zzl.asl.get());
    }

    public long zzbvj() {
        return zzl.ash.get();
    }

    public long zzbvk() {
        return Math.max(0L, zzl.aso.get());
    }

    public long zzbvl() {
        return Math.max(0L, zzl.asp.get());
    }

    public int zzbvm() {
        return Math.min(20, Math.max(0, zzl.asq.get()));
    }

    public String zzbvn() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            return (String)method.invoke(null, "firebase.analytics.debug-mode", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzbwb().zzbwy().zzj("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzbwb().zzbwy().zzj("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzbwb().zzbwy().zzj("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzbwb().zzbwy().zzj("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }
}

