/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.os.Parcel;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;

public class zzo
extends zzaa {
    private final zza asx = new zza(this.getContext(), this.zzade());
    private boolean asy;

    zzo(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzzy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    @WorkerThread
    private boolean zza(int n, byte[] byArray) {
        this.zzaby();
        this.zzzx();
        if (this.asy) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = this.zzbwd().zzbvb();
        for (int i = 0; i < 5; ++i) {
            try (SQLiteDatabase sQLiteDatabase = null;){
                long l;
                sQLiteDatabase = this.getWritableDatabase();
                if (sQLiteDatabase == null) {
                    this.asy = true;
                    boolean bl = false;
                    return false;
                }
                sQLiteDatabase.beginTransaction();
                long l2 = 0L;
                Cursor cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                if (cursor != null && cursor.moveToFirst()) {
                    l2 = cursor.getLong(0);
                }
                if (l2 >= 100000L) {
                    this.zzbwb().zzbwy().log("Data loss, local db full");
                    l = 100000L - l2 + 1L;
                    long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l)});
                    if (l3 != l) {
                        this.zzbwb().zzbwy().zzd("Different delete count than expected in local db. expected, received, difference", l, l3, l - l3);
                    }
                }
                l = sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                boolean bl = true;
                return true;
            }
        }
        this.zzbwb().zzbxa().log("Failed to write entry to local database");
        return false;
    }

    public boolean zza(EventParcel eventParcel) {
        Parcel parcel = Parcel.obtain();
        eventParcel.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            this.zzbwb().zzbxa().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public boolean zza(UserAttributeParcel userAttributeParcel) {
        Parcel parcel = Parcel.obtain();
        userAttributeParcel.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            this.zzbwb().zzbxa().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public List<AbstractSafeParcelable> zzxe(int n) {
        this.zzzx();
        this.zzaby();
        if (this.asy) {
            return null;
        }
        ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
        if (!this.zzbwn()) {
            return arrayList;
        }
        int n2 = 5;
        for (int i = 0; i < 5; ++i) {
            try (SQLiteDatabase sQLiteDatabase = null;){
                Object object;
                int n3;
                Cursor cursor;
                sQLiteDatabase = this.getWritableDatabase();
                if (sQLiteDatabase == null) {
                    this.asy = true;
                    cursor = null;
                    return null;
                }
                sQLiteDatabase.beginTransaction();
                cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(n));
                long l = -1L;
                while (cursor.moveToNext()) {
                    AbstractSafeParcelable abstractSafeParcelable;
                    Parcel parcel;
                    l = cursor.getLong(0);
                    n3 = cursor.getInt(1);
                    object = cursor.getBlob(2);
                    if (n3 == 0) {
                        parcel = Parcel.obtain();
                        abstractSafeParcelable = null;
                        try {
                            parcel.unmarshall(object, 0, ((byte[])object).length);
                            parcel.setDataPosition(0);
                            abstractSafeParcelable = (EventParcel)((Object)EventParcel.CREATOR.createFromParcel(parcel));
                        }
                        catch (zza.zza zza2) {
                            this.zzbwb().zzbwy().log("Failed to load event from local database");
                            continue;
                        }
                        finally {
                            parcel.recycle();
                            continue;
                        }
                        if (abstractSafeParcelable == null) continue;
                        arrayList.add(abstractSafeParcelable);
                        continue;
                    }
                    if (n3 == 1) {
                        parcel = Parcel.obtain();
                        abstractSafeParcelable = null;
                        try {
                            parcel.unmarshall(object, 0, ((byte[])object).length);
                            parcel.setDataPosition(0);
                            abstractSafeParcelable = (UserAttributeParcel)((Object)UserAttributeParcel.CREATOR.createFromParcel(parcel));
                        }
                        catch (zza.zza zza3) {
                            this.zzbwb().zzbwy().log("Failed to load user property from local database");
                        }
                        finally {
                            parcel.recycle();
                        }
                        if (abstractSafeParcelable == null) continue;
                        arrayList.add(abstractSafeParcelable);
                        continue;
                    }
                    this.zzbwb().zzbwy().log("Unknown record type in local database");
                }
                cursor.close();
                n3 = sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)});
                if (n3 < arrayList.size()) {
                    this.zzbwb().zzbwy().log("Fewer entries removed from local database than expected");
                }
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                object = arrayList;
                return object;
            }
        }
        this.zzbwb().zzbxa().log("Failed to read events from database in reasonable time");
        return null;
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        if (this.asy) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.asx.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.asy = true;
            return null;
        }
        return sQLiteDatabase;
    }

    boolean zzbwn() {
        return this.getContext().getDatabasePath(this.zzade()).exists();
    }

    String zzade() {
        return this.zzbwd().zzbus();
    }

    @TargetApi(value=11)
    private class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                    throw sQLiteException;
                }
                zzo.this.zzbwb().zzbwy().log("Opening the local database failed, dropping and recreating it");
                String string = zzo.this.zzade();
                if (!zzo.this.getContext().getDatabasePath(string).delete()) {
                    zzo.this.zzbwb().zzbwy().zzj("Failed to delete corrupted local db file", string);
                }
                try {
                    return super.getWritableDatabase();
                }
                catch (SQLiteException sQLiteException2) {
                    zzo.this.zzbwb().zzbwy().zzj("Failed to open local database. Events will bypass local storage", (Object)sQLiteException2);
                    return null;
                }
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            zze.zza(zzo.this.zzbwb(), sQLiteDatabase, "messages", "create table if not exists messages ( type INTEGER NOT NULL, entry BLOB NOT NULL)", "type,entry", null);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zze.zza(zzo.this.zzbwb(), sQLiteDatabase);
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }
}

