/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzt
extends zzaa {
    static final Pair<String, Long> asX = new Pair((Object)"", (Object)0L);
    private SharedPreferences fF;
    public final zzc asY = new zzc("health_monitor", this.zzbwd().zzafj());
    public final zzb asZ = new zzb("last_upload", 0L);
    public final zzb ata = new zzb("last_upload_attempt", 0L);
    public final zzb atb = new zzb("backoff", 0L);
    public final zzb atc = new zzb("last_delete_stale", 0L);
    public final zzb atd;
    private String ate;
    private boolean atf;
    private long atg;
    private SecureRandom ath;
    public final zzb ati = new zzb("time_before_start", 10000L);
    public final zzb atj = new zzb("session_timeout", 1800000L);
    public final zza atk = new zza("start_new_session", true);
    public final zzb atl = new zzb("last_pause_time", 0L);
    public final zzb atm = new zzb("time_active", 0L);
    public boolean atn;

    @WorkerThread
    private SecureRandom zzbxg() {
        this.zzzx();
        if (this.ath == null) {
            this.ath = new SecureRandom();
        }
        return this.ath;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzmk(String string) {
        this.zzzx();
        long l = this.zzabz().elapsedRealtime();
        if (this.ate != null && l < this.atg) {
            return new Pair((Object)this.ate, (Object)this.atf);
        }
        this.atg = l + this.zzbwd().zzlr(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.ate = info.getId();
            if (this.ate == null) {
                this.ate = "";
            }
            this.atf = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzbwb().zzbxd().zzj("Unable to get advertising id", throwable);
            this.ate = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.ate, (Object)this.atf);
    }

    @WorkerThread
    String zzml(String string) {
        this.zzzx();
        String string2 = (String)this.zzmk((String)string).first;
        MessageDigest messageDigest = zzal.zzfl("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzbxh() {
        byte[] byArray = new byte[16];
        this.zzbxg().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzbtj() {
        this.zzzx();
        try {
            return com.google.firebase.iid.zzc.C().getId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzbwb().zzbxa().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    @WorkerThread
    long zzbxi() {
        this.zzacj();
        this.zzzx();
        long l = this.atd.get();
        if (l == 0L) {
            l = 1 + this.zzbxg().nextInt(86400000);
            this.atd.set(l);
        }
        return l;
    }

    zzt(zzx zzx2) {
        super(zzx2);
        this.atd = new zzb("midnight_offset", 0L);
    }

    @Override
    protected void zzzy() {
        this.fF = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.atn = this.fF.getBoolean("has_been_opened", false);
        if (!this.atn) {
            SharedPreferences.Editor editor = this.fF.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzbxj() {
        this.zzzx();
        this.zzacj();
        return this.fF;
    }

    @WorkerThread
    void zzmm(String string) {
        this.zzzx();
        SharedPreferences.Editor editor = this.zzbxj().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzbxk() {
        this.zzzx();
        return this.zzbxj().getString("gmp_app_id", null);
    }

    @WorkerThread
    Boolean zzbxl() {
        this.zzzx();
        if (!this.zzbxj().contains("use_service")) {
            return null;
        }
        return this.zzbxj().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzcg(boolean bl) {
        this.zzzx();
        this.zzbwb().zzbxe().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzbxj().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzbxm() {
        this.zzzx();
        this.zzbwb().zzbxe().log("Clearing collection preferences.");
        boolean bl = this.zzbxj().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzch(true);
        }
        SharedPreferences.Editor editor = this.zzbxj().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzzx();
        this.zzbwb().zzbxe().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzbxj().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzch(boolean bl) {
        this.zzzx();
        return this.zzbxj().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzbxn() {
        this.zzzx();
        String string = this.zzbxj().getString("previous_os_version", null);
        String string2 = this.zzbvs().zzbws();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzbxj().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzbcn;
        private final boolean ato;
        private boolean atp;
        private boolean xv;

        public zza(String string, boolean bl) {
            com.google.android.gms.common.internal.zzaa.zzib((String)string);
            this.zzbcn = string;
            this.ato = bl;
        }

        @WorkerThread
        private void zzbxo() {
            if (this.atp) {
                return;
            }
            this.atp = true;
            this.xv = zzt.this.fF.getBoolean(this.zzbcn, this.ato);
        }

        @WorkerThread
        public boolean get() {
            this.zzbxo();
            return this.xv;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzt.this.fF.edit();
            editor.putBoolean(this.zzbcn, bl);
            editor.apply();
            this.xv = bl;
        }
    }

    public final class zzb {
        private final String zzbcn;
        private final long atr;
        private boolean atp;
        private long cf;

        public zzb(String string, long l) {
            com.google.android.gms.common.internal.zzaa.zzib((String)string);
            this.zzbcn = string;
            this.atr = l;
        }

        @WorkerThread
        private void zzbxo() {
            if (this.atp) {
                return;
            }
            this.atp = true;
            this.cf = zzt.this.fF.getLong(this.zzbcn, this.atr);
        }

        @WorkerThread
        public long get() {
            this.zzbxo();
            return this.cf;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzt.this.fF.edit();
            editor.putLong(this.zzbcn, l);
            editor.apply();
            this.cf = l;
        }
    }

    public final class zzc {
        final String ats;
        private final String att;
        private final String atu;
        private final long fJ;

        private zzc(String string, long l) {
            com.google.android.gms.common.internal.zzaa.zzib((String)string);
            com.google.android.gms.common.internal.zzaa.zzbt((l > 0L ? 1 : 0) != 0);
            this.ats = String.valueOf(string).concat(":start");
            this.att = String.valueOf(string).concat(":count");
            this.atu = String.valueOf(string).concat(":value");
            this.fJ = l;
        }

        @WorkerThread
        private void zzagu() {
            zzt.this.zzzx();
            long l = zzt.this.zzabz().currentTimeMillis();
            SharedPreferences.Editor editor = zzt.this.fF.edit();
            editor.remove(this.att);
            editor.remove(this.atu);
            editor.putLong(this.ats, l);
            editor.apply();
        }

        @WorkerThread
        private long zzagv() {
            zzt.this.zzzx();
            long l = this.zzagx();
            if (l == 0L) {
                this.zzagu();
                return 0L;
            }
            return Math.abs(l - zzt.this.zzabz().currentTimeMillis());
        }

        @WorkerThread
        public void zzfg(String string) {
            this.zzg(string, 1L);
        }

        @WorkerThread
        public void zzg(String string, long l) {
            long l2;
            zzt.this.zzzx();
            long l3 = this.zzagx();
            if (l3 == 0L) {
                this.zzagu();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzt.this.fF.getLong(this.att, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzt.this.fF.edit();
                editor.putString(this.atu, string);
                editor.putLong(this.att, l);
                editor.apply();
                return;
            }
            long l4 = zzt.this.zzbxg().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzt.this.fF.edit();
            if (bl) {
                editor.putString(this.atu, string);
            }
            editor.putLong(this.att, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzagw() {
            zzt.this.zzzx();
            long l = this.zzagv();
            if (l < this.fJ) {
                return null;
            }
            if (l > this.fJ * 2L) {
                this.zzagu();
                return null;
            }
            String string = zzt.this.zzbxj().getString(this.atu, null);
            long l2 = zzt.this.zzbxj().getLong(this.att, 0L);
            this.zzagu();
            if (string == null || l2 <= 0L) {
                return asX;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzagx() {
            return zzt.this.zzbxj().getLong(this.ats, 0L);
        }
    }
}

