/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzf;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzy
extends zzm.zza {
    private final zzx aqw;
    private Boolean auE;
    @Nullable
    private String auF;

    public zzy(zzx zzx2) {
        this(zzx2, null);
    }

    public zzy(zzx zzx2, @Nullable String string) {
        zzaa.zzy((Object)zzx2);
        this.aqw = zzx2;
        this.auF = string;
    }

    @WorkerThread
    void zzmr(String string) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)string) && (stringArray = string.split(":", 2)).length == 2) {
            long l;
            try {
                l = Long.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                this.aqw.zzbwb().zzbxa().zzj("Combining sample with a non-number weight", stringArray[0]);
                return;
            }
            if (l > 0L) {
                this.aqw.zzbwc().asY.zzg(stringArray[1], l);
            } else {
                this.aqw.zzbwb().zzbxa().zzj("Combining sample with a non-positive weight", l);
            }
        }
    }

    @Override
    @BinderThread
    public void zzb(final AppMetadata appMetadata) {
        this.zzb(appMetadata, false);
        this.aqw.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.aqw.zzbyj();
                zzy.this.zzmr(appMetadata.ard);
                zzy.this.aqw.zzc(appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        zzaa.zzy((Object)((Object)eventParcel));
        this.zzb(appMetadata, false);
        this.aqw.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.aqw.zzbyj();
                zzy.this.zzmr(appMetadata.ard);
                zzy.this.aqw.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final String string, final String string2) {
        zzaa.zzy((Object)((Object)eventParcel));
        zzaa.zzib((String)string);
        this.zzn(string, true);
        this.aqw.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.aqw.zzbyj();
                zzy.this.zzmr(string2);
                zzy.this.aqw.zzb(eventParcel, string);
            }
        });
    }

    @Override
    @BinderThread
    public byte[] zza(final EventParcel eventParcel, final String string) {
        zzaa.zzib((String)string);
        zzaa.zzy((Object)((Object)eventParcel));
        this.zzn(string, true);
        this.aqw.zzbwb().zzbxd().zzj("Log and bundle. event", eventParcel.name);
        long l = this.aqw.zzabz().nanoTime() / 1000000L;
        Future<byte[]> future = this.aqw.zzbwa().zze(new Callable<byte[]>(){

            public byte[] zzbyl() throws Exception {
                zzy.this.aqw.zzbyj();
                return zzy.this.aqw.zza(eventParcel, string);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbyl();
            }
        });
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.aqw.zzbwb().zzbwy().log("Log and bundle returned null");
                byArray = new byte[]{};
            }
            long l2 = this.aqw.zzabz().nanoTime() / 1000000L;
            this.aqw.zzbwb().zzbxd().zzd("Log and bundle processed. event, size, time_ms", eventParcel.name, byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.aqw.zzbwb().zzbwy().zze("Failed to log and bundle. event, error", eventParcel.name, exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        zzaa.zzy((Object)((Object)userAttributeParcel));
        this.zzb(appMetadata, false);
        if (userAttributeParcel.getValue() == null) {
            this.aqw.zzbwa().zzm(new Runnable(){

                @Override
                public void run() {
                    zzy.this.aqw.zzbyj();
                    zzy.this.zzmr(appMetadata.ard);
                    zzy.this.aqw.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.aqw.zzbwa().zzm(new Runnable(){

                @Override
                public void run() {
                    zzy.this.aqw.zzbyj();
                    zzy.this.zzmr(appMetadata.ard);
                    zzy.this.aqw.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    @BinderThread
    public List<UserAttributeParcel> zza(final AppMetadata appMetadata, boolean bl) {
        this.zzb(appMetadata, false);
        Future<List<zzak>> future = this.aqw.zzbwa().zzd(new Callable<List<zzak>>(){

            public List<zzak> zzbym() throws Exception {
                zzy.this.aqw.zzbyj();
                return zzy.this.aqw.zzbvw().zzly(appMetadata.packageName);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbym();
            }
        });
        try {
            List<zzak> list = future.get();
            ArrayList<UserAttributeParcel> arrayList = new ArrayList<UserAttributeParcel>(list.size());
            for (zzak zzak2 : list) {
                if (!bl && zzal.zzne(zzak2.mName)) continue;
                arrayList.add(new UserAttributeParcel(zzak2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.aqw.zzbwb().zzbwy().zzj("Failed to get user attributes", exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final AppMetadata appMetadata) {
        this.zzb(appMetadata, false);
        this.aqw.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.aqw.zzbyj();
                zzy.this.zzmr(appMetadata.ard);
                zzy.this.aqw.zzd(appMetadata);
            }
        });
    }

    @BinderThread
    private void zzb(AppMetadata appMetadata, boolean bl) {
        zzaa.zzy((Object)((Object)appMetadata));
        this.zzn(appMetadata.packageName, bl);
        this.aqw.zzbvx().zznb(appMetadata.aqZ);
    }

    @BinderThread
    private void zzn(String string, boolean bl) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.aqw.zzbwb().zzbwy().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzo(string, bl);
        }
        catch (SecurityException securityException) {
            this.aqw.zzbwb().zzbwy().zzj("Measurement Service called with invalid calling package", string);
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public void zza(final long l, final String string, final String string2, final String string3) {
        this.aqw.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                if (string2 == null) {
                    zzy.this.aqw.zzbvu().zza(string3, null);
                    return;
                }
                AppMeasurement.zzf zzf2 = new AppMeasurement.zzf();
                zzf2.aqz = string;
                zzf2.aqA = string2;
                zzf2.aqB = l;
                zzy.this.aqw.zzbvu().zza(string3, zzf2);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    protected void zzo(String var1_1, boolean var2_2) throws SecurityException {
        block5: {
            block6: {
                if (!var2_2) break block5;
                if (this.auE != null) break block6;
                if (!"com.google.android.gms".equals(this.auF) && !com.google.android.gms.common.util.zzx.zzf((Context)this.aqw.getContext(), (int)Binder.getCallingUid()) && !zzf.zzbv((Context)this.aqw.getContext()).zza(this.aqw.getContext().getPackageManager(), Binder.getCallingUid())) ** GOTO lbl-1000
                if (!false) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                this.auE = v0;
            }
            if (this.auE.booleanValue()) {
                return;
            }
        }
        if (this.auF == null && zze.zzc((Context)this.aqw.getContext(), (int)Binder.getCallingUid(), (String)var1_1)) {
            this.auF = var1_1;
        }
        if (var1_1.equals(this.auF)) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", new Object[]{var1_1}));
    }
}

