/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzacb;
import com.google.android.gms.internal.measurement.zzacd;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzki;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzkk;
import com.google.android.gms.internal.measurement.zzkl;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzkr;
import com.google.android.gms.internal.measurement.zzks;
import com.google.android.gms.internal.measurement.zzkt;
import com.google.android.gms.internal.measurement.zzku;
import com.google.android.gms.internal.measurement.zzkv;
import com.google.android.gms.internal.measurement.zzkx;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzjz
extends zzjs {
    zzjz(zzjt zzjt2) {
        super(zzjt2);
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    final void zza(zzkx zzkx2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzkx2.zzale = null;
        zzkx2.zzave = null;
        zzkx2.zzasw = null;
        if (object instanceof String) {
            zzkx2.zzale = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzkx2.zzave = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzkx2.zzasw = (Double)object;
            return;
        }
        this.zzgi().zziv().zzg("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(zzks zzks2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzks2.zzale = null;
        zzks2.zzave = null;
        zzks2.zzasw = null;
        if (object instanceof String) {
            zzks2.zzale = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzks2.zzave = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzks2.zzasw = (Double)object;
            return;
        }
        this.zzgi().zziv().zzg("Ignoring invalid (type) event param value", object);
    }

    final byte[] zza(zzkt zzkt2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzkt2.zzwb()];
            zzacb zzacb2 = zzacb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkt2.zza(zzacb2);
            zzacb2.zzvt();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zzg("Data loss. Failed to serialize batch", (Object)iOException);
            return null;
        }
    }

    static zzks zza(zzkr zzkr2, String string) {
        zzks[] zzksArray = zzkr2.zzava;
        int n = zzkr2.zzava.length;
        for (int i = 0; i < n; ++i) {
            zzks zzks2 = zzksArray[i];
            if (!zzks2.name.equals(string)) continue;
            return zzks2;
        }
        return null;
    }

    static Object zzb(zzkr zzkr2, String string) {
        zzks zzks2 = zzjz.zza(zzkr2, string);
        if (zzks2 != null) {
            if (zzks2.zzale != null) {
                return zzks2.zzale;
            }
            if (zzks2.zzave != null) {
                return zzks2.zzave;
            }
            if (zzks2.zzasw != null) {
                return zzks2.zzasw;
            }
        }
        return null;
    }

    static zzks[] zza(zzks[] zzksArray, String string, Object object) {
        zzks[] zzksArray2 = zzksArray;
        int n = zzksArray.length;
        for (int i = 0; i < n; ++i) {
            zzks zzks2 = zzksArray2[i];
            if (!string.equals(zzks2.name)) continue;
            zzks2.zzave = null;
            zzks2.zzale = null;
            zzks2.zzasw = null;
            if (object instanceof Long) {
                zzks2.zzave = (Long)object;
            } else if (object instanceof String) {
                zzks2.zzale = (String)object;
            } else if (object instanceof Double) {
                zzks2.zzasw = (Double)object;
            }
            return zzksArray;
        }
        zzksArray2 = new zzks[zzksArray.length + 1];
        System.arraycopy(zzksArray, 0, zzksArray2, 0, zzksArray.length);
        zzks zzks3 = new zzks();
        new zzks().name = string;
        if (object instanceof Long) {
            zzks3.zzave = (Long)object;
        } else if (object instanceof String) {
            zzks3.zzale = (String)object;
        } else if (object instanceof Double) {
            zzks3.zzasw = (Double)object;
        }
        zzksArray2[zzksArray.length] = zzks3;
        return zzksArray2;
    }

    final String zzb(zzkt zzkt2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzkt2.zzavf != null) {
            zzku[] zzkuArray = zzkt2.zzavf;
            int n = zzkt2.zzavf.length;
            for (int i = 0; i < n; ++i) {
                zzkx zzkx2;
                int n2;
                int n3;
                zzkx[] zzkxArray;
                zzku zzku2 = zzkuArray[i];
                if (zzku2 == null) continue;
                zzku zzku3 = zzku2;
                StringBuilder stringBuilder2 = stringBuilder;
                zzjz zzjz2 = this;
                if (zzku3 == null) continue;
                zzjz.zza(stringBuilder2, 1);
                stringBuilder2.append("bundle {\n");
                zzjz.zza(stringBuilder2, 1, "protocol_version", zzku3.zzavh);
                zzjz.zza(stringBuilder2, 1, "platform", zzku3.zzavp);
                zzjz.zza(stringBuilder2, 1, "gmp_version", zzku3.zzavt);
                zzjz.zza(stringBuilder2, 1, "uploading_gmp_version", zzku3.zzavu);
                zzjz.zza(stringBuilder2, 1, "config_version", zzku3.zzawf);
                zzjz.zza(stringBuilder2, 1, "gmp_app_id", zzku3.zzafa);
                zzjz.zza(stringBuilder2, 1, "app_id", zzku3.zzth);
                zzjz.zza(stringBuilder2, 1, "app_version", zzku3.zztg);
                zzjz.zza(stringBuilder2, 1, "app_version_major", zzku3.zzawb);
                zzjz.zza(stringBuilder2, 1, "firebase_instance_id", zzku3.zzafc);
                zzjz.zza(stringBuilder2, 1, "dev_cert_hash", zzku3.zzavx);
                zzjz.zza(stringBuilder2, 1, "app_store", zzku3.zzafh);
                zzjz.zza(stringBuilder2, 1, "upload_timestamp_millis", zzku3.zzavk);
                zzjz.zza(stringBuilder2, 1, "start_timestamp_millis", zzku3.zzavl);
                zzjz.zza(stringBuilder2, 1, "end_timestamp_millis", zzku3.zzavm);
                zzjz.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzku3.zzavn);
                zzjz.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzku3.zzavo);
                zzjz.zza(stringBuilder2, 1, "app_instance_id", zzku3.zzaez);
                zzjz.zza(stringBuilder2, 1, "resettable_device_id", zzku3.zzavv);
                zzjz.zza(stringBuilder2, 1, "device_id", zzku3.zzawe);
                zzjz.zza(stringBuilder2, 1, "ds_id", zzku3.zzawh);
                zzjz.zza(stringBuilder2, 1, "limited_ad_tracking", zzku3.zzavw);
                zzjz.zza(stringBuilder2, 1, "os_version", zzku3.zzavq);
                zzjz.zza(stringBuilder2, 1, "device_model", zzku3.zzavr);
                zzjz.zza(stringBuilder2, 1, "user_default_language", zzku3.zzahd);
                zzjz.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzku3.zzavs);
                zzjz.zza(stringBuilder2, 1, "bundle_sequential_index", zzku3.zzavy);
                zzjz.zza(stringBuilder2, 1, "service_upload", zzku3.zzavz);
                zzjz.zza(stringBuilder2, 1, "health_monitor", zzku3.zzafy);
                if (zzku3.zzawg != null && zzku3.zzawg != 0L) {
                    zzjz.zza(stringBuilder2, 1, "android_id", zzku3.zzawg);
                }
                if (zzku3.zzawj != null) {
                    zzjz.zza(stringBuilder2, 1, "retry_counter", zzku3.zzawj);
                }
                zzacd[] zzacdArray = zzku3.zzavj;
                StringBuilder stringBuilder3 = stringBuilder2;
                zzjz zzjz3 = zzjz2;
                if (zzacdArray != null) {
                    zzkxArray = zzacdArray;
                    n3 = zzacdArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzkx2 = zzkxArray[n2];
                        if (zzkx2 == null) continue;
                        zzjz.zza(stringBuilder3, 2);
                        stringBuilder3.append("user_property {\n");
                        zzjz.zza(stringBuilder3, 2, "set_timestamp_millis", zzkx2.zzaws);
                        zzjz.zza(stringBuilder3, 2, "name", zzjz3.zzgf().zzbo(zzkx2.name));
                        zzjz.zza(stringBuilder3, 2, "string_value", zzkx2.zzale);
                        zzjz.zza(stringBuilder3, 2, "int_value", zzkx2.zzave);
                        zzjz.zza(stringBuilder3, 2, "double_value", zzkx2.zzasw);
                        zzjz.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzacdArray = zzku3.zzawa;
                stringBuilder3 = stringBuilder2;
                if (zzacdArray != null) {
                    zzkxArray = zzacdArray;
                    n3 = zzacdArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzkx2 = zzkxArray[n2];
                        if (zzkx2 == null) continue;
                        zzjz.zza(stringBuilder3, 2);
                        stringBuilder3.append("audience_membership {\n");
                        zzjz.zza(stringBuilder3, 2, "audience_id", ((zzkp)((Object)zzkx2)).zzate);
                        zzjz.zza(stringBuilder3, 2, "new_audience", ((zzkp)((Object)zzkx2)).zzauv);
                        zzjz.zza(stringBuilder3, 2, "current_data", ((zzkp)((Object)zzkx2)).zzaut);
                        zzjz.zza(stringBuilder3, 2, "previous_data", ((zzkp)((Object)zzkx2)).zzauu);
                        zzjz.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzacdArray = zzku3.zzavi;
                stringBuilder3 = stringBuilder2;
                zzjz3 = zzjz2;
                if (zzacdArray != null) {
                    zzkxArray = zzacdArray;
                    n3 = zzacdArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzkx2 = zzkxArray[n2];
                        if (zzkx2 == null) continue;
                        zzjz.zza(stringBuilder3, 2);
                        stringBuilder3.append("event {\n");
                        zzjz.zza(stringBuilder3, 2, "name", zzjz3.zzgf().zzbm(((zzkr)((Object)zzkx2)).name));
                        zzjz.zza(stringBuilder3, 2, "timestamp_millis", ((zzkr)((Object)zzkx2)).zzavb);
                        zzjz.zza(stringBuilder3, 2, "previous_timestamp_millis", ((zzkr)((Object)zzkx2)).zzavc);
                        zzjz.zza(stringBuilder3, 2, "count", ((zzkr)((Object)zzkx2)).count);
                        zzks[] zzksArray = ((zzkr)((Object)zzkx2)).zzava;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        zzjz zzjz4 = zzjz3;
                        if (zzksArray != null) {
                            zzks[] zzksArray2 = zzksArray;
                            int n4 = zzksArray.length;
                            for (int j = 0; j < n4; ++j) {
                                zzks zzks2 = zzksArray2[j];
                                if (zzks2 == null) continue;
                                zzjz.zza(stringBuilder4, 3);
                                stringBuilder4.append("param {\n");
                                zzjz.zza(stringBuilder4, 3, "name", zzjz4.zzgf().zzbn(zzks2.name));
                                zzjz.zza(stringBuilder4, 3, "string_value", zzks2.zzale);
                                zzjz.zza(stringBuilder4, 3, "int_value", zzks2.zzave);
                                zzjz.zza(stringBuilder4, 3, "double_value", zzks2.zzasw);
                                zzjz.zza(stringBuilder4, 3);
                                stringBuilder4.append("}\n");
                            }
                        }
                        zzjz.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzjz.zza(stringBuilder2, 1);
                stringBuilder2.append("}\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzkh zzkh2) {
        if (zzkh2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzjz.zza(stringBuilder, 0, "filter_id", zzkh2.zzatk);
        zzjz.zza(stringBuilder, 0, "event_name", this.zzgf().zzbm(zzkh2.zzatl));
        this.zza(stringBuilder, 1, "event_count_filter", zzkh2.zzato);
        stringBuilder.append("  filters {\n");
        zzki[] zzkiArray = zzkh2.zzatm;
        int n = zzkh2.zzatm.length;
        for (int i = 0; i < n; ++i) {
            zzki zzki2 = zzkiArray[i];
            this.zza(stringBuilder, 2, zzki2);
        }
        zzjz.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zza(zzkk zzkk2) {
        if (zzkk2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzjz.zza(stringBuilder, 0, "filter_id", zzkk2.zzatk);
        zzjz.zza(stringBuilder, 0, "property_name", this.zzgf().zzbo(zzkk2.zzauc));
        this.zza(stringBuilder, 1, zzkk2.zzaud);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzkv zzkv2) {
        Long l;
        int n2;
        int n3;
        long[] lArray;
        int n4;
        if (zzkv2 == null) {
            return;
        }
        zzjz.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzkv2.zzawm != null) {
            zzjz.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n4 = 0;
            lArray = zzkv2.zzawm;
            n3 = zzkv2.zzawm.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzkv2.zzawl != null) {
            zzjz.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n4 = 0;
            lArray = zzkv2.zzawl;
            n3 = zzkv2.zzawl.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        zzjz.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzkj zzkj2) {
        if (zzkj2 == null) {
            return;
        }
        zzjz.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzkj2.zzatw != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzkj2.zzatw) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzjz.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzjz.zza(stringBuilder, n, "match_as_float", zzkj2.zzatx);
        zzjz.zza(stringBuilder, n, "comparison_value", zzkj2.zzaty);
        zzjz.zza(stringBuilder, n, "min_comparison_value", zzkj2.zzatz);
        zzjz.zza(stringBuilder, n, "max_comparison_value", zzkj2.zzaua);
        zzjz.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzki zzki2) {
        if (zzki2 == null) {
            return;
        }
        zzjz.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzjz.zza(stringBuilder, n, "complement", zzki2.zzats);
        zzjz.zza(stringBuilder, n, "param_name", this.zzgf().zzbn(zzki2.zzatt));
        zzkl zzkl2 = zzki2.zzatq;
        String string = "string_filter";
        int n2 = n + 1;
        StringBuilder stringBuilder2 = stringBuilder;
        if (zzkl2 != null) {
            String[] stringArray;
            zzjz.zza(stringBuilder2, n2);
            stringBuilder2.append(string);
            stringBuilder2.append(" {\n");
            if (zzkl2.zzaue != null) {
                stringArray = "UNKNOWN_MATCH_TYPE";
                switch (zzkl2.zzaue) {
                    case 1: {
                        stringArray = "REGEXP";
                        break;
                    }
                    case 2: {
                        stringArray = "BEGINS_WITH";
                        break;
                    }
                    case 3: {
                        stringArray = "ENDS_WITH";
                        break;
                    }
                    case 4: {
                        stringArray = "PARTIAL";
                        break;
                    }
                    case 5: {
                        stringArray = "EXACT";
                        break;
                    }
                    case 6: {
                        stringArray = "IN_LIST";
                    }
                }
                zzjz.zza(stringBuilder2, n2, "match_type", stringArray);
            }
            zzjz.zza(stringBuilder2, n2, "expression", zzkl2.zzauf);
            zzjz.zza(stringBuilder2, n2, "case_sensitive", zzkl2.zzaug);
            if (zzkl2.zzauh.length > 0) {
                zzjz.zza(stringBuilder2, n2 + 1);
                stringBuilder2.append("expression_list {\n");
                stringArray = zzkl2.zzauh;
                int n3 = zzkl2.zzauh.length;
                for (int i = 0; i < n3; ++i) {
                    String string2 = stringArray[i];
                    zzjz.zza(stringBuilder2, n2 + 2);
                    stringBuilder2.append(string2);
                    stringBuilder2.append("\n");
                }
                stringBuilder2.append("}\n");
            }
            zzjz.zza(stringBuilder2, n2);
            stringBuilder2.append("}\n");
        }
        this.zza(stringBuilder, n + 1, "number_filter", zzki2.zzatr);
        zzjz.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzjz.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzgi().zziv().log("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zzd(zzex zzex2, zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzex2);
        Preconditions.checkNotNull((Object)zzeb2);
        if (TextUtils.isEmpty((CharSequence)zzeb2.zzafa)) {
            zzee zzee2 = this.zzgl();
            return false;
        }
        return true;
    }

    static boolean zzcf(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    final boolean zza(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzbt().currentTimeMillis() - l) > l2;
    }

    final byte[] zza(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zzg("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgi().zziv().zzg("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }
}

