/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzv;

public final class zzew
extends zzez {
    private final AlarmManager zzyt = (AlarmManager)this.getContext().getSystemService("alarm");
    private final zzv zzata;
    private Integer zzyu;

    protected zzew(zzfa zzfa2) {
        super(zzfa2);
        this.zzata = new zzex(this, (zzcq)zzfa2.zzmb(), zzfa2);
    }

    @Override
    protected final boolean zzgt() {
        this.zzyt.cancel(this.zzeo());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzlm();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzlm() {
        JobScheduler jobScheduler = (JobScheduler)this.getContext().getSystemService("jobscheduler");
        this.zzgo().zzjl().zzg("Cancelling job. JobID", (Object)this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzh(long l) {
        this.zzcl();
        zzk zzk2 = this.zzgr();
        if (!zzbj.zza((Context)this.getContext())) {
            this.zzgo().zzjk().zzbx("Receiver not registered/enabled");
        }
        zzk2 = this.zzgr();
        if (!zzfk.zza((Context)this.getContext(), (boolean)false)) {
            this.zzgo().zzjk().zzbx("Service not registered/enabled");
        }
        this.cancel();
        long l2 = this.zzbx().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzaf.zzaka.get()) && !this.zzata.zzej()) {
            this.zzgo().zzjl().zzbx("Scheduling upload with DelayedRunnable");
            this.zzata.zzh(l);
        }
        zzk2 = this.zzgr();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzgo().zzjl().zzbx("Scheduling upload with JobScheduler");
            long l3 = l;
            zzew zzew2 = this;
            ComponentName componentName = new ComponentName(zzew2.getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)zzew2.getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzew2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            zzew2.zzgo().zzjl().zzg("Scheduling job. JobID", (Object)zzew2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        this.zzgo().zzjl().zzbx("Scheduling upload with AlarmManager");
        this.zzyt.setInexactRepeating(2, l2, Math.max((Long)zzaf.zzajv.get(), l), this.zzeo());
    }

    private final int getJobId() {
        if (this.zzyu == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzyu = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzyu;
    }

    public final void cancel() {
        this.zzcl();
        this.zzyt.cancel(this.zzeo());
        this.zzata.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzlm();
        }
    }

    private final PendingIntent zzeo() {
        Intent intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }
}

