/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzga;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzzj;
import com.google.android.gms.internal.measurement.zzzl;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzfq
extends zzfj {
    zzfq(zzfk zzfk2) {
        super(zzfk2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    final void zza(zzgo zzgo2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgo2.zzamw = null;
        zzgo2.zzaxq = null;
        zzgo2.zzava = null;
        if (object instanceof String) {
            zzgo2.zzamw = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzgo2.zzaxq = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzgo2.zzava = (Double)object;
            return;
        }
        this.zzgt().zzjg().zzg("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(zzgj zzgj2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgj2.zzamw = null;
        zzgj2.zzaxq = null;
        zzgj2.zzava = null;
        if (object instanceof String) {
            zzgj2.zzamw = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzgj2.zzaxq = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzgj2.zzava = (Double)object;
            return;
        }
        this.zzgt().zzjg().zzg("Ignoring invalid (type) event param value", object);
    }

    final byte[] zza(zzgk zzgk2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzgk2.zzwe()];
            zzzj zzzj2 = zzzj.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgk2.zza(zzzj2);
            zzzj2.zzzh();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Data loss. Failed to serialize batch", (Object)iOException);
            return null;
        }
    }

    static zzgj zza(zzgi zzgi2, String string) {
        zzgj[] zzgjArray = zzgi2.zzaxm;
        int n = zzgi2.zzaxm.length;
        for (int i = 0; i < n; ++i) {
            zzgj zzgj2 = zzgjArray[i];
            if (!zzgj2.name.equals(string)) continue;
            return zzgj2;
        }
        return null;
    }

    static Object zzb(zzgi zzgi2, String string) {
        zzgj zzgj2 = zzfq.zza(zzgi2, string);
        if (zzgj2 != null) {
            if (zzgj2.zzamw != null) {
                return zzgj2.zzamw;
            }
            if (zzgj2.zzaxq != null) {
                return zzgj2.zzaxq;
            }
            if (zzgj2.zzava != null) {
                return zzgj2.zzava;
            }
        }
        return null;
    }

    static zzgj[] zza(zzgj[] zzgjArray, String string, Object object) {
        zzgj[] zzgjArray2 = zzgjArray;
        int n = zzgjArray.length;
        for (int i = 0; i < n; ++i) {
            zzgj zzgj2 = zzgjArray2[i];
            if (!string.equals(zzgj2.name)) continue;
            zzgj2.zzaxq = null;
            zzgj2.zzamw = null;
            zzgj2.zzava = null;
            if (object instanceof Long) {
                zzgj2.zzaxq = (Long)object;
            } else if (object instanceof String) {
                zzgj2.zzamw = (String)object;
            } else if (object instanceof Double) {
                zzgj2.zzava = (Double)object;
            }
            return zzgjArray;
        }
        zzgjArray2 = new zzgj[zzgjArray.length + 1];
        System.arraycopy(zzgjArray, 0, zzgjArray2, 0, zzgjArray.length);
        zzgj zzgj3 = new zzgj();
        new zzgj().name = string;
        if (object instanceof Long) {
            zzgj3.zzaxq = (Long)object;
        } else if (object instanceof String) {
            zzgj3.zzamw = (String)object;
        } else if (object instanceof Double) {
            zzgj3.zzava = (Double)object;
        }
        zzgjArray2[zzgjArray.length] = zzgj3;
        return zzgjArray2;
    }

    final String zzb(zzgk zzgk2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzgk2.zzaxr != null) {
            zzgl[] zzglArray = zzgk2.zzaxr;
            int n = zzgk2.zzaxr.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2;
                int n3;
                Object object2;
                zzgl zzgl2 = zzglArray[i];
                if (zzgl2 == null) continue;
                zzgl zzgl3 = zzgl2;
                StringBuilder stringBuilder2 = stringBuilder;
                zzfq zzfq2 = this;
                if (zzgl3 == null) continue;
                zzfq.zza(stringBuilder2, 1);
                stringBuilder2.append("bundle {\n");
                zzfq.zza(stringBuilder2, 1, "protocol_version", zzgl3.zzaxt);
                zzfq.zza(stringBuilder2, 1, "platform", zzgl3.zzayb);
                zzfq.zza(stringBuilder2, 1, "gmp_version", zzgl3.zzayf);
                zzfq.zza(stringBuilder2, 1, "uploading_gmp_version", zzgl3.zzayg);
                zzfq.zza(stringBuilder2, 1, "config_version", zzgl3.zzayr);
                zzfq.zza(stringBuilder2, 1, "gmp_app_id", zzgl3.zzafx);
                zzfq.zza(stringBuilder2, 1, "admob_app_id", zzgl3.zzaxc);
                zzfq.zza(stringBuilder2, 1, "app_id", zzgl3.zztt);
                zzfq.zza(stringBuilder2, 1, "app_version", zzgl3.zzts);
                zzfq.zza(stringBuilder2, 1, "app_version_major", zzgl3.zzayn);
                zzfq.zza(stringBuilder2, 1, "firebase_instance_id", zzgl3.zzafz);
                zzfq.zza(stringBuilder2, 1, "dev_cert_hash", zzgl3.zzayj);
                zzfq.zza(stringBuilder2, 1, "app_store", zzgl3.zzage);
                zzfq.zza(stringBuilder2, 1, "upload_timestamp_millis", zzgl3.zzaxw);
                zzfq.zza(stringBuilder2, 1, "start_timestamp_millis", zzgl3.zzaxx);
                zzfq.zza(stringBuilder2, 1, "end_timestamp_millis", zzgl3.zzaxy);
                zzfq.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzgl3.zzaxz);
                zzfq.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzgl3.zzaya);
                zzfq.zza(stringBuilder2, 1, "app_instance_id", zzgl3.zzafw);
                zzfq.zza(stringBuilder2, 1, "resettable_device_id", zzgl3.zzayh);
                zzfq.zza(stringBuilder2, 1, "device_id", zzgl3.zzayq);
                zzfq.zza(stringBuilder2, 1, "ds_id", zzgl3.zzayt);
                zzfq.zza(stringBuilder2, 1, "limited_ad_tracking", zzgl3.zzayi);
                zzfq.zza(stringBuilder2, 1, "os_version", zzgl3.zzayc);
                zzfq.zza(stringBuilder2, 1, "device_model", zzgl3.zzayd);
                zzfq.zza(stringBuilder2, 1, "user_default_language", zzgl3.zzaid);
                zzfq.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzgl3.zzaye);
                zzfq.zza(stringBuilder2, 1, "bundle_sequential_index", zzgl3.zzayk);
                zzfq.zza(stringBuilder2, 1, "service_upload", zzgl3.zzayl);
                zzfq.zza(stringBuilder2, 1, "health_monitor", zzgl3.zzagy);
                if (zzgl3.zzays != null && zzgl3.zzays != 0L) {
                    zzfq.zza(stringBuilder2, 1, "android_id", zzgl3.zzays);
                }
                if (zzgl3.zzayv != null) {
                    zzfq.zza(stringBuilder2, 1, "retry_counter", zzgl3.zzayv);
                }
                zzzl[] zzzlArray = zzgl3.zzaxv;
                StringBuilder stringBuilder3 = stringBuilder2;
                zzfq zzfq3 = zzfq2;
                if (zzzlArray != null) {
                    object2 = zzzlArray;
                    n3 = zzzlArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzgo zzgo2 = object2[n2];
                        if (zzgo2 == null) continue;
                        zzfq.zza(stringBuilder3, 2);
                        stringBuilder3.append("user_property {\n");
                        zzfq.zza(stringBuilder3, 2, "set_timestamp_millis", zzgo2.zzazg);
                        zzfq.zza(stringBuilder3, 2, "name", zzfq3.zzgq().zzbx(zzgo2.name));
                        zzfq.zza(stringBuilder3, 2, "string_value", zzgo2.zzamw);
                        zzfq.zza(stringBuilder3, 2, "int_value", zzgo2.zzaxq);
                        zzfq.zza(stringBuilder3, 2, "double_value", zzgo2.zzava);
                        zzfq.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                object2 = zzgl3.zztt;
                zzzlArray = zzgl3.zzaym;
                stringBuilder3 = stringBuilder2;
                zzfq3 = zzfq2;
                if (zzzlArray != null) {
                    zzzl[] zzzlArray2 = zzzlArray;
                    n2 = zzzlArray.length;
                    for (int j = 0; j < n2; ++j) {
                        object = zzzlArray2[j];
                        if (object == null) continue;
                        zzfq.zza(stringBuilder3, 2);
                        stringBuilder3.append("audience_membership {\n");
                        zzfq.zza(stringBuilder3, 2, "audience_id", object.zzavr);
                        zzfq.zza(stringBuilder3, 2, "new_audience", object.zzaxh);
                        zzfq3.zza(stringBuilder3, 2, "current_data", object.zzaxf, (String)object2);
                        zzfq3.zza(stringBuilder3, 2, "previous_data", object.zzaxg, (String)object2);
                        zzfq.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzzlArray = zzgl3.zzaxu;
                stringBuilder3 = stringBuilder2;
                zzfq3 = zzfq2;
                if (zzzlArray != null) {
                    object2 = zzzlArray;
                    n3 = zzzlArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzgo zzgo3 = object2[n2];
                        if (zzgo3 == null) continue;
                        zzfq.zza(stringBuilder3, 2);
                        stringBuilder3.append("event {\n");
                        zzfq.zza(stringBuilder3, 2, "name", zzfq3.zzgq().zzbv(((zzgi)((Object)zzgo3)).name));
                        zzfq.zza(stringBuilder3, 2, "timestamp_millis", ((zzgi)((Object)zzgo3)).zzaxn);
                        zzfq.zza(stringBuilder3, 2, "previous_timestamp_millis", ((zzgi)((Object)zzgo3)).zzaxo);
                        zzfq.zza(stringBuilder3, 2, "count", ((zzgi)((Object)zzgo3)).count);
                        zzgj[] zzgjArray = ((zzgi)((Object)zzgo3)).zzaxm;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        object = zzfq3;
                        if (zzgjArray != null) {
                            zzgj[] zzgjArray2 = zzgjArray;
                            int n4 = zzgjArray.length;
                            for (int j = 0; j < n4; ++j) {
                                zzgj zzgj2 = zzgjArray2[j];
                                if (zzgj2 == null) continue;
                                zzfq.zza(stringBuilder4, 3);
                                stringBuilder4.append("param {\n");
                                zzfq.zza(stringBuilder4, 3, "name", object.zzgq().zzbw(zzgj2.name));
                                zzfq.zza(stringBuilder4, 3, "string_value", zzgj2.zzamw);
                                zzfq.zza(stringBuilder4, 3, "int_value", zzgj2.zzaxq);
                                zzfq.zza(stringBuilder4, 3, "double_value", zzgj2.zzava);
                                zzfq.zza(stringBuilder4, 3);
                                stringBuilder4.append("}\n");
                            }
                        }
                        zzfq.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzfq.zza(stringBuilder2, 1);
                stringBuilder2.append("}\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfy zzfy2) {
        if (zzfy2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzfq.zza(stringBuilder, 0, "filter_id", zzfy2.zzavx);
        zzfq.zza(stringBuilder, 0, "event_name", this.zzgq().zzbv(zzfy2.zzavy));
        this.zza(stringBuilder, 1, "event_count_filter", zzfy2.zzawb);
        stringBuilder.append("  filters {\n");
        zzfz[] zzfzArray = zzfy2.zzavz;
        int n = zzfy2.zzavz.length;
        for (int i = 0; i < n; ++i) {
            zzfz zzfz2 = zzfzArray[i];
            this.zza(stringBuilder, 2, zzfz2);
        }
        zzfq.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zza(zzgb zzgb2) {
        if (zzgb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzfq.zza(stringBuilder, 0, "filter_id", zzgb2.zzavx);
        zzfq.zza(stringBuilder, 0, "property_name", this.zzgq().zzbx(zzgb2.zzawn));
        this.zza(stringBuilder, 1, zzgb2.zzawo);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzgm zzgm2, String string2) {
        Object object;
        int n2;
        int n3;
        Object[] objectArray;
        int n4;
        if (zzgm2 == null) {
            return;
        }
        zzfq.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzgm2.zzaza != null) {
            zzfq.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n4 = 0;
            objectArray = zzgm2.zzaza;
            n3 = zzgm2.zzaza.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzgm2.zzayz != null) {
            zzfq.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n4 = 0;
            objectArray = zzgm2.zzayz;
            n3 = zzgm2.zzayz.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (this.zzgv().zzbd(string2)) {
            if (zzgm2.zzazb != null) {
                zzfq.zza(stringBuilder, 4);
                stringBuilder.append("dynamic_filter_timestamps: {");
                n4 = 0;
                objectArray = (Object[])zzgm2.zzazb;
                n3 = zzgm2.zzazb.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray[n2];
                    if (n4++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((zzgh)((Object)object)).zzaxj).append(":").append(((zzgh)((Object)object)).zzaxk);
                }
                stringBuilder.append("}\n");
            }
            if (zzgm2.zzazc != null) {
                zzfq.zza(stringBuilder, 4);
                stringBuilder.append("sequence_filter_timestamps: {");
                n4 = 0;
                objectArray = (Object[])zzgm2.zzazc;
                n3 = zzgm2.zzazc.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray[n2];
                    if (n4++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((zzgn)((Object)object)).zzaxj).append(": [");
                    int n5 = 0;
                    long[] lArray = ((zzgn)((Object)((Object)object))).zzaze;
                    int n6 = ((zzgn)((Object)((Object)object))).zzaze.length;
                    for (int i = 0; i < n6; ++i) {
                        long l = lArray[i];
                        if (n5++ != 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(l);
                    }
                    stringBuilder.append("]");
                }
                stringBuilder.append("}\n");
            }
        }
        zzfq.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzga zzga2) {
        if (zzga2 == null) {
            return;
        }
        zzfq.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzga2.zzawh != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzga2.zzawh) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzfq.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzfq.zza(stringBuilder, n, "match_as_float", zzga2.zzawi);
        zzfq.zza(stringBuilder, n, "comparison_value", zzga2.zzawj);
        zzfq.zza(stringBuilder, n, "min_comparison_value", zzga2.zzawk);
        zzfq.zza(stringBuilder, n, "max_comparison_value", zzga2.zzawl);
        zzfq.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfz zzfz2) {
        if (zzfz2 == null) {
            return;
        }
        zzfq.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzfq.zza(stringBuilder, n, "complement", zzfz2.zzawf);
        zzfq.zza(stringBuilder, n, "param_name", this.zzgq().zzbw(zzfz2.zzawg));
        zzgc zzgc2 = zzfz2.zzawd;
        String string = "string_filter";
        int n2 = n + 1;
        StringBuilder stringBuilder2 = stringBuilder;
        if (zzgc2 != null) {
            String[] stringArray;
            zzfq.zza(stringBuilder2, n2);
            stringBuilder2.append(string);
            stringBuilder2.append(" {\n");
            if (zzgc2.zzawp != null) {
                stringArray = "UNKNOWN_MATCH_TYPE";
                switch (zzgc2.zzawp) {
                    case 1: {
                        stringArray = "REGEXP";
                        break;
                    }
                    case 2: {
                        stringArray = "BEGINS_WITH";
                        break;
                    }
                    case 3: {
                        stringArray = "ENDS_WITH";
                        break;
                    }
                    case 4: {
                        stringArray = "PARTIAL";
                        break;
                    }
                    case 5: {
                        stringArray = "EXACT";
                        break;
                    }
                    case 6: {
                        stringArray = "IN_LIST";
                    }
                }
                zzfq.zza(stringBuilder2, n2, "match_type", stringArray);
            }
            zzfq.zza(stringBuilder2, n2, "expression", zzgc2.zzawq);
            zzfq.zza(stringBuilder2, n2, "case_sensitive", zzgc2.zzawr);
            if (zzgc2.zzaws.length > 0) {
                zzfq.zza(stringBuilder2, n2 + 1);
                stringBuilder2.append("expression_list {\n");
                stringArray = zzgc2.zzaws;
                int n3 = zzgc2.zzaws.length;
                for (int i = 0; i < n3; ++i) {
                    String string2 = stringArray[i];
                    zzfq.zza(stringBuilder2, n2 + 2);
                    stringBuilder2.append(string2);
                    stringBuilder2.append("\n");
                }
                stringBuilder2.append("}\n");
            }
            zzfq.zza(stringBuilder2, n2);
            stringBuilder2.append("}\n");
        }
        this.zza(stringBuilder, n + 1, "number_filter", zzfz2.zzawe);
        zzfq.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzfq.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzgt().zzjg().zzca("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zze(zzae zzae2, zzi zzi2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotNull((Object)zzi2);
        if (TextUtils.isEmpty((CharSequence)zzi2.zzafx) && TextUtils.isEmpty((CharSequence)zzi2.zzagk)) {
            zzl zzl2 = this.zzgw();
            return false;
        }
        return true;
    }

    static boolean zzcu(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    final boolean zzb(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzbx().currentTimeMillis() - l) > l2;
    }

    final byte[] zza(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    @Nullable
    final int[] zzmi() {
        Map map = zzag.zzm((Context)this.zzang.getContext());
        if (map == null || map.size() == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzag.zzaks.get();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzgt().zzjj().zzg("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzgt().zzjj().zzg("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Object object = new int[arrayList.size()];
        int n3 = 0;
        ArrayList<Integer> arrayList2 = arrayList;
        int n4 = arrayList2.size();
        for (int i = 0; i < n4; ++i) {
            Object e = arrayList2.get(i);
            Integer n5 = (Integer)e;
            object[n3++] = n5;
        }
        return object;
    }
}

