/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpErrorResponse {
    @VisibleForTesting
    static final String ERROR_KEY = "error";
    @VisibleForTesting
    static final String CODE_KEY = "code";
    @VisibleForTesting
    static final String MESSAGE_KEY = "message";
    private int errorCode;
    private String errorMessage;

    @NonNull
    public static HttpErrorResponse fromJsonString(@NonNull String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        String innerErrorString = jsonObject.optString(ERROR_KEY);
        JSONObject innerJsonObject = new JSONObject(innerErrorString);
        int code = innerJsonObject.optInt(CODE_KEY);
        String message = innerJsonObject.optString(MESSAGE_KEY);
        return new HttpErrorResponse(code, message);
    }

    private HttpErrorResponse(int errorCode, @NonNull String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @NonNull
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

