/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzabb;
import com.google.android.gms.internal.zzabs;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.appindexing.FirebaseAppIndex;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.Thing;
import com.google.firebase.appindexing.internal.zze;
import com.google.firebase.appindexing.internal.zzl;
import com.google.firebase.appindexing.internal.zzm;
import com.google.firebase.appindexing.internal.zzs;
import java.util.concurrent.Executor;

public final class zzd
extends FirebaseAppIndex {
    private zzc zzbXo;

    public zzd(@NonNull Context context) {
        this(context, new zza(context));
    }

    zzd(@NonNull Context context, @NonNull com.google.android.gms.common.api.zzc<Api.ApiOptions.NoOptions> zzc2) {
        this.zzbXo = new zzc(zzc2);
    }

    @Override
    public Task<Void> update(Indexable ... indexableArray) {
        if (indexableArray == null) {
            return Tasks.forException((Exception)new NullPointerException("Indexables cannot be null."));
        }
        final Thing[] thingArray = new Thing[indexableArray.length];
        try {
            System.arraycopy(indexableArray, 0, thingArray, 0, indexableArray.length);
        }
        catch (ArrayStoreException arrayStoreException) {
            return Tasks.forException((Exception)((Object)new FirebaseAppIndexingInvalidArgumentException("Custom Indexable-objects are not allowed. Please use the 'Indexables'-class for creating the objects.")));
        }
        return this.zzbXo.zzb(new zzb(this){

            @Override
            protected void zza(zzl zzl2) throws RemoteException {
                zzl2.zza(this.zzVu(), thingArray);
            }
        });
    }

    @Override
    public Task<Void> remove(final String ... stringArray) {
        return this.zzbXo.zzb(new zzb(this){

            @Override
            protected void zza(zzl zzl2) throws RemoteException {
                zzl2.zza(this.zzVu(), stringArray);
            }
        });
    }

    @Override
    public Task<Void> removeAll() {
        return this.zzbXo.zzb(new zzb(this){

            @Override
            protected void zza(zzl zzl2) throws RemoteException {
                zzl2.zzc(this.zzVu());
            }
        });
    }

    static class zzc
    implements OnCompleteListener<Void>,
    Executor {
        public static int MAX_RETRIES = 10;
        public static long zzbXs = 250L;
        public static double zzbXt = 1.5;
        public static double zzbXu = 0.25;
        @NonNull
        private final com.google.android.gms.common.api.zzc<?> zzaDe;
        @NonNull
        private final Handler mHandler;
        @Nullable
        private Task<Void> zzbXv = null;

        public zzc(@NonNull com.google.android.gms.common.api.zzc<?> zzc2) {
            this.zzaDe = zzc2;
            this.mHandler = new Handler(zzc2.getLooper());
        }

        static long zzqa(int n) {
            double d = (double)zzbXs * Math.pow(zzbXt, n) * ((Math.random() * 2.0 - 1.0) * zzbXu + 1.0);
            return (long)d;
        }

        private static boolean zzc(@NonNull Task<Status> task) {
            if (task.isSuccessful()) {
                Status status = (Status)task.getResult();
                return zze.zzqb(status.getStatusCode());
            }
            return false;
        }

        private void zza(final @NonNull zzb zzb2, final @NonNull TaskCompletionSource<Void> taskCompletionSource, final int n) {
            this.zzaDe.doWrite((zzabv)zzb2).addOnCompleteListener((Executor)this, (OnCompleteListener)new OnCompleteListener<Status>(){

                public void onComplete(@NonNull Task<Status> task) {
                    Object object;
                    if (n < MAX_RETRIES && zzc.zzc((Task<Status>)task)) {
                        object = new Runnable(){

                            @Override
                            public void run() {
                                zzc.this.zza(zzb2, (TaskCompletionSource<Void>)taskCompletionSource, n + 1);
                            }
                        };
                        long l = zzc.zzqa(n);
                        if (zzc.this.mHandler.postDelayed((Runnable)object, l)) {
                            zzm.zzit(new StringBuilder(47).append("Task will be retried in ").append(l).append(" ms").toString());
                            return;
                        }
                        zzm.zzit("Failed to schedule retry -- failing immediately!");
                    }
                    if (task.isSuccessful()) {
                        object = (Status)task.getResult();
                        if (object.isSuccess()) {
                            taskCompletionSource.setResult(null);
                        } else {
                            taskCompletionSource.setException((Exception)((Object)zzs.zzb(object, "Indexing error, please try again.")));
                        }
                    } else {
                        taskCompletionSource.setException(task.getException());
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task<Void> zzb(final @NonNull zzb zzb2) {
            Task<Void> task;
            final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            Task task2 = taskCompletionSource.getTask();
            zzc zzc2 = this;
            synchronized (zzc2) {
                task = this.zzbXv;
                this.zzbXv = task2;
            }
            task2.addOnCompleteListener((Executor)this, (OnCompleteListener)this);
            if (task == null) {
                this.zza(zzb2, (TaskCompletionSource<Void>)taskCompletionSource, 0);
            } else {
                task.addOnCompleteListener((Executor)this, (OnCompleteListener)new OnCompleteListener<Void>(){

                    public void onComplete(@NonNull Task<Void> task) {
                        zzc.this.zza(zzb2, (TaskCompletionSource<Void>)taskCompletionSource, 0);
                    }
                });
            }
            return task2;
        }

        public synchronized void onComplete(@NonNull Task<Void> task) {
            if (task == this.zzbXv) {
                this.zzbXv = null;
            }
        }

        @Override
        public void execute(Runnable runnable) {
            this.mHandler.post(runnable);
        }
    }

    private static abstract class zzb
    extends zzabv<com.google.firebase.appindexing.internal.zzc, Status> {
        private TaskCompletionSource<Status> zzazE;

        private zzb() {
        }

        protected final void zza(com.google.firebase.appindexing.internal.zzc zzc2, TaskCompletionSource<Status> taskCompletionSource) throws RemoteException {
            this.zzazE = taskCompletionSource;
            this.zza((zzl)zzc2.zzxD());
        }

        protected abstract void zza(zzl var1) throws RemoteException;

        protected zzabb zzVu() {
            return new zzabb.zza(){

                public void zzp(Status status) throws RemoteException {
                    zzb.this.zzazE.setResult((Object)status);
                }
            };
        }
    }

    private static class zza
    extends com.google.android.gms.common.api.zzc<Api.ApiOptions.NoOptions> {
        public zza(Context context) {
            super(context, com.google.firebase.appindexing.internal.zzc.API, null, Looper.getMainLooper(), (zzabs)new com.google.firebase.zza());
        }
    }
}

