/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzaot;
import com.google.android.gms.internal.zzapk;
import com.google.android.gms.internal.zzapl;
import com.google.android.gms.internal.zzapo;
import com.google.android.gms.internal.zzaps;
import com.google.android.gms.internal.zzapt;
import com.google.android.gms.internal.zzapu;
import com.google.android.gms.internal.zzapw;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbay;
import java.util.List;

public final class zzapv
implements AppIndexApi {
    private static final String TAG = zzapv.class.getSimpleName();

    public final PendingResult<Status> zza(GoogleApiClient googleApiClient, zzapk ... zzapkArray) {
        return googleApiClient.zzd((zzbax)new zzapw(this, googleApiClient, zzapkArray));
    }

    @Override
    public final PendingResult<Status> view(GoogleApiClient googleApiClient, Activity activity, Intent intent, String string, Uri uri, List<AppIndexApi.AppIndexingLink> list) {
        String string2 = googleApiClient.getContext().getPackageName();
        List<AppIndexApi.AppIndexingLink> list2 = list;
        if (list2 != null) {
            for (AppIndexApi.AppIndexingLink appIndexingLink : list2) {
                zzapv.zzb(null, appIndexingLink.appIndexingUrl);
            }
        }
        return this.zza(googleApiClient, new zzapk(string2, intent, string, uri, null, list, 1));
    }

    @Override
    public final PendingResult<Status> viewEnd(GoogleApiClient googleApiClient, Activity activity, Intent intent) {
        String string = googleApiClient.getContext().getPackageName();
        zzapk zzapk2 = new zzapl().zza(zzapk.zza(string, intent)).zzv(System.currentTimeMillis()).zzS(0).zzT(2).zzmm();
        return this.zza(googleApiClient, zzapk2);
    }

    public static Intent zza(String string, Uri uri) {
        zzapv.zzb(string, uri);
        if (zzapv.zzk(uri)) {
            return new Intent("android.intent.action.VIEW", uri);
        }
        if (zzapv.zzl(uri)) {
            return new Intent("android.intent.action.VIEW", zzapv.zzj(uri));
        }
        String string2 = String.valueOf(uri);
        throw new RuntimeException(new StringBuilder(70 + String.valueOf(string2).length()).append("appIndexingUri is neither an HTTP(S) URL nor an \"android-app://\" URL: ").append(string2).toString());
    }

    private static Uri zzj(Uri uri) {
        List list = uri.getPathSegments();
        String string = (String)list.get(0);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(string);
        if (list.size() > 1) {
            builder.authority((String)list.get(1));
            for (int i = 2; i < list.size(); ++i) {
                builder.appendPath((String)list.get(i));
            }
        } else {
            String string2 = String.valueOf(uri);
            Log.e((String)TAG, (String)new StringBuilder(88 + String.valueOf(string2).length()).append("The app URI must have the format: android-app://<package_name>/<scheme>/<path>. But got ").append(string2).toString());
        }
        builder.encodedQuery(uri.getEncodedQuery());
        builder.encodedFragment(uri.getEncodedFragment());
        return builder.build();
    }

    private static void zzb(String string, Uri uri) {
        if (zzapv.zzk(uri)) {
            if (uri.getHost().isEmpty()) {
                String string2 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(98 + String.valueOf(string2).length()).append("AppIndex: The web URL must have a host (follow the format http(s)://<host>/<path>). Provided URI: ").append(string2).toString());
            }
            return;
        }
        if (zzapv.zzl(uri)) {
            if (string != null && !string.equals(uri.getHost())) {
                String string3 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(150 + String.valueOf(string3).length()).append("AppIndex: The android-app URI host must match the package name and follow the format android-app://<package_name>/<scheme>/<host_path>. Provided URI: ").append(string3).toString());
            }
            List list = uri.getPathSegments();
            if (list.isEmpty() || ((String)list.get(0)).isEmpty()) {
                String string4 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(128 + String.valueOf(string4).length()).append("AppIndex: The app URI scheme must exist and follow the format android-app://<package_name>/<scheme>/<host_path>). Provided URI: ").append(string4).toString());
            }
            return;
        }
        String string5 = String.valueOf(uri);
        throw new IllegalArgumentException(new StringBuilder(176 + String.valueOf(string5).length()).append("AppIndex: The URI scheme must either be 'http(s)' or 'android-app'. If the latter, it must follow the format 'android-app://<package_name>/<scheme>/<host_path>'. Provided URI: ").append(string5).toString());
    }

    private static boolean zzk(Uri uri) {
        String string = uri.getScheme();
        return "http".equals(string) || "https".equals(string);
    }

    private static boolean zzl(Uri uri) {
        String string = uri.getScheme();
        return "android-app".equals(string);
    }

    @Override
    public final PendingResult<Status> view(GoogleApiClient googleApiClient, Activity activity, Uri uri, String string, Uri uri2, List<AppIndexApi.AppIndexingLink> list) {
        String string2 = googleApiClient.getContext().getPackageName();
        zzapv.zzb(string2, uri);
        Intent intent = zzapv.zza(string2, uri);
        return this.view(googleApiClient, activity, intent, string, uri2, list);
    }

    @Override
    public final PendingResult<Status> viewEnd(GoogleApiClient googleApiClient, Activity activity, Uri uri) {
        Intent intent = zzapv.zza(googleApiClient.getContext().getPackageName(), uri);
        return this.viewEnd(googleApiClient, activity, intent);
    }

    @Override
    public final AppIndexApi.ActionResult action(GoogleApiClient googleApiClient, Action action) {
        PendingResult<Status> pendingResult = this.zza(googleApiClient, action, 1);
        return new zza(this, pendingResult, action);
    }

    @Override
    public final PendingResult<Status> start(GoogleApiClient googleApiClient, Action action) {
        return this.zza(googleApiClient, action, 1);
    }

    @Override
    public final PendingResult<Status> end(GoogleApiClient googleApiClient, Action action) {
        return this.zza(googleApiClient, action, 2);
    }

    private final PendingResult<Status> zza(GoogleApiClient googleApiClient, Action action, int n) {
        String string = googleApiClient.getContext().getPackageName();
        long l = System.currentTimeMillis();
        zzapk zzapk2 = zzapu.zza(action, l, string, n);
        return this.zza(googleApiClient, zzapk2);
    }

    @Deprecated
    static final class zza
    implements AppIndexApi.ActionResult {
        private zzapv zzajN;
        private PendingResult<Status> zzajO;
        private Action zzajP;

        zza(zzapv zzapv2, PendingResult<Status> pendingResult, Action action) {
            this.zzajN = zzapv2;
            this.zzajO = pendingResult;
            this.zzajP = action;
        }

        @Override
        public final PendingResult<Status> end(GoogleApiClient googleApiClient) {
            String string = googleApiClient.getContext().getPackageName();
            long l = System.currentTimeMillis();
            zzapk zzapk2 = zzapu.zza(this.zzajP, l, string, 2);
            return this.zzajN.zza(googleApiClient, zzapk2);
        }

        @Override
        public final PendingResult<Status> getPendingResult() {
            return this.zzajO;
        }
    }

    public static final class zzd
    extends zzaps<Status> {
        public zzd(zzbay<Status> zzbay2) {
            super(zzbay2);
        }

        @Override
        public final void zza(Status status) {
            this.zzajL.setResult((Object)status);
        }
    }

    public static abstract class zzc<T extends Result>
    extends zzb<Status> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            return status;
        }
    }

    static abstract class zzb<T extends Result>
    extends zzbax<T, zzapt> {
        public zzb(GoogleApiClient googleApiClient) {
            super(zzaot.zzaiT, googleApiClient);
        }

        protected abstract void zza(zzapo var1) throws RemoteException;

        protected final /* synthetic */ void zza(Api.zzb zzb2) throws RemoteException {
            zzapt zzapt2 = (zzapt)zzb2;
            this.zza((zzapo)zzapt2.zzrf());
        }
    }
}

