/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing;

import android.net.Uri;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.List;

public final class AndroidAppUri {
    private final Uri mUri;

    private AndroidAppUri(Uri uri) {
        this.mUri = uri;
    }

    public static AndroidAppUri newAndroidAppUri(Uri uri) {
        AndroidAppUri androidAppUri;
        AndroidAppUri androidAppUri2 = androidAppUri = new AndroidAppUri(uri);
        if (!"android-app".equals(androidAppUri2.mUri.getScheme())) {
            throw new IllegalArgumentException("android-app scheme is required.");
        }
        if (TextUtils.isEmpty((CharSequence)androidAppUri2.getPackageName())) {
            throw new IllegalArgumentException("Package name is empty.");
        }
        return androidAppUri;
    }

    public final String getPackageName() {
        return this.mUri.getAuthority();
    }

    public final Uri getDeepLinkUri() {
        List list = this.mUri.getPathSegments();
        if (list.size() > 0) {
            String string = (String)list.get(0);
            Uri.Builder builder = new Uri.Builder();
            builder.scheme(string);
            if (list.size() > 1) {
                builder.authority((String)list.get(1));
                for (int i = 2; i < list.size(); ++i) {
                    builder.appendPath((String)list.get(i));
                }
            }
            builder.encodedQuery(this.mUri.getEncodedQuery());
            builder.encodedFragment(this.mUri.getEncodedFragment());
            return builder.build();
        }
        return null;
    }

    public final String toString() {
        return this.mUri.toString();
    }

    public final boolean equals(Object object) {
        if (object instanceof AndroidAppUri) {
            return this.mUri.equals((Object)((AndroidAppUri)object).mUri);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.mUri});
    }
}

