/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.internal.icing.zzab;
import com.google.android.gms.internal.icing.zzaf;
import com.google.android.gms.internal.icing.zzag;
import com.google.android.gms.internal.icing.zzah;
import com.google.android.gms.internal.icing.zzaj;
import com.google.android.gms.internal.icing.zze;
import com.google.android.gms.internal.icing.zzx;
import com.google.android.gms.internal.icing.zzy;
import java.util.List;

public final class zzai
implements AppIndexApi {
    private static final String TAG = zzai.class.getSimpleName();

    public final PendingResult<Status> zza(GoogleApiClient googleApiClient, zzx ... zzxArray) {
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzaj(this, googleApiClient, zzxArray));
    }

    @Override
    public final PendingResult<Status> view(GoogleApiClient googleApiClient, Activity activity, Intent intent, String string, Uri uri, List<AppIndexApi.AppIndexingLink> list) {
        String string2 = googleApiClient.getContext().getPackageName();
        List<AppIndexApi.AppIndexingLink> list2 = list;
        if (list2 != null) {
            for (AppIndexApi.AppIndexingLink appIndexingLink : list2) {
                zzai.zzb(null, appIndexingLink.appIndexingUrl);
            }
        }
        return this.zza(googleApiClient, new zzx(string2, intent, string, uri, null, list, 1));
    }

    @Override
    public final PendingResult<Status> viewEnd(GoogleApiClient googleApiClient, Activity activity, Intent intent) {
        String string = googleApiClient.getContext().getPackageName();
        zzx zzx2 = new zzy().zza(zzx.zza(string, intent)).zza(System.currentTimeMillis()).zzb(0).zzc(2).zzc();
        return this.zza(googleApiClient, zzx2);
    }

    public static Intent zza(String string, Uri uri) {
        zzai.zzb(string, uri);
        if (zzai.zza(uri)) {
            return new Intent("android.intent.action.VIEW", uri);
        }
        if (zzai.zzb(uri)) {
            Uri uri2 = uri;
            List list = uri2.getPathSegments();
            String string2 = (String)list.get(0);
            Uri.Builder builder = new Uri.Builder();
            builder.scheme(string2);
            if (list.size() > 1) {
                builder.authority((String)list.get(1));
                for (int i = 2; i < list.size(); ++i) {
                    builder.appendPath((String)list.get(i));
                }
            } else {
                String string3 = String.valueOf(uri2);
                Log.e((String)TAG, (String)new StringBuilder(88 + String.valueOf(string3).length()).append("The app URI must have the format: android-app://<package_name>/<scheme>/<path>. But got ").append(string3).toString());
            }
            builder.encodedQuery(uri2.getEncodedQuery());
            builder.encodedFragment(uri2.getEncodedFragment());
            return new Intent("android.intent.action.VIEW", builder.build());
        }
        String string4 = String.valueOf(uri);
        throw new RuntimeException(new StringBuilder(70 + String.valueOf(string4).length()).append("appIndexingUri is neither an HTTP(S) URL nor an \"android-app://\" URL: ").append(string4).toString());
    }

    private static void zzb(String string, Uri uri) {
        if (zzai.zza(uri)) {
            if (uri.getHost().isEmpty()) {
                String string2 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(98 + String.valueOf(string2).length()).append("AppIndex: The web URL must have a host (follow the format http(s)://<host>/<path>). Provided URI: ").append(string2).toString());
            }
            return;
        }
        if (zzai.zzb(uri)) {
            if (string != null && !string.equals(uri.getHost())) {
                String string3 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(150 + String.valueOf(string3).length()).append("AppIndex: The android-app URI host must match the package name and follow the format android-app://<package_name>/<scheme>/<host_path>. Provided URI: ").append(string3).toString());
            }
            List list = uri.getPathSegments();
            if (list.isEmpty() || ((String)list.get(0)).isEmpty()) {
                String string4 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(128 + String.valueOf(string4).length()).append("AppIndex: The app URI scheme must exist and follow the format android-app://<package_name>/<scheme>/<host_path>). Provided URI: ").append(string4).toString());
            }
            return;
        }
        String string5 = String.valueOf(uri);
        throw new IllegalArgumentException(new StringBuilder(176 + String.valueOf(string5).length()).append("AppIndex: The URI scheme must either be 'http(s)' or 'android-app'. If the latter, it must follow the format 'android-app://<package_name>/<scheme>/<host_path>'. Provided URI: ").append(string5).toString());
    }

    private static boolean zza(Uri uri) {
        String string = uri.getScheme();
        return "http".equals(string) || "https".equals(string);
    }

    private static boolean zzb(Uri uri) {
        String string = uri.getScheme();
        return "android-app".equals(string);
    }

    @Override
    public final PendingResult<Status> view(GoogleApiClient googleApiClient, Activity activity, Uri uri, String string, Uri uri2, List<AppIndexApi.AppIndexingLink> list) {
        String string2 = googleApiClient.getContext().getPackageName();
        zzai.zzb(string2, uri);
        Intent intent = zzai.zza(string2, uri);
        return this.view(googleApiClient, activity, intent, string, uri2, list);
    }

    @Override
    public final PendingResult<Status> viewEnd(GoogleApiClient googleApiClient, Activity activity, Uri uri) {
        Intent intent = zzai.zza(googleApiClient.getContext().getPackageName(), uri);
        return this.viewEnd(googleApiClient, activity, intent);
    }

    @Override
    public final AppIndexApi.ActionResult action(GoogleApiClient googleApiClient, Action action) {
        PendingResult<Status> pendingResult = this.zza(googleApiClient, action, 1);
        return new zza(this, pendingResult, action);
    }

    @Override
    public final PendingResult<Status> start(GoogleApiClient googleApiClient, Action action) {
        return this.zza(googleApiClient, action, 1);
    }

    @Override
    public final PendingResult<Status> end(GoogleApiClient googleApiClient, Action action) {
        return this.zza(googleApiClient, action, 2);
    }

    private final PendingResult<Status> zza(GoogleApiClient googleApiClient, Action action, int n) {
        String string = googleApiClient.getContext().getPackageName();
        long l = System.currentTimeMillis();
        zzx zzx2 = zzah.zza(action, l, string, n);
        return this.zza(googleApiClient, zzx2);
    }

    @Deprecated
    static final class zza
    implements AppIndexApi.ActionResult {
        private zzai zzat;
        private PendingResult<Status> zzau;
        private Action zzav;

        zza(zzai zzai2, PendingResult<Status> pendingResult, Action action) {
            this.zzat = zzai2;
            this.zzau = pendingResult;
            this.zzav = action;
        }

        @Override
        public final PendingResult<Status> end(GoogleApiClient googleApiClient) {
            String string = googleApiClient.getContext().getPackageName();
            long l = System.currentTimeMillis();
            zzx zzx2 = zzah.zza(this.zzav, l, string, 2);
            return this.zzat.zza(googleApiClient, zzx2);
        }

        @Override
        public final PendingResult<Status> getPendingResult() {
            return this.zzau;
        }
    }

    public static final class zzd
    extends zzaf<Status> {
        public zzd(BaseImplementation.ResultHolder<Status> resultHolder) {
            super(resultHolder);
        }

        @Override
        public final void zza(Status status) {
            this.zzar.setResult((Object)status);
        }
    }

    public static abstract class zzc<T extends Result>
    extends zzb<Status> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            return status;
        }
    }

    static abstract class zzb<T extends Result>
    extends BaseImplementation.ApiMethodImpl<T, zzag> {
        public zzb(GoogleApiClient googleApiClient) {
            super(zze.zzg, googleApiClient);
        }

        protected abstract void zza(zzab var1) throws RemoteException;

        protected /* synthetic */ void doExecute(Api.AnyClient anyClient) throws RemoteException {
            zzag zzag2 = (zzag)anyClient;
            this.zza((zzab)zzag2.getService());
        }
    }
}

