/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzbe;
import com.google.android.gms.internal.icing.zzcm;
import com.google.android.gms.internal.icing.zzcr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzcl
extends zzbe<Integer>
implements zzcr<Integer>,
RandomAccess {
    private static final zzcl zzih = new zzcl();
    private int[] zzii;
    private int size;

    zzcl() {
        this(new int[10], 0);
    }

    private zzcl(int[] nArray, int n) {
        this.zzii = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzii, n2, this.zzii, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzcl)) {
            return super.equals(object);
        }
        zzcl zzcl2 = (zzcl)object;
        if (this.size != zzcl2.size) {
            return false;
        }
        int[] nArray = zzcl2.zzii;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzii[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzii[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzf(n);
        return this.zzii[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzq();
        zzcm.checkNotNull(collection);
        if (!(collection instanceof zzcl)) {
            return super.addAll(collection);
        }
        zzcl zzcl2 = (zzcl)collection;
        if (zzcl2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzcl2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzcl2.size;
        if (n > this.zzii.length) {
            this.zzii = Arrays.copyOf(this.zzii, n);
        }
        System.arraycopy(zzcl2.zzii, 0, this.zzii, this.size, zzcl2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzii[i])) continue;
            System.arraycopy(this.zzii, i + 1, this.zzii, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzcl zzcl2 = this;
        zzcl2.zzq();
        zzcl2.zzf(n);
        int n4 = zzcl2.zzii[n];
        zzcl2.zzii[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzcl zzcl2 = this;
        zzcl2.zzq();
        zzcl2.zzf(n);
        int n2 = zzcl2.zzii[n];
        if (n < zzcl2.size - 1) {
            System.arraycopy(zzcl2.zzii, n + 1, zzcl2.zzii, n, zzcl2.size - n);
        }
        --zzcl2.size;
        ++zzcl2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        int n4 = n;
        zzcl zzcl2 = this;
        zzcl2.zzq();
        if (n4 < 0 || n4 > zzcl2.size) {
            throw new IndexOutOfBoundsException(zzcl2.zzg(n4));
        }
        if (zzcl2.size < zzcl2.zzii.length) {
            System.arraycopy(zzcl2.zzii, n4, zzcl2.zzii, n4 + 1, zzcl2.size - n4);
        } else {
            int[] nArray = new int[zzcl2.size * 3 / 2 + 1];
            System.arraycopy(zzcl2.zzii, 0, nArray, 0, n4);
            System.arraycopy(zzcl2.zzii, n4, nArray, n4 + 1, zzcl2.size - n4);
            zzcl2.zzii = nArray;
        }
        zzcl2.zzii[n4] = n3;
        ++zzcl2.size;
        ++zzcl2.modCount;
    }

    @Override
    public final /* synthetic */ zzcr zzh(int n) {
        int n2 = n;
        zzcl zzcl2 = this;
        if (n2 < zzcl2.size) {
            throw new IllegalArgumentException();
        }
        return new zzcl(Arrays.copyOf(zzcl2.zzii, n2), zzcl2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzih.zzp();
    }
}

