/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzft;
import com.google.android.gms.internal.icing.zzfz;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzfs {
    private final ByteBuffer zznu;

    private zzfs(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzfs(ByteBuffer byteBuffer) {
        this.zznu = byteBuffer;
        this.zznu.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzfs zzf(byte[] byArray) {
        return zzfs.zzf(byArray, 0, byArray.length);
    }

    public static zzfs zzf(byte[] byArray, int n, int n2) {
        return new zzfs(byArray, 0, n2);
    }

    public final void zza(int n, String string) throws IOException {
        this.zzb(n, 2);
        String string2 = string;
        zzfs zzfs2 = this;
        try {
            int n2 = zzfs.zzx(string2.length());
            int n3 = zzfs.zzx(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzfs2.zznu.position();
                if (zzfs2.zznu.remaining() < n2) {
                    throw new zzft(n4 + n2, zzfs2.zznu.limit());
                }
                zzfs2.zznu.position(n4 + n2);
                zzfs.zza(string2, zzfs2.zznu);
                int n5 = zzfs2.zznu.position();
                zzfs2.zznu.position(n4);
                zzfs2.zzak(n5 - n4 - n2);
                zzfs2.zznu.position(n5);
                return;
            }
            zzfs2.zzak(zzfs.zza(string2));
            zzfs.zza(string2, zzfs2.zznu);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzft zzft2 = new zzft(zzfs2.zznu.position(), zzfs2.zznu.limit());
            zzft2.initCause(bufferOverflowException);
            throw zzft2;
        }
    }

    public final void zza(int n, zzfz zzfz2) throws IOException {
        this.zzb(n, 2);
        zzfz zzfz3 = zzfz2;
        zzfs zzfs2 = this;
        zzfz zzfz4 = zzfz3;
        if (zzfz4.zzoe < 0) {
            zzfz4.zzan();
        }
        zzfs2.zzak(zzfz4.zzoe);
        zzfz3.zza(zzfs2);
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zzb(int n, String string) {
        int n2 = zzfs.zza(string);
        return zzfs.zzp(n) + (zzfs.zzx(n2) + n2);
    }

    public static int zzb(int n, zzfz zzfz2) {
        int n2 = zzfz2.zzan();
        return zzfs.zzp(n) + (zzfs.zzx(n2) + n2);
    }

    public final void zzda() {
        if (this.zznu.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zznu.remaining()));
        }
    }

    public final void zzb(byte by) throws IOException {
        if (!this.zznu.hasRemaining()) {
            throw new zzft(this.zznu.position(), this.zznu.limit());
        }
        this.zznu.put(by);
    }

    private final void zzaj(int n) throws IOException {
        byte by = (byte)n;
        zzfs zzfs2 = this;
        if (!zzfs2.zznu.hasRemaining()) {
            throw new zzft(zzfs2.zznu.position(), zzfs2.zznu.limit());
        }
        zzfs2.zznu.put(by);
    }

    public final void zzb(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzak(n << 3 | n3);
    }

    public static int zzp(int n) {
        return zzfs.zzx(n << 3);
    }

    public final void zzak(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzaj(n);
                return;
            }
            this.zzaj(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzx(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public final void zzl(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzaj((int)l);
                return;
            }
            this.zzaj((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public final void zzm(long l) throws IOException {
        if (this.zznu.remaining() < 8) {
            throw new zzft(this.zznu.position(), this.zznu.limit());
        }
        this.zznu.putLong(l);
    }
}

