/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.builders;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.Thing;
import com.google.firebase.appindexing.internal.zzu;
import java.util.Arrays;

public class IndexableBuilder<T extends IndexableBuilder<?>> {
    private final Bundle zzaw;
    private final String type;
    private Thing.zza zzcf;
    private String url;

    protected IndexableBuilder(@NonNull String string) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotEmpty((String)string);
        this.zzaw = new Bundle();
        this.type = string;
    }

    public T put(@NonNull String string, String ... stringArray) {
        IndexableBuilder.zza(this.zzaw, string, stringArray);
        return (T)this;
    }

    public T put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
        IndexableBuilder.zza(this.zzaw, string, indexableArray);
        return (T)this;
    }

    public T put(@NonNull String string, boolean ... blArray) {
        IndexableBuilder.zza(this.zzaw, string, blArray);
        return (T)this;
    }

    public T put(@NonNull String string, long ... lArray) {
        IndexableBuilder.zza(this.zzaw, string, lArray);
        return (T)this;
    }

    public final T setName(@NonNull String string) {
        Preconditions.checkNotNull((Object)string);
        return this.put("name", string);
    }

    public final T setUrl(@NonNull String string) {
        Preconditions.checkNotNull((Object)string);
        this.url = string;
        return (T)this;
    }

    public final T setImage(@NonNull String string) {
        Preconditions.checkNotNull((Object)string);
        return this.put("image", string);
    }

    public final T setDescription(@NonNull String string) {
        Preconditions.checkNotNull((Object)string);
        return this.put("description", string);
    }

    public final T setSameAs(@NonNull String string) {
        Preconditions.checkNotNull((Object)string);
        return this.put("sameAs", string);
    }

    public final T setKeywords(String ... stringArray) {
        return this.put("keywords", stringArray);
    }

    public T setMetadata(@NonNull Indexable.Metadata.Builder builder) {
        Preconditions.checkState((this.zzcf == null ? 1 : 0) != 0, (Object)"setMetadata may only be called once");
        Preconditions.checkNotNull((Object)builder);
        this.zzcf = builder.zzi();
        return (T)this;
    }

    public final Indexable build() {
        return new Thing(new Bundle(this.zzaw), this.zzcf == null ? new Indexable.Metadata.Builder().zzi() : this.zzcf, this.url, this.type);
    }

    protected <S extends IndexableBuilder> T put(@NonNull String string, S ... SArray) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull(SArray);
        if (SArray.length > 0) {
            Thing[] thingArray = new Thing[SArray.length];
            for (int i = 0; i < SArray.length; ++i) {
                if (SArray[i] == null) {
                    int n = i;
                    zzu.zze(new StringBuilder(60).append("Builder at ").append(n).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                thingArray[i] = (Thing)((IndexableBuilder)SArray[i]).build();
            }
            if (thingArray.length > 0) {
                IndexableBuilder.zza(this.zzaw, string, thingArray);
            }
        } else {
            zzu.zze("Builder array is empty and is ignored by put method.");
        }
        return (T)this;
    }

    private static void zza(@NonNull Bundle bundle, @NonNull String string, Thing ... thingArray) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)thingArray);
        if (thingArray.length > 0) {
            int n = 0;
            for (int i = 0; i < thingArray.length; ++i) {
                thingArray[n] = thingArray[i];
                if (thingArray[i] == null) {
                    int n2 = i;
                    zzu.zze(new StringBuilder(58).append("Thing at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                thingArray = Arrays.copyOfRange(thingArray, 0, n);
                bundle.putParcelableArray(string, (Parcelable[])IndexableBuilder.zza(thingArray));
            }
            return;
        }
        zzu.zze("Thing array is empty and is ignored by put method.");
    }

    public static void zza(@NonNull Bundle bundle, @NonNull String string, String ... stringArray) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)stringArray);
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        if (stringArray2.length > 0) {
            int n = 0;
            for (int i = 0; i < Math.min(stringArray2.length, 100); ++i) {
                int n2;
                stringArray2[n] = stringArray2[i];
                if (stringArray2[i] == null) {
                    n2 = i;
                    zzu.zze(new StringBuilder(59).append("String at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                if (stringArray2[n].length() > 20000) {
                    String string2;
                    n2 = i;
                    zzu.zze(new StringBuilder(53).append("String at ").append(n2).append(" is too long, truncating string.").toString());
                    String string3 = stringArray2[n];
                    if (string3.length() <= 20000) {
                        string2 = string3;
                    } else {
                        int n3 = 20000;
                        if (Character.isHighSurrogate(string3.charAt(19999)) && Character.isLowSurrogate(string3.charAt(20000))) {
                            --n3;
                        }
                        string2 = string3.substring(0, n3);
                    }
                    stringArray2[n] = string2;
                }
                ++n;
            }
            if (n > 0) {
                stringArray2 = Arrays.copyOfRange(stringArray2, 0, n);
                bundle.putStringArray(string, IndexableBuilder.zza(stringArray2));
            }
            return;
        }
        zzu.zze("String array is empty and is ignored by put method.");
    }

    public static void zza(@NonNull Bundle bundle, @NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)indexableArray);
        Thing[] thingArray = new Thing[indexableArray.length];
        for (int i = 0; i < indexableArray.length; ++i) {
            if (indexableArray[i] != null && !(indexableArray[i] instanceof Thing)) {
                throw new FirebaseAppIndexingInvalidArgumentException("Invalid Indexable encountered. Use Indexable.Builder or convenience methods under Indexables to create the Indexable.");
            }
            thingArray[i] = (Thing)indexableArray[i];
        }
        IndexableBuilder.zza(bundle, string, thingArray);
    }

    public static void zza(@NonNull Bundle bundle, @NonNull String string, boolean ... blArray) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)blArray);
        if (blArray.length > 0) {
            boolean[] blArray2;
            boolean[] blArray3 = blArray;
            if (blArray.length < 100) {
                blArray2 = blArray3;
            } else {
                zzu.zze("Input Array of elements is too big, cutting off.");
                blArray2 = Arrays.copyOf(blArray3, 100);
            }
            bundle.putBooleanArray(string, blArray2);
            return;
        }
        zzu.zze("Boolean array is empty and is ignored by put method.");
    }

    public static void zza(@NonNull Bundle bundle, @NonNull String string, long ... lArray) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)lArray);
        if (lArray.length > 0) {
            long[] lArray2;
            long[] lArray3 = lArray;
            if (lArray.length < 100) {
                lArray2 = lArray3;
            } else {
                zzu.zze("Input Array of elements is too big, cutting off.");
                lArray2 = Arrays.copyOf(lArray3, 100);
            }
            bundle.putLongArray(string, lArray2);
            return;
        }
        zzu.zze("Long array is empty and is ignored by put method.");
    }

    private static <S> S[] zza(S[] SArray) {
        if (SArray.length < 100) {
            return SArray;
        }
        zzu.zze("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(SArray, 100);
    }
}

