/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.aet;
import com.google.android.gms.internal.aeu;
import com.google.android.gms.internal.lv;
import com.google.android.gms.internal.nf;
import com.google.android.gms.internal.np;
import com.google.android.gms.internal.nr;
import com.google.android.gms.internal.ns;
import com.google.android.gms.internal.pi;
import com.google.android.gms.internal.pr;
import com.google.android.gms.internal.qh;
import com.google.android.gms.internal.ql;
import com.google.android.gms.internal.qn;
import com.google.android.gms.internal.qo;
import com.google.android.gms.internal.qu;
import com.google.android.gms.internal.qw;
import com.google.android.gms.internal.qx;
import com.google.android.gms.internal.qy;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzf;
import com.google.firebase.auth.zzg;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements aet {
    private FirebaseApp zzbXX;
    private List<IdTokenListener> zzbXY;
    private List<AuthStateListener> zzbXb;
    private lv zzbXZ;
    private FirebaseUser zzbYa;
    private qw zzbYb;
    private qx zzbYc;
    private static Map<String, FirebaseAuth> zzbgU = new ArrayMap();
    private static FirebaseAuth zzbYd;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        nr nr2 = new ns(firebaseApp2.getOptions().getApiKey()).zzEV();
        this(firebaseApp, np.zza(firebaseApp2.getApplicationContext(), nr2), new qw(firebaseApp.getApplicationContext(), firebaseApp.zzEt()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, lv lv2, qw qw2) {
        pi pi2;
        this.zzbXX = (FirebaseApp)zzbr.zzu((Object)firebaseApp);
        this.zzbXZ = (lv)((Object)zzbr.zzu((Object)((Object)lv2)));
        this.zzbYb = (qw)zzbr.zzu((Object)qw2);
        this.zzbXY = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzbXb = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzbYc = qx.zzFs();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzbYa = firebaseAuth.zzbYb.zzFr();
        if (firebaseAuth.zzbYa != null && (pi2 = firebaseAuth.zzbYb.zzh(firebaseAuth.zzbYa)) != null) {
            firebaseAuth.zza(firebaseAuth.zzbYa, pi2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzbYa;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull pi pi2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbr.zzu((Object)firebaseUser);
        zzbr.zzu((Object)pi2);
        if (this.zzbYa == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzbYa.zzEI().getAccessToken();
            boolean bl4 = !string2.equals(string = pi2.getAccessToken());
            boolean bl5 = this.zzbYa.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbr.zzu((Object)firebaseUser2);
        if (firebaseAuth.zzbYa == null) {
            firebaseAuth.zzbYa = firebaseUser2;
        } else {
            firebaseAuth.zzbYa.zzax(firebaseUser2.isAnonymous());
            firebaseAuth.zzbYa.zzP(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzbYb.zzg(firebaseAuth.zzbYa);
        }
        if (bl3) {
            if (this.zzbYa != null) {
                this.zzbYa.zza(pi2);
            }
            this.zza(this.zzbYa);
        }
        if (bl6) {
            this.zzb(this.zzbYa);
        }
        if (bl) {
            this.zzbYb.zza(firebaseUser, pi2);
        }
    }

    public final void zzEF() {
        if (this.zzbYa != null) {
            FirebaseUser firebaseUser = this.zzbYa;
            qw qw2 = this.zzbYb;
            zzbr.zzu((Object)firebaseUser);
            qw2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzbYa = null;
        }
        this.zzbYb.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza(null);
        this.zzb(null);
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzbgU.get(firebaseApp.zzEt());
        if (firebaseAuth == null) {
            firebaseAuth = new qn(firebaseApp);
            firebaseApp.zza((aet)firebaseAuth);
            if (zzbYd == null) {
                zzbYd = firebaseAuth;
            }
            zzbgU.put(firebaseApp.zzEt(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzbXY.add(idTokenListener);
        this.zzbYc.execute(new zzf(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzbXY.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzbXb.add(authStateListener);
        this.zzbYc.execute(new zzg(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzbXb.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzEK() : null;
        aeu aeu2 = new aeu(string);
        this.zzbYc.execute(new zzh(this, aeu2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzbYc.execute(new zzi(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzaw(boolean bl) {
        return this.zza(this.zzbYa, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)nf.zzK(new Status(17495)));
        }
        pi pi2 = this.zzbYa.zzEI();
        if (pi2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(pi2.getAccessToken()));
        }
        return this.zzbXZ.zza(this.zzbXX, firebaseUser, pi2.zzFg(), (qh)new zzj(this));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbr.zzu((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbXZ.zzb(this.zzbXX, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzbXZ.zza(this.zzbXX, phoneAuthCredential, (qh)new zza(this));
        }
        return this.zzbXZ.zza(this.zzbXX, authCredential, (qh)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbr.zzu((Object)firebaseUser);
        zzbr.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbXZ.zza(this.zzbXX, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (qy)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzbXZ.zzb(this.zzbXX, firebaseUser, (PhoneAuthCredential)authCredential, (qy)((Object)new zzb(this)));
        }
        return this.zzbXZ.zza(this.zzbXX, firebaseUser, authCredential, (qy)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbr.zzu((Object)firebaseUser);
        zzbr.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbXZ.zzb(this.zzbXX, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (qy)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzbXZ.zzc(this.zzbXX, firebaseUser, authCredential, (qy)((Object)new zzb(this)));
        }
        return this.zzbXZ.zzb(this.zzbXX, firebaseUser, authCredential, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbr.zzcF((String)string);
        return this.zzbXZ.zza(this.zzbXX, string, (qh)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        return this.zzbXZ.zzb(this.zzbXX, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzbYa != null && this.zzbYa.isAnonymous()) {
            qo qo2 = (qo)this.zzbYa;
            return Tasks.forResult((Object)new ql(qo2));
        }
        return this.zzbXZ.zza(this.zzbXX, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block8: {
            block9: {
                block10: {
                    block7: {
                        var14_8 = var1_1;
                        var13_9 = this.zzbXX.getApplicationContext();
                        zzbr.zzu((Object)var13_9);
                        zzbr.zzcF((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzs.zzsd()) break block7;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block8;
                        v0 = var16_15;
                        break block9;
                    }
                    if (!"US".equals(var15_14)) break block8;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block10;
                    v0 = null;
                    break block9;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        if (var10_19 < 30L) {
            var10_19 = 30L;
        }
        var12_20 = new pr(var9_18, var10_19, var8_7);
        this.zzbXZ.zza(this.zzbXX, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbr.zzu((Object)firebaseUser);
        return this.zzbXZ.zza(this.zzbXX, firebaseUser, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbr.zzu((Object)((Object)authCredential));
        zzbr.zzu((Object)firebaseUser);
        return this.zzbXZ.zzd(this.zzbXX, firebaseUser, authCredential, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbr.zzcF((String)string);
        zzbr.zzu((Object)firebaseUser);
        return this.zzbXZ.zzc(this.zzbXX, firebaseUser, string, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        return this.zzbXZ.zza(this.zzbXX, string, string2, (qh)new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbr.zzcF((String)string);
        return this.zzbXZ.zza(this.zzbXX, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbr.zzu((Object)firebaseUser);
        zzbr.zzu((Object)((Object)userProfileChangeRequest));
        return this.zzbXZ.zza(this.zzbXX, firebaseUser, userProfileChangeRequest, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbr.zzu((Object)firebaseUser);
        zzbr.zzcF((String)string);
        return this.zzbXZ.zza(this.zzbXX, firebaseUser, string, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbr.zzu((Object)firebaseUser);
        zzbr.zzu((Object)((Object)phoneAuthCredential));
        return this.zzbXZ.zza(this.zzbXX, firebaseUser, phoneAuthCredential, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbr.zzu((Object)firebaseUser);
        zzbr.zzcF((String)string);
        return this.zzbXZ.zzb(this.zzbXX, firebaseUser, string, (qy)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbr.zzcF((String)string);
        return this.zzbXZ.zzb(this.zzbXX, string);
    }

    @NonNull
    public final Task<Void> zzgr(@NonNull String string) {
        zzbr.zzcF((String)string);
        return this.zzbXZ.zzc(this.zzbXX, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbr.zzcF((String)string);
        return this.zzbXZ.zzd(this.zzbXX, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbr.zzcF((String)string);
        return this.zzbXZ.zze(this.zzbXX, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbr.zzcF((String)string);
        return this.zzbXZ.zzf(this.zzbXX, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        return this.zzbXZ.zza(this.zzbXX, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbr.zzu((Object)firebaseUser);
        return this.zzbXZ.zza(firebaseUser, new zzk(this, firebaseUser));
    }

    public void signOut() {
        this.zzEF();
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbXX;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbXY;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbXb;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbYa;
    }

    final class zzb
    extends zza
    implements qh,
    qu {
        private /* synthetic */ FirebaseAuth zzbYf;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzbYf = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzbYf.signOut();
            }
        }
    }

    class zza
    implements qh {
        private /* synthetic */ FirebaseAuth zzbYf;

        zza(FirebaseAuth firebaseAuth) {
            this.zzbYf = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull pi pi2, @NonNull FirebaseUser firebaseUser) {
            zzbr.zzu((Object)pi2);
            zzbr.zzu((Object)firebaseUser);
            firebaseUser.zza(pi2);
            this.zzbYf.zza(firebaseUser, pi2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

