/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbcq;
import com.google.android.gms.internal.zzdio;
import com.google.android.gms.internal.zzdkw;
import com.google.android.gms.internal.zzdlp;
import com.google.android.gms.internal.zzdlr;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzdlx {
    private Context mContext;
    private String zzljr;
    private SharedPreferences zzbfr;
    private zzbcq zzecu;

    public zzdlx(@NonNull Context context, @NonNull String string) {
        zzbp.zzu((Object)context);
        this.zzljr = zzbp.zzgf((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzljr);
        this.zzbfr = this.mContext.getSharedPreferences(string2, 0);
        this.zzecu = new zzbcq("StorageHelpers", new String[0]);
    }

    public final void zzg(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzi(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbfr.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbou() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbfr.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzr(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdkw zzdkw2) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)zzdkw2));
        this.zzbfr.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzdkw2.zzaag()).apply();
    }

    public final zzdkw zzh(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzbfr.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzdkw.zzof(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzbfr.edit().remove(string).apply();
    }

    @Nullable
    private final String zzi(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzdlr.class.isAssignableFrom(firebaseUser.getClass())) {
            zzdlr zzdlr2 = (zzdlr)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzdlr2).zzbob());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzdlr2).zzbnz().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzdlr2.zzbos() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzdlp> list = zzdlr2.zzbos();
                    for (int i = 0; i < list.size(); ++i) {
                        zzdlp zzdlp2 = list.get(i);
                        jSONArray.put((Object)zzdlp2.zzaag());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzdlr2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzecu.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdio(exception);
            }
        }
        return null;
    }

    private final zzdlr zzr(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzdlp> arrayList = new ArrayList<zzdlp>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzdlp.zzog(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzdlr zzdlr2 = new zzdlr(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzdkw zzdkw2 = zzdkw.zzof(string);
                ((FirebaseUser)zzdlr2).zza(zzdkw2);
            }
            ((zzdlr)((FirebaseUser)zzdlr2).zzbz(bl)).zzoh(string3);
            return zzdlr2;
        }
        catch (zzdio | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzecu.zzc(throwable);
            return null;
        }
    }
}

