/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzdiv;
import com.google.android.gms.internal.zzdke;
import com.google.android.gms.internal.zzdkj;
import com.google.android.gms.internal.zzdkl;
import com.google.android.gms.internal.zzdkm;
import com.google.android.gms.internal.zzdlc;
import com.google.android.gms.internal.zzdlk;
import com.google.android.gms.internal.zzdlq;
import com.google.android.gms.internal.zzdlu;
import com.google.android.gms.internal.zzdlw;
import com.google.android.gms.internal.zzdlx;
import com.google.android.gms.internal.zzdmb;
import com.google.android.gms.internal.zzdmd;
import com.google.android.gms.internal.zzdme;
import com.google.android.gms.internal.zzdmf;
import com.google.android.gms.internal.zzeai;
import com.google.android.gms.internal.zzeaj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzf;
import com.google.firebase.auth.zzg;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements zzeai {
    private FirebaseApp zzlga;
    private List<IdTokenListener> zzlei;
    private List<AuthStateListener> zzlgb;
    private zzdiv zzlgc;
    private FirebaseUser zzlgd;
    private zzdmd zzlge;
    private zzdme zzlgf;
    private static Map<String, FirebaseAuth> zzhtf = new ArrayMap();
    private static FirebaseAuth zzlgg;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzdkl zzdkl2 = new zzdkm(firebaseApp2.getOptions().getApiKey()).zzboj();
        this(firebaseApp, zzdkj.zza(firebaseApp2.getApplicationContext(), zzdkl2), new zzdmd(firebaseApp.getApplicationContext(), firebaseApp.zzbnl()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, zzdiv zzdiv2, zzdmd zzdmd2) {
        zzdlc zzdlc2;
        this.zzlga = (FirebaseApp)zzbp.zzu((Object)firebaseApp);
        this.zzlgc = (zzdiv)((Object)zzbp.zzu((Object)((Object)zzdiv2)));
        this.zzlge = (zzdmd)zzbp.zzu((Object)zzdmd2);
        this.zzlei = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzlgb = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzlgf = zzdme.zzbov();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzlgd = firebaseAuth.zzlge.zzbou();
        if (firebaseAuth.zzlgd != null && (zzdlc2 = firebaseAuth.zzlge.zzh(firebaseAuth.zzlgd)) != null) {
            firebaseAuth.zza(firebaseAuth.zzlgd, zzdlc2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzlgd;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdlc zzdlc2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)zzdlc2));
        if (this.zzlgd == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzlgd.zzboa().getAccessToken();
            boolean bl4 = !string2.equals(string = zzdlc2.getAccessToken());
            boolean bl5 = this.zzlgd.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbp.zzu((Object)firebaseUser2);
        if (firebaseAuth.zzlgd == null) {
            firebaseAuth.zzlgd = firebaseUser2;
        } else {
            firebaseAuth.zzlgd.zzbz(firebaseUser2.isAnonymous());
            firebaseAuth.zzlgd.zzan(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzlge.zzg(firebaseAuth.zzlgd);
        }
        if (bl3) {
            if (this.zzlgd != null) {
                this.zzlgd.zza(zzdlc2);
            }
            this.zza(this.zzlgd);
        }
        if (bl6) {
            this.zzb(this.zzlgd);
        }
        if (bl) {
            this.zzlge.zza(firebaseUser, zzdlc2);
        }
    }

    public final void zzbnx() {
        if (this.zzlgd != null) {
            FirebaseUser firebaseUser = this.zzlgd;
            zzdmd zzdmd2 = this.zzlge;
            zzbp.zzu((Object)firebaseUser);
            zzdmd2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzlgd = null;
        }
        this.zzlge.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza(null);
        this.zzb(null);
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzhtf.get(firebaseApp.zzbnl());
        if (firebaseAuth == null) {
            firebaseAuth = new zzdlw(firebaseApp);
            firebaseApp.zza((zzeai)firebaseAuth);
            if (zzlgg == null) {
                zzlgg = firebaseAuth;
            }
            zzhtf.put(firebaseApp.zzbnl(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlei.add(idTokenListener);
        this.zzlgf.execute(new zzf(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlei.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlgb.add(authStateListener);
        this.zzlgf.execute(new zzg(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlgb.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzboc() : null;
        zzeaj zzeaj2 = new zzeaj(string);
        this.zzlgf.execute(new zzh(this, zzeaj2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzlgf.execute(new zzi(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzby(boolean bl) {
        return this.zza(this.zzlgd, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzdke.zzak(new Status(17495)));
        }
        zzdlc zzdlc2 = this.zzlgd.zzboa();
        if (zzdlc2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzdlc2.getAccessToken()));
        }
        return this.zzlgc.zza(this.zzlga, firebaseUser, zzdlc2.zzbom(), (zzdlq)new zzj(this));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlgc.zzb(this.zzlga, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzlgc.zza(this.zzlga, phoneAuthCredential, (zzdlq)new zza(this));
        }
        return this.zzlgc.zza(this.zzlga, authCredential, (zzdlq)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlgc.zza(this.zzlga, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdmf)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlgc.zzb(this.zzlga, firebaseUser, (PhoneAuthCredential)authCredential, (zzdmf)((Object)new zzb(this)));
        }
        return this.zzlgc.zza(this.zzlga, firebaseUser, authCredential, (zzdmf)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlgc.zzb(this.zzlga, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdmf)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlgc.zzc(this.zzlga, firebaseUser, authCredential, (zzdmf)((Object)new zzb(this)));
        }
        return this.zzlgc.zzb(this.zzlga, firebaseUser, authCredential, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbp.zzgf((String)string);
        return this.zzlgc.zza(this.zzlga, string, (zzdlq)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        return this.zzlgc.zzb(this.zzlga, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzlgd != null && this.zzlgd.isAnonymous()) {
            zzdlx zzdlx2 = (zzdlx)this.zzlgd;
            return Tasks.forResult((Object)new zzdlu(zzdlx2));
        }
        return this.zzlgc.zza(this.zzlga, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block8: {
            block9: {
                block10: {
                    block7: {
                        var14_8 = var1_1;
                        var13_9 = this.zzlga.getApplicationContext();
                        zzbp.zzu((Object)var13_9);
                        zzbp.zzgf((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzp.zzalj()) break block7;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block8;
                        v0 = var16_15;
                        break block9;
                    }
                    if (!"US".equals(var15_14)) break block8;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block10;
                    v0 = null;
                    break block9;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        if (var10_19 < 30L) {
            var10_19 = 30L;
        }
        var12_20 = new zzdlk(var9_18, var10_19, var8_7);
        this.zzlgc.zza(this.zzlga, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        return this.zzlgc.zza(this.zzlga, firebaseUser, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        zzbp.zzu((Object)firebaseUser);
        return this.zzlgc.zzd(this.zzlga, firebaseUser, authCredential, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzgf((String)string);
        zzbp.zzu((Object)firebaseUser);
        return this.zzlgc.zzc(this.zzlga, firebaseUser, string, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        return this.zzlgc.zza(this.zzlga, string, string2, (zzdlq)new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbp.zzgf((String)string);
        return this.zzlgc.zza(this.zzlga, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)userProfileChangeRequest));
        return this.zzlgc.zza(this.zzlga, firebaseUser, userProfileChangeRequest, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzgf((String)string);
        return this.zzlgc.zza(this.zzlga, firebaseUser, string, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)phoneAuthCredential));
        return this.zzlgc.zza(this.zzlga, firebaseUser, phoneAuthCredential, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzgf((String)string);
        return this.zzlgc.zzb(this.zzlga, firebaseUser, string, (zzdmf)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbp.zzgf((String)string);
        return this.zzlgc.zzb(this.zzlga, string);
    }

    @NonNull
    public final Task<Void> zzoa(@NonNull String string) {
        zzbp.zzgf((String)string);
        return this.zzlgc.zzc(this.zzlga, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbp.zzgf((String)string);
        return this.zzlgc.zzd(this.zzlga, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbp.zzgf((String)string);
        return this.zzlgc.zze(this.zzlga, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbp.zzgf((String)string);
        return this.zzlgc.zzf(this.zzlga, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        return this.zzlgc.zza(this.zzlga, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        return this.zzlgc.zza(firebaseUser, new zzk(this, firebaseUser));
    }

    public void signOut() {
        this.zzbnx();
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlga;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlei;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlgb;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlgd;
    }

    final class zzb
    extends zza
    implements zzdlq,
    zzdmb {
        private /* synthetic */ FirebaseAuth zzlgi;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzlgi = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzlgi.signOut();
            }
        }
    }

    class zza
    implements zzdlq {
        private /* synthetic */ FirebaseAuth zzlgi;

        zza(FirebaseAuth firebaseAuth) {
            this.zzlgi = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzdlc zzdlc2, @NonNull FirebaseUser firebaseUser) {
            zzbp.zzu((Object)((Object)zzdlc2));
            zzbp.zzu((Object)firebaseUser);
            firebaseUser.zza(zzdlc2);
            this.zzlgi.zza(firebaseUser, zzdlc2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

