/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzdka;
import com.google.android.gms.internal.zzdlj;
import com.google.android.gms.internal.zzdlo;
import com.google.android.gms.internal.zzdlq;
import com.google.android.gms.internal.zzdlr;
import com.google.android.gms.internal.zzdls;
import com.google.android.gms.internal.zzdmi;
import com.google.android.gms.internal.zzdmq;
import com.google.android.gms.internal.zzdmw;
import com.google.android.gms.internal.zzdna;
import com.google.android.gms.internal.zzdnc;
import com.google.android.gms.internal.zzdnd;
import com.google.android.gms.internal.zzdnh;
import com.google.android.gms.internal.zzdnj;
import com.google.android.gms.internal.zzdnk;
import com.google.android.gms.internal.zzdnl;
import com.google.android.gms.internal.zzeku;
import com.google.android.gms.internal.zzekv;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements zzeku {
    private FirebaseApp zzlkm;
    private List<IdTokenListener> zzlil;
    private List<AuthStateListener> zzlkn;
    private zzdka zzlko;
    private FirebaseUser zzlkp;
    private final Object zzlkq;
    private String zzlkr;
    private zzdnj zzlks;
    private zzdnk zzlkt;
    private static Map<String, FirebaseAuth> zzhtn = new ArrayMap();
    private static FirebaseAuth zzlku;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzdlq zzdlq2 = new zzdlr(firebaseApp2.getOptions().getApiKey()).zzbou();
        this(firebaseApp, zzdlo.zza(firebaseApp2.getApplicationContext(), zzdlq2), new zzdnj(firebaseApp.getApplicationContext(), firebaseApp.zzbnx()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, zzdka zzdka2, zzdnj zzdnj2) {
        zzdmi zzdmi2;
        this.zzlkq = new Object();
        this.zzlkm = (FirebaseApp)zzbp.zzu((Object)firebaseApp);
        this.zzlko = (zzdka)((Object)zzbp.zzu((Object)((Object)zzdka2)));
        this.zzlks = (zzdnj)zzbp.zzu((Object)zzdnj2);
        this.zzlil = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzlkn = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzlkt = zzdnk.zzbph();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzlkp = firebaseAuth.zzlks.zzbpg();
        if (firebaseAuth.zzlkp != null && (zzdmi2 = firebaseAuth.zzlks.zzg(firebaseAuth.zzlkp)) != null) {
            firebaseAuth.zza(firebaseAuth.zzlkp, zzdmi2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzlkp;
    }

    @Nullable
    public final String getUid() {
        if (this.zzlkp == null) {
            return null;
        }
        return this.zzlkp.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdmi zzdmi2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)zzdmi2));
        if (this.zzlkp == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzlkp.zzbom().getAccessToken();
            boolean bl4 = !string2.equals(string = zzdmi2.getAccessToken());
            boolean bl5 = this.zzlkp.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbp.zzu((Object)firebaseUser2);
        if (firebaseAuth.zzlkp == null) {
            firebaseAuth.zzlkp = firebaseUser2;
        } else {
            firebaseAuth.zzlkp.zzcd(firebaseUser2.isAnonymous());
            firebaseAuth.zzlkp.zzan(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzlks.zzf(firebaseAuth.zzlkp);
        }
        if (bl3) {
            if (this.zzlkp != null) {
                this.zzlkp.zza(zzdmi2);
            }
            this.zza(this.zzlkp);
        }
        if (bl6) {
            this.zzb(this.zzlkp);
        }
        if (bl) {
            this.zzlks.zza(firebaseUser, zzdmi2);
        }
    }

    public final void zzboj() {
        if (this.zzlkp != null) {
            FirebaseUser firebaseUser = this.zzlkp;
            zzdnj zzdnj2 = this.zzlks;
            zzbp.zzu((Object)firebaseUser);
            zzdnj2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzlkp = null;
        }
        this.zzlks.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza(null);
        this.zzb(null);
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzhtn.get(firebaseApp.zzbnx());
        if (firebaseAuth == null) {
            firebaseAuth = new zzdnc(firebaseApp);
            firebaseApp.zza((zzeku)firebaseAuth);
            if (zzlku == null) {
                zzlku = firebaseAuth;
            }
            zzhtn.put(firebaseApp.zzbnx(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlil.add(idTokenListener);
        this.zzlkt.execute(new zzh(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlil.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlkn.add(authStateListener);
        this.zzlkt.execute(new zzi(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlkn.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzboo() : null;
        zzekv zzekv2 = new zzekv(string);
        this.zzlkt.execute(new zzj(this, zzekv2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzlkt.execute(new zzk(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzcc(boolean bl) {
        return this.zza(this.zzlkp, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzdlj.zzak(new Status(17495)));
        }
        zzdmi zzdmi2 = this.zzlkp.zzbom();
        if (zzdmi2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzdmi2.getAccessToken()));
        }
        return this.zzlko.zza(this.zzlkm, firebaseUser, zzdmi2.zzboy(), (zzdmw)new zzl(this));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlko.zzb(this.zzlkm, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzlko.zza(this.zzlkm, phoneAuthCredential, (zzdmw)new zza(this));
        }
        return this.zzlko.zza(this.zzlkm, authCredential, (zzdmw)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlko.zza(this.zzlkm, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdnl)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlko.zzb(this.zzlkm, firebaseUser, (PhoneAuthCredential)authCredential, (zzdnl)((Object)new zzb(this)));
        }
        return this.zzlko.zza(this.zzlkm, firebaseUser, authCredential, (zzdnl)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlko.zzb(this.zzlkm, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdnl)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlko.zzc(this.zzlkm, firebaseUser, authCredential, (zzdnl)((Object)new zzb(this)));
        }
        return this.zzlko.zzb(this.zzlkm, firebaseUser, authCredential, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlko.zza(this.zzlkm, string, (zzdmw)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        return this.zzlko.zzb(this.zzlkm, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzlkp != null && this.zzlkp.isAnonymous()) {
            zzdnd zzdnd2 = (zzdnd)this.zzlkp;
            return Tasks.forResult((Object)new zzdna(zzdnd2));
        }
        return this.zzlko.zza(this.zzlkm, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block8: {
            block9: {
                block10: {
                    block7: {
                        var14_8 = var1_1;
                        var13_9 = this.zzlkm.getApplicationContext();
                        zzbp.zzu((Object)var13_9);
                        zzbp.zzgg((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzq.zzalj()) break block7;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block8;
                        v0 = var16_15;
                        break block9;
                    }
                    if (!"US".equals(var15_14)) break block8;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block10;
                    v0 = null;
                    break block9;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        if (var10_19 < 30L) {
            var10_19 = 30L;
        }
        var12_20 = new zzdmq(var9_18, var10_19, var8_7);
        this.zzlko.zza(this.zzlkm, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        return this.zzlko.zza(this.zzlkm, firebaseUser, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        zzbp.zzu((Object)firebaseUser);
        return this.zzlko.zzd(this.zzlkm, firebaseUser, authCredential, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzgg((String)string);
        zzbp.zzu((Object)firebaseUser);
        return this.zzlko.zzc(this.zzlkm, firebaseUser, string, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        return this.zzlko.zza(this.zzlkm, string, string2, (zzdmw)new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlko.zza(this.zzlkm, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)userProfileChangeRequest));
        return this.zzlko.zza(this.zzlkm, firebaseUser, userProfileChangeRequest, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzgg((String)string);
        return this.zzlko.zza(this.zzlkm, firebaseUser, string, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)phoneAuthCredential));
        return this.zzlko.zza(this.zzlkm, firebaseUser, phoneAuthCredential, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzgg((String)string);
        return this.zzlko.zzb(this.zzlkm, firebaseUser, string, (zzdnl)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        zzbp.zzgg((String)string);
        if (this.zzlkr != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzol(this.zzlkr);
        }
        return this.zzlko.zza(this.zzlkm, string, actionCodeSettings);
    }

    @NonNull
    public final Task<Void> zzom(@NonNull String string) {
        zzbp.zzgg((String)string);
        String string2 = string;
        FirebaseApp firebaseApp = this.zzlkm;
        return this.zzlko.zza(firebaseApp, (ActionCodeSettings)null, string2);
    }

    @NonNull
    public final Task<Void> zza(@NonNull ActionCodeSettings actionCodeSettings, @NonNull String string) {
        zzbp.zzgg((String)string);
        if (this.zzlkr != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzol(this.zzlkr);
        }
        return this.zzlko.zza(this.zzlkm, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlko.zzb(this.zzlkm, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlko.zzc(this.zzlkm, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlko.zzd(this.zzlkm, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        return this.zzlko.zza(this.zzlkm, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        return this.zzlko.zza(firebaseUser, new zzm(this, firebaseUser));
    }

    public void signOut() {
        this.zzboj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        Object object = this.zzlkq;
        synchronized (object) {
            this.zzlkr = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzlkq;
        synchronized (object) {
            return this.zzlkr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzlkq;
        synchronized (object) {
            this.zzlkr = zzdls.zzbov();
            return;
        }
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlkm;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlil;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlkn;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlkp;
    }

    final class zzb
    extends zza
    implements zzdmw,
    zzdnh {
        private /* synthetic */ FirebaseAuth zzlkw;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzlkw = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzlkw.signOut();
            }
        }
    }

    class zza
    implements zzdmw {
        private /* synthetic */ FirebaseAuth zzlkw;

        zza(FirebaseAuth firebaseAuth) {
            this.zzlkw = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzdmi zzdmi2, @NonNull FirebaseUser firebaseUser) {
            zzbp.zzu((Object)((Object)zzdmi2));
            zzbp.zzu((Object)firebaseUser);
            firebaseUser.zza(zzdmi2);
            this.zzlkw.zza(firebaseUser, zzdmi2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

