/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzdzh;
import com.google.android.gms.internal.zzeaw;
import com.google.android.gms.internal.zzebb;
import com.google.android.gms.internal.zzebd;
import com.google.android.gms.internal.zzebe;
import com.google.android.gms.internal.zzebf;
import com.google.android.gms.internal.zzebw;
import com.google.android.gms.internal.zzece;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzab;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzu;
import com.google.firebase.auth.internal.zzx;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.internal.InternalTokenProvider;
import com.google.firebase.internal.zzc;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalTokenProvider {
    private FirebaseApp zza;
    private List<IdTokenListener> zzb;
    private List<AuthStateListener> zzc;
    private zzdzh zzd;
    private FirebaseUser zze;
    private final Object zzf;
    private String zzg;
    private zzx zzh;
    private zzy zzi;
    private zzaa zzj;
    private static Map<String, FirebaseAuth> zzk = new ArrayMap();
    private static FirebaseAuth zzl;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zza(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zza(firebaseApp);
    }

    @Hide
    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzebd zzebd2 = new zzebe(firebaseApp2.getOptions().getApiKey()).zza();
        this(firebaseApp, zzebb.zza(firebaseApp2.getApplicationContext(), zzebd2), new zzx(firebaseApp.getApplicationContext(), firebaseApp.zzc()));
    }

    @Hide
    private FirebaseAuth(FirebaseApp firebaseApp, zzdzh zzdzh2, zzx zzx2) {
        zzebw zzebw2;
        this.zzf = new Object();
        this.zza = (FirebaseApp)zzbq.zza((Object)firebaseApp);
        this.zzd = (zzdzh)zzbq.zza((Object)zzdzh2);
        this.zzh = (zzx)zzbq.zza((Object)zzx2);
        this.zzb = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzc = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzj = zzaa.zza();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zze = firebaseAuth.zzh.zza();
        if (firebaseAuth.zze != null && (zzebw2 = firebaseAuth.zzh.zzb(firebaseAuth.zze)) != null) {
            firebaseAuth.zza(firebaseAuth.zze, zzebw2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zze;
    }

    @Hide
    @Nullable
    public final String zza() {
        if (this.zze == null) {
            return null;
        }
        return this.zze.getUid();
    }

    @Hide
    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzebw zzebw2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((Object)((Object)zzebw2));
        if (this.zze == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zze.zzc().zzc();
            boolean bl4 = !string2.equals(string = zzebw2.zzc());
            boolean bl5 = this.zze.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbq.zza((Object)firebaseUser2);
        if (firebaseAuth.zze == null) {
            firebaseAuth.zze = firebaseUser2;
        } else {
            firebaseAuth.zze.zza(firebaseUser2.isAnonymous());
            firebaseAuth.zze.zza(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzh.zza(firebaseAuth.zze);
        }
        if (bl3) {
            if (this.zze != null) {
                this.zze.zza(zzebw2);
            }
            this.zzc(this.zze);
        }
        if (bl6) {
            this.zzd(this.zze);
        }
        if (bl) {
            this.zzh.zza(firebaseUser, zzebw2);
        }
        firebaseAuth = this;
        firebaseAuth.zzc().zza(firebaseAuth.zze.zzc());
    }

    @Hide
    public final void zzb() {
        if (this.zze != null) {
            FirebaseUser firebaseUser = this.zze;
            zzx zzx2 = this.zzh;
            zzbq.zza((Object)firebaseUser);
            zzx2.zza(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zze = null;
        }
        this.zzh.zza("com.google.firebase.auth.FIREBASE_USER");
        this.zzc(null);
        this.zzd(null);
    }

    @Hide
    private final synchronized void zza(zzy zzy2) {
        this.zzi = zzy2;
        this.zza.zza((FirebaseApp.zzb)zzy2);
    }

    @Hide
    private final synchronized zzy zzc() {
        if (this.zzi == null) {
            this.zza(new zzy(this.zza));
        }
        return this.zzi;
    }

    public FirebaseApp getApp() {
        return this.zza;
    }

    private static synchronized FirebaseAuth zza(@NonNull FirebaseApp firebaseApp) {
        String string = firebaseApp.zzc();
        FirebaseAuth firebaseAuth = zzk.get(string);
        if (firebaseAuth == null) {
            firebaseAuth = new com.google.firebase.auth.internal.zzj(firebaseApp);
            firebaseApp.zza((InternalTokenProvider)firebaseAuth);
            if (zzl == null) {
                zzl = firebaseAuth;
            }
            zzk.put(string, firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.add(idTokenListener);
        this.zzj.execute(new zzi(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzc.add(authStateListener);
        this.zzj.execute(new zzj(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzc.remove(authStateListener);
    }

    @Hide
    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zze() : null;
        zzc zzc2 = new zzc(string);
        this.zzj.execute(new com.google.firebase.auth.zzk(this, zzc2));
    }

    @Hide
    private final void zzd(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzj.execute(new zzl(this));
    }

    @Hide
    @NonNull
    public final Task<GetTokenResult> zza(boolean bl) {
        return this.zza(this.zze, bl);
    }

    @Hide
    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzeaw.zza(new Status(17495)));
        }
        zzebw zzebw2 = this.zze.zzc();
        if (zzebw2.zza() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzebw2.zzc()));
        }
        return this.zzd.zza(this.zza, firebaseUser, zzebw2.zzb(), (zzab)((Object)new zzm(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbq.zza((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if (!emailAuthCredential.zzc()) {
                return this.zzd.zzb(this.zza, emailAuthCredential.zza(), emailAuthCredential.zzb(), new zza(this));
            }
            return this.zzd.zza(this.zza, emailAuthCredential, (com.google.firebase.auth.internal.zza)new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzd.zza(this.zza, phoneAuthCredential, (com.google.firebase.auth.internal.zza)new zza(this));
        }
        return this.zzd.zza(this.zza, authCredential, (com.google.firebase.auth.internal.zza)new zza(this));
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzd.zza(this.zza, firebaseUser, emailAuthCredential.zza(), emailAuthCredential.zzb(), (zzab)((Object)new zzb(this)));
            }
            return this.zzd.zza(this.zza, firebaseUser, emailAuthCredential, (zzab)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzd.zzb(this.zza, firebaseUser, (PhoneAuthCredential)authCredential, (zzab)((Object)new zzb(this)));
        }
        return this.zzd.zza(this.zza, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
    }

    @Hide
    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzd.zzb(this.zza, firebaseUser, emailAuthCredential.zza(), emailAuthCredential.zzb(), (zzab)((Object)new zzb(this)));
            }
            return this.zzd.zzb(this.zza, firebaseUser, emailAuthCredential, (zzab)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzd.zzc(this.zza, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
        }
        return this.zzd.zzb(this.zza, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbq.zza((String)string);
        return this.zzd.zza(this.zza, string, (com.google.firebase.auth.internal.zza)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        return this.zzd.zzb(this.zza, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zze != null && this.zze.isAnonymous()) {
            zzk zzk2 = (zzk)this.zze;
            zzk2.zzb(false);
            return Tasks.forResult((Object)new zzf(zzk2));
        }
        return this.zzd.zza(this.zza, new zza(this));
    }

    @Hide
    @NonNull
    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzece zzece2 = new zzece(string, l2, bl, this.zzg);
        this.zzd.zza(this.zza, zzece2, onVerificationStateChangedCallbacks, activity, executor);
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser) {
        zzbq.zza((Object)firebaseUser);
        return this.zzd.zza(this.zza, firebaseUser, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.zza((Object)((Object)authCredential));
        zzbq.zza((Object)firebaseUser);
        return this.zzd.zzd(this.zza, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.zza((String)string);
        zzbq.zza((Object)firebaseUser);
        return this.zzd.zzd(this.zza, firebaseUser, string, (zzab)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        return this.zzd.zza(this.zza, string, string2, new zza(this));
    }

    @Deprecated
    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbq.zza((String)string);
        return this.zzd.zza(this.zza, string);
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        zzbq.zza((String)string);
        return this.zzd.zzb(this.zza, string);
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((Object)((Object)userProfileChangeRequest));
        return this.zzd.zza(this.zza, firebaseUser, userProfileChangeRequest, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((String)string);
        return this.zzd.zzb(this.zza, firebaseUser, string, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((Object)phoneAuthCredential);
        return this.zzd.zza(this.zza, firebaseUser, phoneAuthCredential, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((String)string);
        return this.zzd.zzc(this.zza, firebaseUser, string, (zzab)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbq.zza((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        zzbq.zza((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.newBuilder().build();
        }
        if (this.zzg != null) {
            actionCodeSettings.zza(this.zzg);
        }
        actionCodeSettings.zza(1);
        return this.zzd.zza(this.zza, string, actionCodeSettings);
    }

    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        zzbq.zza((String)string);
        zzbq.zza((Object)((Object)actionCodeSettings));
        if (this.zzg != null) {
            actionCodeSettings.zza(this.zzg);
        }
        return this.zzd.zzb(this.zza, string, actionCodeSettings);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.zza(string);
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        zzbq.zza((String)string);
        if (this.zzg != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zza(this.zzg);
        }
        return this.zzd.zza(this.zza, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbq.zza((String)string);
        return this.zzd.zzc(this.zza, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbq.zza((String)string);
        return this.zzd.zzd(this.zza, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbq.zza((String)string);
        return this.zzd.zze(this.zza, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbq.zza((String)string);
        zzbq.zza((String)string2);
        return this.zzd.zza(this.zza, string, string2);
    }

    @Hide
    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzbq.zza((Object)firebaseUser);
        return this.zzd.zza(firebaseUser, new zzn(this, firebaseUser));
    }

    public void signOut() {
        this.zzb();
        if (this.zzi != null) {
            this.zzi.zza();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        zzbq.zza((String)string);
        Object object = this.zzf;
        synchronized (object) {
            this.zzg = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzf;
        synchronized (object) {
            return this.zzg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzf;
        synchronized (object) {
            this.zzg = zzebf.zza();
            return;
        }
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzd.zza(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zza;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zze;
    }

    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzu {
        private /* synthetic */ FirebaseAuth zza;

        zzb(FirebaseAuth firebaseAuth) {
            this.zza = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zza.signOut();
            }
        }
    }

    class zza
    implements com.google.firebase.auth.internal.zza {
        private /* synthetic */ FirebaseAuth zza;

        zza(FirebaseAuth firebaseAuth) {
            this.zza = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzebw zzebw2, @NonNull FirebaseUser firebaseUser) {
            zzbq.zza((Object)((Object)zzebw2));
            zzbq.zza((Object)firebaseUser);
            firebaseUser.zza(zzebw2);
            this.zza.zza(firebaseUser, zzebw2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

