/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzdyz;
import com.google.android.gms.internal.zzebw;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzk;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Hide
public final class zzx {
    private Context zza;
    private String zzb;
    private SharedPreferences zzc;
    private zzbhf zzd;

    public zzx(@NonNull Context context, @NonNull String string) {
        zzbq.zza((Object)context);
        this.zzb = zzbq.zza((String)string);
        this.zza = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzb);
        this.zzc = this.zza.getSharedPreferences(string2, 0);
        this.zzd = new zzbhf("StorageHelpers", new String[0]);
    }

    public final void zza(@NonNull FirebaseUser firebaseUser) {
        zzbq.zza((Object)firebaseUser);
        String string = this.zzc(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzc.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zza() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzc.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zza(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzebw zzebw2) {
        zzbq.zza((Object)firebaseUser);
        zzbq.zza((Object)((Object)zzebw2));
        this.zzc.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzebw2.zzf()).apply();
    }

    public final zzebw zzb(@NonNull FirebaseUser firebaseUser) {
        zzbq.zza((Object)firebaseUser);
        String string = this.zzc.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzebw.zzb(string);
        }
        return null;
    }

    @Hide
    public final void zza(String string) {
        this.zzc.edit().remove(string).apply();
    }

    @Nullable
    private final String zzc(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzk.class.isAssignableFrom(firebaseUser.getClass())) {
            zzk zzk2 = (zzk)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzk2).zzd());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzk2).zzb().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzk2.zzf() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzh> list = zzk2.zzf();
                    for (int i = 0; i < list.size(); ++i) {
                        zzh zzh2 = list.get(i);
                        jSONArray.put((Object)zzh2.zzb());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzk2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzd.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdyz(exception);
            }
        }
        return null;
    }

    private final zzk zza(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzh> arrayList = new ArrayList<zzh>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzh.zza(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzk zzk2 = new zzk(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzebw zzebw2 = zzebw.zzb(string);
                ((FirebaseUser)zzk2).zza(zzebw2);
            }
            ((zzk)((FirebaseUser)zzk2).zza(bl)).zza(string3);
            return zzk2;
        }
        catch (zzdyz | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzd.zza(throwable);
            return null;
        }
    }
}

