/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzdyz;
import com.google.android.gms.internal.zzebw;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzk;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Hide
public final class zzx {
    private Context mContext;
    private String zzmuf;
    private SharedPreferences zzbkx;
    private zzbhf zzenl;

    public zzx(@NonNull Context context, @NonNull String string) {
        zzbq.checkNotNull((Object)context);
        this.zzmuf = zzbq.zzgv((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzmuf);
        this.zzbkx = this.mContext.getSharedPreferences(string2, 0);
        this.zzenl = new zzbhf("StorageHelpers", new String[0]);
    }

    public final void zzg(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzi(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbkx.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbuq() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbkx.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzz(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzebw zzebw2) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzebw2));
        this.zzbkx.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzebw2.zzack()).apply();
    }

    public final zzebw zzh(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzbkx.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzebw.zzpg(string);
        }
        return null;
    }

    @Hide
    public final void clear(String string) {
        this.zzbkx.edit().remove(string).apply();
    }

    @Nullable
    private final String zzi(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzk.class.isAssignableFrom(firebaseUser.getClass())) {
            zzk zzk2 = (zzk)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzk2).zzbtn());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzk2).zzbtl().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzk2.zzbum() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzh> list = zzk2.zzbum();
                    for (int i = 0; i < list.size(); ++i) {
                        zzh zzh2 = list.get(i);
                        jSONArray.put((Object)zzh2.zzack());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzk2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzenl.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdyz(exception);
            }
        }
        return null;
    }

    private final zzk zzz(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzh> arrayList = new ArrayList<zzh>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzh.zzph(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzk zzk2 = new zzk(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzebw zzebw2 = zzebw.zzpg(string);
                ((FirebaseUser)zzk2).zza(zzebw2);
            }
            ((zzk)((FirebaseUser)zzk2).zzck(bl)).zzpi(string3);
            return zzk2;
        }
        catch (zzdyz | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzenl.zzf(throwable);
            return null;
        }
    }
}

